/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *
 *   Exec for Bit true models
 *
 *   main_hw.c
 *----------------------------------------------------------------------------
 */


#include "const.h"
#include "typedef.h"

#ifdef UNITTEST_PRN
#include <stdio.h>
#include <string.h>
#endif

/* for debugging interrupt handler */
// #define TEST_INTERRUPT

uint16  int_enable=0;
uint16   int_id=0x0F0F;
uint16   task_id=0xABCD;
uint16   ptr_tcb_tc=0x1234;
uint16   ptr_tcb_ntc=0x4321;
uint16  int_timer=0;
uint16  int_count=0;
uint16  int_count1=0;
uint16  int_count3=0;
uint16  int_count4=0;

uint16   int_req=0;
uint16   int_source=0;
uint16  imask_value=0x01;
uint16   loop_len=1234;

uint16  read_reg_flag=0;
uint16  set_int_flag=0;
uint16  set_imask_flag=0;

uint16  imask_reg=0;
uint16  ireq_reg=0;
uint16  hwflag_reg=0;
uint16  smode_reg=0;

uint16   int_dur_hist[32];


/* ==================================================================== */
/*  ******************  Prototypes        *************************** */
/* ==================================================================== */

extern void cyclecount(int16 index);
void InitUnitTests(void);
void KernelInit(void);
void InitModemTasks_PreHandshake(void);
void SetLinkModeDependentVariables(void);
void InitModemTasks_PostHandshake(void);


int16 test_index=27;


void VectorPowerUTInit(void);
void VectorPowerUT(void);
void VectorPowerUTPrint(void);
void BgAlignmentUTInit(void);
void BgAlignmentUT(void);
void BgAlignmentUTPrint(void);
void FDQTrainUTInit(void);
void FDQTrainUT(void);
void FDQTrainUTPrint(void);
void BGReverb2SnrCalcUTInit(void);
void BGReverb2SnrCalcUT(void);
void BGReverb2SnrCalcUTPrint(void);
void BgDECTrain2UTInit(void);
void BgDECTrain2UT(void);
void BgDECTrain2UTPrint(void);
void TdqInitUTInit(void);
void TdqInitUT(void);
void TdqInitUTPrint(void);


int32 gla_VectorPowerOut[3];

#ifdef UNITTEST_PRN
FILE *UnitTestOutPtr, *UnitTestInPtr, *UnitTestReadPtr;
#endif

/* #define VECTOR_POWER_TEST_INDEX     0 */


/*-------------------------------------------------------------------
*
*  void main(void)
*
*  Description: This is the main program for running SW unit tests
*
*
*
*-------------------------------------------------------------------
*^^^
*/

   uint16   gus_StrymonCPE_RegBaseAddr,      /* Register base address */
   gus_StrymonCPE_RAMBaseAddr;      /* Filter coeff. RAM base address */


   int16 VECTOR_POWER_TEST_INDEX;
   int16 gs_UnitTestIteration, i;
   int16 units[7];
   char input_file[100], output_file[100];

#define UNITTEST_MAX    6

   PtrToFunc UnitTestInitFns[UNITTEST_MAX];   /* pointer to unit test init functions */
   PtrToFunc UnitTestFns[UNITTEST_MAX];   /* pointer to unit test init functions */
   PtrToFunc UnitTestPrintFns[UNITTEST_MAX];   /* pointer to unit test init functions */
   PtrToFunc UnitTestAlignmentFns[UNITTEST_MAX];   /* pointer to unit test init functions */

   void main()
   {

   KernelInit();

   InitModemTasks_PreHandshake();
   SetLinkModeDependentVariables(); /* call before InitModemTasks_PostHandshake() */
   InitModemTasks_PostHandshake();

   InitUnitTests();

   /* ==================================================================== */
   /*  ******************  Initialize Function Tables ******************** */
   /* ==================================================================== */


      UnitTestInitFns[0]        = (PtrToFunc)VectorPowerUTInit;
      UnitTestFns[0]        = (PtrToFunc)VectorPowerUT;
      UnitTestPrintFns[0]        = (PtrToFunc)VectorPowerUTPrint;

      UnitTestInitFns[1]        = (PtrToFunc)BgAlignmentUTInit;
      UnitTestFns[1]        = (PtrToFunc)BgAlignmentUT;
      UnitTestPrintFns[1]        = (PtrToFunc)BgAlignmentUTPrint;

      UnitTestInitFns[2]        = (PtrToFunc)FDQTrainUTInit;
      UnitTestFns[2]        = (PtrToFunc)FDQTrainUT;
      UnitTestPrintFns[2]        = (PtrToFunc)FDQTrainUTPrint;

      UnitTestInitFns[3]        = (PtrToFunc)BGReverb2SnrCalcUTInit;
      UnitTestFns[3]        = (PtrToFunc)BGReverb2SnrCalcUT;
      UnitTestPrintFns[3]        = (PtrToFunc)BGReverb2SnrCalcUTPrint;

      UnitTestInitFns[4]        = (PtrToFunc)BgDECTrain2UTInit;
      UnitTestFns[4]        = (PtrToFunc)BgDECTrain2UT;
      UnitTestPrintFns[4]        = (PtrToFunc)BgDECTrain2UTPrint;

      UnitTestInitFns[5]        = (PtrToFunc)TdqInitUTInit;
      UnitTestFns[5]        = (PtrToFunc)TdqInitUT;
      UnitTestPrintFns[5]        = (PtrToFunc)TdqInitUTPrint;

   /* ==================================================================== */
   /*  **************  Initialize which unit tests to run  **************  */
   /* ==================================================================== */

#ifdef UNITTEST_PRN
   if ((UnitTestReadPtr = fopen("units.in","r")) == NULL) {
         fprintf(stderr, "Cannot open input file units.in \n");
   }
   for(i = 1; fscanf(UnitTestReadPtr, "%d\n", &units[i]) == 1; i++){
   }
   fclose(UnitTestReadPtr);
#endif

   /* ==================================================================== */
   /*  ******************  Run BgAlignment Cocomo Test  *****************  */
   /* ==================================================================== */


   if (units[1] == 1) {
   for (gs_UnitTestIteration = 1; gs_UnitTestIteration < 7; gs_UnitTestIteration++)
   {
#ifdef UNITTEST_PRN
      if (gs_UnitTestIteration == 1)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fralign\\ansi7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fralign\\ansi7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 2)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fralign\\ansi13.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fralign\\ansi13.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 3)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fralign\\csa4.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fralign\\csa4.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 4)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fralign\\csa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fralign\\csa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 5)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fralign\\csa7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fralign\\csa7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 6)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fralign\\midcsa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fralign\\midcsa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }

#endif
         UnitTestInitFns[1]();
         UnitTestFns[1]();
#ifdef UNITTEST_PRN
         UnitTestPrintFns[1]();
#endif

   }
   }

   /* ==================================================================== */
   /*  ******************  Run FDQTrain Cocomo Test  *****************     */
   /* ==================================================================== */

   if (units[2] == 1) {
   for (gs_UnitTestIteration = 1; gs_UnitTestIteration < 7; gs_UnitTestIteration++)
   {
#ifdef UNITTEST_PRN
      if (gs_UnitTestIteration == 1)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fdq\\ansi7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fdq\\ansi7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 2)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fdq\\ansi13.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fdq\\ansi13.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 3)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fdq\\csa4.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fdq\\csa4.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 4)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fdq\\csa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fdq\\csa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 5)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fdq\\csa7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fdq\\csa7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 6)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\fdq\\midcsa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\fdq\\midcsa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }

#endif
         UnitTestInitFns[2]();
         UnitTestFns[2]();
#ifdef UNITTEST_PRN
         UnitTestPrintFns[2]();
#endif

   }
   }


   /* ==================================================================== */
   /*  ******************  Run BGReverb2SnrCalc Cocomo Test  *********     */
   /* ==================================================================== */

   if (units[3] == 1) {
   for (gs_UnitTestIteration = 1; gs_UnitTestIteration < 7; gs_UnitTestIteration++)
   {
#ifdef UNITTEST_PRN
      if (gs_UnitTestIteration == 1)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\snr\\ansi7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\snr\\ansi7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 2)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\snr\\ansi13.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\snr\\ansi13.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 3)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\snr\\csa4.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\snr\\csa4.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 4)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\snr\\csa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\snr\\csa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 5)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\snr\\csa7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\snr\\csa7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 6)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\snr\\midcsa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\snr\\midcsa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }

#endif
         UnitTestInitFns[3]();
         UnitTestFns[3]();
#ifdef UNITTEST_PRN
         UnitTestPrintFns[3]();
#endif

   }
   }

   /* ==================================================================== */
   /*  ******************  Run BgDECTrain2 Cocomo Test  *********    */
   /* ==================================================================== */

   if (units[4] == 1) {
   for (gs_UnitTestIteration = 1; gs_UnitTestIteration < 7; gs_UnitTestIteration++)
   {
#ifdef UNITTEST_PRN
      if (gs_UnitTestIteration == 1)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\dec\\ansi7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\dec\\ansi7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 2)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\dec\\ansi13.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\dec\\ansi13.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 3)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\dec\\csa4.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\dec\\csa4.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 4)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\dec\\csa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\dec\\csa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 5)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\dec\\csa7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\dec\\csa7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 6)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\dec\\midcsa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\dec\\midcsa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }

#endif
         UnitTestInitFns[4]();
         UnitTestFns[4]();
#ifdef UNITTEST_PRN
         UnitTestPrintFns[4]();
#endif

   }
   }


   /* ==================================================================== */
   /*  ******************  Run TdqInit Cocomo Test  *********     */
   /* ==================================================================== */

   if (units[5] == 1) {
   for (gs_UnitTestIteration = 1; gs_UnitTestIteration < 7; gs_UnitTestIteration++)
   {
#ifdef UNITTEST_PRN
      if (gs_UnitTestIteration == 1)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\tdq\\ansi7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\tdq\\ansi7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 2)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\tdq\\ansi13.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\tdq\\ansi13.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 3)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\tdq\\csa4.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\tdq\\csa4.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 4)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\tdq\\csa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\tdq\\csa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 5)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\tdq\\csa7.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\tdq\\csa7.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }
      if (gs_UnitTestIteration == 6)
      {
         strcpy(input_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testvec\\g992_1\\tdq\\midcsa6.in");
         if ((UnitTestInPtr = fopen(input_file,"r")) == NULL) {
            fprintf(stderr, "Cannot open input file %s \n", input_file);
         }
         strcpy(output_file, "..\\..\\..\\..\\..\\..\\..\\tdpqa\\qa\\testcocomo\\g992_1\\tdq\\midcsa6.out");
         if ((UnitTestOutPtr = fopen(output_file,"w")) == NULL) {
            fprintf(stderr, "Cannot open output file %s \n", output_file);
         }
      }

#endif
         UnitTestInitFns[5]();
         UnitTestFns[5]();
#ifdef UNITTEST_PRN
         UnitTestPrintFns[5]();
#endif

   }
   }

   /* ==================================================================== */
   /*  ******************  Platform Test ************************* */
   /* ==================================================================== */

   cyclecount(test_index);
   cyclecount(test_index);
   cyclecount(test_index);

   /* ==================================================================== */
   /*  ******************  End Test Code ************************* */
   /* ==================================================================== */


}

