/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   tvcont.c
*
*  Functions for controlling test vector generation and tests
*-------------------------------------------------------------------------
*/

#include <string.h>
#include <stdio.h>
#include "typedef.h"
#include "common.h"
#include "pll.h"
#include "tx_ops.h"
#include "gdata.h"
#include "showtime.h"
#include "states.h"
#include "rx_ops.h"
#include "acc48_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "trail.h"
#include "const.h"
#include "bert.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "fifo.h"
#include "debug.h"
#include "cmv.h"
#include "medley.h"
#include "rt_tones.h"
#include "accum32.h"
#include "noiseacc.h"
#include "snr.h"
#include "pga_set.h"
#include "ieee_flt.h"
#include "dsp_op.h"
#include "fdq_init.h"
#include "detect.h"
#include "GenMedly.h"

int16 gs_NoiseAccTVFlag;
int16 noiseacc_test_rec[512];
int16 noiseacc_test_ref[512];
int32 noiseacc_test_acc[512];


int32 l_temp1,l_temp2,l_temp3,l_temp4,l_temp5;
int16 s_temp1,s_temp2,s_temp3,s_temp4,s_temp5;


extern int16 gsa_unpk_PN_US[PN_US_LEN + 1];
extern int16 gsa_unpk_PN512[PN512_LEN + 1];       /* DMT tones generated using PN512 */
extern int16 gs_TxFirstPNbit, gs_RxFirstPNbit;

                                                /*  did not correlate */

/*****************************************************************************
;  Prototype: void UnitTest(int16 gs_TestIndex)
;
;     This function runs a unit test based indexed by parameter gs_TestIndex
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

#define MIPS_TEST
#define TV_TEST

void cyclecount(int16 index)
{

   int16 sa_snr_ref_tones[512];
   int16 i;

   int16 temp16;
   int32 temp32=0;

   int32   l_Psam;
   int16 temp_val;
   int16   *temp_ptr;

   int32 gl_acc48H=0;
   int32 gl_acc48L=0;

   Float32 gx,gy,gz;

   int16 s_nchannels;
   static int16 s_GuardBits = -1;
   int16 *ps_databuf;

   switch (index)
   {
      case 1:
#ifdef MIPS_TEST
         l_temp1 = VectorPower(noiseacc_test_ref, 0, 2*255, 8);
#endif
#ifdef TV_TEST
         if (s_GuardBits == -1)
         {
         s_GuardBits = RXPWR_GUARD_BITS;
         }
         s_nchannels = gs_RxLastChannel - gs_RxFirstChannel + 1;
         ps_databuf = gsa_RxToneBuf+2*gs_RxFirstChannel;


         l_temp1 = VectorPower(noiseacc_test_ref, 0, 2*s_nchannels, s_GuardBits);
         l_temp2 = VectorPower(noiseacc_test_ref, 0, 2, 8);
         l_temp3 = VectorPower(noiseacc_test_ref, 0, 2*s_GuardBits, 0);
         l_temp4 = VectorPower(noiseacc_test_ref, 0, 4, s_GuardBits);
         l_temp5 = VectorPower(noiseacc_test_ref, 0, 400, 0);

         s_GuardBits++;
         s_GuardBits++;
#endif
         break;

      case 2:

         GenerateMedley(gsa_unpk_PN512, sa_snr_ref_tones, gs_RxFirstPNbit, (int16)PN512_LEN, gs_RxFftLength);

         break;

      case 3:
         TxReverbSegueSetUp(6, 31, 0x1800);
         break;

      case 4:


         NoiseAcc(noiseacc_test_acc, 2*gs_RxFirstChannel, noiseacc_test_rec, gs_RxFirstPNbit,(int16)PN512_LEN, gs_RxFftLength,
               noiseacc_test_ref,(int16)gs_RxFirstChannel, (int16)gs_RxLastChannel);

         break;

      case 5:
         Accum16to32(noiseacc_test_acc, 0, noiseacc_test_rec, 0, gs_RxFftLength);
         break;


      case 6:

         gs_TxNextState = UNKNOWN;
         gs_TxState = UNKNOWN;
         gpF_TxStateFunc = (PtrToFunc)EmptyState;
         TxForeGround();
         break;

      case 7:

         gs_RxNextState = UNKNOWN;
         gs_RxState = UNKNOWN;
         gpF_RxStateFunc = (PtrToFunc)EmptyState;
         RxForeGround();
         break;
         break;

      case 8:

         DetectTone(gsa_RxToneBuf, C_PILOT_TONE, C_PILOT_TONE_MIN, C_PILOT_TONE_MAX, (DETECT_SCALE*256));
         break;


      case 9:

         i = DetectReverbSegue(gusa_PN512Tab, NUM_REVERB_SEGUE_BINS, FIRST_REVERB_SEGUE_BIN);
         break;

      case 10:

         i = DetectReverbSegue(gusa_PN512Tab, 100, FIRST_REVERB_SEGUE_BIN);
         break;


      case 11:
         ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
         break;


      case 12:
      /* do I need a better vector here? make sure we don't take a short path */
      /* through the code */
         PLL(gsa_RxPilotTone);
         break;

      case 13:
      /*  accumulate received power */
      /*  accumulate received power */
         temp_ptr = noiseacc_test_ref;
         gl_acc48L = 0;
         gl_acc48H = 0;
         for (i = 0; i < gs_RxFftLength; i++)
         {
            temp_val = *temp_ptr++;
            l_Psam = (int32)temp_val*temp_val;
            gl_acc48L += l_Psam & 0xFFFF;
            gl_acc48H += l_Psam >> 16;
         }
         norm_acc48(&gl_acc48H, &gl_acc48L);

         l_temp1 = round_acc48(gl_acc48H, gl_acc48L,
                        (int16)(gs_RxLog2FftLength1+1+LOG2_PGA_ACCUM_SYMBOLS));
         l_temp2 = VectorPower(noiseacc_test_ref, 0, 512, (int16)(gs_RxLog2FftLength1+1+LOG2_PGA_ACCUM_SYMBOLS));
         break;

      case 14:
         norm_acc48(&gl_acc48H, &gl_acc48L);
         break;

      case 15:
         temp32 = round_acc48(gl_acc48H, gl_acc48L,
                        (int16)(gs_RxLog2FftLength1+1+LOG2_PGA_ACCUM_SYMBOLS));
         break;

      case 16:
         temp16 = ConvertToDB(temp32); /* recommended cutback */
         break;

      case 17:
         /*Gen_Reverb_Ref_fd(gsa_CReverbRefTones, "C", gs_RxNumTones,
                     gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));
         UnpackPN(gsa_unpk_PN512, (PN512_LEN + 1), gusa_PN512Tab, (int16)(DEC_QPSK_GAIN));
         FdqAdjust(gsa_FDQ_coef_sav, gsa_FDQ_exp_sav, (int16)(gs_SynchOffsetIdx-POSTSYNCH_SEARCH_OFFSET),
               gsa_pre_FDQ_coef, gsa_pre_FDQ_exp);*/


         break;


      case 18:
         temp16 = 37;
         gx  = int2f32(temp16);
         temp16 = -49;
         gy  = int2f32(temp16);
         break;

      case 19:
      /* int32toFloat32(int32 l_xin);  */
         break;

      case 20:

            /*    int16 f32toint16(Float32 f_in, int16 s_conv_mode); */
         break;

      case 21:
         temp16 = 37;
         gx  = int2f32(temp16);
         temp16 = -49;
         gy  = int2f32(temp16);
         gz =  addf32(gx,gy);
         break;
      case 22:
         temp16 = 37;
         gx  = int2f32(temp16);
         temp16 = -49;
         gy  = int2f32(temp16);
         gz =  subf32(gx,gy);
         break;
      case 23:
         temp16 = 37;
         gx  = int2f32(temp16);
         temp16 = -49;
         gy  = int2f32(temp16);
         gz =  mpyf32(gx,gy);
         break;
      case 24:
         temp16 = 37;
         gx  = int2f32(temp16);
         temp16 = -49;
         gy  = int2f32(temp16);
         gz =  divf32(gx,gy);
         break;

      case 25:
         l_temp2++;
         l_temp3 = l_add(l_temp1,l_temp2);
         l_temp5 = l_add(l_temp4,-l_temp2);
         break;

      case 26:
         s_temp2++;
         l_temp3 = round(l_temp1,s_temp2);
         l_temp5 = round(l_temp4,s_temp2);
         break;

      case 27:
         memcpy(gsa_RxToneBuf, &gsa_RxRepFrameAlignBuf[(int16)gus_SyncOffset],
               sizeof(int16)*(gs_RxFftLength-gus_SyncOffset));
         memcpy(&gsa_RxToneBuf[(int16)(gs_RxFftLength-gus_SyncOffset)], &gsa_RxRepFrameAlignBuf[0],
               sizeof(int16)*(gus_SyncOffset));
         memcpy(gsa_RxRepFrameAlignBuf, gsa_RxToneBuf, sizeof(int16)*gs_RxFftLength);
         break;

      case 28:
         gt_TaskArray[TX_FRAME_START].TimeCriticalTask = TxProcessTones/*(PtrToFunc) NULL*/;
         gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask = /*TxForeGround*/(PtrToFunc) NULL;

         gs_IntNextFrameEnable = (int16) (gs_IntNextFrameEnable | (1<<TX_FRAME_START));
         gs_InterruptEnableMask=gs_IntNextFrameEnable;
         SetInterrupt(TX_FRAME_START);
         gs_TxState = 0;
         MasterIntHandler();

         ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);

         break;




   }


}



/*****************************************************************************
;  Prototype: void TestVectorRxControl(void)
;
;  This subroutine uses the state, the symbol, and other information to
;  "trigger" a particular test vector generation.  The generation functions
;  themselves are called from within each function and are called based on
;  the flags set within this function.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;
;  Global Variables:
;     gs_TxState
;     gs_RxState
;     gl_TxSymbolCount
;     gl_RxSymbolCount
;     gs_TxSubStateCnt
;     gs_RxSubStateCnt
;
;****************************************************************************/

/* define R_C_MEDLEY substates */
#define R_C_MEDLEY_RX_TEST_FRAME_SYNCH  (0)
#define R_C_MEDLEY_RX_PICK_FRAME_SYNCH  (1)
#define R_C_MEDLEY_RX_CALCULATE_SNR     (2)
#define R_C_MEDLEY_RX_WAIT              (3)
#define R_C_MEDLEY_RX_DETECT_SEGUE      (4)

void TestVectorRxControl(void)
{


   /* =============================================================================== */
   /*  NoiseAcc Test Vector Control                                     */
   /* =============================================================================== */
   if ((gs_RxState == R_C_MEDLEY_RX) &&
      (gs_RxSubState == R_C_MEDLEY_RX_CALCULATE_SNR) &&
      (gs_RxSubStateCnt == R_C_MEDLEY_WT_LEN) )
   {
      gs_NoiseAccTVFlag = 1;
   }



}






/* undefine R_C_MEDLEY substates */
#undef R_C_MEDLEY_RX_TEST_FRAME_SYNCH
#undef R_C_MEDLEY_RX_PICK_FRAME_SYNCH
#undef R_C_MEDLEY_RX_CALCULATE_SNR
#undef R_C_MEDLEY_RX_WAIT
#undef R_C_MEDLEY_RX_DETECT_SEGUE

/*-------------------------------------------------------------------
*
*  void InitUnitTests(void)
*
*  Description:
*
*
*
*-------------------------------------------------------------------
*^^^
*/

void InitUnitTests()
{
   int16 i;

   for (i=0; i<256; i++)
   {
      noiseacc_test_ref[2*i] = (int16)0x2000;
      noiseacc_test_ref[2*i+1] = (int16)0xe000;
      noiseacc_test_rec[2*i] = noiseacc_test_ref[2*i] + 10*i;
      noiseacc_test_rec[2*i+1] = noiseacc_test_ref[2*i+1] - 10*i;
      noiseacc_test_acc[i] = 0;
   }

   l_temp1 = 0x7ffe;
   l_temp2 = -1;
   l_temp3 = 0;
   l_temp4 = 0x8001;
   l_temp5 = 0;

   s_temp1 = (int16)0x7ffe;
   s_temp2 = -1;
   s_temp3 = 0;
   s_temp4 = (int16)0x8004;
   s_temp5 = 0;

}


