/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   tvcont.c
*
*  Functions for controlling test vector generation and tests
*-------------------------------------------------------------------------
*/

#include <string.h>
#include <stdio.h>
#include "typedef.h"
#include "common.h"
#include "pll.h"
#include "tx_ops.h"
#include "gdata.h"
#include "showtime.h"
#include "states.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "trail.h"
#include "const.h"
#include "bert.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "fifo.h"
#include "debug.h"
#include "cmv.h"
#include "medley.h"
#include "rt_tones.h"
#include "accum32.h"
#include "noiseacc.h"
#include "snr.h"
#include "pga_set.h"
#include "ieee_flt.h"
#include "dsp_op.h"
#include "fdq_init.h"
#include "ec_data.h"
#include "tx_ops2.h"



int16 gs_NoiseAccTVFlag;
int16 noiseacc_test_rec[512];
int16 noiseacc_test_ref[512];
int32 noiseacc_test_acc[512];

int32 l_temp1,l_temp2,l_temp3,l_temp4,l_temp5;
int16 s_temp1,s_temp2,s_temp3,s_temp4,s_temp5;

void BgAlignmentTraining(void);
void BGReverb2SnrCalc(void);
void BgDECTrain2(void);
void TdqInit(void);


extern int16 gsa_unpk_PN_US[PN_US_LEN + 1];
extern int16 gsa_unpk_PN512[PN512_LEN + 1];       /* DMT tones generated using PN512 */
extern int16 gs_TxFirstPNbit, gs_RxFirstPNbit;
                                                /*  did not correlate */

extern int32 gla_VectorPowerOut[3];
extern FILE *UnitTestOutPtr;
extern FILE *UnitTestInPtr;
extern int16 gs_UnitTestIndex;
extern int16 gs_UnitTestIteration;



/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void VectorPowerUTInit(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void VectorPowerUTInit(void)
{

   switch(gs_UnitTestIteration)
   {
      case 1:

         /* Generate reference C_Reverb signal */
         Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
                     gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));
         break;

      case 2:

         /* Generate reference C_Reverb signal */
         Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
                     gs_RxFirstChannel, gs_RxLastChannel, (int16)(0x7FFF));
         break;

      case 3:

         /* Generate reference C_Reverb signal */
         Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
                     gs_RxFirstChannel, gs_RxLastChannel, (int16)(0x0001));
         break;
   }


}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void VectorPowerUT(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void VectorPowerUT(void)
{

   switch(gs_UnitTestIteration)
   {
      case 1:

         gla_VectorPowerOut[0] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 0);
         gla_VectorPowerOut[1] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 4);
         gla_VectorPowerOut[2] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 8);
         break;

      case 2:

         gla_VectorPowerOut[0] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 0);
         gla_VectorPowerOut[1] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 4);
         gla_VectorPowerOut[2] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 8);
         break;

      case 3:

         gla_VectorPowerOut[0] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 0);
         gla_VectorPowerOut[1] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 4);
         gla_VectorPowerOut[2] = VectorPower(gsa_CReverbRefTones, 0, 2*gs_RxFftLength, 8);
         break;
   }


}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void VectorPowerUTPrint(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void VectorPowerUTPrint(void)
{

#ifdef UNITTEST_PRN
fprintf(UnitTestOutPtr, "TV:VectorPower:\t %ld %ld %ld\n", gla_VectorPowerOut[0],gla_VectorPowerOut[1],gla_VectorPowerOut[2]);
#endif

}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BgAlignmentUTInit(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void BgAlignmentUTInit(void)
{

   int16 i;

   /* Generate reference C_Reverb signal */
   Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
                     gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));

#ifdef UNITTEST_PRN
   for(i = 0; fscanf(UnitTestInPtr, "%d\n", &gsa_RxRepFrameAlignBuf[i]) == 1; i++){
   }
   fclose(UnitTestInPtr);
#endif


}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BgAlignmentUT(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void BgAlignmentUT(void)
{

   BgAlignmentTraining();

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BgAlignmentUTPrint(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void BgAlignmentUTPrint(void)
{

   int16  i;

#ifdef UNITTEST_PRN
   for (i = 0; i < 512; i++)
   {
      fprintf(UnitTestOutPtr, "TV:RxRepFrameAlignBuf:\t %d \t TV:SyncOffset:\t %d\n", gsa_RxRepFrameAlignBuf[i], gus_SyncOffset);
   }
fclose(UnitTestOutPtr);
#endif

}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void FDQTrainUTInit(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void FDQTrainUTInit(void)
{

   int16 i;

   /* Generate reference C_Reverb signal */
   Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
                     gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));
#ifdef UNITTEST_PRN
   for(i = 0; fscanf(UnitTestInPtr, "%lx\n", &gsa_RxRepFDQTrainBuf[i]) == 1; i++){
   }
   fclose(UnitTestInPtr);
#endif

}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void FDQTrainUT(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void FDQTrainUT(void)
{

   FDQTrain();

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void FDQTrainUTPrint(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void FDQTrainUTPrint(void)
{

   int16 i, j;

#ifdef UNITTEST_PRN
   for (i = 0; i < 256; i++)
   {
      j = i * 2;
      fprintf(UnitTestOutPtr, "TV:FDQcoeff:\t %3d  0x%X  0x%X  0x%X\n",
                        i,
                        gsa_pre_FDQ_coef[j],
                        gsa_pre_FDQ_coef[j+1],
                        gsa_pre_FDQ_exp[i]);

   }
fclose(UnitTestOutPtr);
#endif

}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BGReverb2SnrCalcUTInit(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void BGReverb2SnrCalcUTInit(void)
{
   int16 i;
   int32 *pla_RxAccumBufTmp;

   pla_RxAccumBufTmp = gla_RxAccumBuf;

   /* Generate reference C_Reverb signal */
   Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
                     gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));

#ifdef UNITTEST_PRN
    for(i = 0; fscanf(UnitTestInPtr, "%lx\n", &gla_RxAccumBuf[i]) == 1; i++){
   }
   fclose(UnitTestInPtr);
#endif

   /* Takes care of the issue of 16-TDP word v.s. 32-bit PC word */
   for(i = gs_RxFirstChannel; i <= 2*gs_RxLastChannel + 1; i++) {
      pla_RxAccumBufTmp[i] = ((gla_RxAccumBuf[2*i+1]) << 16) +
         (gla_RxAccumBuf[2*i] & ((int32) 0x0000FFFF));
   }
}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BGReverb2SnrCalcUT(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void BGReverb2SnrCalcUT(void)
{

   BGReverb2SnrCalc();

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BGReverb2SnrCalcUTPrint(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void BGReverb2SnrCalcUTPrint(void)
{
   int16 i;

#ifdef UNITTEST_PRN
   for (i = 0; i < 256; i++){
      fprintf(UnitTestOutPtr, "TV:SNR(Q8.8):\t Channel %3d \t 0x%X\n", i, gsa_ReverbSnrBuf[i]);
   }
#endif
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BgDECTrain2UTInit(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void BgDECTrain2UTInit(void)
{
   int16 i, *ps_temp;

#ifdef UNITTEST_PRN
   /* Read input from file & convert it to 32-bit word */
   ps_temp = (int16 *)gla_RxAccumBuf;
   for(i=0;i<DEC_TRAINING_PERIOD*gs_RxFftLength;i++) {
      fscanf(UnitTestInPtr,"0x%x\n",&*ps_temp++);
      fscanf(UnitTestInPtr,"0x%x\n",&*ps_temp++);
   }
   fclose(UnitTestInPtr);
#endif
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BGReverb2SnrCalcUT(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void BgDECTrain2UT(void)
{

   BgDECTrain2();

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BGReverb2SnrCalcUTPrint(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void BgDECTrain2UTPrint(void)
{
   int16 i;

#ifdef UNITTEST_PRN
   fprintf(UnitTestOutPtr,"%d\n",gs_pre_dec_h_exp);
   fprintf(UnitTestOutPtr,"%d\n",gs_pre_dec_h_delay);
   for (i = 0;i<DEC_ORDER;i++) {
      fprintf(UnitTestOutPtr,"%d\n",gsa_pre_dec_h[i]);
   }
#endif
}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void TdqInitUTInit(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void TdqInitUTInit(void)
{
   int16 i, *ps_temp;

#ifdef UNITTEST_PRN
   /* Read input from a file */
   ps_temp = (int16 *)gsa_RxRepFrameAlignBuf;
   for(i=0;i<gs_RxFftLength;i++) {
      fscanf(UnitTestInPtr,"%d\n",&*ps_temp++);
   }
   fclose(UnitTestInPtr);
#endif
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void TdqInitUT(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void TdqInitUT(void)
{

   TdqInit();

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void TdqInitUTPrint(void);
*
*   Description:
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void TdqInitUTPrint(void)
{
   int16 i;

#ifdef UNITTEST_PRN
   fprintf(UnitTestOutPtr,"%d\n",gs_pre_tdq_h_exp);
   for (i = 0;i<gs_TDQLen;i++) {
      fprintf(UnitTestOutPtr,"%d\n",gsa_pre_tdq_h[i]);
   }
   fclose(UnitTestOutPtr);
#endif
}
