/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   CalcDECPathDelay.c
 *
 *   Function for calculating DEC path delay.
 *
 *------------------------------------------------------------------------
 */

#include "gdata.h"
#include "ec_data.h"
#include "gdata_bis.h"
#include "cmv.h"

int32  gw_DbgRms=0;
int16 CalcDECPathDelay(void)
{
   int16 s_delay, s_temp;
    int16 *psa_RxToneBuf;

   // Assume Tx is sending a ramp signal with values ranging from (1,128)
   // Scan using a window of width DecUpSamplingFactor for non-zero value in RxToneBuf
   s_delay = gs_RxSamplesPerFrame-gs_DECUpsamplingFactor;
   psa_RxToneBuf = &gsa_RxToneBuf[s_delay];
   while(s_delay < gs_RxSamplesPerFrame)
   {
       /* temporary workaround for AnnexL */
#ifndef ADSL_62
      if((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_L)  )) == 0)
         s_temp =  gsa_RxToneBuf[(s_delay - ((*psa_RxToneBuf - 1)*gs_DECUpsamplingFactor))];
      else
         s_temp = 1;
#else
      s_temp =  gsa_RxToneBuf[(s_delay - ((*psa_RxToneBuf - 1)*gs_DECUpsamplingFactor))];
#endif //ADSL_62
      // Non-zero value found, deduce the position of value 1
      if(   (*psa_RxToneBuf != 0) &&
         (s_temp == 1))
      {
         return(s_delay - ((*psa_RxToneBuf - 1)*gs_DECUpsamplingFactor));
      }
      else
      {
         s_delay++;
         psa_RxToneBuf++;
      }
   }
   return(-1);
}
