/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   DecTrain_b.c
 *
 *   Functions for BG Tasks from rcpilot3.c
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "dsp_op.h"
#include "tx_ops.h"
#include "pll.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ec_init.h"
#include "DSLEngin.h"
#include "xrtstate.h"
#include "fifo.h"
#include "ec_data.h"
#include "accum32.h"
#include "cmv.h"
#include <string.h>
#include "tx_ops2.h"
#include "memcopy.h"
#include "memsetbf.h"
#include "vecpwr.h"
#include "DecTrain_Data.h"

#define FFT_LEN_1024          1024

/* =============================================== */
/* constants used by this file only */
/* =============================================== */
#define DEBUG_IO           /* turn off file write if DEBUG_IO is defined */
#if (DEC_TRAINING_PERIOD == 2)
#define DEC_NORMALIZING_SHIFT (LOG2_NUM_DEC_TRAINING_SYMBOLS-1)
#else // DEC_TRAINING_PERIOD == 1
#define DEC_NORMALIZING_SHIFT (LOG2_NUM_DEC_TRAINING_SYMBOLS)
#endif

#ifndef DEBUG_IO
extern FILE *debug_dec, *debug_dec3;
#endif

extern int16 *ps_RxDECTrainRepBuf;
extern int16 gs_dec_path_fdelay,gs_dec_path_sdelay;

void BgDECTrainAveragePilot(void)
{

   int16 i,j;
   int32 *pl_AccumBuf, *pl_CPilot;
   int16 pilot;
   int16 s_shift;
   // initialize the accum buf with the negated acumulation of the pilot.
   // This accomplishes subtraction of the pilot when the DEC training
   // sequence is accumulated.

    /* In G.Lite with TDQ working at 1.1Mhz, we only have 256 non-zero values in
      gsa_RxToneBuf array which implies pilot tone period equal to 4 samples.
      In other cases, pilot tone period is equal to 8 */
   pilot = gs_CPilotTone;

   if((pilot ==48) || (pilot ==80) || (pilot > 96))
   {
      if(gs_RxFftLength == FFT_LEN_1024)
      {
         /* fs = 4.416MHz */
         gs_PilotPeriod =64;  // 64 samples correspond to 3 periods for pilot==48 and 5 periods for pilot==80
      }
      else
      {
         /* fs = 2.208MHz */
         gs_PilotPeriod =32;  // 64 samples correspond to 3 periods for pilot==48 and 5 periods for pilot==80
      }
      s_shift =LOG2_NUM_PILOT_EST_SYMBOLS + 4- DEC_NORMALIZING_SHIFT;
   }
   else if (pilot == 96){
      if(gs_RxFftLength == FFT_LEN_1024)
      {
         /* fs = 4.416MHz */
         gs_PilotPeriod =32; // 32 samples correspond to 3 periods.
      }
      else
      {
         /* fs = 2.208MHz */
         gs_PilotPeriod =16; // Annex B: 16 samples correspond to 3 periods.
      }
      s_shift =LOG2_NUM_PILOT_EST_SYMBOLS + 5 - DEC_NORMALIZING_SHIFT;

   }
   else if (OPTNArray[OPTN_AlgControl] & OPTN_Run_TDQ_at_1104){
       gs_PilotPeriod =4;
       s_shift =LOG2_NUM_PILOT_EST_SYMBOLS + 6- DEC_NORMALIZING_SHIFT;
   }
    else{

      if(gs_RxFftLength == FFT_LEN_1024)
      {
         gs_PilotPeriod = 16; /* fs = 4.416MHz */
      }
      else
      {
         gs_PilotPeriod = 8; /* fs = 2.208MHz */
      }
      s_shift =LOG2_NUM_PILOT_EST_SYMBOLS + 6- DEC_NORMALIZING_SHIFT;

   }

   pl_AccumBuf = gla_RxAccumBuf + gs_PilotPeriod;

   for(i=0; i<(gs_RxSamplesPerFrame/gs_PilotPeriod)-1; i++)
   {
        pl_CPilot = gla_RxAccumBuf;

      for(j=0; j<gs_PilotPeriod; j++)
      {
          *pl_CPilot = *pl_CPilot + *pl_AccumBuf;
      pl_CPilot++;
      pl_AccumBuf++;
      }
   }


   pl_CPilot = gla_RxAccumBuf;
   pl_AccumBuf = gla_RxAccumBuf;

   for(i = 0; i < gs_PilotPeriod; i++) {
      *pl_CPilot++ = -(*pl_AccumBuf++ >> s_shift);

   }


   for(i=1; i<(gs_RxSamplesPerFrame/gs_PilotPeriod); i++)
   {
          pl_CPilot = gla_RxAccumBuf + i*gs_PilotPeriod;
          MemCopyWords((int16 *)(void *)pl_CPilot, 0, (int16 *)(void *)gla_RxAccumBuf, 0, (int16)(sizeof(int32)*gs_PilotPeriod/(sizeof(int16))));
   }

#if (DEC_TRAINING_PERIOD == 2)
   pl_CPilot = gla_RxAccumBuf  + gs_RxSamplesPerFrame;
   MemCopyWords((int16 *)(pl_CPilot), 0, (int16 *)(gla_RxAccumBuf), 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame/(sizeof(int16))));
#endif

   guc_EcTrainingState = TRAINING_DONE;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background functions to perform DEC training pre-processing.
 *
 *  Prototype: void BgDECTrain2PreProc(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */

void BgDECTrain2PreProc(void)
{

   int16 i;
   int32 *pl_AccumBuf;
   int32 l_Average = 0;

   ps_RxDECTrainRepBuf = (int16 *)(void *)gla_RxAccumBuf;
   pl_AccumBuf  = gla_RxAccumBuf;

   // This conversion from 32 to 16 bits is done in place. Also find DC value.
   for(i=0 ; i<DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame ; i++) {
      *ps_RxDECTrainRepBuf = (int16) (*pl_AccumBuf >> DEC_NORMALIZING_SHIFT);
      l_Average += (int32)(*ps_RxDECTrainRepBuf);
      ps_RxDECTrainRepBuf++;
      pl_AccumBuf++;
   }
#if (DEC_TRAINING_PERIOD == 1)
   l_Average = l_Average/gs_RxSamplesPerFrame;
#else
   l_Average =  l_Average/(2*gs_RxSamplesPerFrame);
#endif

   /* If RT asks the CO to transmit C-QUIET during R-ECT */
   if (!gft_PilotOnDecTraining)
   {
      // Remove average from the DEC training signal
      ps_RxDECTrainRepBuf = (int16 *)(void *)gla_RxAccumBuf;
      for (i = 0; i < DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame; i++)
      {
         *ps_RxDECTrainRepBuf -= (int16)l_Average;
         ps_RxDECTrainRepBuf++;
      }
   }

#ifndef DEBUG_IO
   debug_dec = fopen("debug_dec.txt","w");
   ps_RxDECTrainRepBuf = (int16 *) gla_RxAccumBuf;
   for(i=0; i<DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame; i++)
      fprintf(debug_dec, "%d\n", *ps_RxDECTrainRepBuf++);
   fclose(debug_dec);
#endif

   guc_EcTrainingState = TRAINING_IN_PROGRESS;

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background functions to perform DEC training
 *
 *  Prototype: void BgDECTrain2(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgDECTrain2(void)
{

   // Measure average echo power per time domain sample.  Currently used as diagnostic only.
   gl_AvgEchoPowerPerSample= (int32)(VectorPower((int16*)(void *)gla_RxAccumBuf,0,(int16)(gs_RxSamplesPerFrame),(int16)(gs_Log2RxSamplesPerFrame+1) ));

   DECTrain2b(gpsa_DECCorrBuf, (int16 *)(void *)gla_RxAccumBuf, gla_RxDECXcorr);

   // restore C-Reverb reference which may have been obliterated by accumulation
   // if DEC_ORDER+(MAX_DEC_DELAY*gs_DECUpsamplingFactor) > 2*(gs_RxNumTones+1).
   // re-examine common buffer assignment to avoid possible buffer overwrite
   // if DEC_ORDER+(MAX_DEC_DELAY*gs_DECUpsamplingFactor) > 3*(gs_RxNumTones+1).

   Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
      gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));

   /* Reordering of DEC filter coefficients before loading into the Strymon CPE */
   if (gft_ReorderDEC == TRUE) {
      MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
      ReorderDEC((int16 *)(void *)gla_RxAccumBuf);
   }

   guc_EcTrainingState = TRAINING_DONE;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to compute DEC Path Delay
 *
 *  Prototype: void BgDECPathDelay(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgDECPathDelay(void)
{
   int16 i, flag=0;
   int16 *ps_RxAcc;

   ps_RxAcc =(int16 *)(void *)&gla_RxAccumBuf[0];

   for(i=0; i<2*gs_RxSamplesPerFrame; i++) {
      if(ps_RxAcc[i] == 0x7FFF) {
         if(gs_dec_path_sdelay >= gs_RxSamplesPerFrame) {
            gs_dec_path_fdelay = 1;
            gs_dec_path_sdelay -= gs_RxSamplesPerFrame;
         }
         flag=1;
         break;
      }
      else
         gs_dec_path_sdelay++;
   }

   /* unit impulse not detected in following 2 received frames */
   if (flag == 0) {
      gs_dec_path_sdelay = -1;
   }

   guc_EcTrainingState = TRAINING_DONE;
}

#undef FFT_LEN_1024
