/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   PGAHandler.c
 *
 *   This file contains the routine that handles the PGA computation.
 *
 *------------------------------------------------------------------------
 */

#include "RCReverb1RxF_bis.h"
#include "cmv.h"
#include "gdata.h"
#include "compiler.h"
#include "pll.h"
#include "afe.h"
#include "pga_set.h"
#include "fifo.h"
#include "snr.h"
#include "STR_ReconfigRx.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

extern int16 gs_Set_Pause;

//XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (Start_End)
//Modification is not connected with Jira XDSLRTFW-271
//Compiler cribbing as function definition and functional call/usage doesn't match.
C_SCOPE void PGADoubleTraining(void)
{

    int16 s_minPGA;
    int16 s_gain_required;

    switch(guc_DoublePgaHandlerState)
    {
    case PGA_INIT:
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_CheckADCOverflow_ADSL);
      guc_DoublePgaHandlerState = PGA_CLEAR_OVERFLOW; //clear overflow bit before starting PGA training
      if(gs_Set_Pause == 2)Pause(0x1011);  //Debug
      break;

    case PGA_CLEAR_OVERFLOW:
      gft_EnablePLL = FALSE;  //Disable PLL while changing the AFE gains
      gs_PGA_Handler_count = 0;
      if(gft_EnableDoublePGATrain == TRUE)
      {
         if(gs_PgaHandlerRun == 0)       // AGC1 Training
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Bypass); //Stymon Rx IIR Bypass
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_InitAFE_RegsPGA);
         }
         else if( gs_PgaHandlerRun == 1) //AGC2 Training
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_RestoreAFE_RegsforAGC2);
         }
      else
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Bypass); //Stymon Rx IIR Bypass
      }

      if(gs_Set_Pause == 3)Pause(0x1012); //Debug
      guc_DoublePgaHandlerState = BOOST_PGA_GAIN;
      break;

    case BOOST_PGA_GAIN:
      if (gs_PGA_Handler_count < 3)
      {
         gs_PGA_Handler_count++;
      }
      else
      {
         // Increase the PGA Gain by 3 dB for overflow detection
         gs_PGA_required = gs_PGA_set + (3<<8);
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);

         gs_PGA_Handler_count = 0;
         // Jump to the new states for ADC overlow detection
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
         guc_DoublePgaHandlerState = PGA_SET_ADC_OVERFLOWS;
         if(gs_Set_Pause == 0x5)Pause(0x1014);  //Debug
      }
      break;

    case PGA_SET_ADC_OVERFLOWS:
      if (guc_PgaTrainingState == TRAINING_DONE)
      {
         gft_EnablePLL = FALSE;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_PGA_Handler_count = 0;
         guc_DoublePgaHandlerState = PGA_WAIT_ADC_OVERFLOWS;

        if(gs_Set_Pause == 0x6)Pause(0x1015); //Debug
      }
      break;

   case PGA_WAIT_ADC_OVERFLOWS:
      // After setting PGA wait for three symbols to check overflows
      if (gs_PGA_Handler_count < 3)
      {
         gs_PGA_Handler_count++;
      }
      else
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_CheckADCOverflow_ADSL);
         guc_DoublePgaHandlerState = PGA_CHECK_ADC_OVERFLOW;
         if(gs_Set_Pause == 0x7)Pause(0x1016); //Debug
      }
      break;

   case PGA_CHECK_ADC_OVERFLOW:
      if(gs_PgaHandlerRun == 1)
      {
        s_minPGA = 6 << 8;    //Total min Gain in (AGC2Var(6)+AGC3(0))
        s_gain_required =  gs_PGA_required - ((gs_AGC1_Gain_Set ) << 8);
      }
      else
      {
        s_minPGA = -6 << 8; //Total min Gain for AGC1 (-6)
        s_gain_required =  gs_PGA_required - ((gs_AGC2_Gain_Set ) << 8);
      }

      if((gft_ADCOverflowed) && (s_gain_required > (s_minPGA)))   // if there were overlows, decrease the gain by one dB and try again
      {
         gs_PGA_required = gs_PGA_required - (1<<8);
         guc_DoublePgaHandlerState = PGA_SET_ADC_OVERFLOWS;
         if(gs_Set_Pause == 0x8)Pause(0x1017);  //Debug
      }
      else   // if there were no overlows continue with the traditional PGA training
      {
         gs_PGA_required = gs_PGA_required - (3<<8);  // decrease by three dB to have margin for overlows
         guc_DoublePgaHandlerState = SET_PGA_WAIT;
          if(gs_Set_Pause == 0x9)Pause(0x1018);
      }

      guc_PgaTrainingState = TRAINING_IN_PROGRESS;

      //Loading "BgPGA() function into BgFIFO is not working, i.e Basically not going to next substate,
      //We don't know the reason.
      //In order to progress further, we are calling directly
      //This requires further investigation.
      //Kannan & Sriram: 29/01/2010
      AFED_BgPGA();

      if(gs_Set_Pause == 0x11)Pause(0x1012);  //Debug
      gs_PGA_Handler_count = 0;
      break;

    case SET_PGA_WAIT:
      if (guc_PgaTrainingState == TRAINING_DONE)
      {
         gft_EnablePLL = FALSE;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_PGA_Handler_count = 0;
         guc_DoublePgaHandlerState = PGA_RX_PWR_INITIALIZE;

         if(gs_Set_Pause == 0x10)Pause(0x1019);  //Debug
      }
      break;

    case PGA_RX_PWR_INITIALIZE:
      gs_PGA_Handler_count++;

      if(gs_PGA_Handler_count == PGA_SETTLING_TIME)
      {
         gft_EnablePLL = TRUE;
         ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
      }

      if (gs_PGA_Handler_count == (R_C_REVERB1_WT_LEN_BIS-4)) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);
      }

      if (gs_PGA_Handler_count == (R_C_REVERB1_WT_LEN_BIS-3)) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);
      }
      /* ============================================================ */
      /*  Wait for channel to stabilize */
      /* ============================================================ */
        if (gs_PGA_Handler_count == (R_C_REVERB1_WT_LEN_BIS-2))
      {

         /* clear average power accumulator; */
         gl_Pa = 0;
#ifdef HW_VECPOW_ACCUM
         gl_Pa_VecPow =0;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,TriggerVectorPower);
         gs_NPR_GuardBits = gs_Log2RxSamplesPerFrame+LOG2_PGA_ACCUM_SYMBOLS;
#endif
         /* Go to next substate */
            guc_DoublePgaHandlerState = SET_PGA;
            gs_PGA_Handler_count = 0;

            if(gs_Set_Pause == 0x12)Pause(0x1013);  //Debug
        }
        break;

    case SET_PGA:
         /* ==================================================================== */
         /* Set the PGA (PGA should be set when both sides transmit REVERB signal) */
         /* ==================================================================== */

         gs_PGA_Handler_count++;

         /*  accumulate received power */
#ifdef HW_VECPOW_ACCUM
         if (gs_PGA_Handler_count <= PGA_ACCUM_SYMBOLS)
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReadVectorPower);

         if (gs_PGA_Handler_count == PGA_ACCUM_SYMBOLS)
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, RestoreRtvCaptureModeSetting);
#else
         gl_Pa += VectorPower(gsa_RxToneBuf, 0, gs_RxSamplesPerFrame, (int16)(gs_Log2RxSamplesPerFrame+LOG2_PGA_ACCUM_SYMBOLS));
#endif

         if (gs_PGA_Handler_count == PGA_ACCUM_SYMBOLS + HW_VECPOW_ACCUM_DELAY)
         {

#ifdef HW_VECPOW_ACCUM
            gl_Pa = gl_Pa_VecPow;
#endif
            /*  compute recommended PGA adjustment */
            /* required gain = Desired signal level - (computed power - current pga setting) */
            gs_PGA_required = PD_DB - ConvertToDB(gl_Pa) + gs_PGA_set;  /* recommended gain */
#ifdef FD_ACCUM_FOR_PGA
            gs_PGA_required -= gs_td_fd_pwr_offset;
#endif
            gs_PGA_required -= (gs_PGA_margin + gs_PGA_margin_delta_AnxL_BTloops);           /* reduce the PGA setting by the margin */

            guc_PgaTrainingState = TRAINING_IN_PROGRESS;
            //Loading "BgPGA() function into BgFIFO is not working, i.e Basically not going to next substate,
            //We don't know the reason.
            //In order to progress further, we are calling directly
            //This requires further investigation.
            //Kannan & Sriram: 29/01/2010
            AFED_BgPGA();
            guc_DoublePgaHandlerState = PGA_WAIT;
            if(gs_Set_Pause == 0x13)Pause(0x1014);  //Debug
         }
      break;

    case PGA_WAIT:
       if (guc_PgaTrainingState == TRAINING_DONE)
       {
         gs_PGA_Handler_count = 0;
         /* Turn off PLL: */
         gft_EnablePLL = FALSE;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);

         if (gft_EnableDoublePGATrain == TRUE)
         {
            guc_DoublePgaHandlerState = PGA_START_AGC2_COMPUTATION;
         }
         else
         {
           AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Inplace); //Keep Stymon Rx IIR inplace
           guc_DoublePgaHandlerState = PGA_DOUBLE_TRN_DONE;
         }

         if(gs_Set_Pause == 0x15)Pause(0x1016);  //Debug
      }
      break;

   case PGA_START_AGC2_COMPUTATION:
      if (gs_PGA_Handler_count < 3)
      {
         gs_PGA_Handler_count++;
      }
      else
      {
         if(gft_EnableDoublePGATrain == TRUE)
         {
            if(gs_PgaHandlerRun == 0)
            {
               guc_DoublePgaHandlerState = PGA_INIT;
               gs_PgaHandlerRun = 1;
               gs_PGA_required = 0; // Reset gs_PGA_required to 0 before AGC2 train.
               if(gs_Set_Pause == 0x17)Pause(0x1018);  //Debug
            }
            else
            {
               gs_PgaHandlerRun = 0;
               guc_DoublePgaHandlerState = PGA_DOUBLE_TRN_DONE;
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Inplace); //Keep Stymon Rx IIR inplace
               if(gs_Set_Pause == 0x16)Pause(0x1017);  //Debug
            }
        }
      }
      if(gs_Set_Pause == 0x31)Pause(0x1030);
      break;

    } //Switch()

//XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (Start_End)
//Modification is not connected with Jira XDSLRTFW-271
//Compiler cribbing as function definition and functional call/usage doesn't match.
//    return(0);

}

