/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCEctRxF.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_ECT
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCEctRxF.c
//
// History
//
//
// 12/01/2012: 64pt IFFT emulation starts here after ECT training as we do it
//             in danube to improve the US performance
//          Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "const.h"
#include "compiler.h"
#include "gdata.h"
#include "states.h"
#include "RCReverb2RxF.h"
#include "RQuiet3TxF.h"
#ifndef ISDN
#include "cmv.h"
#endif //ifndef ISDN
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCEctRxF
 *
 *  Description: This state coincides with C_ECT states. It simply counts out the C-ECT
 * state before transitioning to RCReverb2RxF
 *
 *  Prototype: void RCEctRxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_RxSubState             - (I/O) Substate within current RX state
 *      gs_RxNextState            - (O)   Rx state starting next symbol period
 *      gl_RxSymbolCount          - (I)   count of symbols passed in current state
 *    gs_RxSubStateCnt          - (I/O) count of symbols passed in current substate
 *
 *  Substates:
 *      R_C_ECT_COUNT         - Counts out the C-ECT state before transitioning
 *                         to RCReverb2RxF
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCEctRxF(void) {

#ifdef BIS_CODESWAP
   if(gs_CodeSwapStatus==CODESWAP_IDLE && gs_CodeSwapSection == CSPAGE_BIS_XCVRDMT && gs_TxState==R_QUIET3_TX)
   {
      gs_CodeSwapStatus = CODESWAP_START;
   }
   // When XCVR2 is in: switch Txstate function for R_Quiet3 to a XCVR2-residing function
   if(gs_CodeSwapStatus==CODESWAP_IDLE && gs_CodeSwapSection == CSPAGE_BIS_ANAL)
   {
      gpF_TxStateFunc = (PtrToFunc)RQuiet3bTxF;
#ifndef ISDN
      //PERF_US_T1413_T1&CNXT_64ptIFFT (START)
      int16 s_temp = (gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_USE_IFFT64) >> 14;

      if ( ((gft_Enable_IFFT64_T1413 == 1) &&
         (s_temp == IFFT64_T1413_CNXT_TI_ENABLED)) ||
         (s_temp == IFFT64_ADSL1_ENABLED) )
      {
         gft_IFFT64_T1413_TxImages = 1;
      }
      //PERF_US_T1413_T1&CNXT_64ptIFFT (END)
#endif //ifndef ISDN
   }
#endif

   if(gl_RxSymbolCount == (R_C_ECT_RX_LEN-1))
   {
#ifdef BIS_CODESWAP
      // If XCVR2 is not in, somethings wrong, check states trail: declare exception
      if(gs_CodeSwapSection != CSPAGE_BIS_ANAL)
      {
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_CODESWAP_ERR;
      }
      else
#endif
      {
         gs_RxNextState = R_C_REVERB2_RX;
         gpF_RxStateFunc = (PtrToFunc)RCReverb2RxF;
      }
   }
}

