/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCPilot1InitRxF.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_QUIET2, R_C_PILOT1
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */
 // ******************************************************************
// RCPilot1InitRxF.c
//
// History
// 15/07/2011 Kannan: T1413 bring up. PGA training variable
//           initialized for T1413 mode.
//           Grep for XDSLRTFW-254 Feature_ALL_T1413_ALL_Bringup
// ******************************************************************
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "states.h"
#include "T1413.h"
#include "cmv.h"
#include "RCPilot1RxF.h"
#include "RCPilot1InitRxF.h"

extern void RestoreUnityTDQBeforeTraining(void);
extern void Reconfigure_FFTandIFFTLengths(void);

#define RECONFIG_STRYMON_TX               5

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCPilot1InitRxF
 *
 *  Description:
 * This state is used to achieve the phase lock. Following phase lock,
 *  the ATU-R initiates sending R-Reverb1. The ATU-C shall detect the onset
 *  of R-Reverb1 and begin transmission of C-Reverb1. The beginning symbols of
 *  R-Reverb1/C-Pilot1 are used to establish a threshold for detection of the
 *  C_Reverb1 signal. The ATU-R shall progress to R_C_REVERB1_RX only after it
 * has detected the C_Reverb1 signal from the ATU-C.
 *
 *  The detection threshold is determined by computing the average of the
 *  received power over a number of frames.  The threshold is set to the
 *  average power multiplied by a scaling factor.
 *
 *  Prototype: void RCPilot1RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_RxSubState            - (I/O) Substate within current RX state
 *    gft_pll_state           - (I/O) PLL state (lock or unlock)
 *      gs_RxToneBuf          - (O)   Output of FFT, set in RxPower()
 *    gs_RxSubStateCnt           - (I/O) count of symbols passed in current substate
 *    gft_C_PILOT1_1A_flag        - (O)   flag to inform TX side to send R_REVERB1
 *      gs_RxNextState           - (O)   Rx state starting next symbol period
 *      gl_RxSymbolCount         - (I)   # of symbol period in current state
 *
 *  Notes:
 * 1) The value of the scaling factor R_C_REVERB1_THR_SCALE will
 *  need to be calibrated w/ the AFE of the target system.
 * 2)  implements state R_C_PILOT1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCPilot1InitRxF(void) {


   if (gs_RxSubStateCnt == 0)
   {
      RestoreUnityTDQBeforeTraining();
#ifndef ISDN
      if (STATArray[STAT_Mode] & STAT_ConfigMode_T1413)
      {
         // force use of emulating IFFT 64 tx Reverb
         OPTNArray[OPTN_StateMachineCtrl] |= OPTN_IFFT64_Enable_PostGHS;
         STATArray[STAT_Misc] |= STAT_IFFT64_EMULATE_REVERB;

      /* For socrates only -- we will switch to 512 pt FFT for G9921A */
   #ifdef TARGET_HW
            if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_FFT1024_Enable) != 0)
            {
               /* Update f/w variables to correspond to using 512 pt FFT */
                  gs_RxFftLength = 512;
#ifdef ADSL_62
                    gs_TxFftLength_Oversample = 512;
#endif
               gs_numAecLMSIterations = NUM_AEC_LMS_ITERATIONS;/* we run out of MIPS here with 1024 samples/frame with default value of 16 */
                                                   /* Empirically, 12 iterations seems to be fine with 1024 samples/frame on Socrates+ */
               gs_presync_stepsize = 1;

               OPTNArray[OPTN_StateMachineCtrl] |= OPTN_FFT512_Enable_PostGHS;
            }
   #endif
      }
#endif
//XDSLRTFW-254   Feature_ALL_T1413_ALL_Bringup   (START)
#ifdef FD_ACCUM_FOR_PGA
      if (gs_RxFftLength  == 1024)
         gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_PLUS;
      else if (gs_RxFftLength  == 512)
         gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_BIS;
#endif
//XDSLRTFW-254   Feature_ALL_T1413_ALL_Bringup   (END)
   }
   else
   {
#ifdef TARGET_HW
      Reconfigure_FFTandIFFTLengths();

      if(gs_RxSubStateCnt == RECONFIG_STRYMON_TX)
#endif
      {
         gs_RxSubStateCnt = -1;

         gs_RxNextState = R_C_PILOT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCPilot1RxF;

      }

   }
   gs_RxSubStateCnt++;

}

#undef RECONFIG_STRYMON_TX

