/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCPilot1RxF.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_QUIET2, R_C_PILOT1
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */
//*******************************************************************
// RCPilot1RxF.c
//
// History
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
// 05/04/2010 Sabrina Y/Veena/Veena: Replaced the C-Pilot1 off detection with Rx frame counter.
//                        Some STM DSLAMs are sensitive to R-ACK power and fail to detect R-Reverb1.
//                        In this case, COs retrain and go to silent. Our detector
//                        will false detect silent signal as C-Pilot1 off and go to
//                        C-Reverb1 state and may stuck there till SW reboots.
//                        On the other hand, T1.413 no-sync issue has been seen with Adtran 1248
//                        and Geminax EVM in MPT lab. IFX CO FW confirmed that CO FW
//                        boosts C-Pilot1 tone power by 6dB if it fails in the activation
//                        even during Tx C-REVERB1 which makes the CPE Pilot1 off detection
//                        failing since the Pilot1A off detector looks for the power
//                        difference between the pilot bin and the neighbor (+/- 4)
//                        bins. Unfortunately, this assumption doesn't hold if the
//                        Pilot bin has higher power than the neighboring bins in
//                        C-REVERB1 signal like the IFX CO Tx.
//                        We also tried to add a C-Reverb1 detection after sending
//                        out R-Reverb1. (This piece of code can be found in clearcase)
//                        However, we saw miss-detection and false-detection against
//                        some COs in some test conditions, especially with bridged tap,
//                        ANSI13 loop and 5T1 noise.
//                        To compromise all above scenarios, we introduced a counter,
//                        after sending R-Reverb1, to skip ~530 frames before entering
//                        C-Reverb1 state. This is ported from AR7 as per G.dmt and T1.413
//                        specifications. This feature is CMV protected and applied to
//                        both AnnexA and AnnexB.
//                        To enable C-Pilot1 off detection for state transition
//                        cw info 103 20 0x8000
//                        Grep for SMS00919148 IOP_AB_DS_ALL_CReverb1Counter
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated reference data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//          1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//          After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//          Then CPE will select the first option from the C-RatesRA.
//          2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//       incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//       Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//       frame sync and TDQ calculation incorrect.
//       The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//       zero response for the reference tones.
//          3. Change near-end vendor ID to "AWARE" to improve US rate.
//          4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//       so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//          Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement.
//
// 22/03/2013 Prashant Patil: Avoid zero input to function (ConvertToDB), this was affecting the QLN computed
//                            at short loops.
//       Grep for XDSLRTFW-759 BugFix_DS_ALL_ALL_ShortLoopQln
//
//*****************************************************************************

#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "pll.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "vecpwr.h"
#include "detect.h"
#include "states.h"
#include "RCReverb1RxF.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "T1413.h"
#include "fft_tab.h"
#include "statein1.h"
#include "RQuiet2TxF.h"
#include "fifo.h"
#include "noiseacc.h"
#include "diagparam_bis.h"
#include "memsetbf.h"
#include "afe.h"
#include "cmv.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start_End)
#include "pga_set.h"
#include "AFED_Functions.h"
#include "VRX_AfeCommonData.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCPilot1RxF
 *
 *  Description:
 * This state is used to achieve the phase lock. Following phase lock,
 *  the ATU-R initiates sending R-Reverb1. The ATU-C shall detect the onset
 *  of R-Reverb1 and begin transmission of C-Reverb1. The beginning symbols of
 *  R-Reverb1/C-Pilot1 are used to establish a threshold for detection of the
 *  C_Reverb1 signal. The ATU-R shall progress to R_C_REVERB1_RX only after it
 * has detected the C_Reverb1 signal from the ATU-C.
 *
 *  The detection threshold is determined by computing the average of the
 *  received power over a number of frames.  The threshold is set to the
 *  average power multiplied by a scaling factor.
 *
 *  Prototype: void RCPilot1RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_RxSubState            - (I/O) Substate within current RX state
 *    gft_pll_state           - (I/O) PLL state (lock or unlock)
 *      gs_RxToneBuf          - (O)   Output of FFT, set in RxPower()
 *    gs_RxSubStateCnt           - (I/O) count of symbols passed in current substate
 *    gft_C_PILOT1_1A_flag        - (O)   flag to inform TX side to send R_REVERB1
 *      gs_RxNextState           - (O)   Rx state starting next symbol period
 *      gl_RxSymbolCount         - (I)   # of symbol period in current state
 *
 *  Notes:
 * 1) The value of the scaling factor R_C_REVERB1_THR_SCALE will
 *  need to be calibrated w/ the AFE of the target system.
 * 2)  implements state R_C_PILOT1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* Substates */
/* =============================================== */
#define R_C_PILOT1_RX_ADJUST_PILOT_POWER  (0)
#define R_C_PILOT1_RX_SET_PGA          (1)
#define R_C_PILOT1_RX_LOCK_PHASE_FAST     (2)
#define R_C_PILOT1_RX_ACCUM_QLN_PSD       (3)
#define R_C_PILOT1_RX_LOCK_PHASE       (4)
#define R_C_PILOT1_RX_HYPERFRAME_SYNCH    (5)
#define R_C_PILOT1_RX_CS_WAIT          (6)
#define R_C_PILOT1_RX_WAIT             (7)
#define R_C_PILOT1_RX_DETECT_PILOT_OFF    (8)
#define R_C_PILOT1_RX_REVERB_WAIT         (9)
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start)
#define R_C_PILOT_PRE_QLN_PSD1               (10)
#define R_C_PILOT_PRE_QLN_PSD2            (11)
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (End)

#define R_C_PILOT1_RX_ACCUM_QLN_PSD_INIT    (12)
#define R_C_PILOT1_RX_ACCUM_QLN_PSD_SILENCE (13)
/* =============================================== */
/* Other definitions */
/* =============================================== */
#define UPPER_PP_THRESHOLD    (0x20000000)
#define LOWER_PP_THRESHOLD    (0x08000000)
#define PP_STEP               (0x0300)
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start)
#define R_C_QUIET2_QLN_DMT_Accum    16
#define LOG2_R_C_QUIET2_QLN_DMT_Accum  4
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (End)
int16 gs_PLL_FAST_ACQUISITION_LEN;
int16 gs_RxSState_2;


void RCPilot1RxF(void)
{
   int32 l_PilotPower;
   //SMS00919148 IOP_AB_DS_ALL_CReverb1Counter (START_END)
   static int16 s_WaitReverb1Limit;

   // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start_End)
   int32 l_Acc;
#ifndef ISDN
   uint16 us_CTune_12kft_above;
   int16  s_hsk_power_12kft_above;
   FlagT ft_CTune_Adapt;
   FlagT ft_AWGN130_140Noise;
   uint16 us_NO_CTUNE_AWGN_140_THR; //XDSLRTFW-3674
   static uint16 us_ctune_poco_bin;
#endif

#ifdef BIS_CODESWAP
   if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_XCVR1))
   {
      InitGlobalVariables_DMT();

      /* Switch the R-QUIET2 TX state function to the dummy one that resides in */
      /* XCVR0 before starting the XCVR1 code swap. */
      gpF_TxStateFunc = (PtrToFunc)RQuiet2TxF_CS;

      gs_CodeSwapStatus = CODESWAP_START;
   }
#else
   if(gl_RxSymbolCount == 0)
   {
      InitGlobalVariables_DMT();
      gpF_TxStateFunc = (PtrToFunc)RQuiet2TxF_CS;
   }
#endif

   switch (gs_RxSubState)
   {
   case R_C_PILOT1_RX_ADJUST_PILOT_POWER:

      if (++gs_RxSubStateCnt == PGA_SETTLING_TIME) //5 symbols delay required to get proper new data in the FFT buffer
      {
         /* Set PGA based on pilot power (shift by 1 is to prevent overflow in the */
         /* extreme case of Real = Imag = 0x8000). */
         l_PilotPower = (gsa_RxPilotTone[0] * gsa_RxPilotTone[0]) >> 1;
         l_PilotPower += (gsa_RxPilotTone[1] * gsa_RxPilotTone[1]) >> 1;

         if ((l_PilotPower > UPPER_PP_THRESHOLD) && (gs_PGA_required > gs_min_pga_setting))
         {
            gs_PGA_required -= PP_STEP;
         }
         else if ((l_PilotPower < LOWER_PP_THRESHOLD) && (gs_PGA_required < gs_max_pga_setting))
         {
            gs_PGA_required += PP_STEP;
         }
         else
         {
            /* Get the reference phase of pilot signal. */
            ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);

            /* Set PLL loop filter parameters to fast converge. */
            ResetPLL((int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);

            /* Turn on PLL. */
            gft_EnablePLL = TRUE;

            /* Go to next substate. */
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_PILOT1_RX_LOCK_PHASE_FAST;
            break;
         }

         /* Change PGA if necessary. */
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
         gs_RxSubState = R_C_PILOT1_RX_SET_PGA;
      }
      break;

   case R_C_PILOT1_RX_SET_PGA:
      if (guc_PgaTrainingState == TRAINING_DONE)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_PILOT1_RX_ADJUST_PILOT_POWER;
      }
      break;

   case R_C_PILOT1_RX_LOCK_PHASE_FAST:

      if (++gs_RxSubStateCnt == PLL_FAST_ACQUISITION_LEN)
      {
         /* Reset PLL loop filter parameters to slow converge parameters. */
         ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
         /* Setup for ICN power measurement. */
         MemSetBuffer((int16*)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(gs_RxNumTones*2)));
         memset(gsa_CReverbRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));

         //XDSLRTFW-3257 (START_END)
         gs_Hyb_Hsk_QlnHlog = 2;

         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_HskQlnHlogSetHybrid);
         /* Go to next substate. */
         // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration(Start)
#if 0    // Sriram : Added new states for Qln measurement ( consider time domain offset, pga margin)
         gs_RxSubState = R_C_PILOT1_RX_ACCUM_QLN_PSD;
#else
         gs_RxSubStateCnt = -1;
         gl_Rx_QLN_Power = 0;
         gs_RxSubState = R_C_PILOT_PRE_QLN_PSD1;
#endif

#if 0 //def HW_SNR_FDQ
         //Enable latching of pilot tone at QT startup
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableLatchPilot);

         gft_fw_pilot_fdq = 1;

         // setup to do hardware accumulation mode
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train_Accum);

         /* Turn off Copy RxToneBuf */
         gft_CopyRxBuffer = FALSE;

         // Reset the Noise Accumulator Buffer and trigger the SNR in hardware
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetNoisePowerBuffer);
#endif
      }
      break;

    case R_C_PILOT_PRE_QLN_PSD1:

         gs_RxSubStateCnt++;
         if (gs_RxSubStateCnt < R_C_QUIET2_QLN_DMT_Accum)
         {
            l_Acc = VectorPower(gsa_RxToneBuf, 0, (int16) (2 * gs_RxNumTones), (int16) (gs_RxLog2NumTones));
            /* Compute the average power */
            gl_Rx_QLN_Power += (l_Acc >> LOG2_R_C_QUIET2_QLN_DMT_Accum);
         }
         else if (gs_RxSubStateCnt == R_C_QUIET2_QLN_DMT_Accum)
         {
#ifdef FD_ACCUM_FOR_PGA
         if (gs_RxFftLength  == 1024)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_PLUS;     // 3 db
         else if (gs_RxFftLength  == 512)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_BIS;      // 6 db
#endif
         //XDSLRTFW-759 BugFix_DS_ALL_ALL_ShortLoopQln (START)
         // Work around
         if (gl_Rx_QLN_Power == 0)
         {
            gl_Rx_QLN_Power = 1; //Inorder avoid log(0)
         }
         //XDSLRTFW-759 BugFix_DS_ALL_ALL_ShortLoopQln (END)

         // Reqd_pga = desired_pwr + Power_mea_qln_ + pga_margin + offset_td_freq
         // cross check  the condition... gs_pga_required_QLN_meas = gs_PGA_required_In_GHS,,  should be the same
         gs_PGA_required = PD_DB - ConvertToDB(gl_Rx_QLN_Power) - (gs_td_fd_pwr_offset + gs_PGA_margin) + gs_PGA_set;
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_PILOT_PRE_QLN_PSD2;

         }
      break;

   case R_C_PILOT_PRE_QLN_PSD2:

      if (gs_RxSubStateCnt == 0)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_HskQlnHlogSetHybrid);
         gs_RxSubStateCnt++;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;

      } /* "gs_RxSubStateCnt==0" */
      else if (gs_RxSubStateCnt == 1)
      {
         if (guc_PgaTrainingState == TRAINING_DONE)
         {
            gs_RxSubStateCnt++; /* set PGA */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_TxNoise_PILOT1)
            {
               /* Turn off PLL. */
               gft_EnablePLL = FALSE; // this should be always
            }
         }
      } /* "gs_RxSubStateCnt==1" */
      else if (gs_RxSubStateCnt == 2)
      {
         // Setup for ICN power measurement.
         memset(gla_RxAccumBuf, (int16)0, sizeof(int32)*(gs_RxNumTones*2));
         memset(gsa_CReverbRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));


         if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_TxNoise_PILOT1)
         {

            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_PILOT1_RX_ACCUM_QLN_PSD_SILENCE;
            guc_TxSilence = SILENCE_IN_PROGRESS;
            gft_NMSTxSilence = TRUE;
         }
         else
         {
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_PILOT1_RX_ACCUM_QLN_PSD;
            gs_PLL_FAST_ACQUISITION_LEN = PLL_FAST_ACQUISITION_LEN;
            gs_RxSState_2= 0;
         }
      }/* "gs_RxSubStateCnt==5" */

      break;
      // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (End)

      case R_C_PILOT1_RX_ACCUM_QLN_PSD_SILENCE:

         gs_RxSubStateCnt++;
         if(gs_RxSubStateCnt == PGA_SETTLING_TIME)
         {
            /* Get the reference phase of pilot signal. */
            ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);

            /* Set PLL loop filter parameters to fast converge. */
            //ResetPLL((int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);

            /* Turn off PLL. */
            gft_EnablePLL = TRUE;

         }
         if (gs_RxSubStateCnt >= PGA_SETTLING_TIME + PLL_FAST_ACQUISITION_LEN)
            NoiseAcc(gla_RxAccumBuf, (int16)0, gsa_RxToneBuf, (int16)0, (int16)0, (int16)0, gsa_CReverbRefTones, (int16)0, (int16)(gs_RxNumTones-1));

         if (gs_RxSubStateCnt == gt_DS_MeasurementPeriod.us_QLN_measurement_period + PLL_FAST_ACQUISITION_LEN + PGA_SETTLING_TIME)
         {
               /* Accumulation is completed, smooth out the pilot tone value. */
               gla_RxAccumBuf[2*gs_CPilotTone] = gla_RxAccumBuf[2*gs_CPilotTone-2];
               gla_RxAccumBuf[2*gs_CPilotTone+1] = gla_RxAccumBuf[2*gs_CPilotTone-1];

               /* Compute QLN in background from accumulated PSD. */
               guc_SnrCalcState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)QuietLineNoisePSD);
               gs_RxSubState = R_C_PILOT1_RX_ACCUM_QLN_PSD_INIT;
               guc_TxSilence = SILENCE_DONE;
               //gs_RxSubStateCnt = 0;
               gs_RxSState_2 = -4;
            }
            break;
   case R_C_PILOT1_RX_ACCUM_QLN_PSD_INIT:
         gs_RxSState_2++; // 4symbols waiting
         if((guc_SnrCalcState == TRAINING_DONE) && (gs_RxSState_2 >=0))
         {
            // Setup for ICN power measurement.
            memset(gla_RxAccumBuf, (int16)0, sizeof(int32)*(gs_RxNumTones*2));
            memset(gsa_CReverbRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));
            //gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_PILOT1_RX_ACCUM_QLN_PSD;
            gft_NMSTxSilence = FALSE;
            gs_PLL_FAST_ACQUISITION_LEN = 0;
            gs_RxSState_2= 0;
         }

      break;

   case R_C_PILOT1_RX_ACCUM_QLN_PSD:

#if 1 //ndef HW_SNR_FDQ
      gs_RxSubStateCnt++;
      gs_RxSState_2++;

      if (gs_RxSState_2 >= PGA_SETTLING_TIME + gs_PLL_FAST_ACQUISITION_LEN)
         NoiseAcc(gla_RxAccumBuf, (int16)0, gsa_RxToneBuf, (int16)0, (int16)0, (int16)0, gsa_CReverbRefTones, (int16)0, (int16)(gs_RxNumTones-1));

      if (gs_RxSState_2 == gt_DS_MeasurementPeriod.us_QLN_measurement_period + gs_PLL_FAST_ACQUISITION_LEN + PGA_SETTLING_TIME)
      {
         /* Accumulation is completed, smooth out the pilot tone value. */
         gla_RxAccumBuf[2*gs_CPilotTone] = gla_RxAccumBuf[2*gs_CPilotTone-2];
         gla_RxAccumBuf[2*gs_CPilotTone+1] = gla_RxAccumBuf[2*gs_CPilotTone-1];

         /* Compute QLN in background from accumulated PSD. */
         guc_SnrCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)QuietLineNoisePSD);

         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_RestoreHyb_QlnHlog);

         gs_RxSubState = R_C_PILOT1_RX_LOCK_PHASE;
      }
#else
      gs_RxSState_2++;
      /* HW Based ACC*/
      if (gs_RxSState_2 ==gt_DS_MeasurementPeriod.us_QLN_measurement_period + PLL_FAST_ACQUISITION_LEN)
      {
         // Queue TC task to read the Accumulated Noise
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadAccumulatedNoise);
         // Reset Accum mode
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, RestoreRtvCaptureModeSetting);
         /* Enable call to GetRxTones() */
         gft_CopyRxBuffer = TRUE;
      }
      else if (gs_RxSState_2 == gt_DS_MeasurementPeriod.us_QLN_measurement_period + PLL_FAST_ACQUISITION_LEN + 1)
      {
            gft_fw_pilot_fdq = 0 ;

         //Disable latching of pilot tone at QT startup
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableLatchPilot);

         /* Accumulation is completed, smooth out the pilot tone value. */
         gla_RxAccumBuf[2*gs_CPilotTone] = gla_RxAccumBuf[2*gs_CPilotTone-2];
         gla_RxAccumBuf[2*gs_CPilotTone+1] = gla_RxAccumBuf[2*gs_CPilotTone-1];

         /* Compute QLN in background from accumulated PSD. */
         guc_SnrCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)QuietLineNoisePSD);
         gs_RxSubState = R_C_PILOT1_RX_LOCK_PHASE;
      }
      gs_RxSubStateCnt++;
#endif
      break;

   /* ====================================================================== */
   /*  Wait for phase lock, set steady-state PLL parameters, start R-Reverb1 */
   /* ====================================================================== */
   case R_C_PILOT1_RX_LOCK_PHASE:
      /* Update substate count */
      gs_RxSubStateCnt++;

      /* Achieve phase lock before going to state R_REVERB1 */
      if ((gs_RxSubStateCnt >= PLL_ACQUISITION_LEN0) && (guc_SnrCalcState == TRAINING_DONE))
      {
         /* Reset PGA back to the value found in handshake (trained on both echo */
         /* and RX tones). */
         //29/09/2010: Observed AFE overflows due to high echo in Bridge taps loops, Eg.15kft, BT > 500 ft,
         //Hence AFE gain is reduced by 12dB from the Handshake estimated gain to detect the
         //RCReverb1
         gs_PGA_required = gs_PGA_required_In_GHS - (12 << 8);
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);

         gs_RxSubState = R_C_PILOT1_RX_CS_WAIT;
#ifndef ISDN
         us_ctune_poco_bin = gus_ctune_poco_bin;

         //XDSLRTFW-3603  (start)
         ft_CTune_Adapt = TRUE;
         us_CTune_12kft_above = 0xC;
         s_hsk_power_12kft_above = MINIMUM_GHS_TONE_PWR_CTune12;
         //XDSLRTFW-3618 /XDSLRTFW-3619 (start)
         // With CNXT DSLAMs BT loops US Rate are better and DS rates are less
         // Use CTune value of 14 in BT loops to gain DS data rates.
         ft_AWGN130_140Noise = FALSE;
         if (gft_24HDSLNoise == TRUE)
         {
            gt_HercADSL_OPTNMap_MarginControl.s_OPTN_margin = 0x0080;
            ft_CTune_Adapt = FALSE;
         }
         //XDSLRTFW-3674 New_LLAPI_changes (start)
         // will use this threshold based BT detection till proper BT detection algorithm implemented.
         // Note: In ADSL1, there is a risk of not having enough symbols to implement BT detection.
         if((gs_CurrentCoChipset == GSI_CO_CHIPSET)||(gs_CurrentCoChipset == BDCM_CO_CHIPSET))
         {
            us_NO_CTUNE_AWGN_140_THR = NO_CTUNE_AWGN_140_THR;
         }
         else
            us_NO_CTUNE_AWGN_140_THR = NO_CTUNE_AWGN_140_THR_ADSL1;

         if ((STATArray[STAT_Performance] == STAT_M140WhiteNoise)
              ||(STATArray[STAT_Performance] == (STAT_M140WhiteNoise|STAT_M130M140WhiteNoise))
             )
         {
            ft_AWGN130_140Noise = TRUE;
         }
         // For BT lengths between 300 -500 AWGN-140 from QLN selected as "STAT_M130M140WhiteNoise"
         // Usage of "gft_M140WhiteNoise" is avoided  becasue of "24DSL_RA" noise cases we see "
         // STAT_19 as 0x484.
         if((gs_CurrentCoChipset == GSI_CO_CHIPSET)
             &&(gus_XtalkLowerThan_m138dBmHz < us_NO_CTUNE_AWGN_140_THR)
             &&(ft_AWGN130_140Noise == TRUE)
            )
         {
            us_CTune_12kft_above = 0xE;
            s_hsk_power_12kft_above = MINIMUM_GHS_TONE_PWR_FINETUNE_CTune14;
         }
         //ADSL1/T1413/Annex A
         if( (gl_SelectedMode & ANNEX_A)
               &&(ft_CTune_Adapt == TRUE)
            )
         {
            // Ctune 14 for HSK power < 3000
            if (gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_CTune14)
            {
               us_ctune_poco_bin = 0xE;
               if (gusa_AfeChipId[1] == 2) //A21 chip
               {
                  gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_17kft[0][0];
                  guc_HybTable = 2;
               }
               // For 17.5 kft long loops( BT loops use margin for bit loading benefit)
               //gt_HercADSL_OPTNMap_MarginControl.s_OPTN_margin = 0x0100;// Since DS margin seen as 7dB, use margin of 1dB for bitloading
               //gt_HercADSL_OPTNMap_MarginControl.s_FineGainAdjust = 0x00C0; // Increase av fine gain of DS (check for US margin degradation)
            }
            // Ctune 12 for HSK power < 8600
            else if(gs_hsk_tone_power_dB < s_hsk_power_12kft_above)
            {
               us_ctune_poco_bin = us_CTune_12kft_above;
            }
         }
        //XDSLRTFW-3674 Options_For_debug(start)
         if((gs_CurrentCoChipset == BDCM_CO_CHIPSET) //&&((guca_fe_G9941_VendorID[6] & 0xF0) == 0xB0)
            )
         {
            if((ft_AWGN130_140Noise == TRUE)
                && (gs_hsk_tone_power_dB < 9100)   // loops around 12kft+BT and 13kft use Ctune 10 to narraow performance gap with BDCM based CPE.
                && (gs_hsk_tone_power_dB > 6000)
               )
            {
               us_ctune_poco_bin = 0xA;
            }
            else
               ft_CTune_Adapt = FALSE;
         }

         if(gs_ctune_poco_bin_force >=0)
         {
            us_ctune_poco_bin = (uint16)(gs_ctune_poco_bin_force & 0x000F);
            ft_CTune_Adapt = TRUE;
         }
         if (ft_CTune_Adapt == TRUE)
         {
            gus_ctune_poco_bin = us_ctune_poco_bin;
            vrx5afe_c_tune(gus_ctune_poco_bin & 0x000F);
         }
         //XDSLRTFW-3674 Options_For_debug(end)
         //XDSLRTFW-3674 Options_For_debug(start)
         // Added as per Lorenzo's request
         //BT loops hybrid table switching
         if( ((gl_SelectedMode & ANNEX_A)
              &&(ft_AWGN130_140Noise == TRUE)
              //&&(gus_XtalkLowerThan_m138dBmHz < us_NO_CTUNE_AWGN_140_THR)
              &&(gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_12kft_THR_LLAPI)
              &&(gt_INFX_CMV.s_HybTablesSwitch & 0x0001))
            ||(gs_HybTableForce == 3)
         )
         {
            if(gs_HybTrIndexDbg == 0)
            {
               memcpy(&gusa_A21_HybridSetting_ADSL_A_BTLOOPS[0][0],gsa_NMS_Force,4*2);
            }
            gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_BTLOOPS[0][0];
            guc_HybTable = 3;
         }
         if(gs_HybTableForce == 2)
         {
            if(gs_HybTrIndexDbg == 0)
            {
               memcpy(&gusa_A21_HybridSetting_ADSL_A_17kft[0][0],gsa_NMS_Force,4*2);
            }

            gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_17kft[0][0];
            guc_HybTable = 2;
         }
         if(gs_HybTableForce == 1)
         {
            if(gs_HybTrIndexDbg == 0)
            {
               memcpy(&gusa_A21_HybridSetting_ADSL_A[0][0],gsa_NMS_Force,4*2);
            }

            gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A[0][0];
            guc_HybTable = 1;
         }
         //XDSLRTFW-3674 Options_For_debug(end)
         //XDSLRTFW-3674 New_LLAPI_changes (end)
         //XDSLRTFW-3603  (end)
#endif
      }
      break;

   case R_C_PILOT1_RX_CS_WAIT:
#ifdef BIS_CODESWAP
      /* Wait for XCVR1 page to be swapped in and for PGA training to be done. */
      if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_XCVR1EXT) && (guc_PgaTrainingState == TRAINING_DONE))
#else
      /* Wait for PGA training to be done. */
      if (guc_PgaTrainingState == TRAINING_DONE)
#endif
      {
         /* Set the flag to inform TX State Machine to transit to R_REVERB1. */
         gft_C_PILOT1_1A_flag = TRUE;
         /* Disable PLL. */
         gft_EnablePLL = FALSE;
         /* Set PGA. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);

         /* Go to a substate to give R-Reverb1 a chance to settle in. */
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_PILOT1_RX_WAIT;
      }
      break;

   /* ================================================== */
   /* Send a few REVERB frames before starting detection */
   /* ================================================== */
      case R_C_PILOT1_RX_WAIT:

         if (++gs_RxSubStateCnt == R_C_PILOT1_WT_LEN)
         {
            /* After the TX signal settles, there should not be much echo */
            /* around pilot tone (TX REVERB is periodic so there is only */
            /* non-linear echo in the DS band), so it is safe to proceed */
            /* to detection of pilot going off. */
            gs_RxSubStateCnt = 0;
            //SMS00919148 IOP_AB_DS_ALL_CReverb1Counter (START)
            //After sending R-Reverb1, use a counter to skip ~530 frames before
            //entering C-Reverb1 state as per G.dmt and T1.413 standard.
            //This feature is CMV protected.
            if (gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_CPILOT1Off_Detection)
            {
            gs_RxSubState = R_C_PILOT1_RX_DETECT_PILOT_OFF;
            s_WaitReverb1Limit = R_C_QUIET3A_MAX_RX_LEN;
            }
            else
            {
            gs_RxSubState = R_C_PILOT1_RX_REVERB_WAIT;
            s_WaitReverb1Limit = R_C_REVERB1_RX_LEN + R_C_REVERB1_WT_LEN;
             //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
#ifndef ISDN   // only for Anx-A
             if (gft_NVLTC_T1413_fix == TRUE)
                  s_WaitReverb1Limit += 32;
#endif
             //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
            }
            //SMS00919148 IOP_AB_DS_ALL_CReverb1Counter (END)
         }
         break;


      case R_C_PILOT1_RX_DETECT_PILOT_OFF:

         if (!DetectTone(gsa_RxToneBuf,gs_CPilotTone,(int16)(gs_CPilotTone-4),(int16)(gs_CPilotTone+4),(int16)(gs_ToneDetectScale*256))) {
            gs_RxSubStateCnt++;
         }
         else {
            gs_RxSubStateCnt = 0;
         }

         if (gs_RxSubStateCnt == R_C_REVERB1_DET_CNT)
         {
            if (gft_PilotOnDecTraining == FALSE)
            {
               /* If R-ACK1 was selected, we just detected C-QUIET3A. */
               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_PILOT1_RX_REVERB_WAIT;
            }
            else
            {
               /* If R-ACK2 was selected, we just detected C-REVERB1. */
               gs_RxNextState = R_C_REVERB1_RX;
               gpF_RxStateFunc = (PtrToFunc)RCReverb1RxF;
            }
         }

         break;

      case R_C_PILOT1_RX_REVERB_WAIT:
         //SMS00919148 IOP_AB_DS_ALL_CReverb1Counter (START_END)
         /* Wait before transition to R_C_REVERB1_RX. */
         if (++gs_RxSubStateCnt == s_WaitReverb1Limit)
         {
            gs_RxNextState = R_C_REVERB1_RX;
            gpF_RxStateFunc = (PtrToFunc) RCReverb1RxF;
         }

         break;

   }


}

#undef R_C_PILOT1_RX_ADJUST_PILOT_POWER
#undef R_C_PILOT1_RX_SET_PGA
#undef R_C_PILOT1_RX_LOCK_PHASE_FAST
#undef R_C_PILOT1_RX_ACCUM_QLN_PSD
#undef R_C_PILOT1_RX_DETECT_XTALK
#undef R_C_PILOT1_RX_LOCK_PHASE
#undef R_C_PILOT1_RX_HYPERFRAME_SYNCH
#undef R_C_PILOT1_RX_CS_WAIT
#undef R_C_PILOT1_RX_WAIT
#undef R_C_PILOT1_RX_DETECT_PILOT_OFF
#undef R_C_PILOT1_RX_REVERB_WAIT

#undef NOISE_THRESHOLD
