/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCPilot2RxF.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_PILOT2
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fft_bg.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "aec_init.h"
#include "const.h"
#include "compiler.h"
#include "T1413.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "afe.h"
#include "xcvr_rx1_b.h"
#include "DSLEngin.h"
#include "RCEctRxF.h"
#include "afe_hyb.h"
#include "HybridTraining.h"



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCPilot2RxF
 *
 *  Description: This state coincides with C_REVERB1, C_PILOT2 and C_ECT
 * states. It sets PGA and run PLL through C_PILOT2 state (but not during C_ECT)
 *
 *  Prototype: void RCPilot2RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_RxSubState             - (I/O) Substate within current RX state
 *      gs_RxNextState            - (O)   Rx state starting next symbol period
 *      gl_RxSymbolCount          - (I)   count of symbols passed in current state
 *    gs_RxSubStateCnt          - (I/O) count of symbols passed in current substate
 *    gl_Pa                - (I/O) accumulated power
 *    gs_PGA_offset           - (O)    PGA offset
 *      gs_RxToneBuf[]            - (O)   Output of FFT, set in RxPower()
 *
 *  Substates:
 *      R_C_REVERB1_RX_INITIALIZE - Waits a pre-determined number of symbols (frames)
 *                                  for the channel to stabilize, and clears the power
 *                                  measurement accumulator.  Also updates the PLL.
 *      R_C_REVERB1_RX_SET_PGA    - Computes an average power to be used in setting
 *                                  the PGA, then adjusts and implements this setting
 *                                  into the PGA.  Also updates the PLL.
 *
 *      R_C_REVERB1_RX_WAIT       - Waits until the current state (R_C_REVERB1_RX)
 *                                  completes, then sets the next state pointer to
 *                                  R_C_REVERB2_RX.  Also updates the PLL.
 *
 *  Notes: implements state R_C_REVERB1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
#define R_C_REVERB1_RX_WAIT                  (90)
#else // Non-AMAZON_AFE
#define R_C_REVERB1_RX_WAIT                  (14)
#endif   /* End of #ifdef/#else AMAZON_AFE */
void RCPilot2RxF(void) {

   int16 r_c_reverb1_det_cnt_temp = R_C_REVERB1_DET_CNT;

    switch (gs_RxSubState) {


   case R_C_REVERB1_RX_WAIT:


      /* Offset of 16+2 is to be safe in R-ACK1 case when we do not detect C-QUIET3A */
      /* to C-REVERB1 transition. */
      if(gl_RxSymbolCount == (R_C_REVERB1_RX_LEN + R_C_PILOT2_RX_LEN
                        - R_C_REVERB1_DET_CNT - 18))
      {
         /* Turn off PLL: CO training their DEC */
         gft_EnablePLL = FALSE;
      }

      /* ========================================================================== */
      /* Transition to R-C-ECT state  */
      /* ========================================================================== */

        if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C))
        {
            // When testing G.lite against an ADI CO, it was found that the CPE RX was ahead
            // of the CO TX by 2 symbols.  This prevented Swap 11 from being triggered because the
            // rx symbol count (>0) was greater than expected symbol count (=0) in the function
            // CheckForCodeSwapTrain().  Therefore the necessary conditions for a swap were not met.
            // Delaying the reciever by 2 symbols resolved the issue, this change delays by
            // 4 symbols in g.lite to make it more robust.

            r_c_reverb1_det_cnt_temp -= 4;
        }

      if(gl_RxSymbolCount == (R_C_REVERB1_RX_LEN + R_C_PILOT2_RX_LEN
                        - r_c_reverb1_det_cnt_temp - 1))
      {
            gs_RxNextState = R_C_ECT_RX;
            gpF_RxStateFunc = (PtrToFunc)RCEctRxF;
            // Reset the IR_OVFLOW register
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reset_MTE_Overflow);
        }

      break;
    } /* switch(gs_RxSubState) */

}


#undef R_C_REVERB1_RX_WAIT

