/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCQuiet2RxF.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_QUIET2, R_C_PILOT1
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCQuiet2RxF.c
//
// History
//
// 08/07/2010  Nihar: Added code to increase DS performance with ADI (930/ANCD) in DMT mode on short loops with strong noise
//                  Use US-PCB starting from Reverb to reduce DS-PCB
//             grep for  IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB
//
//31/10/2008 Hanyu/Bhadra: Added code to improve C-Pilot1 detection for CNXT/D57/Rev7
//                    to overcome a xtalk issue with UT900 DSLAM at Netcom.
//                    By default, this fix is disabled. To enable it cw INFO 103 20 0x0004
//                    Grep for SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det
// 10/08/2010 Nihar: Tramsmit Reverb 1 & 2 from tone 2, against all COs & in all modes. This helps in improving
//                   the US performance. Grep for PERF_US_ALL_ALL_TxReverbFromTone-2
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 2/04/2013 Mahesh Set proper fuse data in AFE regs BIAS1 & DAC1_MISC1 & increase PSD for ADSL1 by 1.2dB
//                      Grep for XDSLRTFW-785: Bug_All_All_All_PsdAfeReg
//
// 16/05/2013 Prashant: Reduced HSK PSD by 0.3dB as we seen at short loops more DS PCB requested from CO and
//                      there by reducing DS rate
//                      Grep for XDSLRTFW-946: BugFix_DS_DMT_All_DSRateFail_TR067B242
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                   then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                   (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                   = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                   in which AR9 will select the second or third option.
//                2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
//
// **********************************************************************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "pll.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "vecpwr.h"
#include "detect.h"
#include "states.h"
#include "RCPilot1RxF.h"
#include "fifo.h"
#include "ec_data.h"
#include "cmv.h"
#include "DSLEngin.h"
#include "round_acc48.h"
#include "InitTDQfilter.h"
#include "hndshk_Data.h"





// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#include "dsp_op2.h"
#include "snr.h"

int32 ComputePilot_SNR(int32 * PilotAccR, int32 * PilotAccI, int32 * NoiseAccH, int32 * NoiseAccL);

//DATA_BULKO1_BEGIN
// Defined the following global variables
// from "Static" to avoid potential memory corruption.
// Need to confirm with Aware/ARC.
int32 gl_PilotAccR;
int32 gl_PilotAccI;
int32 gl_NoiseAccH;
int32 gl_NoiseAccL;
//DATA_MAP_END   // DATA_BULKO1_BEGIN
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
#define COMPUTE_FFT_IFFT_LENGTHS       1
#define RECONFIG_IRIDIA_FFT_IFFT_LENGTHS  2
#define RECONFIG_STRYMON_SMODE_REGISTER      3
#define RECONFIG_STRYMON_RX               4
#define RECONFIG_STRYMON_TX               5

#ifdef DANUBE
// we will not use the 64pt emulation mode rightr now since results are worse.
#define Use64pt_FOR_TI (0)
#define Use64pt_FOR_ADI (0)
#else
#define Use64pt_FOR_TI (1)
#define Use64pt_FOR_ADI (1)
#endif

FlagT DetectPilot(void);

void RestoreUnityTDQBeforeTraining(void)
{
   /* Clear TDQ memory. */
   SetTDQtoUnity();
   AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);

   guc_FdqTrainingState = TRAINING_WAITING;
   guc_TdqTrainingState = TRAINING_WAITING;
   guc_EcTrainingState     = TRAINING_WAITING;
   guc_AecTrainingState = TRAINING_WAITING;
   guc_AvgAecLmsSequences  = TRAINING_WAITING;
   gft_BitloadState     = TRAINING_WAITING;

   //Set the flag to true to indicate DMA buffer pointers should be reset
   gft_ResetDmaPtr = TRUE;
}

void Reconfigure_FFTandIFFTLengths(void)
{
   int16 s_temp;

      //if(gs_RxSubStateCnt == 1)
      if(gs_RxSubStateCnt == COMPUTE_FFT_IFFT_LENGTHS)
      {
#ifdef ADSL_62
         // A code optimization since we are only here if FFT is 512!
         // gs_RxFftLength would have changed.
         gs_RxCPLength = 512 >> 4;
         gs_RxSamplesPerFrame = 512;
         /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
         gs_RxLog2FftLength1 = 8;
         /* Compute log2rxnumsamples */
         gs_Log2RxSamplesPerFrame = 9;

            gs_TxFftLength_Oversample = gs_RxFftLength;
            gs_TxCPLength_Oversample = gs_RxCPLength;
         /* Compute log2(gs_TxFftLength)-1 = log2(gs_FftLength/2) */
         gs_TxLog2FftLength1_Oversample = 8;

#else

         // gs_TxFftLength would have changed.
         gs_TxCPLength = (int16) (gs_TxFftLength>>4);
         /* Compute log2(gs_TxFftLength)-1 = log2(gs_TxFftLength/2) */
         gs_TxLog2FftLength1 = 0;
         s_temp = (gs_TxFftLength >> 1);
         while((s_temp&1) == 0)
         {
            gs_TxLog2FftLength1++;
            s_temp >>= 1;
         }

         // gs_RxFftLength would have changed.
         gs_RxCPLength = gs_RxFftLength >> 4;
         gs_RxSamplesPerFrame = gs_RxFftLength;
         /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
         gs_RxLog2FftLength1 = 0;
         s_temp = (gs_RxFftLength >> 1);
         while((s_temp&1) == 0)
         {
            gs_RxLog2FftLength1++;
            s_temp >>= 1;
         }
         /* Compute log2rxnumsamples */
         s_temp = gs_RxSamplesPerFrame;
         gs_Log2RxSamplesPerFrame = 0;
         while((s_temp&1) == 0)
         {
            gs_Log2RxSamplesPerFrame++;
            s_temp >>= 1;

         //load unity DEC
         gs_pre_dec_h_exp = 1;
         gs_pre_dec_h_delay  = 0;
         gsa_pre_dec_h[0] = 0x4000;
         for(i=1; i<gs_DEC_ORDER; i++)
            gsa_pre_dec_h[i] = 0;
         }
#endif

         /* =============================================================================== */
         /* Update DEC Upsampling factor based on Rx FFT and Tx IFFT Lengths */
         /* =============================================================================== */
         for(gs_DECUpsamplingFactor=1, s_temp=gs_TxFftLength_Oversample; s_temp<gs_RxSamplesPerFrame; s_temp<<=1)
            gs_DECUpsamplingFactor <<= 1;

      }
      //else if(gs_RxSubStateCnt == 2)
      else if(gs_RxSubStateCnt == RECONFIG_IRIDIA_FFT_IFFT_LENGTHS)
      {
         /* =============================================================================== */
         /* Update Iridia based on Rx FFT and Tx IFFT Lengths                       */
         /* =============================================================================== */
#ifndef ADSL_62
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_IRI);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_PostGHS);
         gs_RxSubStateCnt = RECONFIG_STRYMON_TX;
#endif
      }
#ifndef ADSL_62
      //else if(gs_RxSubStateCnt == 3)
      else if(gs_RxSubStateCnt == RECONFIG_STRYMON_SMODE_REGISTER)
      {
         /* =============================================================================== */
      /* Update Strymons SMODE Register based on Rx FFT and Tx IFFT Lengths            */
      /* =============================================================================== */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_STR_SMODE);
      }
      //else if(gs_RxSubStateCnt == 4)
      else if(gs_RxSubStateCnt == RECONFIG_STRYMON_RX)
      {
         /* =============================================================================== */
         /* Update Strymons Filters based on above reconfigs (SMODE registers/DEC Length)   */
         /* =============================================================================== */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_DFE_Rx);

      }
      //else if(gs_RxSubStateCnt == 5)
      else if(gs_RxSubStateCnt == RECONFIG_STRYMON_TX)
      {
      /* =============================================================================== */
         /* Update Strymons Filters based on above reconfigs (SMODE registers/DEC Length)   */
         /* =============================================================================== */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_DFE_Tx);

      }
#endif
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCQuiet2RxF
 *
 *  Description: The ATU-R progresses to R_C_PILOT1_RX only after it has detected the
 *  C_Pilot1/1A or C-Quiet3 signal from the ATU-C.
 *
 *  Prototype: void RCQuiet2RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount  - (I) count of symbols passed in current RX state
 *    gs_RxSubStateCnt  - (I/O) count of symbols pass in current RX substate
 *      gs_RxNextState     - (O)   Rx state starting next symbol period
 *      gs_RxToneBuf    - (O)   Output of FFT.
 *
 *  Notes: implements state R_C_QUIET2_RX
 *
 *  R_C_QUIET2_RX_WAIT:       Wait for channel to stabilize and check whether 64IFFT is needed for better performance
 *  R_C_QUIET2_RX_SET_64IFFT_512FFT: Reconfig to 64IFFT and 512FFT
 *  R_C_QUIET2_RX_DETECT_PILOT: Try to detect pilot tone
 *------------------------------------------------------------------------
 *^^^
 */

#define R_C_QUIET2_RX_WAIT         (0)
#define R_C_QUIET2_RX_SET_64IFFT_512FFT    (1)
#define R_C_QUIET2_RX_DETECT_PILOT (2)
#define R_C_QUIET2_RX_MEASURE_SILENCE     (3)
#define R_C_QUIET2_RX_MEASURE_QUIET       (4)



#define PLUS_HALF_DB    (17355)     // * 2^-14
#define PLUS_FOUR_DB    (25967)     // * 2^-14
#define PLUS_ONE_DB     (18382)

//XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
#define PLUS_Pt_8_DB   (17965) //2^-14

#define PLUS_ONE_Pt_2_DB   (18810) //2^-14

#define PLUS_ZERO_Pt_2_DB   (16766) // 20*log10(X/2^14)=YdB ,  X = (2^14) * 10^(YdB/20) for 0.5 dB add = 16765.6
#define PLUS_ZERO_Pt_8_DB  (17965) // 20*log10(X/2^14)=YdB ,  X = (2^14) * 10^(YdB/20) for 0.8 dB  = 17964.7~17965
#define PLUS_2_Pt_8_dB  (22616) // 20*log10(X/2^14)=YdB ,  X = (2^14) * 10^(YdB/20) for 2.8 dB  = 22616.22~22616

uint16 gus_DelayCPilot1Det = 990 ;


void RCQuiet2RxF(void) {

   if(gl_RxSymbolCount == 0
#ifdef BIS_CODESWAP
      || gft_Quiet_Transit
#endif
      )  {
      gft_Quiet_Transit = FALSE;

#ifdef ISDN
#if 0

        // SMS00842175 IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start)
      if ((gs_CurrentCoChipset == ADI_CO_CHIPSET) || (gs_CurrentCoChipset == ANCDA_CO_CHIPSET))
      {
         //Tx Power cut back and boost is defined from 0 to 6dB
         //Reduce Reverb signal (and Reverb) by gs_Persis_CurrGHsTxPCB dB
         if ((gs_Persis_CurrReverbTxPCB >= 0) && (gs_Persis_CurrReverbTxPCB <= 6)) {
            gt_INFX_CMV.us_TxPwrCutDMTforDSPCB = gusa_TxPwrCut_Table[gs_Persis_CurrReverbTxPCB];
            //Amount of Tx Power Reduction linked to CMV for Readability
            //The value "x" must be in Q.14 format, i.e 20*log10(x/2^14)
            gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * gt_INFX_CMV.us_TxPwrCutDMTforDSPCB) >> 14);
        }
      }
   //As per Ganesh  PSD m/nt with FW5.6.6.0.3.2_0106 -1dB for 1B, -0.6dB for 3b/5B and 0.2 dB for Annex J
   //gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * PLUS_ONE_Pt_2_DB) >> 14);

   //gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * PLUS_ZERO_Pt_2_DB) >> 14);
   // Previously we were using +0.2dB boosting. After measurement, we found it be required to be boosted by
   // 0.8dB more. So total bossting = 0.2 + 0.8 = 1dB.

   // gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * PLUS_ONE_DB) >> 14);
      // XDSLRTFW-946: BugFix_DS_DMT_All_DSRateFail_TR067B242 (Start)
   //Reduce by 0.3dB as we seen at short loops more DS PCB requested from CO and there by reducing DS rate
   //We reduced HSK PSD by 0.1 dB So to compensate we increased here So in total 1- 0.3dB + 0.1dB
      //gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * PLUS_ZERO_Pt_8_DB) >> 14);
   // We reduced Tx Var gain by 2dB in statein1.sc, we are compensating here the same by 2 dB
      gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * PLUS_2_Pt_8_dB  ) >> 14);
      // XDSLRTFW-946: BugFix_DS_DMT_All_DSRateFail_TR067B242 (End)

      gus_TxSineGain = gus_TxGain_NoCutBack;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
      // SMS00842175 IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (End)
#endif
#else
      //XDSLRTFW-1692 (start)
      if ((gs_CurrentCoChipset == ANCDA_CO_CHIPSET)
            // added for field failure
            &&(gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_13500F)  //around upto 3400m
            &&(gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_TXCUTBACK)
          )
      {
         gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * M_ONE_dB) >> 14);
      }
      ////XDSLRTFW-1692 (end)
#endif

#ifndef ISDN
   //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start]
      gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * PLUS_Pt_8_DB) >> 14);
      gus_TxSineGain = gus_TxGain_NoCutBack;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
   //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [End]
#endif

      gs_RxSubStateCnt = 0;


      // TDQ coefs may have been changed in GHS/T1413. Restore Unity TDQ before xcvr training.
      RestoreUnityTDQBeforeTraining();
   }

   switch (gs_RxSubState)
   {

   case R_C_QUIET2_RX_WAIT:
   // SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#ifndef  ISDN  // Only for Annex - A
   if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
        (gs_CurrentCoVendorID == 0x0007) &&
        (gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_Ghs_CPilot1DetFix))
   {
      //Set this flag to enable G.hs based C-Pilot1 detector to avoid false detection
      // due to C-Pilot1 xtlak in C-QUIET2 state in G.dmt mode.
      gft_Ghs_CPilot1Det_Enabled = TRUE;
      // Compute G.hs pilot SNR for C-Pilot1 detector.
      gl_Ghs_PilotSNR = ComputePilot_SNR(&gl_Ghs_PilotAccR, &gl_Ghs_PilotAccI, &gl_Ghs_NoiseAccH, &gl_Ghs_NoiseAccL);
   }
#endif
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)

//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
#ifndef ISDN
      if ( (gs_CurrentCoChipset == IFTN_CO_CHIPSET) && (gs_CurrentCoVendorID == 0x71C5) &&
            (gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_ENABLE_GMX_DMT_DSPerf))
         gft_Adtran_GMX_DMT = TRUE;
      else
         gft_Adtran_GMX_DMT = FALSE;
#endif
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)

         AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);

         // Catena, TI, Anaconda and Centillium (also Generic, since CTLM rarely sends meaningfull Vendor ID):
         // Start TxReverb1/2 from tone 4 (helps US tdq train)
if (gl_SelectedMode & ANNEX_A)
{
         if ( (gs_CurrentCoChipset == GENERIC_CO_CHIPSET) ||
#ifndef ISDN   // Only for Anx-A
         //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START_END)
         (gs_CurrentCoChipset == ALA2_CO_CHIPSET) ||
#endif // ifndef ISDN
            (gs_CurrentCoChipset == CTLM_CO_CHIPSET)    ||
            (gs_CurrentCoChipset == ANCDA_CO_CHIPSET) ||
            (gs_CurrentCoChipset == CTNW_CO_CHIPSET) ||
            (gs_CurrentCoChipset == TI_CO_CHIPSET))
         {
                // PERF_US_ALL_ALL_TxReverbFromTone-2 (Start_End)
                gs_TxReverb12FirstCh = 2 ;
            }
        }
#ifndef ADSL_62 //for the moment do not reconfigure US tx for VR9
#ifndef HERCULES_ADSL_CPE
        // The 64IFFT option probably has a problem on Hercules.  Against TI/Adtran it caused the CO to reset shortly
        // after Tx CP insertion.  Hence bypass this code for now.

         //We will switch to 64IFFT after GHS (for better US performance) when the following are ALL met:
         //1) Catena, TI CO or ADI Anaconda (maybe GlobeSpan also ?)
         //2) DMT (excluding AnnexB) ; T1.413 mode unfortunately doesn't provide Vendor ID at this point
         //3) 128 IFFT size was set as default

         if ( ( ( Use64pt_FOR_TI  && (gs_CurrentCoChipset == TI_CO_CHIPSET) )
            || ( Use64pt_FOR_ADI && (gs_CurrentCoChipset == ANCDA_CO_CHIPSET) )
            || (gs_CurrentCoChipset == CTNW_CO_CHIPSET)) &&
            (OPTNArray[OPTN_AlgControl] & OPTN_IFFT128_Enable) )
         {
            if(gs_TxState == R_QUIET2_TX)
            {

#ifdef HWENGINE_30
               //In HWEngin3.0, we use 128pt to do 64pt emulation
               gs_TxFftLength = 128;
#else
               gs_TxFftLength = 64;
#endif // HWENGINE_30
               STATArray[STAT_Misc] |= STAT_IFFT64_EMULATE_REVERB;
            }
         }
#endif //HERCULES_ADSL_CPE
#endif
#ifdef ADSL_62
#ifdef ISDN
         gft_TxImages = 1;
#else
         //either turn on all images or add one image during reverb
         //gft_TxImages = 1;
         OPTNArray[OPTN_StateMachineCtrl] |= OPTN_IFFT64_Enable_PostGHS; //add image during reverb by default - may need to tx all images for CO's that use 32 tone receiver
#endif
#endif

         // if force use of emulating IFFT 64 tx Reverb in software
         if ((OPTNArray[OPTN_AlgControl] & OPTN_IFFT128_Enable) && (OPTNArray[OPTN_StateMachineCtrl] & OPTN_IFFT64_Enable_PostGHS))
               STATArray[STAT_Misc] |= STAT_IFFT64_EMULATE_REVERB;

         if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_IFFT64_DISABLE_PostGHS )
               STATArray[STAT_Misc] &= ~STAT_IFFT64_EMULATE_REVERB;

           /* For socrates only -- we will switch to 512 pt FFT for G9921A & G.992.2AB */
#ifdef TARGET_HW
         if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_FFT1024_Enable) != 0)
         {
            /* Update f/w variables to correspond to using 512 pt FFT */
               gs_RxFftLength = 512;
#ifdef ADSL_62
                gs_TxFftLength_Oversample = 512;
#endif
            gs_numAecLMSIterations = NUM_AEC_LMS_ITERATIONS;/* we run out of MIPS here with 1024 samples/frame with default value of 16 */
                                                /* Empirically, 12 iterations seems to be fine with 1024 samples/frame on Socrates+ */
            gs_presync_stepsize = 1;

            OPTNArray[OPTN_StateMachineCtrl] |= OPTN_FFT512_Enable_PostGHS;
         }
         //XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration(Start)
         // (Sriram)Accounted the offset in RCPilot1RxF
#if 0
#ifdef FD_ACCUM_FOR_PGA
         if (gs_RxFftLength  == 1024)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_PLUS;
         else if (gs_RxFftLength  == 512)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_BIS;
#endif
#endif
         //XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration(End)

#endif
//    }

      /* Reconfig digital front end filters based on selected mode */
      Reconfig_STR_FW(gl_SelectedMode);
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_DFE_Tx);

      gs_RxSubStateCnt = 0;

      if ((STATArray[STAT_Misc] & STAT_IFFT64_EMULATE_REVERB ) ||
         (OPTNArray[OPTN_StateMachineCtrl] & OPTN_FFT512_Enable_PostGHS))
      {
         gs_RxSubState = R_C_QUIET2_RX_SET_64IFFT_512FFT;
      }
      else
      {  // Non G.992.1.A
         gs_RxSubState = R_C_QUIET2_RX_DETECT_PILOT;
      }
      break;


   case R_C_QUIET2_RX_SET_64IFFT_512FFT:

      gs_RxSubStateCnt++;

      // Reconfigure RxFFt lengths and Tx Ifft length, if necessary
      Reconfigure_FFTandIFFTLengths();

      if(gs_RxSubStateCnt == RECONFIG_STRYMON_TX)
      {
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_QUIET2_RX_DETECT_PILOT;
      }

      break;


   case R_C_QUIET2_RX_DETECT_PILOT:
      // Because of the presence of CPilot1-like Xtalk from CO side (other ports ?), which triggers our detection,
      // add the option to delay the start of the detection until a time when CPilot1 should be approaching.
      // Xtalk first observed from GSI ADSL1/AnnexB DSLAM's.
      if ( (gl_RxSymbolCount>=(int32)gus_DelayCPilot1Det) || ((OPTNArray[OPTN_GhsControl]&OPTN_DelayCPilot1Det)==0) )
      {
         /* Wait until pilot is detected. */
         if (DetectPilot() != FALSE)
         {
            /* Go to next state */
            gs_RxNextState = R_C_PILOT1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCPilot1RxF;
         }

      }
      break;
   }

   // Check for RCQuiet2 time out failure (RCQuiet2RxF length<=2048)
   if (gl_RxSymbolCount >= (R_C_QUIET2_RX_TIMEOUT+20)) {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_RCQUIET2_TIMEOUT_Failure;
   }

}


// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START_END)
// Moved PILOT_AV_COUNT/SHIFT to rt_state.h.

FlagT DetectPilot(void)
{
   int16 i;
   // SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
   // Moved the STATIC variables to global to avoid potential memory corruption.

   int32 l_Temp;
   int16 scale1;

#ifndef ISDN
   int16 scale2;
#endif
   /* Initialize new detection window. */
   if (gs_RxSubStateCnt == 0)
   {
      gl_PilotAccR = 0;
      gl_PilotAccI = 0;
      gl_NoiseAccH = 0;
      gl_NoiseAccL = 0;
      gs_RxSubStateCnt = PILOT_AV_COUNT;
   }

   /* Accumulate pilot magnitude and noise power. */
   for (i = 2*(gs_CPilotTone - 1); i < 2*(gs_CPilotTone + 2); i++)
   {
      l_Temp = (int32)gsa_RxToneBuf[i];
      if (i == 2*gs_CPilotTone)
      {
         gl_PilotAccR += l_Temp;
      }
      else if (i == (2*gs_CPilotTone + 1))
      {
         gl_PilotAccI += l_Temp;
      }
      else
      {
         l_Temp *= l_Temp;
         gl_NoiseAccH += (l_Temp >> 16);
         gl_NoiseAccL += (l_Temp & 0xFFFF);
      }
   }

   /* Check if accumulation is completed. */
   if (--gs_RxSubStateCnt == 0)
   {
     // Compute C-Pilot1 tone power and noise power to get SNR.
     scale1 = ComputePilot_SNR(&gl_PilotAccR, &gl_PilotAccI, &gl_NoiseAccH, &gl_NoiseAccL);
#ifndef  ISDN // Only for Annex - A
    if (gft_Ghs_CPilot1Det_Enabled == TRUE)
    {
      scale2 = ConvertToDB(gs_ToneDetectScale) >> 8;

      if ( (scale1 > gl_Ghs_PilotSNR - gs_Ghs_ToneDetectScale) &&
           (scale1 > scale2) )
      {
        return TRUE;
      }
    }
    else
#endif
      /* Test if signal is present. */
      if (gl_PilotAccR > (gs_ToneDetectScale * gl_NoiseAccH))
      {
         return TRUE;
      }
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
   }

   return FALSE;
}
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
// This function is created here to share with C-Pilot1 detector power measurement.
int32 ComputePilot_SNR(int32 * PilotAccR, int32 * PilotAccI, int32 * NoiseAccH, int32 * NoiseAccL)
{
      int32 PilotSNR;

      if ((*PilotAccR) < 0) (*PilotAccR) = ~(*PilotAccR) + 1;
      (*PilotAccR) += (1 << (PILOT_AV_SHIFT-1));
      (*PilotAccR) >>= PILOT_AV_SHIFT;

      if ((*PilotAccI) < 0) (*PilotAccI) = ~(*PilotAccI) + 1;
      (*PilotAccI) += (1 << (PILOT_AV_SHIFT-1));
      (*PilotAccI) >>= PILOT_AV_SHIFT;

      (*PilotAccR) = (*PilotAccR) * (*PilotAccR) + (*PilotAccI) * (*PilotAccI);

      // Tone power can overflow only if real and imaginary parts are equal to
      // 0x8000. Saturate if necessary.
      if ((*PilotAccR) < 0)
        (*PilotAccR) = 0x7FFFFFFF;

      // Find noise power. Noise power is the average of 2*PILOT_AV_COUNT noise tones,
      // therefore to compare the noise power with tone power we need a total shift of
      // (PILOT_AV_SHIFT+1).
      if ((*NoiseAccH) == 0)
        (*NoiseAccH) = ((*NoiseAccL) + (1 << PILOT_AV_SHIFT)) >> (PILOT_AV_SHIFT+1);
      else
        (*NoiseAccH) = round_acc48((*NoiseAccH), (*NoiseAccL), (PILOT_AV_SHIFT+1));

      // In case noise power overflow
      (*NoiseAccH) = ((*NoiseAccH) > 0)?((*NoiseAccH)):(1);
      // ConvertToDB: input Q32.0 and output Q8.8 format; So PilotSNR is the integer dB
      PilotSNR = (ConvertToDB((*PilotAccR)) - ConvertToDB((*NoiseAccH))) >> 8;

      return PilotSNR;
}
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)

#undef COMPUTE_FFT_IFFT_LENGTHS
#undef RECONFIG_IRIDIA_FFT_IFFT_LENGTHS
#undef RECONFIG_STRYMON_SMODE_REGISTER
#undef RECONFIG_STRYMON_RX
#undef R_C_QUIET2_RX_MEASURE_SILENCE
#undef R_C_QUIET2_RX_MEASURE_QUIET
#undef RECONFIG_STRYMON_TX
