/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RCReverb1RxF.c
*
*   Transceiver Training Phase RX State Functions for ATU-R.
*   Covering the RX states: R_C_QUIET2, R_C_PILOT1, R_C_REVERB1
*   and R_C_REVERB2.
*
*   Notes:
*
*   R_C_PILOT3 and R_C_REVERB3 are implemented in RCReverb3RxF.c
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// RCReverb1RxF.c
//
// History
//
// 30/11/2007 Nihar: Removed the Tx power boost by 1dB from beginning of C-Quiet2
//                   state to the beginning of C-Reverb1 state for TI CO,so that it doesn't
//                   calculate extra DS PCB because of this boost, thereby giving
//                   better DS performance.
//                   Grep for PERF_US_ALL_ALL_TxPwrBoost1dB
//
// 21/11/2011 Vinjam/Bhadra: Added code to populate hybrid indix/metric to INFO 103 6 6
//            for NLNF filter detection and training.
//            Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo
//
// 21/11/2011 Hanyu: ported MFD code to VRx. Set NLNF IB bit7 to indicate Hybrid training data is ready.
//            Mapped hybrid index into NLNF IB bit9:8 to indicate training hyb range.
//            Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo
//
// 29/11/2010 Palaksha/Bhadra: Added Framework to integrate hybrid training
//            modules to "SLEEP" state codeswap page.
//            Grep for "XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo"
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 27/03/2014 Hanyu: Ported SMS00822444: Retrain and cut Tx power in short loops against CTLM CO, which has
//                        0x00 as Vender ID. This will improve DS rate performance and solve
//                        long training time issue in short loops in TR67 A2 FB noise tests.
//                        Grep for XDLSRTFW-1682 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut
//
// 27/03/14 Hanyu: Ported ADSLRTFW-1416: Added CMV bit-12 of info 103 26 to control the retrain logic for DS
//       performance tuning in TR-67 A.2/EU shor loops < 700m in SMS00822444 / XDSLRTFW-1682.
//       By default, this CMV bit is set to 1 (enabled).
//       For LiteSpan/CTLM DSLAM at AT&T lab, this CMV bit is disabled (0) to shorten training time.
//       Grep for XDSLRTFW-1592 IOP_A_DS_ADSL1_CTLM_AddCMV_TxPowerCut
//
// 11/04/2014 Sriram Shastry.: Retrain and cut Tx power by 6 dB in short loops with FB
//                        noise against ADI anaconda CO. This will improve DS rate
//                        performance.
//                        cw INFO 103 20 0x0008
//                        Grep for ADSLRTFW-918_XDSLRTFW-462_IOP_DS_ANCDA_Gdmt_FBnoiseHighDSRate
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fft_bg.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "aec_init.h"
#include "const.h"
#include "compiler.h"
#include "T1413.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "afe.h"
#include "xcvr_rx1_b.h"
#include "DSLEngin.h"
#include "RCPilot2RxF.h"
#include "HybridTraining.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


//XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (Start_End)
//Modification is not connected with Jira XDSLRTFW-271
//Compiler cribbing as function definition and functional call/usage doesn't match.
#include "DoubleTrainingPGAHandler.h"
#include "STR_ReconfigRx.h"
/*^^^
*------------------------------------------------------------------------
*
*  Name: RCReverb1RxF
*
*  Description: This state coincides with C_REVERB1, C_PILOT2 and C_ECT
*  states. It sets PGA and run PLL through C_PILOT2 state (but not during C_ECT)
*
*  Prototype: void RCReverb1RxF(void)
*
*  Input Arguments: none
*
*  Output Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      gs_RxSubState             - (I/O) Substate within current RX state
*      gs_RxNextState            - (O)   Rx state starting next symbol period
*      gl_RxSymbolCount          - (I)   count of symbols passed in current state
*     gs_RxSubStateCnt          - (I/O) count of symbols passed in current substate
*     gl_Pa                - (I/O) accumulated power
*     gs_PGA_offset           - (O)    PGA offset
*      gs_RxToneBuf[]            - (O)   Output of FFT, set in RxPower()
*
*  Substates:
*      R_C_REVERB1_RX_INITIALIZE - Waits a pre-determined number of symbols (frames)
*                                  for the channel to stabilize, and clears the power
*                                  measurement accumulator.  Also updates the PLL.
*      R_C_REVERB1_RX_SET_PGA    - Computes an average power to be used in setting
*                                  the PGA, then adjusts and implements this setting
*                                  into the PGA.  Also updates the PLL.
*
*     R_C_REVERB1_MEASURE_PGA_PRE_AEC_TRAIN
*                       - while CO is sending Pilot and RT sending Reverb
*                          measure echo only required PGA (AEC off).
*
*
*      R_C_REVERB1_RX_AEC_INIT
*                       - Acquire length (2*RxNumtones) LMS input signal
*                          for training AEC. Load AEC with unit impulse.
*                          Clear entire gla_RxAccumBuf (4*RxNumtones) as
*                          LMS reference signal will also be stored.
*
*     R_C_REVERB1_RX_ACCUM_AEC_HYB_PATH
*                       - Accumulate for NUM_AEC_LMS_SYMBOLS the sequence
*                          through both the (unit AEC) and hybrid paths.
*                          Clear AEC to capture sequence through hybrid
*                          only path.
*
*     R_C_REVERB1_RX_ACCUM_HYB_PATH
*                       - Accumulate for NUM_AEC_LMS_SYMBOLS the sequence
*                          through hybrid only path. Call background job
*                          to compute (16 bit) representative LMS input
*                          sequence (unit AEC path only) and (16 bit)
*                          representative LMS reference sequence (hybrid
*                          path only). Each length (2*RxNumtones) sequence
*                          is packed into the first half of the (32 bit)
*                          gla_RxAccumBuf.
*
*
*     R_C_REVERB1_RX_AEC_TRAIN
*                       - Call background job to train AEC using LMS.
*
*     R_C_REVERB1_RX_AEC_TRAINING_DONE
*                       - If cmv controlling AEC download is clear, Load
*                          AEC taps, exponent, and delay to hardware.
*
*     R_C_REVERB1_RX_AEC_SETTLE
*                       - (DEBUG substate) Wait and capture one rx frame.
*                          clear power accumulator.
*
*     R_C_REVERB1_MEASURE_PGA_POST_AEC_TRAIN
*                       - while CO is sending Pilot and RT sending Reverb
*                          measure echo only required PGA (AEC on).
*
*      R_C_REVERB1_RX_WAIT       - Waits until the current state (R_C_REVERB1_RX)
*                                  completes, then sets the next state pointer to
*                                  R_C_REVERB2_RX.  Also updates the PLL.
*
*  Notes: implements state R_C_REVERB1_RX
*
*------------------------------------------------------------------------
*^^^
*/

/* =============================================== */
/* substates */
/* =============================================== */
#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */

#define R_C_REVERB1_RX_INIT_HYBRID_TRAINING     (0)
#define R_C_REVERB1_RX_AGC1_ACCUM            (10)
#define R_C_REVERB1_RX_AGC2_ACCUM            (20)
#define R_C_REVERB1_RX_FREQ_DOMAIN_WAIT         (30)
#define R_C_REVERB1_RX_SIG_PSD_ACCUM         (40)
#define R_C_REVERB1_RX_PILOT_WAIT            (50)
#define R_C_REVERB1_RX_NOISE_PSD_ACCUM       (60)
#define R_C_REVERB1_RX_LOAD_BEST_HYBRID         (70)
#define R_C_REVERB1_RX_PLL_ON_WAIT           (80)
#define R_C_REVERB1_RX_WAIT                  (90)

#else // Non-AMAZON_AFE

#define R_C_REVERB1_RX_PGA_TRAIN          (207)
#define R_C_REVERB1_RX_INIT_HYBRID_TRAINING     (210)
#define R_C_REVERB1_RX_AGC1_ACCUM            (211)
#define R_C_REVERB1_RX_AGC2_ACCUM_INIT          (212)
#define R_C_REVERB1_RX_AGC2_ACCUM            (213)
#define R_C_REVERB1_RX_SIG_PSD_ACCUM         (214)
#define R_C_REVERB1_RX_PILOT_WAIT            (215)
#define R_C_REVERB1_RX_NOISE_PSD_ACCUM       (216)
#define R_C_REVERB1_RX_LOAD_BEST_HYBRID         (217)
#define R_C_REVERB1_RX_PLL_ON_WAIT           (218)

#define R_C_REVERB1_RX_RESET_PGA          (0)
#define R_C_REVERB1_RX_RESET_PGA_WAIT        (1)
#define R_C_REVERB1_RX_INITIALIZE            (2)
#define R_C_REVERB1_RX_SET_PGA               (3)
#define R_C_REVERB1_RX_PGA_WAIT              (4)
#define R_C_REVERB1_RX_RESET_PILOT_REFERENCE (5)
#define R_C_REVERB1_MEASURE_PGA_PRE_AEC_TRAIN   (6)

#define R_C_REVERB1_RX_WAIT                  (14)


#endif   //AMAZON_AFE
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void RCReverb1RxF(void) {

    int16 r_c_reverb1_det_cnt_temp = R_C_REVERB1_DET_CNT;

    switch (gs_RxSubState) {

    case R_C_REVERB1_RX_RESET_PGA:
        gs_RxSubStateCnt = 0;
        gft_EnableDoublePGATrain = TRUE;
        gs_RxSubState = R_C_REVERB1_RX_INIT_HYBRID_TRAINING;
#ifndef  ISDN
      //XDSLRTFW-3674 New_LLAPI_changes
        if((guc_HybTable == 3) &&(gt_INFX_CMV.s_HybTablesSwitch & 0x0001))
        {
           gft_IsBTorLLoop = TRUE;
        }
#endif
        gl_HybTrSymcnt[0] = gl_RxSymbolCount; //debug
        break;

    case R_C_REVERB1_RX_RESET_PGA_WAIT:

        if (guc_PgaTrainingState == TRAINING_DONE) {
            gft_EnablePLL = FALSE;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB1_RX_INITIALIZE;
        }
        break;

    case R_C_REVERB1_RX_PGA_TRAIN:
        if (gs_RxSubStateCnt < 3)
        {
            gs_RxSubStateCnt++;
        }
        else
        {
            if (guc_DoublePgaHandlerState != PGA_DOUBLE_TRN_DONE)
            {
                PGADoubleTraining();
            }
            else
            {
                gs_RxSubStateCnt = 0;
                gs_RxSubState = R_C_REVERB1_RX_RESET_PILOT_REFERENCE;
            }
        }
        break;
    case R_C_REVERB1_RX_INIT_HYBRID_TRAINING:
        gs_RxSubStateCnt++;
        if (gs_RxSubStateCnt == 1)
        {
           gl_HybTrSymcnt_start = gl_RxSymbolCount; //debug
            InitHybridVars_VR9();
            /* Disable PLL. */
            gft_EnablePLL = FALSE;
            //Bypass Rx IIR Filter
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Bypass); //Stymon Rx IIR Bypass
#ifndef  ISDN  // Only for Annex - A
            // PERF_US_ALL_ALL_TxPwrBoost1dB (Start)
            // TI US Performance British Telecom
            // 1.0dB additional Tx Power Boost is required in DMT to meet the British Telecom
            // Requirement in
            // Strong Noise Case(Euro - K) for US Performance. TI AR7 CPE also does 1dB Extra Tx
            // Power Boost.
            // Increase of 1dB Tx Power in DFE causes DFE overflow and results to DS and US CRC
            // Errors.
            // So Tx Power Boost is possible only in the AFE BIAS Register.
            // Risk: We may face the Tx PSD Violation.
            // This should be controlled by CMV.
            // Tx Power Boost by 1dB in the AFE BIAS Register

            //------------------------------------------------------------------------
            // WARNING: AFED_IncreaseTxPowerInAFE is NOT SUPPORTED IN VRx518 !!!!
            //------------------------------------------------------------------------
            if (gs_CurrentCoChipset == TI_CO_CHIPSET)
                AddFunctionToFifo(gp_TxLoadingFunctionFifo, AFED_IncreaseTxPowerInAFE);   // XDSLRTFW-1891(Start_End)
            // PERF_US_ALL_ALL_TxPwrBoost1dB (End)
#endif // ifndef ISDN
//XDSLRTFW-3192 (START)
//Add 1 dB to PGA2 margin to avoid clipping in FB noise cases.
#ifdef ISDN
         if (gft_FBnoise == TRUE)
         gs_PGA_margin_AGC2 += 0x0100;
#endif
//XDSLRTFW-3192 (END)

        }
        if (gs_RxSubStateCnt == 2)
        {
            //We are doing double PGA training, i.e train PGA1 followed by PGA2 for all the Hybrid's
            gs_PgaHandlerRun = 0; //Train PGA1 first , while training keep HPF in Bypass mode
            gs_LoadHybIndex = 0;  // Load initial hybrid, HPF, and corresponding PGA.
            //clear previous AFE overflow
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_CheckADCOverflow_ADSL);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);

        }
        if (gs_RxSubStateCnt == 5) //3 symbol delay after setting PGA to have correct value
        {
#ifdef VR9_HYB_TRAIN_DEBUG
            if(gs_Set_Pause == 0x199)Pause(0x1991);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG

            InitHybridAccum(0);
            /* Initialize the hybrid training pipeline for AGC1 accumulation. */
            gs_HybridAccumCnt = HYB_PGA_ACCUM_CNT;
            gs_Log2HybridAccumCnt = HYB_LOG2_PGA_ACCUM_CNT;
            gs_RxSubState = R_C_REVERB1_RX_AGC1_ACCUM;
        }

        break;
    case R_C_REVERB1_RX_AGC1_ACCUM:
        if (HybridTrainingPipeline_VR9(0) != FALSE)
        {
            gs_RxSubStateCnt = 0;
            //#ifdef VR9_HYB_TRAIN_DEBUG
            //         if(gs_Set_Pause == 0x200)Pause(0x2001);  //Debug
            //#endif //VR9_HYB_TRAIN_DEBUG
            /* Initialize the hybrid training pipeline for AGC2 accumulation. */
            gs_PgaHandlerRun = 1; //Train PGA2, while training put HPF inplace
            //gs_LoadHybIndex = 0;  //Start Index //This line may not be required here
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);
            gs_RxSubState = R_C_REVERB1_RX_AGC2_ACCUM_INIT;
        }
        break;
    case R_C_REVERB1_RX_AGC2_ACCUM_INIT:
        gs_RxSubStateCnt++;
        if (gs_RxSubStateCnt == 3)
        {
            /* Initialize the hybrid training pipeline for AGC2 accumulation. */
            InitHybridAccum(1);
            gs_RxSubState = R_C_REVERB1_RX_AGC2_ACCUM;
            gl_HybTrSymcnt[1] = gl_RxSymbolCount; //debug
        }
        break;
    case R_C_REVERB1_RX_AGC2_ACCUM:
        if (HybridTrainingPipeline_VR9(1) != FALSE)
        {
            //#ifdef VR9_HYB_TRAIN_DEBUG
            //         if(gs_Set_Pause == 0x201)Pause(0x2002);  //Debug
            //         gl_HYbPGATrain_SymCount = gl_RxSymbolCount; //Debug
            //#endif //VR9_HYB_TRAIN_DEBUG
            //Restore RxIIR filter after PGA computation
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Inplace); //Keep Stymon Rx IIR inplace


         //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
         /* Load Decim2/HPF after PGA training. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReconfigDecim2_HPF);
            //gs_LoadHybIndex = 0;  //Start Index //This line may not be required here
            gs_LoadAllPGAGains = 1; //Load PGA1 & PGA2 gains at a time
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);

            //         gl_DetectTone_RevRefPwr = 0;
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB1_RX_RESET_PILOT_REFERENCE;
        }
        break;

    case R_C_REVERB1_RX_RESET_PILOT_REFERENCE:
        //#ifdef VR9_HYB_TRAIN_DEBUG
        //         if(gs_Set_Pause == 0x205)Pause(0x2006);  //Debug
        //#endif //VR9_HYB_TRAIN_DEBUG
        gs_RxSubStateCnt++;
        if (gs_RxSubStateCnt < PGA_SETTLING_TIME)
        {
            break;
        }
        else if (gs_RxSubStateCnt == PGA_SETTLING_TIME)
        {
            gl_Pa = 0;
            gs_RxSubStateCnt = 0;

            /* Clear the REVERB reference buffer to convert NoiseAcc() to PSD accumulation. */
            /* Note that this reference buffer is not being used until frame synchronization */
            /* when it gets restored so there is no need to restore it right after the */
            /* hybrid training. */
            memset(gsa_CReverbRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));
            /* Initialize the hybrid training pipeline for signal PSD accumulation. */
            gs_HybridAccumCnt = HYB_SIG_PSD_ACCUM_CNT;
            gs_Log2HybridAccumCnt = HYB_LOG2_SIG_PSD_ACCUM_CNT;
            InitHybridAccum(2);
            gl_HybTrSymcnt[2] = gl_RxSymbolCount; //debug
            gs_RxSubState = R_C_REVERB1_RX_SIG_PSD_ACCUM;

        }
        break;

    case R_C_REVERB1_RX_SIG_PSD_ACCUM:
        if (HybridTrainingPipeline_VR9(2) != FALSE)
        {

#ifdef VR9_HYB_TRAIN_DEBUG
            gl_HybTrainSigPSD_SymCount = gl_RxSymbolCount; //Debug
            if(gs_Set_Pause == 0x202)Pause(0x2003);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
            gs_RxSubState = R_C_REVERB1_RX_PILOT_WAIT;
            gl_HybTrSymcnt[3] = gl_RxSymbolCount; //debug
        }
        break;
    case R_C_REVERB1_RX_PILOT_WAIT:
        if (gl_RxSymbolCount == R_C_REVERB1_RX_LEN + R_C_PILOT2_WT_LEN)
        {
#ifdef VR9_HYB_TRAIN_DEBUG
            if(gs_Set_Pause == 0x203)Pause(0x2004);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
            //gs_LoadHybIndex = 0;  //Start Index //This line may not be required here
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);
        }
        if (gl_RxSymbolCount == R_C_REVERB1_RX_LEN + R_C_PILOT2_WT_LEN + PGA_SETTLING_TIME)
        {
            /* Initialize the hybrid training pipeline for noise PSD accumulation. */
            gs_HybridAccumCnt = HYB_NOISE_PSD_ACCUM_CNT;
            gs_Log2HybridAccumCnt = HYB_LOG2_NOISE_PSD_ACCUM_CNT;
            InitHybridAccum(3);
            gs_RxSubState = R_C_REVERB1_RX_NOISE_PSD_ACCUM;
        }
        break;
    case R_C_REVERB1_RX_NOISE_PSD_ACCUM:
        if (HybridTrainingPipeline_VR9(3) != FALSE)
        {
            /* Notify TX side to switch the TSSI back on. Note that a clean echo from */
            /* the new TX signal will appear in the RX buffer five frames from now. */
            guc_HybTssiOff = 0x10;
            gs_RxSubState = R_C_REVERB1_RX_LOAD_BEST_HYBRID;
        }
        break;
    case R_C_REVERB1_RX_LOAD_BEST_HYBRID:
        if (guc_BkgdTaskState == BKGDTASK_DONE)
        {
            //#ifdef VR9_HYB_TRAIN_DEBUG
            //         if(gs_Set_Pause == 0x204)Pause(0x2005);  //Debug
            //#endif //VR9_HYB_TRAIN_DEBUG
            /* Assume we are on a short loop if maximum metric is within 0.78% of the */
            /* straight loop hybrid metric. */
            if ((gs_HybZeroMetric + (gs_HybZeroMetric >> 7)) > gs_HybMaxMetric)
            {
                /* Load the default (straight loop) hybrid. */
                gs_LoadHybIndex = STRAIGHTLOOP_HYBIDX;
            }
//XDSLRTFW-3378 (START)
#ifdef VRX518
#ifndef ISDN
           //XDSLRTFW-3407 XDSLRTFW-3408 XDSLRTFW-3409 (START)
           //Set the switching point => gs_t1413_crevelle_tone_power_dB = 0x5600
           //for the selection of zero or best hybrid which is in between 3K and 4K feet loop in T1413 mode
           //gs_t1413_crevelle_tone_power_dB = 0x5800 in 3Kft AWGN NDLT-G case
           //gs_t1413_crevelle_tone_power_dB = 0x5400 in 4Kft AWGN NDLT-G case
           //XDSLRTFW-3727 T1413_perf_improvement_Ctune_Adapt- change needed after compensation
           else if ((STATArray[STAT_Mode] & STAT_ConfigMode_T1413) && (gs_t1413_crevelle_tone_power_dB > HSK_TONE_PWR_TO_FORCE_0_HYB))
           //XDSLRTFW-3407 XDSLRTFW-3408 XDSLRTFW-3409 (START)
           {
              gs_LoadHybIndex = STRAIGHTLOOP_HYBIDX;
           }
#endif
            //Force null loop hybrid in null loop based on GHS tones received power up to 300m
            //and PGA required < -10dB*256
            else if (((gs_hsk_tone_power_dB - gs_hsk_power_dB_VendorComp) > HSK_TONE_PWR_TO_FORCE_0_HYB) &&
                                    (gs_PGA_required_In_GHS < (int16)0xF600))
            {
            /* Load the Null (straight loop) hybrid. */
            gs_LoadHybIndex = STRAIGHTLOOP_HYBIDX;
            }
#endif
//XDSLRTFW-3378 (END)
            else
            {
                /* Load the hybrid that gives the best metric. */
                gs_LoadHybIndex = gs_HybMaxIndex;
                if(gs_HybMaxIndex == (VRX518_MAX_NUM_ADAP_HYB_SETTINGS-1)) //XDSLRTFW-3753 last index used for Qln/Hlog Hyb setting (special hybrid)
                {
                   gs_LoadHybIndex = gs_HybSecondBestIndex;
                }

            }

            // Force a specific hybrid index for debug purposes
            if (gs_HybTrIndexDbg != -1)
            {
                gs_LoadHybIndex = gs_HybTrIndexDbg;
            }
            gl_HybTrSymcnt[4] = gl_RxSymbolCount; //debug
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);

           //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start)
           //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (Start)
            gt_HybridInfo.s_HybMaxIndex = gs_HybMaxIndex;
            gt_HybridInfo.s_HybMaxMetric = gs_HybMaxMetric;
            gt_HybridInfo.s_HybSecondBestIndex = gs_HybSecondBestIndex;
            gt_HybridInfo.s_HybSecondBestMetric = gs_HybSecondBestMetric;
            gt_HybridInfo.s_HybZeroMetric = gs_HybZeroMetric;
            gt_HybridInfo.s_LoadHybIndex = gs_LoadHybIndex;
           //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (End)
 #ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
            if((STATArray[STAT_MacroState] == STAT_MFD) ||
              (guc_NLNF_Enable == 1))  //In case FW can't send STAT_NLNFStartState to SW
            {
               gft_NLNF_HybridTraining = 1;
            }
            else
            {
               // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
               //Bit7=1 indicates Hyb training data ready for NLNF decision.
               gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x080;

               // Set Training Hybrid IB of INFO 121 0 or us_NlnfIbs LSB[9:8]
               if ((gs_LoadHybIndex >= 2) && (gs_LoadHybIndex <= 18))
                  gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0100; // 0b01 Short BT <=800ft
               else if ((gs_LoadHybIndex >= 19) && (gs_LoadHybIndex <= 22))
                  gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0200; // 0b10 ~1kft BT 800ft< BT <=1250
               else if (gs_LoadHybIndex >= 23)
                  gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0300; // 0b10 Long BT >1250FT
            // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE

            /* Go to the next state. */
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB1_RX_PLL_ON_WAIT;

#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
           }
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
           //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (End)
        }
        break;
    case R_C_REVERB1_RX_PLL_ON_WAIT:
        gs_RxSubStateCnt++;

        /* Wait for the newly set up TX signal to fully propagate through the TX and */
        /* RX pipelines. */
        if (gs_RxSubStateCnt == PGA_SETTLING_TIME)
        {
#ifdef VR9_HYB_TRAIN_DEBUG
            if(gs_Set_Pause == 0x205)Pause(0x2006);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
            gl_HybTrSymcnt_end = gl_RxSymbolCount; //debug
            /* Get the reference phase of pilot signal */
            ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
            /* Enable PLL. */
            gft_EnablePLL = TRUE;
            //move to next substate
            gs_RxSubState = R_C_REVERB1_RX_WAIT;
            gpF_RxStateFunc = (PtrToFunc)RCPilot2RxF;
        }
      //XDLSRTFW-1682 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (START)
#ifndef ISDN
      //Retrain and cut Tx power against CTLM CO can improve DS rate
      //performance and solve long training time issue in short loops.
      //For now this fix is limited to LSFS+ CTLM which has 0x0000
      //as vender ID. 8 or 12 dB will be cut if loop length < ~700m
      //XDSLRTFW-1592 IOP_A_DS_ADSL1_CTLM_AddCMV_TxPowerCut (START)
        if ((gs_CurrentCoChipset == CTLM_CO_CHIPSET) &&
           (gpt_RxInfoSave->ul_Provider == GHS_0000_ID) &&
           (gs_PGA_set <= 0x1500) &&
           (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_CTLM_ShortLoop_TxPowerCut) &&
           gus_shortloop_cutpower == 0)
      //XDSLRTFW-1592 IOP_A_DS_ADSL1_CTLM_AddCMV_TxPowerCut (END)
        {
           //cut more power if the loop length is < ~300m
           if (gs_PGA_set <= 0x0F00)
             gus_shortloop_cutpower = 12;
           else
             gus_shortloop_cutpower = 8;

           gs_RxNextState = FAIL_RX;
           gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;

           /* Set exception handler variables */
           gus_ExceptionState = gs_RxState;
           gus_ExceptionCode = E_CODE_SHORTLOOP_CUTPOWER;
        }
        //ADSLRTFW-918_XDSLRTFW-462_IOP_DS_ANCDA_Gdmt_FBnoiseHighDSRate (START)
        //Retrain and cut Tx power by 6 dB to imrpove DS rate performance
        //against ADI anaconda DSLAM in short loops with FB noise.
        else if ((gs_CurrentCoChipset == ANCDA_CO_CHIPSET) &&
                 (gs_PGA_set <= 0x1500) &&
                 (gft_FBnoise == 1) &&
                 (gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_ANCDA_FB_DS_RATE_IMPROVE) &&
                  (gus_shortloop_cutpower == 0))
                 {
                   gus_shortloop_cutpower = 6;

                   gs_RxNextState = FAIL_RX;
                   gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;

                   /* Set exception handler variables */
                   gus_ExceptionState = gs_RxState;
                   gus_ExceptionCode = E_CODE_SHORTLOOP_CUTPOWER;
                 }
        else if (gus_shortloop_cutpower != 0)
        //clear the flag if condition changes
        {
          //if CO or looplength changed,
          //retrain to prevent connecting to a low US rate
          if (((gs_CurrentCoChipset != CTLM_CO_CHIPSET) ||
             (gpt_RxInfoSave->ul_Provider != GHS_0000_ID)) &&
             (gs_CurrentCoChipset != ANCDA_CO_CHIPSET) ||
             (gs_PGA_set > 0x1500))
          {
            gus_shortloop_cutpower = 0;
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState = gs_RxState;
            gus_ExceptionCode = E_CODE_SHORTLOOP_CUTPOWER;
          }
        }
        //clear the counter
        gft_shortloop_cutpower_counter = 0;
#endif  // #ifndef ISDN
        //XDLSRTFW-1682 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (END)
      //ADSLRTFW-918_XDSLRTFW-462_IOP_DS_ANCDA_Gdmt_FBnoiseHighDSRate (END)

        break;

    } /* switch(gs_RxSubState) */

}

#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */

#undef R_C_REVERB1_RX_INIT_HYBRID_TRAINING
#undef R_C_REVERB1_RX_AGC1_ACCUM
#undef R_C_REVERB1_RX_AGC2_ACCUM
#undef R_C_REVERB1_RX_FREQ_DOMAIN_WAIT
#undef R_C_REVERB1_RX_SIG_PSD_ACCUM
#undef R_C_REVERB1_RX_PILOT_WAIT
#undef R_C_REVERB1_RX_NOISE_PSD_ACCUM
#undef R_C_REVERB1_RX_LOAD_BEST_HYBRID
#undef R_C_REVERB1_RX_PLL_ON_WAIT
#undef R_C_REVERB1_RX_WAIT

#else

#undef R_C_REVERB1_RX_RESET_PGA
#undef R_C_REVERB1_RX_RESET_PGA_WAIT
#undef R_C_REVERB1_RX_INITIALIZE
#undef R_C_REVERB1_RX_SET_PGA
#undef R_C_REVERB1_RX_PGA_WAIT
#undef R_C_REVERB1_RX_RESET_PILOT_REFERENCE
#undef R_C_REVERB1_MEASURE_PGA_PRE_AEC_TRAIN

#undef R_C_REVERB1_RX_WAIT


#undef R_C_REVERB1_RX_AEC_INIT
#undef R_C_REVERB1_RX_ACCUM_AEC_HYB_PATH
#undef R_C_REVERB1_RX_ACCUM_HYB_PATH
#undef R_C_REVERB1_RX_AEC_TRAIN
#undef R_C_REVERB1_RX_AEC_TRAINING_DONE
#undef R_C_REVERB1_RX_AEC_SETTLE
#undef R_C_REVERB1_MEASURE_PGA_POST_AEC_TRAIN
#undef R_C_REVERB1_RX_PRE_AEC_TRAIN
#undef R_C_REVERB1_RX_PRE_REDUCE_PGA_WAIT
#undef R_C_REVERB1_RX_REDUCE_PGA_WAIT
#undef R_C_REVERB1_RX_PRE_ACCUM_AEC_HYB_PATH_2
#undef R_C_REVERB1_RX_ACCUM_AEC_HYB_PATH_2
#undef R_C_REVERB1_RX_ACCUM_HYB_PATH_2
#undef R_C_REVERB1_RX_RECOVER_PGA_WAIT
#undef R_C_REVERB1_RX_RECOVER_PGA
#undef AEC_GAIN_DB_NEGATED



#endif   /* End of #ifdef/#else AMAZON_AFE */
