/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverb2RxF.c
 *
 *   R_C_REVERB2_RX RX State Function for ATU-R.
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCReverb2RxF.c
//
// History
//
// 11/08/2010 Kannan/Bhadra: Start Channel Identification & TDQ training
//                   from Rx channel '1' against TI & CNXT based COs for better
//                   DS performance. Since this change doesn't degrade the performance make it general.
//                   Grep for PERF_DS_ALL_TI&CNXT_ChIDfrmTone1
//
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "snr.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "fdq_init.h"
#include "states.h"
#include "fifo.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "const.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "afe.h"
#include "frm_sync_proc_b.h"
#include "frm_sync_b.h"
#include "ReverbSnr_b.h"
#include "Decim_Phase_Data.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "RCPilot3Tref2RxF.h"
#include "fft_bg.h"
#include "ovflw.h"
#include "find_sintbl.h"
#include "hndshk_Data.h"

//#ifdef DANUBE
#ifdef TARGET_HW
   #include "dataswap.h"
#endif
//#endif
#include "rcmedley_Data.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverb2RxF
 *
 *  Description: g.992.1/g.992.2 ATU-R state function for R_C_REVERB2_RX.
 * Perform ATU-R frame alignment, downstream loop attenuation estimation,
 * decimator phase selection, and FDQ training in this state.
 *
 *  Prototype: void RCReverb2RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gs_RxSubState              - (I/O) current RX substate
 *    gs_RxSubStateCnt              - (I/O) count of symbols passed in current substate
 *    gl_RxSymbolCount              - (I) count of symbols passed in current state
 *    gs_RxNextState             - (O) RX next state
 *    gus_ExceptionState            - (O) Exception state
 *    gus_ExceptionCode             - (O) Exception code
 *      gla_RxAccumBuf[]            - (I/O) accumulated frames
 *    gsa_RxToneBuf[]               - (O) FFT output buffer
 *    gus_SyncOffset             - (I/O) frame synch offset
 *    guc_FdqTrainingState       - (I/O) FDQ init. flag
 *    gsa_pre_FDQ_coef[]             - (O) mantissas of FDQ coefficients
 *    gsa_pre_FDQ_exp[]             - (O) exponents of FDQ coefficients
 *    gsa_CReverbRefTones[]          - (I) C_Reverb reference tone buffer
 *    gsa_ReverbSnrBuf[]            - (O) SNR buffer
 *
 *  Substates:
 *      R_C_REVERB2_RX_INITIALIZE      Waits a pre-determined number of symbols
 *                            (frames) for the channel to stabilize,
 *                            and clears the Echo Canceller filter
 *                            coefficients. Also updates the PLL.
 *
 *      R_C_REVERB2_RX_DS_ATTEN        Calculates downstream loop attenuation.
 *
 *      R_C_REVERB2_RX_CALC_PGA        If required (echo-only) PGA difference with
                              the AEC-on and the AEC-off exceeds a threshold of
                              PGA_DEFAULT_MARGIN, reset PGA.
 *
 *      R_C_REVERB2_RX_PGA_WAIT        If PGA reset, wait for new PGA setting to settle.
 *
 *      R_C_REVERB2_RX_RESET_PILOT     If PGA reset, reset PLL reference tone.
 *
 *      R_C_REVERB2_RX_SELECT_PHASE    Select decimator phase that gives max total Rx Reverb power.
 *
 *      R_C_REVERB2_RX_AVERAGE_FRAMES_FOR_ALIGNMENT   - Compute a representative
 *                            time domain frame by averaging a set of
 *                                      of received frames.
 *
 *      R_C_REVERB2_RX_FRAME_ALIGN     Estimates best frame alignment based on
 *                            the averaged time domain frame from
 *                            previous substate. Puts frame alignment into
 *                            effect.
 *
 *                                      Also updates the PLL.
 *      R_C_REVERB2_RX_FDQ_SETUP -     Prepare for FDQ training.
 *
 *      R_C_REVERB2_RX_AVERAGE_FRAMES_FOR_FDQ  - Computes a representative frequency
 *                            domain frame by averaging over a set of
 *                                      received frames.
  *
 *      R_C_REVERB2_RX_BEGIN_FDQ_TRAIN Computes the frequency-domain equalizer (FDQ)
 *                                      coefficients, based on the averaged frequency
 *                            domain frame from the previous substate.
 *
 *      R_C_REVERB2_RX_END_FDQ_TRAIN   Loads/activates the new FDQ coefficients.
 *                                      Updates the PLL reference tone accordingly.
 *
 *      R_C_REVERB2_RX_CALCULATE_SNR   Computes a downstream SNR estimate in each of the sub-
 *                                      channels of interest.
 *                                      Also updates the PLL.
 *
 *      R_C_REVERB2_RX_WAIT            Waits until the end of this state
 *                                      (R_C_REVERB2_RX). Also updates the PLL.
 *
 *  Notes: implements state R_C_REVERB2_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB2_RX_DS_ATTEN           (100)
#define R_C_REVERB2_RX_CALCULATE_TEST_SNR (130)
#define R_C_REVERB2_RX_AUX_CHECK       (131)
#define R_C_REVERB2_RX_WAIT               (15)

/* Below States are implemented in function RCReverbFrameSyncFdq() */
#define R_C_REVERB_RX_SELECT_PHASE_INIT      (11)
#define R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT (8)

#define NUM_SYMBOLS_FOR_DS_ATTEN_CALC     (4)
#define LOG2_NUM_SYMBOLS_FOR_DS_ATTEN_CALC   (2)

void RCReverb2RxF(void) {

   int32 l_Acc;

   if(gl_RxSymbolCount == 0)
   {
      // For DMT we use 64 symbols of accumulation of Hlin.

      gt_DS_MeasurementPeriod.us_Hlogf_measurement_period = R_C_REVERB2_ACCUM_LEN_HLIN;  //jd
      gs_RxLog2AccumLenHLin = LOG2_R_C_REVERB2_ACCUM_LEN_HLIN;

      gs_DS_MeasurementPeriod_ChanEst = R_C_REVERB2_ACCUM_LEN_CHANEST;
      gs_RxLog2AccumLenChanEst = LOG2_R_C_REVERB2_ACCUM_LEN_CHANEST;
      // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (Start)
#ifndef  ISDN  // Only for Annex - A
      // Do the Frame Sync and Chnl Identification from Rx Chnl 1 for Better TDQ Training
      // TI CO's send RCREVERB from chnl 24 onwards.
      // Enable this change for TI and Connexant DSLAM's which will send expanded Reverb Signal.
      // This may be enabled for other DSLAMs if this change helps to improve the DS Performance.
      //  if ((gs_CurrentCoChipset == GSI_CO_CHIPSET)||(gs_CurrentCoChipset == TI_CO_CHIPSET))
      // {
      gs_RxFirstChannelSave = gs_RxFirstChannel;
      gs_RxFirstChannel = RX_FIRST_CHNL_TDQ_TRAIN;
      // }
#endif // ifndef ISDN
      // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (End)
   }

    switch (gs_RxSubState) {

   /* ================================================================ */
   /* Calculate the DS Attenuation based on the received signal power   */
   /* ================================================================ */

   case R_C_REVERB2_RX_DS_ATTEN:

      gs_RxSubStateCnt++;

      l_Acc = VectorPower(gsa_RxToneBuf, (int16) (2*gs_RxFirstChannel), (int16)(2*(gs_RxLastChannel-gs_RxFirstChannel+1)), RXPWR_GUARD_BITS);

      /* Compute the average power */
      gl_Atten_Rx_Total_Power += (l_Acc >> LOG2_NUM_SYMBOLS_FOR_DS_ATTEN_CALC);

      if (gs_RxSubStateCnt == NUM_SYMBOLS_FOR_DS_ATTEN_CALC)
      {
         gs_RxSubState = R_C_REVERB_RX_SELECT_PHASE_INIT;
      }

      break;

    /* ============================================================================== */
   /* Calculate TEST SNR for DMT Aux Pilot Tone Selection (Test Snr Unused by BIS)*/
   /* ============================================================================== */
    case R_C_REVERB2_RX_CALCULATE_TEST_SNR:
      if ((gs_RxSubStateCnt >= gs_TrainCnt) &&
         (gs_RxSubStateCnt < (NUM_SYMBOLS_NMS_AVG_ADSL1+gs_TrainCnt)))
      {
         NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0, PN512_LEN, (int16)(2*gs_RxNumTones),
               gsa_CReverbRefTones, gs_RxFirstChannel, gs_RxLastChannel);

         /* Compute SNR value (This task may be done in background) */
            if(gs_RxSubStateCnt == (NUM_SYMBOLS_NMS_AVG_ADSL1+gs_TrainCnt-1))
         {
            gft_CopyRxBuffer = FALSE;

            if (gft_AuxPilot == AUX_PILOT_ENABLE)
            {
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgChooseAuxPilot);
            }

            /* Disable PLL as we load FDQ on pilot tone */
            gft_EnablePLL = FALSE;
            /* Revert f/w coppy of CPilot FDQ coefficient */
            gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)] = gsa_FDQ_coef_pilot_UnityTdq[0];
            gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1] = gsa_FDQ_coef_pilot_UnityTdq[1];
            guca_pre_FDQ_exp[gs_PilotToneIdx] = guc_FDQ_exp_pilot_UnityTdq;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQPilot);

            gs_TrainCnt = 0;
               gs_RxSubStateCnt = -1;
            gs_RxSubState = R_C_REVERB2_RX_AUX_CHECK;
         }
      }
      gs_RxSubStateCnt++;
      break;

   case R_C_REVERB2_RX_AUX_CHECK:

//#ifdef DANUBE
//#ifdef TARGET_HW
        /* Swap the Reverb SNR buffer to XMEM */
//        RequestSwap_ReverbSnrBuf_ToXmem ();
//#endif
//#endif
      if (gft_AuxPilot == AUX_PILOT_DISABLE ||
         gft_AuxPilot == AUX_PILOT_ACTIVE)
      {
         gft_CopyRxBuffer = TRUE;

         /* Switch to Aux Pilot Tone */
         if(gft_AuxPilot == AUX_PILOT_ACTIVE)
         {
            gs_PilotToneIdx = gs_AuxPilotToneIdx;
            ScalePLL(gs_PllScaling);
#ifdef ADSL_62
            //Enable latching of pilot tone at QT startup
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableLatchPilot);
#endif //HW_REIM_ACCUM
         }

         /* Pll settling time */
         gs_TrainCnt = PLL_REACQUISITION_LEN;

         /* Clear RxAccumBuf for Representative frame accum */
         MemSetBuffer((int16 *)(void *)(gla_RxAccumBuf), 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT;
      }
      break;

   /* ======================================================================================== */
   /* Wait to the end of C_REVERB2 signal */
   /* ======================================================================================== */
    case R_C_REVERB2_RX_WAIT:
#if 1
       if( (gs_RxSubStateCnt == 0) &&((guc_SnrCalcState == TRAINING_DONE)))
       {
          //guca_bhadra_Rev2_SymLog[guc_log_idx] = gl_RxSymbolCount;
          //guca_bhadra_Rev2_subState[guc_log_idx++] = R_C_REVERB2_RX_WAIT;
          gs_RxSubStateCnt++;
         //if(gs_brk_dbg & 0x0100)
         // Pause(0x0100);
       }
#endif

      //gs_RxSubStateCnt++;
      if((guc_SnrCalcState == TRAINING_DONE)&& gl_RxSymbolCount == (R_C_REVERB2_RX_LEN - 18))
      {
         if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNR_Save)
         {
            // REVERB QUIET signal.
            memcpy(gpsa_RCReverb_Quiet_Snr,gsa_ReverbSnrBuf,1024);
         }

       #ifdef TARGET_HW
               /* Swap the Reverb SNR buffer to XMEM */
               RequestSwap_ReverbSnrBuf_ToXmem ();
       #endif

      }
#ifdef ISDN
      /* Annex B Globespan CO (Lucent Stinger) does not send pilot during DEC training */
      /* even though R-ACK2 gets selected so set the flag appropriately. */
      if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
      {
         gft_PilotOnDecTraining = FALSE;
      }
#endif

#if 0//ndef ISDN
   if (gl_RxSymbolCount == (R_C_REVERB2_RX_LEN - 22) &&(guc_SnrCalcState == TRAINING_DONE))
   {
         guc_TxSilence = SILENCE_IN_PROGRESS;
         gft_NMSTxSilence = TRUE;
         gft_CopyRxBuffer = TRUE;
         //gs_RxSubState = R_C_REVERB_SILENCE_MEASURE;
         gs_RxSubStateCnt = -3;
         /* Clear RxAccumBuf for Noise Power Accum for Final Snr */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
         gs_TrainCnt = 16;
         gs_log2_TrainCnt = 4;
         //gs_RxSubStateCnt = -1;
   }
   if (gs_RxSubStateCnt < (gs_TrainCnt)&&(gs_RxSubStateCnt >=0))
   {
         NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0, PN512_LEN, (int16)(2*gs_RxNumTones),
                  gsa_CReverbRefTones, gs_RxFirstChannel, gs_RxLastChannel);
            /* Compute SNR value (This task may be done in background) */
            if(gs_RxSubStateCnt == (gs_TrainCnt-1))
            {
               //if(gs_brk_dbg & 0x0200)
               // Pause(0x0200);

               gft_CopyRxBuffer = FALSE;
               guc_SnrCalcState = TRAINING_IN_PROGRESS;
               guc_TxSilence = SILENCE_DONE;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReverbSnrCalc);
               gs_TrainCnt = 0;
               gs_RxSubStateCnt = -1;
            }
   }
#endif

      /* If R-ACK1, CO will send C-QUIET5 instead of C-PILOT3 so turn off PLL. Again, */
      /* offset of 16+2 is to be safe since we do not detect C-QUIET3A to C-REVERB1 */
      /* transition in R-ACK1 case. */
      if ((gl_RxSymbolCount == (R_C_REVERB2_RX_LEN - 18)) && (gft_PilotOnDecTraining == FALSE))
      {
         gft_EnablePLL = FALSE;
      }

      if (gl_RxSymbolCount == (R_C_REVERB2_RX_LEN - 2))
      {
         /* Set unity TDQ exponent back to 1 for DEC training. */
         gs_pre_tdq_h_exp = 14;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);

         /* Disable PLL. */
         gft_EnablePLL = FALSE;

#ifdef ADSL_62
            gs_RtvSelect = FFT_OUTPUT;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#else
         /* Enable time domain capture for DEC training. */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);

#endif
        // Don't comment the below line
        guc_PgaState = TRAINING_DONE;
        // if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_ECTTrain_DELTA)
       //  {
       //     gs_NMS_AGC1_Gain_Save = (gs_AGC1_Gain_Set << 8);
       //     gs_PGA_required_Save = gs_PGA_required;
       //     int16 s_PGA;
       //     s_PGA = 3;          // Measure Medley SNR with 3dB higher AGC gains
       //     if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_DELTA)
       //     {
       //        s_PGA = gt_HercADSL_OPTNMap_MarginControl.s_NMS_AGC;
       //     }
       //     gs_PGA_required = (s_PGA + gs_AGC1_Gain_Set) << 8;   // 8.8 format
       //     guc_PgaState = TRAINING_IN_PROGRESS;
       //     AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSetNmsPGA);
       //  }
      }
      if (gl_RxSymbolCount == (R_C_REVERB2_RX_LEN - 1))
      {

         gft_CopyRxBuffer = TRUE;

         gs_RxNextState = R_C_PILOT3_RX;
         gpF_RxStateFunc = (PtrToFunc)RCPilot3Tref2RxF;
#ifdef ADSL_62
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, Disable_FFT);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);
#endif
         // Save the Rx overflow counters for the current state
         memcpy(gusa_RCReverb2_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
         // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (Start)
#ifndef  ISDN  // Only for Annex - A
         // Do the Frame Sync and Chnl Identification from Rx Chnl 1 for Better TDQ Training
         // TI CO's send RCREVERB from chnl 24 onwards.
         // Enable this change for TI and Connexant DSLAM's which will send expanded Reverb
         // Signal.
         // This may be enabled for other DSLAMs if this change helps to improve the DS
         // Performance.
         //if ((gs_CurrentCoChipset == GSI_CO_CHIPSET)||(gs_CurrentCoChipset == TI_CO_CHIPSET))
         //{
         gs_RxFirstChannel = gs_RxFirstChannelSave;
//         }
#endif // ifndef ISDN
         // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (End)
      }

      else if(gl_RxSymbolCount >= R_C_REVERB2_RX_LEN) {  /* run out of time */
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCReverb2Rx_SignalEnd_Failure;

         // Save the Rx overflow counters for the current state
         memcpy(gusa_RCReverb2_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
      }
       //gs_RxSubStateCnt++;
        break;

   default:
      /* Common utility function between DMT and BIS modes for Reverb w/o echo state */
      RCReverbFrameSyncFdq();
      break;
    }
}
#undef NUM_SYMBOLS_FOR_DS_ATTEN_CALC
#undef LOG2_NUM_SYMBOLS_FOR_DS_ATTEN_CALC

#undef R_C_REVERB2_RX_DS_ATTEN
#undef R_C_REVERB2_RX_CALCULATE_TEST_SNR
#undef R_C_REVERB2_RX_AUX_CHECK
#undef R_C_REVERB2_RX_WAIT

#undef R_C_REVERB_RX_SELECT_PHASE_INIT
#undef R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT

