/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RCReverbFrameSyncFdq.c
*
*   Common State Function for ATU-R RCReverb2RxF and RCReverb3RxF_BIS.
*
*   Notes:
*
*------------------------------------------------------------------------
*/

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "snr.h"
#include "pll.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "frm_sync.h"
#include "fdq_init.h"
#include "states.h"
#include "fifo.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "const.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "afe.h"
#include "frm_sync_proc_b.h"
#include "frm_sync_b.h"
#include "ReverbSnr_b.h"
#include "Decim_Phase_Data.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "fft_bg.h"
#include "ovflw.h"
#include "find_sintbl.h"
#include "train_reinimmunity.h"
#include "rcmedley_Data.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

extern uint8 *gpuca_NMSPilotLog;
extern uint8 guc_PgaState;


#define R_C_REVERB_RX_INITIALIZE    (0)
#define R_C_REVERB_RX_CALC_PGA         (1)
#define R_C_REVERB_RX_PGA_WAIT         (2)
#define R_C_REVERB_RX_RESET_PILOT      (3)
#define R_C_REVERB_RX_SELECT_PHASE_INIT   (11)
#define R_C_REVERB_RX_SELECT_PHASE     (4)
#define R_C_REVERB_RX_AVERAGE_FRAMES_FOR_FDQ    (5)
#define R_C_REVERB_RX_BEGIN_FDQ_TRAIN  (6)
#define R_C_REVERB_RX_END_FDQ_TRAIN    (7)
#define R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT (8)
#define R_C_REVERB_RX_FRAME_ALIGN      (9)
#define R_C_REVERB_RX_CALCULATE_SNR    (10)
#define R_C_REVERB_RX_AVG_FRAMES_FOR_HLIN (12)
#define R_C_REVERB_RX_CHANNEL_ESTIMATE_FOR_HLIN (13)
#define R_C_WAIT_FOR_ACTUAL_AFE_SETTING      (24)
#define R_C_WAIT_FOR_REFERENCE_AFE_SETTING   (25)
#define R_C_WAIT_FOR_REFERENCE_PGA_SETTING   (26) //XDSLRTFW-3753


/* Below States are implemented in function RCReverb2RxF() */
#define R_C_REVERB2_RX_DS_ATTEN           (100)
#define R_C_REVERB2_RX_CALCULATE_TEST_SNR (130)
#define R_C_REVERB2_RX_WAIT               (15)
/* Below States are implemented in function RCReverb3RxF_BIS() */
#define R_C_REVERB3_RX_BIS_COMPUTE_HCHAN  (15)

#define R_C_REVERB_SILENCE_MEASURE_INIT    (120)
#define R_C_REVERB_SILENCE_MEASURE         (121)

#define R_C_REVERB_RX_COMPUTE_ADC_NOISE    (122)
#define R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PGA_WAIT (123)
#define R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK (124)
#define R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PLL_WAIT (125)
#define R_C_REVERB_TRAIN_RX_NOISE_MARGIN_SNR_DELTA (126)





#define FFT_LEN_1024                (1024)

#define UNITY_FDQ_MANTISSA (0x1 << (FDQ_MANTISSA_FRAC_BITS - 1))
#define  UNITY_FDQ_EXPONENT   1

#ifdef DEBUG_IMP_DETECT
#undef DEBUG_IMP_DETECT
#endif

C_SCOPE void RCReverbFrameSyncFdq(void)
{
    int16 NumSnrTrainingSymbolsReverb;

    static int16 s_PLL_reacquisition_extened_len;

    if((gl_SelectedMode & MODE_G992_1) || (gl_SelectedMode & MODE_G992_2))
    {
        NumSnrTrainingSymbolsReverb = NUM_SNR_TRAINING_SYMBOLS_REVERB_DMT;
    }
    else
    {
        NumSnrTrainingSymbolsReverb = NUM_SNR_TRAINING_SYMBOLS_REVERB_ADSL2;
    }


    switch (gs_RxSubState) {

        /* ==================================================================== */
        /* Wait for channel to stabilize and perform initialization */
        /* ==================================================================== */

    case R_C_REVERB_RX_INITIALIZE:

        if (gl_RxSymbolCount == 1)
        {
            /* Turn PLL back on: */
            gft_EnablePLL = TRUE;

            ResetPLL((int16)gs_Kp_After_CECT, (int16)gs_Ki_After_CECT, (int16)PLL_HALF_PI_RADIANS);

            ScalePLL(gs_PllScaling);

            /* Clear RxAccumBuf */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
        }

        if (gl_RxSymbolCount == (PLL_REACQUISITION_LEN-80))
        {
            ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);

            ScalePLL(gs_PllScaling);

        }

        if (gl_RxSymbolCount == PLL_REACQUISITION_LEN) {
            gl_Pa = 0;
#ifdef HW_VECPOW_ACCUM
            gl_Pa_VecPow =0;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,TriggerVectorPower);
            gs_NPR_GuardBits = gs_Log2RxSamplesPerFrame + LOG2_PGA_ACCUM_SYMBOLS;
#endif
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB_RX_CALC_PGA;

            //guca_bhadra_Rev2_SymLog[guc_log_idx] = gl_RxSymbolCount;
            //guca_bhadra_Rev2_subState[guc_log_idx++] = R_C_REVERB_RX_INITIALIZE;
        }
        break;

        /* ================================================================ */
        /* Measure the PGA while CO sending REVERB and RT sending QUIET    */
        /* Accumulate power over PGA_ACCUM_SYMBOLS symbols                  */
        /* ================================================================ */

    case R_C_REVERB_RX_CALC_PGA:


        gs_RxSubStateCnt++;

#ifdef HW_VECPOW_ACCUM
        if (gs_RxSubStateCnt <= PGA_ACCUM_SYMBOLS)
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReadVectorPower);

        if (gs_RxSubStateCnt == PGA_ACCUM_SYMBOLS)
        AddFunctionToFifo(gp_RxLoadingFunctionFifo, RestoreRtvCaptureModeSetting);
#else
        /*  accumulate rx only power */
        gl_Pa_RxOnly += VectorPower(gsa_RxToneBuf, 0, gs_RxSamplesPerFrame, (int16)(gs_Log2RxSamplesPerFrame+LOG2_PGA_ACCUM_SYMBOLS));
#endif

        if (gs_RxSubStateCnt == PGA_ACCUM_SYMBOLS + HW_VECPOW_ACCUM_DELAY)
        {
#ifdef HW_VECPOW_ACCUM
            gl_Pa_RxOnly = gl_Pa_VecPow;
#endif
            gs_PGA_required_RxOnly = PD_DB - ConvertToDB(gl_Pa_RxOnly) + gs_PGA_set;   /* recommended gain */
            gs_PGA_required_RxOnly -= (gs_PGA_margin+ gs_PGA_margin_delta_AnxL_BTloops);

#ifdef FD_ACCUM_FOR_PGA
            gs_PGA_required_RxOnly -= gs_td_fd_pwr_offset;
#endif

            /* do not reset the PGA */
            gs_RxSubState = R_C_REVERB_RX_RESET_PILOT;
            gs_RxSubStateCnt = 0;
        }

        break;

    case R_C_REVERB_RX_PGA_WAIT:

        if (guc_PgaTrainingState == TRAINING_DONE){
            gs_RxSubStateCnt = 0;
            /* Turn off PLL: */
            gft_EnablePLL = FALSE;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            gs_RxSubState = R_C_REVERB_RX_RESET_PILOT;
        }
        break;

    case R_C_REVERB_RX_RESET_PILOT:

        gs_RxSubStateCnt++;
        if (gs_RxSubStateCnt == 1) {
            /* switch to FDQ DONE interrupt to accumulate frequency domain */
            /* domain data for decimator phase selection.               */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);
        }
        else if (gs_RxSubStateCnt == 2) {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
        }
        else if (gs_RxSubStateCnt == PGA_SETTLING_TIME) {
            /* Turn on PLL */
            if (gft_EnablePLL == FALSE) {
                gft_EnablePLL = TRUE;
                /* Get the reference phase of pilot signal */
                ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
            }
            if ((gl_SelectedMode & MODE_ADSL2) != 0)
            {
                gs_RxSubState = R_C_REVERB_RX_SELECT_PHASE_INIT;
            }
            else
            {
                gl_Atten_Rx_Total_Power = 0;
                gs_RxSubStateCnt = 0;
                gs_RxSubState = R_C_REVERB2_RX_DS_ATTEN;
            }
        }
        break;

    case R_C_REVERB_RX_SELECT_PHASE_INIT:
        /* Initialize variables for phase selection */
        gl_MaxPhasePower = 0;
        gs_BestDecimatorPhaseIdx = 0;
        gs_DecimatorPhaseIdx = 0;
        gft_DecimatorPhaseSelectDone = FALSE;

        /* Go to next substate */
        gs_RxSubStateCnt = 0;
        gs_RxSubState = R_C_REVERB_RX_SELECT_PHASE;
        break;

        /* =================================== */
        /*  Choose the optimal decimator phase */
        /* =================================== */
    case R_C_REVERB_RX_SELECT_PHASE:

        gs_RxSubStateCnt++;

        if(gs_RxSubStateCnt==1) {
            gl_Rx_Total_Power = 0;
        }

        if (gs_RxSubStateCnt <= PHASE_SELECT_ACCUM_LEN) {
            /* Calculate power on tones near Nyquist */
            gl_Rx_Frame_Power = VectorPower((int16*)(gsa_RxToneBuf), (int16) (2*(gs_RxLastChannel-PHASE_SELECT_OFFSET)),
            (int16)(2*PHASE_SELECT_NUM_TONES), (int16)(RXPWR_GUARD_BITS+LOG2_PHASE_SELECT_ACCUM_LEN));

            /* accumulate the power into the total power */
            gl_Rx_Total_Power += gl_Rx_Frame_Power;
        }


        if (gs_RxSubStateCnt == PHASE_SELECT_ACCUM_LEN) {
            if (gl_Rx_Total_Power > gl_MaxPhasePower) {
                gl_MaxPhasePower = gl_Rx_Total_Power;
                gs_BestDecimatorPhaseIdx = gs_DecimatorPhaseIdx;
            }
            if (gs_DecimatorPhaseIdx < MAX_DECIMATOR_PHASE_ADJ) {
                gs_DecimatorPhaseIdx++;
            }
            else {
                gft_DecimatorPhaseSelectDone = TRUE;
                gs_DecimatorPhaseIdx = gs_BestDecimatorPhaseIdx;
            }
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetDecimatorPhase);
            gft_EnablePLL = FALSE;
        }

        if (gs_RxSubStateCnt == PHASE_SELECT_ACCUM_LEN + PHASE_ADJ_SETTLE_TIME) {
            /* Enable PLL and reset the reference phase of pilot signal */
            gft_EnablePLL = TRUE;
            ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
            if (gft_DecimatorPhaseSelectDone == FALSE) {
                gs_RxSubStateCnt = 0;
            }
        }

        if (gs_RxSubStateCnt == (PHASE_SELECT_ACCUM_LEN + PHASE_ADJ_SETTLE_TIME + 2))
        {
            /* Clear RxAccumBuf for FDQ Accum */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));

            /* Set number of FDQ training symbols */
            gs_num_fdq_training_symbols = NUM_FDQ_TRAINING_SYMBOLS_TEST;
            gs_log2_num_fdq_training_symbols = LOG2_NUM_FDQ_TRAINING_SYMBOLS_TEST;

            // restore C-Reverb reference which may have been obliterated earlier
            guc_BkgdTaskState = BKGDTASK_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgGen_Reverb_Ref_fd);

            /* Pll Settling Time */
            gs_TrainCnt = TDQ_STABLIZE_LEN;

            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB_RX_AVERAGE_FRAMES_FOR_FDQ;
            gs_PGA_required_Save = gs_PGA_required;

           if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & (OPTN_NoiseMarginChange_NM_Ctrl_ADC_REVERB_EN))
           {
               //gs_RxSubState = R_C_REVERB_RX_COMPUTE_NMS_INIT;
               gft_EnablePLL = FALSE;  //Freeze PLL tracking
               /* Disable FDQ since it will be trained.*/
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ); //disbale FDQ
               // Save values for default SNR measurement after NMS run with AGC1 gain to "actual+3dB"
               gsa_NMS_ResetPllRefToneInput_Save[0] = (gsa_PllRefTone[0]);// / gs_PilotToneScale);   // gsa_PllRefTone_unscale
               gsa_NMS_ResetPllRefToneInput_Save[1] = (gsa_PllRefTone[1]);// / gs_PilotToneScale);
               gs_NMS_AGC1_Gain_Save = (gs_AGC1_Gain_Set << 8);
               //gs_PGA_required_Save = gs_PGA_required;
               guc_NMS_AlgHandler = CALCULATE_SNR_DELTA_AGC_GAIN;
               gs_RxSubState = R_C_REVERB_RX_COMPUTE_ADC_NOISE;
               //gs_RxSubStateCnt = 0;
               //gft_CopyRxBuffer = TRUE;
               //gs_AlignForRotation = 0;
           }
        }

        break;

        /* ==================================================================== */
        /*  FDQ Training: Gather representative frequency domain frame */
        /* ==================================================================== */
    case R_C_REVERB_RX_AVERAGE_FRAMES_FOR_FDQ:

        if (guc_BkgdTaskState == BKGDTASK_DONE)
        {
            if ((gs_RxSubStateCnt >= gs_TrainCnt) &&
                    (gs_RxSubStateCnt < (gs_num_fdq_training_symbols+gs_TrainCnt)))
            {
                Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, (int16)(2*gs_RxNumTones));

                if(gs_RxSubStateCnt == (gs_num_fdq_training_symbols+gs_TrainCnt-1))
                {
                    /* Compute average of the accumulated frames in background */
                    guc_FdqTrainingState = TRAINING_IN_PROGRESS;
                    AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAvgFDQAccumulation);

                    gs_RxSubStateCnt = -1;
                    gs_RxSubState = R_C_REVERB_RX_BEGIN_FDQ_TRAIN;
                }
            }
            gs_RxSubStateCnt++;
        }
        break;


        /* ==================================================================== */
        /*  FDQ training */
        /* ====================================================================  */
    case R_C_REVERB_RX_BEGIN_FDQ_TRAIN:

        if (guc_FdqTrainingState == TRAINING_DONE)
        {
            gft_CopyRxBuffer = FALSE;

            gl_FdqStart = gl_RxSymbolCount;

            guc_FdqTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)FDQTrain);

            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB_RX_END_FDQ_TRAIN;
        }
        break;

        /* ===================================================================== */
        /* Wait for FDQ training to be completed (and check SNR if desired) */
        /* ===================================================================== */
    case R_C_REVERB_RX_END_FDQ_TRAIN:

        if (guc_FdqTrainingState == TRAINING_DONE)
        {
            gl_FdqEnd = gl_RxSymbolCount;

            /* Enable call to GetRxTones() */
            gft_CopyRxBuffer = TRUE;

            /* Clear RxAccumBuf for Representative frame accum/noise power accum */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));

            /* Pll Settling time */
            gs_TrainCnt = PLL_REACQUISITION_LEN;

            gs_RxSubStateCnt = 0;

            if ((gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_ADC_REVERB_EN)
                  &&(guc_NMS_AlgHandler == CALCULATE_SNR_DELTA_AGC_GAIN)
               )
            {
               gs_TrainCnt = 32; // anotehr 32 symbols for PLL reacquisition.
               gs_RxSubState = R_C_REVERB_TRAIN_RX_NOISE_MARGIN_SNR_DELTA;
               // here "gs_log2_TrainCnt" is used for counting number of symbols;
               if((gl_SelectedMode & MODE_G992_1) || (gl_SelectedMode & MODE_G992_2))
               {
                  gs_log2_TrainCnt = NUM_SYMBOLS_NMS_AVG_ADSL1;
               }
               else
               {
                  gs_log2_TrainCnt = NUM_SYMBOLS_NMS_AVG_ADSL2;
               }
               gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)] = UNITY_FDQ_MANTISSA;
               gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1] = 0;
               guca_pre_FDQ_exp[gs_PilotToneIdx] = UNITY_FDQ_EXPONENT;
            }
            else
            {
               if((!( gl_SelectedMode & (MODE_ADSL2)))
                   ||(guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN)
                  )
               {
                  /* Save f/w copy of CPilot FDQ coefficient */
                  gsa_FDQ_coef_pilot_UnityTdq[0] = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)];
                  gsa_FDQ_coef_pilot_UnityTdq[1] = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1];
                  guc_FDQ_exp_pilot_UnityTdq = guca_pre_FDQ_exp[gs_PilotToneIdx];
                  /* Do not fdq CPilot tone yet */
                  gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)] = UNITY_FDQ_MANTISSA;
                  gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1] = 0;
                  guca_pre_FDQ_exp[gs_PilotToneIdx] = UNITY_FDQ_EXPONENT;
                  gs_TrainCnt = 60;//PLL_REACQUISITION_LEN;
                  gs_RxSubState = R_C_REVERB2_RX_CALCULATE_TEST_SNR;
                  if( gl_SelectedMode & (MODE_ADSL2))
                  {
                     gs_RxSubState = R_C_REVERB_TRAIN_RX_NOISE_MARGIN_SNR_DELTA;
                     gs_TrainCnt =  PLL_REACQUISITION_LEN;
                     gs_log2_TrainCnt = NUM_SYMBOLS_NMS_AVG_ADSL2;
                  }

               }
               else
               {
                  /* Disable PLL since we load FDQ on pilot tone */
                  gft_EnablePLL = FALSE;
                  gs_RxSubState = R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT;
               }
            }
            // Load FDQ
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);
         }

         break;

        /* ======================================================================== */
        /* Get the representative frame by averaging over us_Hlogf_measurement_period frames */
        /* ======================================================================== */
    case R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT:

        /* Enable DD Pll now that pilot tone is fdq'ed */
        if (gs_RxSubStateCnt == 0)
        {
            gft_DDPilot = DD_PILOT_ON;
            gft_EnablePLL = TRUE;
            guc_NMS_AlgHandler = NOISE_MARGIN_SEP_DONE;
            gs_PGA_required = gs_PGA_required_Save;
        }
        /* switch to Frame Start interrupt to accumulate time domain samples*/
        else if (gs_RxSubStateCnt == gs_TrainCnt-2)
        {
#ifndef FD_ACCUM_FOR_FRAMEALIGN
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);

#else //FD_ACCUM_FOR_FRAMEALIGN
            gs_RtvSelect = (int16) FFT_OUTPUT;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRTVBuf0_train);
#if 0
            // configure RTV1 to store SFDQ output
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRTVBuf1_SFDQ_OUT);
#endif
            //Enable latching of pilot tone at QT startup
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableLatchPilot);
#endif  //FD_ACCUM_FOR_FRAMEALIGN
        }
        else  if (gs_RxSubStateCnt == gs_TrainCnt-1)
        {

#ifdef FD_ACCUM_FOR_FRAMEALIGN
            gft_fw_pilot_fdq = 1;
#else
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);
#endif  //FD_ACCUM_FOR_FRAMEALIGN
        }
        /*  accumulate representative frame of time samples */
        else if (gs_RxSubStateCnt >= gs_TrainCnt &&
                gs_RxSubStateCnt < (gs_DS_MeasurementPeriod_ChanEst+gs_TrainCnt))
        {
            Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);
        }

        /*  compute the average */
        else if (gs_RxSubStateCnt == (gs_DS_MeasurementPeriod_ChanEst+gs_TrainCnt+1))
        {

            gl_FrameSyncStart = gl_RxSymbolCount;

            /* Turn off PLL */
            gft_EnablePLL = FALSE;  /* We run BgFFT and train fdqs in subsequent Bkgrnd tasks */
            /* Turn off Copy RxToneBuf to save Mips */
            gft_CopyRxBuffer = FALSE;

            /* Perform first stage of frame alignment (Done as a background process) */
            guc_AlignmentPreProcState = TRAINING_IN_PROGRESS;
            /* gs_RxLog2AccumLen set above at gl_RxSymbolCount = 0 */
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAlignmentPreProc);

            /* Perform second stage of frame alignment (Done as a background process) */
            guc_AlignmentTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAlignmentTraining);

            /* Perform third stage of frame alignment (Done as a background process) */
            guc_AlignmentPostProcState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAlignmentPostProc);

            gs_RxSubStateCnt = -1;
            gs_RxSubState = R_C_REVERB_RX_FRAME_ALIGN;
        }
        gs_RxSubStateCnt++;
        break;

        /* ============================================================================ */
        /* Perform frame alignment  */
        /* ============================================================================ */
    case R_C_REVERB_RX_FRAME_ALIGN:

#ifdef USE_ENGINE_FOR_BG_FFTS
        if (gft_StartEngineFFT)
        EngineFFT_StateMachine();
#endif

        if (gs_RxSubStateCnt == 0)
        {
            if (guc_AlignmentPostProcState == TRAINING_DONE){

                gl_FrameSyncEnd = gl_RxSymbolCount;

                gft_CopyRxBuffer = TRUE;

                gs_PreSyncOffset = (int16)gus_SyncOffset;

                // Queue the AdjustAlignmentForward() loading function.
                FrameAlign();

                /* Load recomputed FDQs  */
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);

                gs_RxSubStateCnt = 1;
            }
        }

        else if (gs_RxSubStateCnt == 1)
        {
            // Clear frame alignment offset (should be active for one frame only).
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetRxAlign);
            gs_RxSubStateCnt = 0;
            //back up loaded hybrid index  XDSLRTFW-3753
            gft_HlogMeasurement = TRUE;
            gs_BgHybIndex = gs_LoadHybIndex;
            //Load HLOG Hyb setting (last index used for Qln/Hlog Hyb setting)
            gs_LoadHybIndex = VRX518_MAX_NUM_ADAP_HYB_SETTINGS-1;
            gs_RxSubState = R_C_WAIT_FOR_REFERENCE_AFE_SETTING;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_HskQlnHlogSetHybrid);
        }
        break;

    case R_C_WAIT_FOR_REFERENCE_AFE_SETTING:
        //#############################################################################################################
        //switch AFE to a REFERENCE mode
            //gs_RxSubState = R_C_REVERB_RX_AVG_FRAMES_FOR_HLIN;
            gs_RxSubState = R_C_WAIT_FOR_REFERENCE_PGA_SETTING;   // XDSLRTFW-3753 (start)
            gs_RxSubStateCnt = 0;
        break;

    case R_C_WAIT_FOR_REFERENCE_PGA_SETTING:

         if(gs_RxSubStateCnt == 0)
         {
            int16 s_HybGainIndex = (gs_LoadHybIndex * VRX_HYB_AFE_REG_GAINS);
            gs_PGA_required = gsa_HybGain[s_HybGainIndex + PGA_REQ_OFFSET]; //gs_PGA_required offset 1
            // XDSLRTFW-3974 Wrong Hlog reporting with DPBO in ADSL
            // avoid overwriting gs_PGA_set and gs_PGA_set_In_HLOG, since we use showtime PGA setting
            // during capturing signal for HLOG caluclation
            //gs_PGA_set = gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET];
            gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
            gs_AGC2_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET];
            //Disabled here to write the all AFE gain registers once using SetPGA() and
            //Reenable the flag after SetPGA.
            gft_EnableDoublePGATrain = FALSE;
            guc_PgaState = TRAINING_IN_PROGRESS;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            //AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_PgmHybrGain);
            //gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
         }
         if ((gs_RxSubStateCnt >= 4)&&(guc_PgaState == TRAINING_DONE))
         {
            gs_RxSubState = R_C_REVERB_RX_AVG_FRAMES_FOR_HLIN;
            // XDSLRTFW-3974 Wrong Hlog reporting with DPBO in ADSL
            // Adjust PGA setting by Hybrid gain delta between showtime hybrid and HLOG special hybrid
            gs_PGA_set_In_HLOG = (gs_PGA_set+gs_ResidualGain);
            gs_RxSubStateCnt = -1;
            gft_EnableDoublePGATrain = TRUE;

         }
         gs_RxSubStateCnt++;
      break;

    case R_C_REVERB_RX_AVG_FRAMES_FOR_HLIN:

        /* switch to Frame Start interrupt to accumulate time domain samples */
        if (gs_RxSubStateCnt == 0)
        {
            /* Clear RxAccumBuf for Representative frame accum */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
        }
        /*  accumulate representative frame of time samples */
        else if (gs_RxSubStateCnt >= 3 &&
                gs_RxSubStateCnt < (gt_DS_MeasurementPeriod.us_Hlogf_measurement_period+3))
        {
            Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);
        }
        /*  compute the average */
        else if (gs_RxSubStateCnt == (gt_DS_MeasurementPeriod.us_Hlogf_measurement_period+5))
        {

            /* Turn off Copy RxToneBuf to save Mips */
            gft_CopyRxBuffer = FALSE;

            guc_BkgdTaskState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgChannelEstimateForHLin);

            gs_RxSubState = R_C_REVERB_RX_CHANNEL_ESTIMATE_FOR_HLIN;
        }
        gs_RxSubStateCnt++;
        break;

    case R_C_REVERB_RX_CHANNEL_ESTIMATE_FOR_HLIN:
#ifdef USE_ENGINE_FOR_BG_FFTS
        if (gft_StartEngineFFT){
            EngineFFT_StateMachine();
        }
#endif
        if (guc_BkgdTaskState == TRAINING_DONE){
            gs_RxSubState = R_C_WAIT_FOR_ACTUAL_AFE_SETTING;
            gs_RxSubStateCnt = 0;
        }
        break;

    case R_C_WAIT_FOR_ACTUAL_AFE_SETTING:

        if (gs_RxSubStateCnt == 0)
        {
               // Restore HybIndex
               gs_LoadHybIndex = gs_BgHybIndex;
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_RestoreHyb_QlnHlog);
               //AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);
        }
        else if(gs_RxSubStateCnt == 1)
         {
            int16 s_HybGainIndex = (gs_LoadHybIndex * VRX_HYB_AFE_REG_GAINS);
            gs_PGA_required = gsa_HybGain[s_HybGainIndex + PGA_REQ_OFFSET]; //gs_PGA_required offset 1
            gs_PGA_set = gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET];      //gs_PGA_set offset 2
            gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
            gs_AGC2_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET];
            //Disabled here to write the all AFE gain registers once using SetPGA() and
            //Reenable the flag after SetPGA.
            gft_EnableDoublePGATrain = FALSE;
            guc_PgaState = TRAINING_IN_PROGRESS;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            //AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_PgmHybrGain);
            //gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
         }

         else if ((gs_RxSubStateCnt >= 4)&&(guc_PgaState == TRAINING_DONE))
         {
            gs_RxSubState = R_C_REVERB_RX_CALCULATE_SNR;
            gft_EnableDoublePGATrain = TRUE;
            gft_HlogMeasurement = FALSE;                          // XDSLRTFW-3753 (end)
            gs_RxSubStateCnt = -1;
        }
        gs_RxSubStateCnt++;
        break;

        /* ============================================================================== */
        /* Calculate SNR */
        /* ============================================================================== */
    case R_C_REVERB_RX_CALCULATE_SNR:

        if(gs_RxSubStateCnt == 0)
        {
            gft_CopyRxBuffer = TRUE;

            /* Load unity TDQ exponent. */
            gs_pre_tdq_h_exp = gs_UnityTDQExp;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);

#ifdef FD_ACCUM_FOR_FRAMEALIGN
            gft_fw_pilot_fdq = 0 ;
            //configure RTV0 to store FDQ output
            gs_RtvSelect = (int16) SFDQ_OUTPUT;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRTVBuf0_train);  //also disable RTV1 capturing
            //Disable latching of pilot tone at QT startup
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableLatchPilot);
#endif //FD_ACCUM_FOR_FRAMEALIGN

            /* Pll settling time */
            // we give 512 extra symbols for the PLL to settle, Because it's been disabled during HLIN accumulation.
            if (( gl_SelectedMode & (MODE_ADSL2)  ))
            s_PLL_reacquisition_extened_len = PLL_REACQUISITION_LEN+512;
            else
            s_PLL_reacquisition_extened_len = PLL_REACQUISITION_LEN;

            gs_numSymbolsIgnored = gus_max_imp_symbol;
            if (gus_max_imp_symbol > MAX_IMP_WIDTH ) gs_numSymbolsIgnored = MAX_IMP_WIDTH;
            if (gus_max_imp_symbol < 2 ) gs_numSymbolsIgnored = 2; // always skip 2

            gs_TrainCnt = s_PLL_reacquisition_extened_len + gs_indTimeRevSnr + gs_numSymbolsIgnored;
            iMetricSort(0 , INITIALIZE_METRIC_SORT) ;  // INITIALIZE STATS.

            /* switch to FDQ DONE interrupt to accumulate frequency domain */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, MoveToFdqDoneInt);


            /* Clear RxAccumBuf for Noise Power Accum for Final Snr */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
        }

        else if(gs_RxSubStateCnt == 1)
        {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableFDQDoneNTC_EnableGetRxTones);
        }

        else if(gs_RxSubStateCnt == 3)
        {
            gft_EnablePLL = TRUE;
            /* Notify R_QUIET3_TX that RX frame synchronization is done. */
            gft_RxFrameSynchDoneFlag = TRUE;
        }

        if (gs_RxSubStateCnt >=  s_PLL_reacquisition_extened_len)
        {
            int16 indMetric;

            indMetric = impulseCheck(gsa_RxToneBuf,gsa_COMB_ICOMB_DetectionBins, 4);

#ifdef DEBUG_IMP_DETECT
            gsa_MedleySnrBuf[(gs_RxSubStateCnt -  s_PLL_reacquisition_extened_len) & 0x1ff ] =   indMetric;
#endif
            if ( gs_RxSubStateCnt <= gs_TrainCnt )
            iMetricSort( (int16)indMetric , RUN_METRIC_SORT) ;

            if( gs_RxSubStateCnt ==  gs_TrainCnt )
            {
                gl_ind_metric_acc = iMetricSort(gs_numSymbolsIgnored, DONE_METRIC_SORT) ;  // INITIALIZE STATS.
                gl_indThresh = (gl_ind_metric_acc * gs_KT) >> guc_indScaleRevFdq;

#ifdef DEBUG_IMP_DETECT
                if (jg_pause & 0x20)  Pause(17);
#endif
            }
            else if ((gs_RxSubStateCnt >= gs_TrainCnt) && (gs_RxSubStateCnt < (NumSnrTrainingSymbolsReverb+gs_TrainCnt)))
            {
                if ((gl_indThresh > indMetric ) || !(gft_indEnable & 8) )
                {
                    NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0, (int16)PN512_LEN, (int16)(2*gs_RxNumTones),
                    gsa_CReverbRefTones, gs_RxFirstChannel, gs_RxLastChannel);

                    if (gs_PhaseError < -gs_dbgMaxPhErrRev)
                    gs_dbgMaxPhErrRev = -gs_PhaseError;
                    else if (gs_PhaseError > gs_dbgMaxPhErrRev)
                    gs_dbgMaxPhErrRev = gs_PhaseError;
                }
                else
                {
                    gs_droppedReverbSnr++;
                    gs_RxSubStateCnt--; // don't count this symbol;
#ifdef DEBUG_IMP_DETECT
                    gsa_ReverbEchoSnrBuf[(2*gs_droppedReverbSnr) & 0x1FF] =  (int16) indMetric;
                    gsa_ReverbEchoSnrBuf[(2*gs_droppedReverbSnr+1) & 0x1FF] =  (int16) gs_RxSubStateCnt;
#endif
                }
            }
            /* Compute SNR value (This task may be done in background) */
            if(gs_RxSubStateCnt == (NumSnrTrainingSymbolsReverb+gs_TrainCnt-1))
            {
                gft_CopyRxBuffer = FALSE;
                guc_SnrCalcState = TRAINING_IN_PROGRESS;
                AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReverbSnrCalc);
                gs_TrainCnt = 0;
                gs_RxSubStateCnt = -1;
               if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_TxNoise_REVERB)
               {
                  gs_RxSubState = R_C_REVERB_SILENCE_MEASURE_INIT;
               }
               else
               {
                  if (( gl_SelectedMode & (MODE_ADSL2)  ))
                  {
                    gs_RxSubState = R_C_REVERB3_RX_BIS_COMPUTE_HCHAN;
                  }
                  else
                  {
                    // Switch to CPilot Tone
                    if(gft_AuxPilot == AUX_PILOT_ACTIVE)
                    {
                        gs_PilotToneIdx = gs_CPilotTone;
                        ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
                    }
                    gs_RxSubState = R_C_REVERB2_RX_WAIT;
                  }
               }
            }
        }

        gs_RxSubStateCnt++;
        break;

    case R_C_REVERB_SILENCE_MEASURE_INIT:

         if(guc_SnrCalcState == TRAINING_DONE)
         {
            guc_TxSilence = SILENCE_IN_PROGRESS;
            gft_NMSTxSilence = TRUE;
            gft_CopyRxBuffer = TRUE;
            gs_RxSubState = R_C_REVERB_SILENCE_MEASURE;
            gs_RxSubStateCnt = -3;
            /* Clear RxAccumBuf for Noise Power Accum for Final Snr */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));

            if (( gl_SelectedMode & (MODE_ADSL2)  ))
            {
              //gs_RxSubState = R_C_REVERB3_RX_BIS_COMPUTE_HCHAN;
              gs_TrainCnt = 256;
              gs_log2_TrainCnt = 8;
            }
            else
            {
#if 0
               if (gl_RxSymbolCount < (R_C_REVERB2_RX_LEN - 28 - 128))
               {
                  gs_TrainCnt = 128;
                  gs_log2_TrainCnt = 7;
               }
               else if (gl_RxSymbolCount < (R_C_REVERB2_RX_LEN - 28 - 64))
               {
                  gs_TrainCnt = 64;
                  gs_log2_TrainCnt = 6;
               }
               else if (gl_RxSymbolCount < (R_C_REVERB2_RX_LEN - 28 - 32))
               {
                  gs_TrainCnt = 32;
                  gs_log2_TrainCnt = 5;
               }
#else
               if (gl_RxSymbolCount < (R_C_REVERB2_RX_LEN - 28 - 64))
               {
                  gs_TrainCnt = 64;
                  gs_log2_TrainCnt = 6;
               }

#endif
               else
               {
                   gs_TrainCnt = 0;
                   gs_RxSubStateCnt = 0;
                   gs_RxSubState = R_C_REVERB2_RX_WAIT;

                   guc_TxSilence = SILENCE_WAIT;
                   gft_NMSTxSilence = FALSE;
                   gft_CopyRxBuffer = FALSE;
                   // Switch to CPilot Tone
                   if(gft_AuxPilot == AUX_PILOT_ACTIVE)
                   {
                     gs_PilotToneIdx = gs_CPilotTone;
                     ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
                   }
               }
            }
         }
      break;

    case R_C_REVERB_SILENCE_MEASURE:

         if (gs_RxSubStateCnt < (gs_TrainCnt)&&(gs_RxSubStateCnt >=0))
         {
            NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0, PN512_LEN, (int16)(2*gs_RxNumTones),
                       gsa_CReverbRefTones, gs_RxFirstChannel, gs_RxLastChannel);
            /* Compute SNR value (This task may be done in background) */
            if(gs_RxSubStateCnt == (gs_TrainCnt-1))
            {
               gft_CopyRxBuffer = FALSE;
               guc_SnrCalcState = TRAINING_IN_PROGRESS;
               guc_TxSilence = SILENCE_DONE;
               gt_StateMachCntrl.psa_RXSNRBuf  = gpsa_RCReverb_Silence_Snr;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSnrCalcOnly);
               gs_TrainCnt = 0;
               gs_RxSubStateCnt = -1;
               gft_NMSTxSilence = FALSE;

               if (( gl_SelectedMode & (MODE_ADSL2)  ))
               {
                    gs_RxSubState = R_C_REVERB3_RX_BIS_COMPUTE_HCHAN;
               }
               else
               {
                    // Switch to CPilot Tone
                    if(gft_AuxPilot == AUX_PILOT_ACTIVE)
                    {
                        gs_PilotToneIdx = gs_CPilotTone;
                        ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
                    }
                    gs_RxSubState = R_C_REVERB2_RX_WAIT;
                }

             }
         }
         gs_RxSubStateCnt++;

      break;

   case R_C_REVERB_RX_COMPUTE_ADC_NOISE:

      if (guc_BkgdTaskState == BKGDTASK_DONE)
      {
         if (guc_NMS_AlgHandler == NOISE_MARGIN_SEP_DONE) // will enter here in ADSL2/ ADSL2p modes
         {
            /* Clear RxAccumBuf for Representative frame accum */
            MemSetBuffer((int16 *)(void *)(gla_RxAccumBuf), 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
            /* Pll settling time */
            gs_TrainCnt = PLL_REACQUISITION_LEN;
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT;
         }
         else
         {
            if (guc_NMS_AlgHandler == CALCULATE_SNR_DELTA_AGC_GAIN)
            {
               int16 s_PGA;
               s_PGA = NMS_ADD_AGC_GAIN;          // Measure Medley SNR with 3dB higher AGC gains
               if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_DELTA)
               {
                  s_PGA = gt_HercADSL_OPTNMap_MarginControl.s_NMS_AGC;
               }
               gt_HercADSL_OPTNMap_MarginControl.s_NMS_AGC = s_PGA << 8;
               gs_PGA_required = (s_PGA + gs_AGC1_Gain_Set) << 8;   // 8.8 format
            }
            guc_PgaState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSetNmsPGA);
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK;
            gs_TrainCnt = 4;
         }
         gft_CopyRxBuffer = TRUE;
      }
    break;
#if 0
   case R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PGA_WAIT:
       if (guc_PgaState == TRAINING_DONE)
       {
          gs_RxSubStateCnt++;
          if (gs_RxSubStateCnt >= gs_TrainCnt) //4symbols delay
          {
             gs_RxSubStateCnt = 0;
             gs_RxSubState = R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK;
          }
       }
   break;
#endif
   case R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK:
       if (guc_PgaState == TRAINING_DONE)
       {
          gs_RxSubStateCnt++;

          if (gs_RxSubStateCnt >= gs_TrainCnt) //4symbols delay
          {

             int16 sa_ResetPllRefToneInput[2];
             if ((guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN) ||
                   (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_PllRef))
             {
                sa_ResetPllRefToneInput[0] = gsa_NMS_ResetPllRefToneInput_Save[0];
                sa_ResetPllRefToneInput[1] = gsa_NMS_ResetPllRefToneInput_Save[1];
                 gpuca_NMSPilotLog =  (uint8 *)(void *)gpsa_New_NMS_Vector;    // for debug
             }
             else
             {
                sa_ResetPllRefToneInput[0] = gsa_RxPilotTone[0];
                sa_ResetPllRefToneInput[1] = gsa_RxPilotTone[1];
                gpuca_NMSPilotLog =  (uint8 *)(void *)gpsa_New_NMS_Vector;    // for debug
            gpuca_NMSPilotLog = gpuca_NMSPilotLog + 512; // offset 512 bytes
             }
            /* Adjust FDQ on pilot Tone */
            //FdqAdjustPerTone(&gsa_FDQ_coef_pilot_UnityTdq[0], &guc_FDQ_exp_pilot_UnityTdq,
            //    &gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)], &guca_pre_FDQ_exp[gs_PilotToneIdx],
            //    gs_PilotToneIdx, gs_AlignForRotation);

            //gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)] = UNITY_FDQ_MANTISSA;
            //gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1] = 0;
            //guca_pre_FDQ_exp[gs_PilotToneIdx] = UNITY_FDQ_EXPONENT;
            //
            ///* Load pilot FDQ coefs */
            //AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQPilot);

             /* Get the reference phase of pilot signal and do the appropriate scaling of */
             /* loop coefficients for the new pilot tone. */
             ResetPllRefTone(sa_ResetPllRefToneInput[0], sa_ResetPllRefToneInput[1]);
             //ToDo : check whether any loop filter parameters to be changed ?? not required in genral.
             //ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
             //ScalePLL(gs_PllScaling);
             /* Enable PLL. */
             gft_EnablePLL = TRUE;
             gs_RxSubStateCnt = 0;
             gs_TrainCnt = 32;
             gs_RxSubState = R_C_REVERB_RX_AVERAGE_FRAMES_FOR_FDQ;
         /* Clear RxAccumBuf for FDQ Accum */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));

             if(guc_NMS_AlgHandler == CALCULATE_SNR_DELTA_AGC_GAIN)
            {
               gs_num_fdq_training_symbols = 64;
               gs_log2_num_fdq_training_symbols = 6;
            }
            else //CALCULATE_SNR_DEFAULT_AGC_GAIN
            {
               /* Set number of FDQ training symbols */
               gs_num_fdq_training_symbols = NUM_FDQ_TRAINING_SYMBOLS_TEST;
               gs_log2_num_fdq_training_symbols = LOG2_NUM_FDQ_TRAINING_SYMBOLS_TEST;
            gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)] = gsa_FDQ_coef_pilot_UnityTdq[0];
               gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1] = gsa_FDQ_coef_pilot_UnityTdq[1];
               guca_pre_FDQ_exp[gs_PilotToneIdx] = guc_FDQ_exp_pilot_UnityTdq;
            guc_BkgdTaskState = BKGDTASK_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgGen_Reverb_Ref_fd);
            }

          }
       }
   break;

   case R_C_REVERB_TRAIN_RX_NOISE_MARGIN_SNR_DELTA:

      if ((gs_RxSubStateCnt >= gs_TrainCnt) &&
            (gs_RxSubStateCnt < (gs_log2_TrainCnt+gs_TrainCnt)))
      {
         NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0, PN512_LEN, (int16)(2*gs_RxNumTones),
            gsa_CReverbRefTones, gs_RxFirstChannel, gs_RxLastChannel);

         /* Compute SNR value (This task may be done in background) */
         if(gs_RxSubStateCnt == (gs_log2_TrainCnt+gs_TrainCnt-1))
         {
            if(guc_NMS_AlgHandler == CALCULATE_SNR_DELTA_AGC_GAIN)
            {
               gt_StateMachCntrl.psa_RXSNRBuf  = gpsa_deltaPGA_Snr;
               guc_NMS_AlgHandler = CALCULATE_SNR_DEFAULT_AGC_GAIN;
               /* Disable FDQ since it will be trained.*/
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ); //disbale FDQ
               gs_PGA_required = gs_NMS_AGC1_Gain_Save;
            }
            else // enter here for ADSL2/ADSL2p modes
            {
               gt_StateMachCntrl.psa_RXSNRBuf  = gpsa_PGA_Snr;
               guc_NMS_AlgHandler = NOISE_MARGIN_SEP_DONE;
               /* Revert f/w coppy of CPilot FDQ coefficient */
               gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)] = gsa_FDQ_coef_pilot_UnityTdq[0];
               gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1] = gsa_FDQ_coef_pilot_UnityTdq[1];
               guca_pre_FDQ_exp[gs_PilotToneIdx] = guc_FDQ_exp_pilot_UnityTdq;
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQPilot);
            }
            /* Disable PLL as we load FDQ on pilot tone */
            gft_EnablePLL = FALSE;
            gft_CopyRxBuffer = FALSE;
            gs_RxSubState = R_C_REVERB_RX_COMPUTE_ADC_NOISE;
            guc_SnrCalcState = TRAINING_IN_PROGRESS;
            guc_BkgdTaskState = BKGDTASK_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSnrCalcOnly);
         }
      }
      gs_RxSubStateCnt++;
   break;

#ifdef DEBUG_IMP_DETECT
    case 99:
        if (gs_RxSubStateCnt++ > 100 ) Pause(18);
        break;
#endif
    }

}

# undef UNITY_FDQ_MANTISSA
# undef UNITY_FDQ_EXPONENT

#undef FFT_LEN_1024

#undef R_C_REVERB_RX_INITIALIZE
#undef R_C_REVERB_RX_CALC_PGA
#undef R_C_REVERB_RX_PGA_WAIT
#undef R_C_REVERB_RX_RESET_PILOT
#undef R_C_REVERB_RX_SELECT_PHASE_INIT
#undef R_C_REVERB_RX_SELECT_PHASE
#undef R_C_REVERB_RX_AVERAGE_FRAMES_FOR_FDQ
#undef R_C_REVERB_RX_BEGIN_FDQ_TRAIN
#undef R_C_REVERB_RX_END_FDQ_TRAIN
#undef R_C_REVERB_RX_CALCULATE_SNR
#undef R_C_REVERB_RX_AVERAGE_FRAMES_FOR_ALIGNMENT
#undef R_C_REVERB_RX_FRAME_ALIGN

#undef R_C_REVERB2_RX_DS_ATTEN
#undef R_C_REVERB2_RX_CALCULATE_TEST_SNR
#undef R_C_REVERB2_RX_WAIT
#undef R_C_REVERB3_RX_BIS_COMPUTE_HCHAN
#undef R_C_REVERB_SILENCE_MEASURE_INIT
#undef R_C_REVERB_SILENCE_MEASURE

#undef R_C_REVERB_RX_COMPUTE_ADC_NOISE
#undef R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PGA_WAIT
#undef R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK
#undef R_C_REVERB_TRAIN_RX_NOISE_MARGIN_PLL_WAIT
#undef R_C_REVERB_TRAIN_RX_NOISE_MARGIN_SNR_DELTA
#undef R_C_WAIT_FOR_REFERENCE_PGA_SETTING

