/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RQuiet2TxF.c
 *
 *   Transceiver Training Phase TX State Functions for ATU-R.
 *   Covering the TX states: R_QUIET2
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RQuiet2TxF.c
//
// History
//
// 29/08/2013 Prashant: Merged the fix for XDSLRTFW-772.
// Author of code changes: Hanyu
//    Added code to workaround CO tone detection issue on ECI M41 Vinax DSLAM in Annex B by boosting Tx power level:
//    (1) Boosting 4dB Tx tone power in G.hs when it fails at R_C_GALF1_RX state for loops > 3.5km with PAG setting > 0x1A00dB.
//    (2) Restoring it back to the original power level after G.hs for ADSL2/2+ and ADSL1.
//    (3) Fine-tuned the workaround code (ADSLRTFW-1253) to boost training Tx signal power level by 1.5dB on loops > 3.7km and
//        by 2.5dB on loops > 3.9km when previous exception code is E_CODE_GHS_TONE_LOSS_OR_TIME_OUT or E_CODE_RCReverb3Rx_bis_SignalEnd_Failure.
//    (4) Calibrated the loop length estimation based on the PGA setting in R_C_GALF1_RX state.
//        Above changes are not controlled by CMV bit on DTAG FW branch. Suggest adding a new CMV bit in mainline code to narrow down side effect.
//        Grep for  XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower
//
// 06/08/2014 ChihWen: Lower Tx power by 1dB in order to boost DS PSD to increase DS rate on shorter loops in ADSL1 mode against BRCM CO.
//             Grep for XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "cmv.h"
#include "states.h"
#include "tx_ops.h"
#include "T1413.h"
#include "TxTneSt.h"
#include "RReverb1TxF.h"
#include "act_T1413.h"
#include "AFED_Functions.h"

//XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower (START)
#ifdef ISDN
#include "hndshk_Data.h"
#endif
//XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower (END)

// XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (START)
#ifdef ISDN // Only for Annex B
// Restore Tx gain from G.hs Tx power boost
// 20*log10(X/2^14)=YdB  X = (2^14) * 10^(YdB/20)
#define TX_PWR_MINUS_6_DB        (8211)       // tx power reduced by -6.0dB
#define TX_PWR_MINUS_5_DB        (9213)       // tx power reduced by -5.0dB
#define TX_PWR_MINUS_4_DB        (10338)      // tx power reduced by -4.0dB
#define TX_PWR_MINUS_3_DB        (11599)      // tx power reduced by -3.0dB
//XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower (START_END)
#define TX_PWR_MINUS_1_DB        (14602)      // tx power reduced by -1.0dB
#endif
// XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (END)


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuiet2TxF
 *
 *  Description:    Transmits R_QUIET2 signal to start transciever training
 *  until C-PILOT1/1A or C-Quiet3 is detected. After C-PILOT1/1A is detected,
 *  R_QUIET2 is continuously transmitted until the PLL lock is gained.
 *  Then it enters R_REVERB1_TX state. If the ATU-R does not detect both signals
 *  within 6000 symbols it shall invoke the initialization reset procedure.
 *
 *  Prototype: void RQuiet2TxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *      gft_C_PILOT1_1A_flag - (I) set in RCPilot1RxF(), 1 indicating the transition to R_REVERB1_TX
 *                         should happen; 0, otherwise.
 *
 *  Notes: implements state R_QUIET2_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RQuiet2TxF(void) {

   static int16 s_TimeOut;

   if(gl_TxSymbolCount == 0) {
      gft_C_PILOT1_1A_flag = FALSE;
      TxToneSetUp(0,0,0);
      gft_IFFT_On = TRUE;
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=TxProcessTones;

      if(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)
         s_TimeOut = R_T1413_QUIET2_TX_TIMEOUT - 1;
      else
         s_TimeOut = R_QUIET2_TX_TIMEOUT - 1;

      // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (START)
#ifdef ISDN // Only for Annex B
      // Restore Tx gain from G.hs Tx power boost
      if (gft_workaround_ECIM41_VNX == 1)
      {
         gus_TxGain_NoCutBack = (int16) (((int32) gus_TxGain_NoCutBack * TX_PWR_MINUS_4_DB) >> 14);
         gft_workaround_ECIM41_VNX = 0;
      }
#endif
      // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (END)

//XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower (START)
#ifdef ISDN
   if ( (gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_LOWER_TX_POWER) &&
         (gl_SelectedMode & MODE_G992_1) &&
         (gs_hsk_tone_power_dB >= MINIMUM_GHS_TONE_PWR_AT_1000M) )
      gus_TxGain_NoCutBack = (int16) (((int32) gus_TxGain_NoCutBack * TX_PWR_MINUS_1_DB) >> 14);
#endif
//XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower (END)

   }

   /* Note: This function is in HNDSHK2 swap page. The RX state machine will change */
   /* to a dummy R-QUIET2 state function when it is the time to swap in the XCVR1 */
   /* page. If the timeout occurs before that (i.e., the pilot was not detected), */
   /* go to the exception state. */
   if (gl_TxSymbolCount == s_TimeOut) {

#ifndef ISDN
      if ( (s_TimeOut==R_T1413_QUIET2_TX_TIMEOUT-1) && (gs_NumT1Restarts<4) && !(STATArray[STAT_Mode]&STAT_ConfigMode_T1413) )
#else
        if ( (s_TimeOut==R_T1413_QUIET2_TX_TIMEOUT-1) && (gs_NumT1Restarts<4) && !(STATArray[STAT_Mode1]&STAT_ConfigMode_ETSI_AnnexC) )
#endif

        {
         // If R_C_REVEILLE has declared (in STAT_Mode) T1.413 startup upon detection of C_PILOT1, it's too late to go back
         STATArray[STAT_Misc] &= ~STAT_T1413_Signal_Detected ;
         STATArray[STAT_MacroState] = STAT_ReadyState;
         gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
         gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;
         gs_NumT1Restarts++;
         gs_TxNextState = R_ACT_REQ_TX;
         gpF_TxStateFunc = (PtrToFunc)RActReqTxF;
         gs_RxNextState = R_C_ACT_RX;
         gpF_RxStateFunc = (PtrToFunc)RCActRxF;
      }
      else {
         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = E_CODE_RQuiet2_SignalEnd_Failure;
      }
   }
   //Tx PSD freeze support for showtime unity gain
   if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_SHOWTIME_UNITY_GAIN)
    {
        //Freeze CPE Tx in Showtime with unity fine gains
        gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 = 0;
        gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset1 = 0;
        TESTArray[TEST_SuppressErrorReportingToME] = (int16)0xFFFF;

        TESTArray[TEST_Control3] |= TEST_ForceUpStreamFineGainsToUnity;
    }
   // Program Tx POCO to PD
   if(guc_TxSilence == SILENCE_IN_PROGRESS)
   {
      vrx5afe_POCO_PD();
      guc_TxSilence = SILENCE_WAIT;
   }
   else if (guc_TxSilence == SILENCE_DONE)
   {
      vrx5afe_POCO_PU();
      guc_TxSilence = SILENCE_WAIT;
   }
}

