/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RQuiet2TxF.c
 *
 *   Transceiver Training Phase TX State Functions for ATU-R.
 *   Covering the TX states: R_QUIET2
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */
 // ******************************************************************
// RQuiet2TxF.c
//
// History
//
// 30/3/2015 Sriram Shastry:
//  Jira XDSLRTFW-1843 :CPE  is unable to  link in ADSL2/ADSL2P under Multi-mode configuration.
//  Solution is force CPE  to  G.DMT  mode after 3 fails attempts during  training in ADSL2/ASDL2P mode.
//    Grep for  XDSLRTFW-1843
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "cmv.h"
#include "states.h"
#include "RReverb1TxF.h"
#include "AFED_Functions.h"




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuiet2TxF_CS
 *
 *  Description:  Dummy R-QUIET2 function that waits for codeswap to finish.
 *
 *  Prototype: void RQuiet2TxF_CS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gft_C_PILOT1_1A_flag - (I) set in RCPilot1RxF(), 1 indicating the transition to R_REVERB1_TX
 *                         should happen; 0, otherwise.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RQuiet2TxF_CS(void)
{
   /* gft_C_PILOT1_1A_flag = TRUE implies that C_PILOT1/1A is detected, */
   /* pilot acquisition is achieved, and XCVR1 swap page is in. */
   if (gft_C_PILOT1_1A_flag == TRUE)
   {
      // XDSLRTFW-1843(Start)
      if((((guca_fe_G9941_VendorID[6] << 8) | (guca_fe_G9941_VendorID[7])) == (0X71B3))&& (gs_CurrentCoChipset == IFTN_CO_CHIPSET))
      {
         if(guc_IFTN_DMT_T1413_Train_Cnt == CRC_MISMATCH_ERR_FAIL_COUNT)
         {
            guc_IFTN_CRC_MISMATCH_ERR_cnt = 0;  // Reset
            guc_IFTN_DMT_T1413_Train_Cnt  = 0;  // Reset
         }
         else
         {
            guc_IFTN_DMT_T1413_Train_Cnt++;  // Increment count
         }
      }
         // XDSLRTFW-1843 (End)
      STATArray[STAT_MacroState] = STAT_FullInitState;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_FullInitState;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_FULL_INIT;
      gs_TxNextState = R_REVERB1_TX;
      gpF_TxStateFunc = (PtrToFunc)RReverb1TxF;
   }

   // Program Tx POCO to PD
   if(guc_TxSilence == SILENCE_IN_PROGRESS)
   {
      vrx5afe_POCO_PD();
      guc_TxSilence = SILENCE_WAIT;
   }
   else if (guc_TxSilence == SILENCE_DONE)
   {
      vrx5afe_POCO_PU();
      guc_TxSilence = SILENCE_WAIT;
   }
}

