/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RQuiet3TxF.c
 *
 *   Transceiver Training Phase TX State Functions for ATU-R.
 *   Covering the TX states: R_QUIET2, R_REVERB1, R_QUIET3 and R_REVERB2.
 *
 *   Notes:
 *
 *   R_ECT is implemented in xcvr_tx2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "cmv.h"
#include "mp.h"
#include <string.h>
#include "t1413.h"
#include "TxTneSt.h"
#include "ClrTxBuf.h"
#include "REctTxF.h"




/* =============================================== */
/* global variable declarations */
/* =============================================== */

/* =============================================== */
/* static variable declarations */
/* =============================================== */

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuiet3TxF
 *
 *  Description: Transmits R_QUIET3 signal for 2048 symbols.
 *
 *  Prototype: void RQuiet3TxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount - (I) # symbol periods in current TX state
 *      gs_TxNextState   - (O) TX state that will begin next symbol period
 *
 *  Notes: implements state R_QUIET3_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void RQuiet3TxF(void) {

   if (gl_TxSymbolCount == 0)
   {
      if (gs_TxState == R_QUIET3_TX)
         TxToneSetUp(0,0,0);
#ifndef ISDN
      else // if TxState == R_PILOT1_TX
         TxToneSetUp ((int16) R_PILOT_TONE, (int16) ENCGAIN2, 0);
#endif

      /* Initialize the flag that will be set after the RX frame synchronization. */
      gft_RxFrameSynchDoneFlag = FALSE;
   }

#ifndef BIS_CODESWAP
   //This is now handled by RQuiet3bTxF (residing in XCVR2), switched to when XCVR2 is loaded
    if (gl_TxSymbolCount == (R_QUIET3_TX_LEN - 1)){
        gs_TxNextState = R_ECT_TX;
      gpF_TxStateFunc = (PtrToFunc)REctTxF;
   }
#endif
}

