/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb1TxF.c
 *
 *   Transceiver Training Phase TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB1
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RReverb1TxF.c
//
// History
//
// 08/07/2010 Nihar: Added code to avoid US-rate run2run variations against TI AC5 and TI 4000C on short White Noise loops
//                  Optimize CO TDQ training by sending out a wider Reverb spectrum in Reverb1/Reverb2
//                By default it is disabled. To enable it set bit 4 of OPTN 25 0
//             grep for "IOP_DS_DMT_TI_UseBroaderTxReverbSignal"
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "cmv.h"
#include "mp.h"
#include <string.h>
#include "t1413.h"
#include "TxTneSt.h"
#include "ClrTxBuf.h"
#include "RQuiet3TxF.h"
#include "RReverb1TxF_Wait.h"
#include "RSegueTxF.h"
#include "RSegueRATxF.h"
#include "rx_eoc.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif



/* =============================================== */
/* global variable declarations */
/* =============================================== */

/* =============================================== */
/* static variable declarations */
/* =============================================== */

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb1TxF
 *
 *  Description: Sends the R_Reverb signal to the ATU-C.  R_Reverb is
 *  sent on tones gs_TxFirstChannel to gs_TxLastChannel.  This function is
 *  reused for several states.
 *
 *  Prototype: void RReverb1TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegue() )
 *    gs_TxState        - (I) current TX state
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *    gt_StateMachCntrl - (I/O) state machine control structure
 *    gus_TxSineGain    - (O) TX sine gain
 *
 *  Notes: implements states R_REVERB1_TX
 *
 *------------------------------------------------------------------------
 *^^^
*/
void RReverb1TxF(void) {
#ifndef ISDN
   int16 i;
#endif

#ifdef ADSL_62
   if (gl_TxSymbolCount == 0)
#else
   if ((gl_TxSymbolCount == 0) || ((guc_HybTssiOff & 0x10) != 0)) //only AMAZON hybrid training code uses guc_HybTssiOff - we should ignore it for VR9 - see RCReverb1RxF.c
#endif
   {
#ifdef ISDN
      /*  set up freq domain REVERB signal in gsa_TxToneBuf input buffer  */
      // IOP_DS_DMT_TI_UseBroaderTxReverbSignal
      TxReverbSegueSetUp(gs_TxReverb12FirstCh, gs_TxReverb12LastCh, R_REVERB);      // IOP_DS_DMT_TI_UseBroaderTxReverbSignal
#else
      /*  set up freq domain REVERB signal in gsa_TxToneBuf input buffer  */
      TxReverbSegueSetUp(gs_TxReverb12FirstCh, gs_TxLastChannel, R_REVERB);
#endif
#ifndef ISDN
#ifdef ADSL_62
      if ( (OPTNArray[OPTN_AlgControl] & OPTN_IFFT128_Enable) && (STATArray[STAT_Misc] & STAT_IFFT64_EMULATE_REVERB ) )
      {
#else
      if (  ((guc_HybTssiOff & 0x10) != 0) && (OPTNArray[OPTN_AlgControl] & OPTN_IFFT128_Enable) && (STATArray[STAT_Misc] & STAT_IFFT64_EMULATE_REVERB ) )
      {
         /* RX state machine signals the need for REVERB change using BIT4 in the */
         /* guc_HybTssiOff variable. Clear this bit for future use. */
         guc_HybTssiOff &= 0xEF;
#endif
         // add image signal
         // Mirror and conjugate tones 1-31 into tones 32-63
         for (i=gs_TxNumTones+1 ; i<TX_NUM_TONES ; i++)
         {
            gsa_TxToneBuf[2*i] = gsa_TxToneBuf[2*(TX_NUM_TONES-i)];
            gsa_TxToneBuf[2*i+1] = -gsa_TxToneBuf[2*(TX_NUM_TONES-i)+1]; // Conjugate.
         }

      }
#endif //ISDN
   }


   if (gl_TxSymbolCount == 0)
   {


      AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT_Reordering);
      gft_IFFT_On = TRUE;

      gs_DetSegueFlag = TRUE;

   }

#ifdef BIS_CODESWAP
   /* Wait for XCVR1 page to be swapped in and RReverb1Tx settings are done. */
   if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_XCVR1EXT)
      && (gs_DetSegueFlag == TRUE))
#else
   if (gs_DetSegueFlag == TRUE)
#endif
   {
      gpF_TxStateFunc = (PtrToFunc)RReverb1TxF_Wait;
   }

}

