/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb2TxF.c
 *
 *   Transceiver Training Phase TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB2
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RReverb2TxF.c
//
// History
//
// 08/07/2010 Nihar: Added code to avoid US-rate run2run variations against TI AC5 and TI 4000C on short White Noise loops
//                  Optimize CO TDQ training by sending out a wider Reverb spectrum in Reverb1/Reverb2
//                By default it is disabled. To enable it set bit 4 of OPTN 25 0
//             grep for "IOP_DS_DMT_TI_UseBroaderTxReverbSignal"
//
// 30/04/2015 Sriram Shastry:  Tx Rx frame alignment  is  stuck . We are not  receiving "gs_DECAdaptationRxOffset > 0" with  in 2048 symbol during.
// as a results Tx Rx frame alignment is stuck .Added a  work around , within  2038 to  2048  symbols ,we force the  gs_DECAdaptationRxOffset to 0 and
// enter RECT(). Side effect , once in a while  we get low rates
//          Grep for XDSLRTFW-2331
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "cmv.h"
#include "mp.h"
#include <string.h>
#include "t1413.h"
#include "TxTneSt.h"
#include "ClrTxBuf.h"
#include "RQuiet3TxF.h"
#include "RSegueTxF.h"
#include "RSegueRATxF.h"
#include "REctTxF.h"
#include "dec_adap_Data.h"
#include "memsetbf.h"
#include "AFED_Functions.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif

int16 gs_TxFrame_Extend = 416; //timing advance =416 tx samples, experimental value

#define MINUS_FOUR_DB      (20675)     // * 2^-15

/* =============================================== */
/* global variable declarations */
/* =============================================== */

/* =============================================== */
/* static variable declarations */
/* =============================================== */

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb2TxF
 *
 *  Description: Sends the R_Reverb signal to the ATU-C.  R_Reverb is
 *  sent on tones gs_TxFirstChannel to gs_TxLastChannel.  This function is
 *  reused for several states.
 *
 *  Prototype: void RReverb2TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegue() )
 *    gs_TxState        - (I) current TX state
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *    gt_StateMachCntrl - (I/O) state machine control structure
 *    gus_TxSineGain    - (O) TX sine gain
 *
 *  Notes: implements states R_REVERB2_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RReverb2TxF(void) {
#ifndef ISDN
   int16 i;
#endif

   if (gl_TxSymbolCount == 0) {
      /* Clear TX tone buffer first */
      MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*(2*gs_TxNumTones)));
#ifdef ISDN
      /*  set up freq domain REVERB signal in gsa_TxToneBuf input buffer  */
      // IOP_DS_DMT_TI_UseBroaderTxReverbSignal
      TxReverbSegueSetUp(gs_TxReverb12FirstCh, gs_TxReverb12LastCh, R_REVERB);      // IOP_DS_DMT_TI_UseBroaderTxReverbSignal
#else
      /*  set up freq domain REVERB signal in gsa_TxToneBuf input buffer  */
      TxReverbSegueSetUp(gs_TxReverb12FirstCh, gs_TxLastChannel, R_REVERB);
#endif

#ifndef ISDN
      if ( (OPTNArray[OPTN_AlgControl] & OPTN_IFFT128_Enable)  && (STATArray[STAT_Misc] & STAT_IFFT64_EMULATE_REVERB ))
      {
         // add image signal
         // Mirror and conjugate tones 1-31 into tones 32-63
         for (i=gs_TxNumTones+1 ; i < TX_NUM_TONES ; i++)
         {
            gsa_TxToneBuf[2*i] = gsa_TxToneBuf[2*(TX_NUM_TONES-i)];
            gsa_TxToneBuf[2*i+1] = -gsa_TxToneBuf[2*(TX_NUM_TONES-i)+1]; // Conjugate.
         }

      }

#endif


      if (gft_TxFrameAlignEnable != FALSE)
      {
         /* Setup to transition to R-SEGUE1 based on C-SEGUE1 detection. */
         gs_DetSegueFlag = FALSE;
      }
      else
      {
         /* Setup to tranition to R-SEGUE1 based on symbol count only. */
         gs_DetSegueFlag = TRUE;
      }

   }
   if((gs_DetSegueFlag == TRUE) && (gl_TxSymbolCount >= (R_REVERB2_TX_LEN-1))) {
#ifdef BIS_CODESWAP
      // If ANL1DMT is not in, somethings wrong, check states trail: declare exception
      if(gs_CodeSwapSection != CSPAGE_BIS_MTDQ)
      {
         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = E_CODE_CODESWAP_ERR;
      }
      else
#endif
      {
         gs_TxNextState = R_SEGUE1_TX;
         gpF_TxStateFunc = (PtrToFunc)RSegueTxF;

         // Save the Tx overflow counters for the current state
         memcpy(gusa_RReverb2_TxOverflowCnts, gusa_TxOverflowCnts, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));
      }
   }
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuiet3bTxF
 *
 *  Description: The second part of R_QUIET3 that resides in XCVR2. This
 *               function performs the RX-TX alignment needed for DEC adaptation.
 *
 *  Prototype: void RQuiet3bTxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount - (I) # symbol periods in current TX state
 *      gs_TxNextState   - (O) TX state that will begin next symbol period
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define R_QUIET3_TX_RX_SYNCH_WAIT      (0)
#define R_QUIET3_TX_GET_INIT_ALIGN     (10)
#define R_QUIET3_TX_RESTORE_FRAME      (20)
#define R_QUIET3_TX_TRANSITION_CNT     (30)

void RQuiet3bTxF(void)
{
   int16 s_TxFrameAdjustment;
   int16 s_Shift, s_TxFftLength_Nyquist;

   // Program Tx POCO to PD
   if(guc_TxSilence == SILENCE_IN_PROGRESS)
   {
      vrx5afe_POCO_PD();
      guc_TxSilence = SILENCE_WAIT;
   }
   else if (guc_TxSilence == SILENCE_DONE)
   {
      vrx5afe_POCO_PU();
      guc_TxSilence = SILENCE_WAIT;
   }

   switch (gs_TxSubState)
   {
   case R_QUIET3_TX_RX_SYNCH_WAIT:
      /* RX-TX alignment must wait until the RX frame synchronization is done */
      /* (gft_RxFrameSynchDoneFlag flag is set in the RCReverb2RxF routine when */
      /* synchronization completes). */
      if (gft_RxFrameSynchDoneFlag != FALSE)
      {
         gs_TxSubStateCnt = 0;
         #ifndef VINAX_ADSL_AFE
            gs_TxSubState = R_QUIET3_TX_GET_INIT_ALIGN;
            #else
            /* this alignment was intended to improve showtime DEC adaptation, */
            /* but it is not currently being used. */
         gs_TxSubState = R_QUIET3_TX_TRANSITION_CNT;
            #endif
      }
      break;

   case R_QUIET3_TX_GET_INIT_ALIGN:
      gs_TxSubStateCnt++;
#ifndef ADSL_62
      if (gs_TxSubStateCnt == 1)
      {
         /* Set TX offset to zero. */
         gs_DECAdaptationTxOffset = 0;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, LoadDECAdaptationTxOffset);
      }
      else if (gs_TxSubStateCnt == 2)
      {
         /* Activate DEC capture and enable IRSFS strobe. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ActivateDECAdaptationRxCapture);
      }
      else if (gs_TxSubStateCnt == 3)
      {
         /* Disable IRFSF strobe. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,SupressDECAdaptationRxCapture);
         /* Prepare for RX offset read. */
         gs_DECAdaptationRxOffset = -1;
      }
      else
      {
         /* Poll DEC capture register and read RX offset. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,GetDECAdaptationRxOffset);

         /* Calculate the frame adjustment needed for RX-TX alignment when */
         /* RX offset is read. */
         if (gs_DECAdaptationRxOffset >= 0)
         {
            /* Find target RX-TX alignment (in RX samples) such that the TX */
            /* data captured for DEC adaptation contains TX frame boundary */
            /* for all possible values of DEC delay and DEC phase length: */
            /* Target RX-TX alignment = FrameLenWithCP/2 - (MaxDECDelay128IFFT + CPLen) */
            s_TxFrameAdjustment = (60-MAX_DEC_DELAY) * (gs_RxSamplesPerFrame >> 7);
            /* Correct for the alignment change due to the difference in TX and */
            /* RX cyclic prefix insertion instances. */
            s_TxFrameAdjustment += (5 * gs_RxCPLength);

            /* Find TX frame adjustment in RX samples. Notice that the measured RX */
            /* offset is actually equal to the initial RX-TX alignment since */
            /* TX offset was set to zero. */
            s_TxFrameAdjustment = s_TxFrameAdjustment - gs_DECAdaptationRxOffset;

            /* Convert the TX frame adjustment into a number of upstream samples. */
            /* Note that by standard the adjustment has to be a multiple of the 64 */
            /* point IFFT upstream sample, thus the adjustment is first converted */
            /* into a number of 64 point IFFT samples and then multiplied by 2 if */
            /* 128 point IFFT is used. */
            s_Shift = gs_Log2RxSamplesPerFrame - 6;
            s_TxFrameAdjustment = (s_TxFrameAdjustment + (1 << (s_Shift-1))) >> s_Shift;
            if (gs_TxFftLength == 128)
            {
               s_TxFrameAdjustment <<= 1;
            }

            /* Limit the adjustment to [0, FrameLen) range. */
            while (s_TxFrameAdjustment < 0)
            {
               s_TxFrameAdjustment += gs_TxFftLength;
            }
            while (s_TxFrameAdjustment >= gs_TxFftLength)
            {
               s_TxFrameAdjustment -= gs_TxFftLength;
            }


            /* If enabled and different from 0, perform Tx frame alignment. */
            if ((gft_TxFrameAlignEnable != FALSE) && (s_TxFrameAdjustment != 0))
            {
               /* Extend one TX frame by s_TxFrameAdjustment. This is done by */
               /* setting the cyclic prefix to the TX frame adjustment for one frame. */
               gs_TxCPLength = s_TxFrameAdjustment;
               AddFunctionToFifo(gp_TxLoadingFunctionFifo,InsertTxCP);

               gs_TxSubState = R_QUIET3_TX_RESTORE_FRAME;
            }
            else
            {
               gs_TxSubState = R_QUIET3_TX_TRANSITION_CNT;
            }
         }
      }
#else // #ifndef ADSL_62
      if (gs_TxSubStateCnt == 1)
      {
         /* Set TX offset to zero. */
         gs_DECAdaptationTxOffset = 0;
         gs_DECTxDataCaptureLength =1;
         gs_DECAdaptationInputCaptureOffset = gs_DECAdaptationTxOffset;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, LoadDECAdaptationTxOffset);
      }
      else if (gs_TxSubStateCnt == 2)
      {
         /* Activate DEC capture and enable IRSFS strobe. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ActivateDECAdaptationRxCapture);
      }

      else if (gs_TxSubStateCnt == 5)
      {
         /* set Sync Frame. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetRxSyncFrame);

      }
      else if (gs_TxSubStateCnt == 6)
      {
         /* Disable IRFSF strobe. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,SupressDECAdaptationRxCapture);
         /* Prepare for RX offset read. */
         gs_DECAdaptationRxOffset = -1;
      }

      else if(gs_TxSubStateCnt >= 7)
      {
         /* Poll DEC capture register and read RX offset. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,GetDECAdaptationRxOffset);
         // XDSLRTFW-2331 : (Start)
         // DEC Adaptation is  stuck in Training phase. Tx Rx Frame alignment is very  sensitive.
         // Sometime (1/60 runs) Rx Sample capture is not  working.So  as a workaround moved  the RECT detection
         // ahead of 2048 symbols and initialized Rx-Offset to 0. Echo canceller  works for
         // all 512 Rxfft capture(gs_DECAdaptationRxOffset = 0)
         // Side effect : We can expect occasional low data rate .
         // Below code is  a workaround
         if ((gl_TxSymbolCount >= (R_QUIET3_TX_LEN - 10) ) && (gl_TxSymbolCount <= (R_QUIET3_TX_LEN - 1)) )
         {
            gs_DECAdaptationRxOffset = 0;
         }
         else
         {
            gs_DECAdaptationRxOffset = -1;                  // Predefined value
         }
         // XDSLRTFW-2331(End)
         /* Calculate the frame adjustment needed for RX-TX alignment when */
         /* RX offset is read. */
         if (gs_DECAdaptationRxOffset >= 0)
         {

            /* Find target RX-TX alignment (in RX samples) such that the TX */
            /* data captured for DEC adaptation contains TX frame boundary */
            /* for all possible values of DEC delay and DEC phase length: */
            /* Target RX-TX alignment = FrameLenWithCP/2 - (MaxDECDelay128IFFT + CPLen) */
//          s_TxFrameAdjustment = (60-MAX_DEC_DELAY) * (gs_RxSamplesPerFrame >> 7);
            s_TxFrameAdjustment = gs_TxFrame_Extend;
            /* Correct for the alignment change due to the difference in TX and */
            /* RX cyclic prefix insertion instances. */
            s_TxFrameAdjustment += (5 * gs_RxCPLength);

            /* Find TX frame adjustment in RX samples. Notice that the measured RX */
            /* offset is actually equal to the initial RX-TX alignment since */
            /* TX offset was set to zero. */
            s_TxFrameAdjustment = s_TxFrameAdjustment - gs_DECAdaptationRxOffset;
#ifdef ISDN
            s_TxFftLength_Nyquist = 128;
#else
            s_TxFftLength_Nyquist = 64;
#endif
            s_Shift = 0;
            while((s_TxFftLength_Nyquist << s_Shift) < gs_TxFftLength_Oversample)
               s_Shift++;

            s_Shift = 1 << s_Shift;
            s_TxFrameAdjustment += (s_Shift >> 1); //round
            s_TxFrameAdjustment &= ~(s_Shift - 1); //constrain the adjustment to a multiple of the non-oversampled ifft output
            /* Limit the adjustment to [0, FrameLen) range. */
            while (s_TxFrameAdjustment < 0)
            {
               s_TxFrameAdjustment += gs_TxFftLength_Oversample;
            }
            while (s_TxFrameAdjustment >= gs_TxFftLength_Oversample)
            {
               s_TxFrameAdjustment -= gs_TxFftLength_Oversample;
            }
            /* If enabled and different from 0, perform Tx frame alignment. */
//          if ((gft_TxFrameAlignEnable != FALSE) && (s_TxFrameAdjustment != 0))
            if(s_TxFrameAdjustment != 0)
            {
               /* Extend one TX frame by s_TxFrameAdjustment. This is done by */
               /* setting the cyclic prefix to the TX frame adjustment for one frame. */
               gs_TxCPLength_Oversample = s_TxFrameAdjustment;


               AddFunctionToFifo(gp_TxLoadingFunctionFifo,InsertTxCP);

               gs_TxSubState = R_QUIET3_TX_RESTORE_FRAME;
            }
            else
            {
               gs_TxSubState = R_QUIET3_TX_TRANSITION_CNT;
            }
         }
      }
#endif //#ifndef ADSL_62
      break;

   case R_QUIET3_TX_RESTORE_FRAME:
      /* Remove the cyclic prefix. */
      gs_TxCPLength = 0;
#ifdef ADSL_62
      gs_TxCPLength_Oversample = 0;
#endif //ifdef ADSL_62
      AddFunctionToFifo(gp_TxLoadingFunctionFifo,InsertTxCP);

      /* According to the standard, we can SHORTEN the frame by n samples. However, */
      /* it is safer to extend the frame length, than to shorten it. The effect of */
      /* shortening the frame is produced here by combination of frame length */
      /* extension (done in the previous frame) and increase in the symbol count */
      /* (i.e., we count the extended frame as two: one regular and one shorter */
      /* frame). */
      gl_TxSymbolCount++;

      gs_TxSubState = R_QUIET3_TX_TRANSITION_CNT;
      break;

   case R_QUIET3_TX_TRANSITION_CNT:
      if (gl_TxSymbolCount == (R_QUIET3_TX_LEN - 1))
      {
         /* Restore the cyclic prefix variable value. */
         gs_TxCPLength = gs_TxFftLength >> 4;
#ifdef ADSL_62
         gs_TxCPLength_Oversample = gs_TxFftLength_Oversample >> 4;
#endif //ADSL_62
         gs_TxNextState = R_ECT_TX;
         gpF_TxStateFunc = (PtrToFunc)REctTxF;
      }
      if (gl_TxSymbolCount > (R_QUIET3_TX_LEN - 1))
      {
         /* TX state takes too long due to TX/RX state machine misalignment. Go to the failure state. */
         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = E_CODE_STATE_MACHINE_MISALIGNMENT;
      }
      break;
   }
}
