/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb4TxF.c
 *
 *   Transceiver Training Phase TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB4
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "cmv.h"
#include "mp.h"
#include <string.h>
#include "t1413.h"
#include "TxTneSt.h"
#include "ClrTxBuf.h"
#include "RQuiet3TxF.h"
#include "RSegueTxF.h"
#include "RSegue3TxF.h"



/* =============================================== */
/* global variable declarations */
/* =============================================== */

/* =============================================== */
/* static variable declarations */
/* =============================================== */

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb4TxF
 *
 *  Description: Sends the R_Reverb signal to the ATU-C.  R_Reverb is
 *  sent on tones gs_TxFirstChannel to gs_TxLastChannel.
 *
 *  Prototype: void RReverb4TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegue() )
 *    gs_TxState        - (I) current TX state
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *    gt_StateMachCntrl - (I/O) state machine control structure
 *    gus_TxSineGain    - (O) TX sine gain
 *
 *  Notes: implements states R_REVERB4_TX
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RReverb4TxF(void) {

   if (gl_TxSymbolCount == 0) {

      /*  set up freq domain REVERB signal in gsa_TxToneBuf input buffer  */
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);


      AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT_Reordering);
      gft_IFFT_On = TRUE;

   }

   if (gl_TxSymbolCount >= R_REVERB4_TX_LEN-1) {
      gs_TxNextState = R_SEGUE3_TX;
      gpF_TxStateFunc = (PtrToFunc)RSegue3TxF;
   }
}

