/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: circor48.c
*
*   This file contains the fixed point CircularCorrelate function (in tdq_init.c).
*
*******************************************************************************/
#include "common.h"
#include "gdata.h"
#include "ieee_flt.h"
#include "int48toFloat32.h"
#include "ccloop.h"
/*****************************************************************************
;  Subroutine Name: CircularCorrelate
;
;  Description:
;
;     fixed point Circular Correlate using 16 bit input
;
;  Prototype:
;
;     Float32 CircularCorrelate(int16 *psa_Signal1, int16 *psa_Signal2, int16 s_signal1len, int16 s_signal2len, int16 s_offset)
;
;  Input Arguments:
;     int16 *psa_Signal1      - pointer to 16-bit input signal1
;     int16 *psa_Signal2      - pointer to 16-bit input signal2
;     int16 s_signal1len      - length of input signal1
;     int16 s_signal2len      - length of input signal2
;     int16 s_offset       - offset given
;
;  Output Arguments:
;     none
;
;  Return Value:
;     circular correlation output (Float32)
;
;  Global Variables Used:
;****************************************************************************/
extern int32 l_acc48H;
extern int32 l_acc48L;

Float32 CircularCorrelate(int16 *psa_Signal1, int16 *psa_Signal2, int16 s_signal1len, int16 s_signal2len, int16 s_offset)
{
   Float32 f_Accum=0;
   Float32 f_Sum;

   l_acc48L = 0;
   l_acc48H = 0;

   CircCorrLoop(psa_Signal1, psa_Signal2, s_signal1len, s_signal2len, s_offset);

   f_Sum = int48toFloat32(l_acc48H, l_acc48L);
    f_Accum = addf32(f_Accum, f_Sum);

    return f_Accum;
}

