/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
 /*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   ec_sequence_62.c
;
;  Echo Canceller (EC) training/correlation sequece for ADSL_62
;
;
;****************************************************************************/
#include "common.h"
#include "dsp_op.h"
#include "gdata.h"
#include "DSLEngin.h"
#include "compiler.h"
#include "norm_acc48.h"
#include "ec_data.h"
#include "const.h"
#include "ec_init.h"
#include "cmv.h"
#include "data_alloc.h"
#include "ifft_cutback.h"

#ifdef ADSL_62

DATA_BULKO1_BEGIN

int16 gs_CorrelateShift32 = 1; /* Correlates to 0.5 */
int16 gs_CorrelateShift_AnnexA = 1; /* Correlates to 0.5 */
int16 gs_CorrelateShift_AnnexA_Plus = 1; /* Correlates to 0.5 */
int16 gs_CorrelateShift_AnnexL_Mask1 = 1; /* Correlates to 0.5 */
int16 gs_CorrelateShift_AnnexL_Mask2 = 1; /* Correlates to 0.5 */


int16 gsa_EC_Train_Seq[EC_TRAIN_SEQ_BUF_SIZE] = {
//int16  usa_sym_taper_tail[TAIL_TAPER_LEN]  = {
                                                1, 3, 7, 12, 19, 27, 36, 47, 58, 72, 86, 101,
                                    117, 134, 151, 169, 188, 207, 227, 246, 266,
                                    285, 305, 324, 343, 361, 378, 395, 411, 426,
                                    440, 454, 465, 476, 485, 493, 500, 505, 509,
                                    511,
//};

//int16 gsa_DECTrainBuf32[64] = {
                            3843, 3161, -3928, 1938, 1557, -2504, -2999, 1075, 816, 70,
                     5446, 1093, -8447, 2367, 2629, 1145, 436, -3677, 578, -1380,
                     5593, -4239, 6019, -1041, -1148, -2499, -1311, 2995, 988, -5457,
                     1370, 4018, 2447, -198, -1301, -574, -2270, -4473, 508, 5593,
                     -4495, 3952, 776, -2516, 2082, -1928, -1275, -3039, -954, 2311,
                     4803, -345, 925, 830, -496, -2263, -4540, 5334, 938, 3325,
                     -3959, -3173, 309, -955,
//};

//int16 gsa_DECCorrBuf32[64] = {
                            8766, 8030, 6850, 8553, 9918, 2540, 2855, 1479, 3020, -144,
                     7474, 3451, 1369, 8732, 13187, 10180, 12060, 5215, 9182, 3043,
                     8937, -2256, 7260, -460, 2819, 162, 4639, 5689, 6869, -1195,
                     5146, 2687, 2316, -4087, -3766, -7063, -6430, -11240, -5376, -4760,
                     -9934, -6870, -6733, -11521, -4491, -8174, -2196, -2559, 5606, 9172,
                     16808, 12328, 16300, 12285, 11234, 3513, 347, 1023, -2459, -4917,
                     -7518, -8053, -163, -518,
//};




/* Datapath Afe and Cocomo */

// Spectrum in AnnexA US band.
//int16 gsa_DECTrainBuf_AnnexA[512] = {

//ectrain 1 - 512 (15 db low)

 4190,
  -2835,
   1500,
    803,
   1985,
   1910,
  -2354,
   2027,
  -1284,
   -397,
   -108,
  -1255,
   -808,
   1165,
  -1659,
  -1000,
    999,
  -2470,
  -1324,
    412,
  -1568,
   3690,
  -1137,
    745,
   2708,
   -103,
  -1768,
    400,
  -3683,
   -356,
   1390,
   3992,
  -1121,
   1373,
  -1314,
   2496,
     22,
   1379,
  -2943,
   1523,
  -1968,
   1776,
   1376,
  -1474,
    591,
   1432,
   1388,
    514,
  -1869,
   -188,
   -722,
  -1600,
    220,
   2574,
   3727,
  -1544,
   -792,
   3587,
    349,
    -68,
    852,
     91,
  -2544,
  -1263,
  -1389,
  -1465,
    842,
   1827,
   3521,
  -4088,
  -3746,
  -1376,
  -2130,
  -1364,
   1431,
   -378,
   -147,
  -1501,
   -678,
   1071,
   -552,
   1467,
   1215,
   3072,
   2230,
   -324,
   -821,
   -762,
   2189,
  -1380,
    575,
   1344,
   -680,
  -1679,
   2271,
  -3465,
  -3177,
    108,
   1982,
  -2037,
  -1555,
   2969,
   -923,
    988,
   3525,
     18,
    419,
   1667,
   2200,
   1780,
    680,
    660,
   -189,
    469,
   3510,
    249,
   1529,
   5493,
   -437,
   1335,
   -569,
  -3295,
   1380,
    478,
    414,
   1823,
   1096,
  -1534,
  -1333,
   2125,
   -135,
    342,
   -589,
   1037,
   -598,
   -755,
   -369,
  -4009,
   2162,
  -1070,
   1130,
    335,
   1433,
   2625,
     79,
    287,
     88,
    169,
     43,
  -2269,
  -1075,
   1887,
    838,
  -3171,
  -1882,
   1487,
    255,
   -590,
  -2111,
   -489,
    509,
  -1285,
   -101,
    826,
  -4366,
   1941,
    496,
   -911,
   2055,
   -954,
   -336,
  -1316,
   -716,
    437,
   -398,
  -1681,
    -53,
  -1734,
   2173,
   1053,
   1471,
    107,
  -1384,
  -1328,
   3713,
   3131,
    507,
    425,
  -4883,
  -2761,
    294,
   3058,
    182,
   -445,
  -1844,
   -664,
  -2646,
  -1309,
   -170,
   -594,
    -46,
   -333,
   1325,
  -3713,
    389,
   -307,
   -516,
    406,
  -2870,
     91,
    979,
   1730,
    464,
  -3073,
   -488,
   -556,
   1015,
  -2076,
   1445,
  -1311,
   2032,
   -479,
    459,
  -1394,
    301,
   1178,
    523,
  -4390,
  -1287,
  -1529,
   -124,
  -1056,
   -802,
  -1695,
  -1796,
    844,
  -3572,
    -43,
    395,
   -141,
     -6,
   2072,
   -485,
  -2519,
  -1291,
   -199,
   3790,
      0,
  -1646,
   1538,
   -463,
   3687,
  -1900,
  -1957,
   -333,
  -1758,
   -413,
    575,
   4510,
    985,
   1088,
    311,
    407,
   1759,
   2160,
    840,
  -2059,
     88,
  -3812,
   3227,
    847,
    310,
    472,
    299,
     56,
  -1600,
   2207,
    730,
    -69,
  -3236,
    479,
   2908,
    419,
  -1402,
   1947,
   -430,
  -2051,
  -1573,
    185,
   1470,
   -396,
   1426,
   1616,
  -1330,
   3045,
  -2689,
    656,
  -2557,
  -1410,
  -1405,
   -872,
   -457,
   1941,
   -349,
   1093,
   6334,
   -486,
  -2640,
  -1463,
   3075,
  -3131,
   2606,
   1687,
    510,
   5337,
  -2432,
   1690,
   -149,
  -1598,
  -1736,
    564,
   1113,
   1872,
  -3878,
   -639,
  -2502,
    413,
    524,
    819,
  -1198,
  -1619,
   -985,
   3339,
    514,
    211,
    562,
   3870,
   3131,
    -29,
   1294,
     14,
   -215,
  -2679,
  -2746,
  -1709,
  -2260,
   -612,
   -319,
  -1514,
    -23,
   3130,
   4958,
   -522,
   4279,
   2596,
   3544,
  -1277,
   -577,
    272,
    137,
   1494,
  -2307,
  -4413,
   -749,
   2094,
   1815,
    384,
    199,
  -1038,
   -808,
    395,
  -2619,
  -3871,
    812,
   2385,
  -2586,
    132,
  -1094,
  -3513,
    907,
    766,
    358,
   2309,
  -1800,
   -413,
    244,
   2210,
    176,
   1932,
  -2523,
    598,
   -248,
   3777,
   1036,
   3324,
  -2563,
    -76,
   1138,
   1067,
  -1714,
    482,
   2264,
   3094,
   2140,
  -1043,
    687,
  -1190,
  -1475,
    152,
   2497,
     -5,
   1864,
  -1397,
   1519,
  -1152,
  -4444,
   2459,
    255,
  -2422,
   1535,
   1571,
   1848,
   2869,
    225,
   1733,
  -2991,
   1232,
  -1246,
   -170,
    350,
    737,
    566,
    480,
   3328,
   1714,
   1809,
   -220,
    980,
     81,
   1842,
    382,
     60,
   4019,
  -2175,
   -452,
     48,
    308,
  -1675,
    833,
   -432,
   1828,
   1089,
    400,
  -2872,
   1672,
   2039,
   -166,
   -589,
   1376,
    599,
   -771,
   -629,
   -948,
   -343,
   1584,
  -1184,
    208,
   -517,
  -2519,
    532,
    889,
  -1649,
   -308,
   1014,
     -4,
  -2823,
   -119,
  -3082,
   3896,
   -115,
    -94,
   -772,
   -919,
  -1081,
  -2695,
  -1018,
   -755,
   2068,
  -1328,
  -3559,
   4620,
    490,
  -1720,
   1255,
  -1518,
   1186,
  -1720,
   1266,
    344,
   -308,
    876,
  -1397,
   -301,
   2944,
   -145,
   3673,
   -261,
   1917,
   3754,
   -333,
  -1998,
   -137,
   1296,
   -877,
    464,
    248,
    614,
    591,
   -728,
    627,
   -397,
   -123,
    -33,
   -388,
   -250,
    360,
   -513,
   -309,
    309,
   -764,
   -409,
    127,
   -485,
   1142,
   -352,
    230,
    838,
    -32,
   -547,
    124,
  -1139,
   -110,
    430,
   1235,
   -347,
    425,
   -406,
    772,
      7,
    427,
   -910,
    471,
   -609,
    549,
    426,
   -456,
    183,
    443,
    429,
    159,
   -578,
    -58,
   -223,
   -495,
     68,
    796,
   1153,
   -477,
   -245,
   1110,
    108,
    -21,
    263,
     28,
   -787,
   -391,
   -430,
   -453,
    261,
    565,
   1089,
  -1264,
  -1159,
   -426,
   -659,
   -422,
    443,
   -117,
    -46,
   -464,
   -210,
    331,
   -171,
    454,
    376,
    950,
    690,
   -100,
   -254,
   -236,
    677,
   -427,
    178,
    416,
   -210,
   -519,
    703,
  -1072,
   -983,
     33,
    613,
   -630,
   -481,
    918,
   -286,
    306,
   1090,
      6,
    130,
    516,
    681,
    551,
    210,
    204,
    -58,
    145,
   1086,
     77,
    473,
   1699,
   -135,
    413,
   -176,
  -1019,
    427,
    148,
    128,
    564,
    339,
   -474,
   -412,
    657,
    -42,
    106,
   -182,
    321,
   -185,
   -234,
   -114,
  -1240,
    669,
   -331,
    350,
    104,
    443,
    812,
     24,
     89,
     27,
     52,
     13,
   -702,
   -333,
    584,
    259,
   -981,
   -582,
    460,
     79,
   -183,
   -653,
   -151,
    158,
   -398,
    -31,
    256,
  -1351,
    600,
    153,
   -282,
    636,
   -295,
   -104,
   -407,
   -222,
    135,
   -123,
   -520,
    -16,
   -536,
    672,
    326,
    455,
     33,
   -428,
   -411,
   1148,
    969,
    157,
    131,
  -1510,
   -854,
     91,
    946,
     56,
   -138,
   -570,
   -205,
   -818,
   -405,
    -53,
   -184,
    -14,
   -103,
    410,
  -1148,
    120,
    -95,
   -160,
    126,
   -888,
     28,
    303,
    535,
    144,
   -951,
   -151,
   -172,
    314,
   -642,
    447,
   -406,
    628,
   -148,
    142,
   -431,
     93,
    365,
    162,
  -1358,
   -398,
   -473,
    -38,
   -327,
   -248,
   -524,
   -556,
    261,
  -1105,
    -13,
    122,
    -43,
     -2,
    641,
   -150,
   -779,
   -399,
    -61,
   1172,
      0,
   -509,
    476,
   -143,
   1140,
   -588,
   -605,
   -103,
   -544,
   -128,
    178,
   1395,
    305,
    337,
     96,
    126,
    544,
    668,
    260,
   -637,
     27,
  -1179,
    998,
    262,
     96,
    146,
     92,
     17,
   -495,
    683,
    226,
    -21,
  -1001,
    148,
    899,
    130,
   -434,
    602,
   -133,
   -634,
   -487,
     57,
    455,
   -123,
    441,
    500,
   -411,
    942,
   -832,
    203,
   -791,
   -436,
   -435,
   -270,
   -141,
    600,
   -108,
    338,
   1959,
   -150,
   -816,
   -453,
    951,
   -969,
    806,
    522,
    158,
   1651,
   -752,
    523,
    -46,
   -494,
   -537,
    174,
    344,
    579,
  -1200,
   -198,
   -774,
    128,
    162,
    253,
   -370,
   -501,
   -305,
   1033,
    159,
     65,
    174,
   1197,
    968,
     -9,
    400,
      4,
    -67,
   -829,
   -849,
   -529,
   -699,
   -189,
    -99,
   -468,
     -7,
    968,
   1534,
   -161,
   1324,
    803,
   1096,
   -395,
   -178,
     84,
     42,
    462,
   -714,
  -1365,
   -232,
    648,
    561,
    119,
     61,
   -321,
   -250,
    122,
   -810,
  -1197,
    251,
    738,
   -800,
     41,
   -338,
  -1086,
    281,
    237,
    111,
    714,
   -557,
   -128,
     75,
    683,
     54,
    598,
   -780,
    185,
    -77,
   1168,
    320,
   1028,
   -793,
    -23,
    352,
    330,
   -530,
    149,
    700,
    957,
    662,
   -323,
    213,
   -368,
   -456,
     47,
    772,
     -2,
    577,
   -432,
    470,
   -356,
  -1375,
    761,
     79,
   -749,
    475,
    486,
    572,
    888,
     70,
    536,
   -925,
    381,
   -385,
    -53,
    108,
    228,
    175,
    148,
   1029,
    530,
    560,
    -68,
    303,
     25,
    570,
    118,
     19,
   1243,
   -673,
   -140,
     15,
     95,
   -518,
    258,
   -134,
    565,
    337,
    124,
   -888,
    517,
    631,
    -51,
   -182,
    425,
    185,
   -238,
   -194,
   -293,
   -106,
    490,
   -366,
     64,
   -160,
   -779,
    165,
    275,
   -510,
    -95,
    314,
     -1,
   -873,
    -37,
   -953,
   1205,
    -36,
    -29,
   -239,
   -284,
   -335,
   -834,
   -315,
   -233,
    640,
   -411,
  -1101,
   1429,
    151,
   -532,
    388,
   -470,
    367,
   -532,
    392,
    106,
    -95,
    271,
   -432,
    -93,
    911,
    -45,
   1136,
    -81,
    593,
   1161,
   -103,
   -618,
    -42,


//int16 gsa_DECTrainBuf_AnnexA_Plus[1024] = {
//dectrain(1:512)plus (-15db)
    2848,
     54,
  -1780,
  -1711,
  -1601,
   1661,
   -691,
   -136,
   1335,
   1075,
    823,
    -59,
  -1054,
    -51,
   -729,
   1062,
   -262,
  -1038,
   2073,
    165,
   -494,
    119,
   -392,
    625,
  -1963,
   -588,
    648,
   -916,
  -1290,
   -297,
    780,
    791,
   1025,
  -2091,
  -1142,
  -1457,
  -1577,
   1589,
  -1618,
   1287,
  -1666,
   1542,
   -364,
   2490,
    587,
   1160,
    355,
  -2735,
   2648,
    866,
   1246,
   1232,
   -997,
    229,
  -1159,
  -1151,
  -1283,
   -247,
    -22,
    417,
  -1477,
   2209,
   -654,
   -196,
     92,
   -300,
    226,
   3656,
   -980,
    393,
   -866,
  -1752,
    328,
    -54,
   -115,
   -595,
  -1300,
  -1019,
    962,
   -366,
   -744,
  -1450,
   1131,
    -49,
    159,
   -283,
    236,
  -1698,
  -1088,
    544,
   -962,
   -126,
   2588,
    101,
  -1516,
   1316,
   -728,
    -16,
   1533,
   -455,
   -866,
  -1027,
    278,
   -684,
   -234,
    117,
   1652,
    411,
   3395,
    638,
   -276,
    421,
   -909,
   2073,
    861,
   1213,
   1622,
   -468,
  -1544,
   -329,
   2155,
  -1576,
  -1813,
   1507,
   -289,
  -1791,
   -648,
  -1642,
  -2394,
   -565,
    175,
   -108,
  -1055,
     84,
    479,
   1154,
   2852,
  -1332,
  -5018,
    157,
   -886,
  -1382,
    886,
    382,
    -12,
  -1121,
    855,
   -733,
    711,
    836,
    691,
   -813,
   -261,
  -1112,
   1845,
    984,
  -1180,
   2490,
   1342,
    -27,
  -1052,
   -464,
    173,
    650,
    362,
    733,
   -250,
    835,
    242,
   -608,
   -315,
    282,
   -730,
   -568,
  -2722,
  -1485,
   1320,
  -1724,
    491,
    335,
   2569,
     92,
   2043,
   1064,
   -267,
   -718,
   1534,
  -2064,
    682,
    188,
  -1440,
    578,
  -2152,
   2420,
   -745,
    551,
   1264,
  -1394,
  -1280,
  -2372,
   -598,
    390,
    708,
    806,
     57,
    277,
   1000,
     50,
    834,
    329,
   -203,
  -1592,
   -561,
    871,
   -314,
  -1825,
    646,
   -714,
    334,
   1716,
    775,
    346,
   2117,
    422,
  -1972,
   1717,
  -1255,
    800,
   2014,
  -1685,
   1038,
     45,
    182,
    314,
  -2588,
   2874,
    531,
    409,
   -196,
    756,
   -314,
  -1109,
   -591,
  -1287,
   1049,
    536,
   -848,
    508,
    599,
    102,
     11,
  -1159,
   1278,
    557,
   -518,
  -1089,
   -793,
    739,
   -339,
   1361,
    317,
    327,
   -803,
   -666,
    682,
   1340,
   -515,
  -1793,
     43,
  -1944,
   -983,
   -607,
   -776,
   -340,
  -1675,
    298,
   1487,
   1924,
    713,
  -3045,
    220,
  -2181,
   -815,
   -829,
   1677,
   1259,
    815,
   -653,
   -876,
   -175,
   -307,
    256,
   -567,
   -174,
  -1412,
    912,
  -1417,
   -650,
    166,
  -1829,
    -64,
   1236,
     91,
    958,
   2032,
  -1293,
    630,
  -1802,
    432,
   1588,
   -195,
    508,
     32,
   -797,
   1012,
    119,
  -2955,
    -92,
   2904,
   -879,
   -106,
    -99,
   2801,
  -1632,
   1410,
    847,
    709,
  -2175,
  -1617,
    345,
    924,
   1144,
   -438,
  -1788,
  -1088,
    195,
   2522,
   -480,
  -2587,
  -1435,
    471,
    612,
    201,
    578,
  -2457,
    450,
   -360,
    -65,
    117,
  -2824,
   1563,
    -57,
   -370,
   1392,
   -152,
    913,
   1321,
    723,
   -151,
   2261,
   1649,
    -10,
   -707,
   -650,
  -2631,
  -2752,
   -594,
   -222,
   1301,
   1300,
   1901,
   1850,
   1802,
  -1016,
  -1042,
   1640,
  -2240,
  -3102,
  -1737,
    924,
    280,
    518,
   -765,
    701,
    270,
   -876,
  -1574,
    888,
   -688,
  -1543,
   1661,
    -62,
   -866,
   -299,
   -906,
   2441,
   -292,
   2733,
    610,
   -136,
   -600,
   2918,
   2519,
    780,
   -776,
  -1120,
   -251,
    302,
    679,
    970,
    489,
    809,
  -2889,
   1363,
   2850,
    194,
    965,
   1021,
   -788,
    522,
    503,
    682,
  -1930,
    102,
   -380,
   -197,
  -3176,
  -1356,
    361,
  -1529,
    -71,
    968,
   1214,
    -15,
  -1635,
   1773,
   -873,
    769,
    676,
    265,
   -304,
    858,
   1429,
  -1785,
    116,
    645,
    -18,
  -2125,
   -323,
   -184,
   -879,
    432,
  -3003,
  -1872,
  -1354,
  -2468,
    -56,
   1400,
   -683,
    882,
  -1054,
   1127,
    539,
  -1942,
   1080,
  -1566,
  -1655,
   -904,
  -1825,
   -198,
   -105,
   -284,
  -1077,
  -1355,
  -1381,
  -1546,
   2385,
    445,
    657,
   -394,
    820,
   -436,
    743,
    389,
  -1636,
    752,
   -596,
    -72,
   1313,
  -2604,
   -969,
   1070,
    275,
  -1149,
   1155,
   -909,
   2227,
    630,
    997,
    269,
    237,
   -237,
   2013,
    489,
  -1940,
     79,
   1008,
  -1403,
    283,
   2821,
   -965,
   -305,
    800,
   -507,
  -2563,
    218,
   2197,
   1349,
  -1754,
    124,
   -204,
   1529,
    290,
   -112,
    940,
   -355,
    314,
    992,
  -1362,
  -1444,
   2278,
   -770,
   1430,
    480,
   -235,
    349,
  -2062,
  -2303,
   -697,
   2855,
   -555,
   1126,
   -539,
   2108,
   -547,
    -93,
  -1392,
    950,
  -2719,
   2092,
  -2046,
   2832,
    199,
  -1313,
   1600,
   1040,
    851,
  -2178,
   -687,
     -7,
    490,
   -323,
   1280,
    784,
    498,
  -2587,
  -1065,
   -658,
    614,
  -1119,
   1525,
   -756,
    900,
    790,
   -146,
   -140,
   1846,
    477,
    697,
   -173,
   -305,
    936,
   -921,
   1790,
   1210,
   -285,
  -2703,
    994,
   2090,
  -1430,
   -490,
  -1820,
   -786,
    317,
  -1890,
  -1259,
   -221,
   -411,
   1085,
  -2031,
   -182,
   2053,
    830,
    381,
   1564,
    604,
   -519,
  -1554,
  -1107,
  -1429,
   3096,
    259,
    865,
  -1399,
  -1990,
  -3209,
   1222,
  -3742,
   2077,
   -459,
      5,
   -883,
  -2870,
   1241,
   -553,
    351,
  -2108,
   2179,
   -369,
   -655,
  -1337,
   -468,
  -1579,
    673,
   -854,
   -574,
  -2192,
  -1113,
    210,
    270,
   -785,
   1767,
   1893,
   2257,
    -71,
  -1544,
  -2241,
    649,
  -2616,
  -1978,
    214,
   -464,
  -1209,
   -137,
   -154,
   -402,
   2773,
    -67,
  -1007,
   1049,
   1369,
   -584,
   -572,
   1965,
    484,
   -755,
   1198,
   -847,
   1554,
  -2321,
   -402,
    220,
   1185,
    805,
   1766,
    994,
  -1259,
   1458,
   1869,
  -1037,
   1400,
   -612,
    211,
  -3789,
  -1690,
    779,
    177,
  -1891,
   -852,
   -255,
  -1773,
    253,
    845,
    685,
  -2068,
    -69,
  -2026,
    258,
   -975,
   1884,
   -228,
   1029,
   2204,
   -843,
    472,
    235,
    614,
   1986,
    578,
    987,
   2987,
   -924,
   -831,
    494,
   -528,
   -315,
  -2241,
   -374,
   -335,
   -241,
  -2073,
   2753,
  -1923,
  -3833,
   -878,
  -2261,
  -1306,
   1159,
   1315,
    682,
   3285,
   -395,
    278,
   1038,
    625,
  -1280,
    530,
   2085,
  -1568,
    162,
   -343,
   1131,
  -1664,
    388,
   1037,
  -1000,
   -258,
    531,
    579,
  -1486,
  -1053,
  -2614,
    269,
   1873,
   -168,
  -1486,
   -725,
    588,
   1191,
    259,
  -1340,
    611,
   1015,
   1091,
   -529,
   1006,
  -1545,
    410,
   -565,
   -845,
    654,
   -112,
   -203,
   3283,
     60,
   1803,
   -200,
    361,
  -1782,
    503,
    169,
   -622,
    353,
    293,
   -122,
   3489,
   1035,
   -394,
   -672,
   3277,
   -367,
   2189,
    900,
    -89,
   -200,
   2376,
   1407,
     77,
   -435,
  -1609,
   1456,
    549,
    -14,
    728,
   -106,
   2277,
   1142,
    119,
   1518,
   2454,
    857,
   -524,
    873,
    530,
  -1442,
    208,
   2199,
    521,
   1781,
   -399,
   -909,
    475,
   1097,
   1511,
  -1422,
   -358,
   2416,
    616,
   1224,
  -3440,
  -2631,
    -89,
  -1818,
   -170,
    464,
  -2935,
   1268,
   -441,
    610,
   -132,
    143,
    114,
   -186,
   1923,
  -1716,
    508,
   -816,
   1124,
   1587,
   1984,
     -7,
   -508,
     83,
   1491,
  -1632,
   -570,
   1977,
    781,
   1029,
   1227,
    201,
    190,
    842,
   1577,
   -378,
    940,
   2008,
  -1010,
    252,
   -242,
   -848,
   -145,
    372,
    573,
    -38,
   -690,
    453,
   -214,
   1535,
   -493,
  -1132,
  -1707,
   -248,
    970,
  -1314,
   1887,
    -18,
  -1848,
   1452,
   -182,
      6,
    337,
   2060,
   -786,
  -1225,
  -1291,
   1557,
   2216,
    265,
   -406,
   -962,
   1308,
   1197,
    685,
     49,
    320,
  -1217,
   -344,
   -856,
   2706,
    528,
   -519,
     14,
   -644,
  -1815,
   -895,
    748,
   1815,
   -790,
    490,
     -2,
   -157,
   -978,
  -1352,
    830,
   -257,
  -1268,
  -1467,
    604,
    294,
   -870,
    -83,
   -995,
   1440,
     16,
   -473,
    542,
   -119,
    537,
  -1629,
   3000,
    153,
   -968,
     69,
   -608,
   1030,
    614,
   -293,
    753,
   -424,
  -2296,
    627,
    272,
    537,
    323,
   1132,
      4,
    553,
  -1771,
    173,
   -713,
   1956,
   -458,
   1466,
    302,
   -462,
   -642,
  -1670,
  -2881,
     34,
     38,
    347,
  -1906,
   -238,
  -1547,
    561,
   -193,
   -799,
   -105,
  -1322,
   -777,
   2832,
    -25,
    548,
  -2532,
   -179,
   1523,
   -381,
  -1873,
   1634,
   -294,
   1787,
  -1319,
  -1547,
    590,
  -1468,
   1248,
    704,
   -699,
   1570,
   1047,
   -256,
  -1973,
   -525,
  -1177,
   2233,
   -833,
   -265,
   -171,
    717,
   3204,
    504,
    391,
   -516,
   -156,
   2928,
   1872,
   1643,
  -1641,
   1211,
    520,
   -478,
    556,
    810,
   1055,
    153,
   -409,
   -405,
   -353,
    662,
    -64,
     93,
    576,
    476,
    414,
    117,
   -179,
    120,
    -77,
    472,
     71,
   -192,
    810,
    188,
     -2,
    174,
     30,
    334,
   -467,
    -50,
    359,
   -154,
   -254,
     42,
    401,
    386,
    478,
   -525,
   -207,
   -325,
   -345,
    639,
   -358,
    543,
   -373,
    624,
     39,
    924,
    340,
    503,
    267,
   -729,
    992,
    410,
    548,
    526,
   -161,
    209,
   -213,
   -228,
   -252,
     58,
    147,
    268,
   -313,
    835,
    -53,
     74,
    183,
     41,
    226,
   1293,
   -156,
    261,
   -120,
   -418,
    258,
    119,
    118,
    -52,
   -257,
   -186,
    458,
     20,
    -81,
   -323,
    512,
    121,
    204,
     47,
    229,
   -401,
   -190,
    308,
   -150,
     96,
    973,
    168,
   -326,
    553,
    -76,
    131,
    639,
     -8,
   -120,
   -189,
    242,
    -80,
     80,
    173,
    677,
    266,
   1228,
    338,
     67,
    269,
   -133,
    792,
    427,
    520,
    667,
    -12,
   -334,
     32,
    836,
   -362,
   -419,
    613,
     63,
   -431,
    -51,
   -383,
   -603,
    -43,
    209,
    102,
   -180,
    163,
    306,
    501,
   1056,
   -285,
  -1434,
    186,
   -126,
   -301,
    435,
    257,
    150,
   -219,
    425,
    -96,
    379,
    401,
    373,
   -121,
     71,
   -216,
    738,
    448,
   -219,
    924,
    579,
    128,
   -179,
    -10,
    209,
    342,
    269,
    368,
     75,
    400,
    231,
    -56,
     54,
    225,
    -77,
    -43,
   -707,
   -334,
    572,
   -409,
    309,
    242,
    967,
    165,
    800,
    473,
     70,
    -91,
    639,
   -517,
    370,
    196,
   -301,
    319,
   -527,
    902,
    -81,
    311,
    554,
   -305,
   -251,
   -614,
    -35,
    260,
    378,
    391,
    172,
    224,
    471,
    152,
    418,
    240,
     90,
   -367,
    -23,
    412,
     55,
   -441,
    358,
    -90,
    260,
    679,
    399,
    246,
    824,
    270,
   -470,
    680,
   -243,
    389,
    791,
   -397,
    482,
    150,
    212,
    235,
   -665,
   1046,
    322,
    265,
     92,
    375,
     55,
   -215,
    -33,
   -271,
    486,
    306,
   -114,
    297,
    344,
    168,
    158,
   -230,
    558,
    312,
    -10,
   -208,
    -97,
    370,
     47,
    567,
    254,
    240,
   -100,
    -75,
    370,
    560,
     -9,
   -431,
    168,
   -479,
   -157,
    -56,
    -91,
     29,
   -376,
    231,
    625,
    745,
    380,
   -827,
    224,
   -554,
   -104,
   -126,
    685,
    535,
    412,
    -71,
   -123,
     81,
     57,
    217,
    -25,
     81,
   -293,
    425,
   -294,
    -70,
    207,
   -442,
    134,
    527,
    183,
    439,
    797,
   -273,
    353,
   -434,
    291,
    639,
     92,
    297,
    164,
   -116,
    474,
    174,
   -781,
    107,
   1073,
   -142,
    121,
    105,
   1040,
   -380,
    600,
    404,
    378,
   -552,
   -358,
    245,
    447,
    498,
     15,
   -430,
   -190,
    198,
    952,
    -16,
   -664,
   -318,
    303,
    330,
    218,
    319,
   -623,
    279,
     40,
    116,
    191,
   -757,
    648,
    118,
     37,
    577,
    106,
    425,
    572,
    365,
    106,
    851,
    676,
    133,
    -70,
    -70,
   -678,
   -734,
    -34,
     66,
    566,
    547,
    756,
    722,
    724,
   -185,
   -175,
    655,
   -555,
   -845,
   -395,
    429,
    243,
    300,
    -88,
    358,
    240,
   -141,
   -344,
    417,
    -64,
   -352,
    679,
    117,
   -120,
     41,
   -132,
    908,
     62,
   1001,
    347,
     93,
    -36,
   1059,
    951,
    383,
    -92,
   -218,
     75,
    232,
    369,
    443,
    309,
    392,
   -760,
    567,
   1056,
    198,
    459,
    459,
    -95,
    301,
    313,
    352,
   -457,
    168,
     34,
     74,
   -851,
   -293,
    268,
   -348,
    132,
    442,
    538,
    132,
   -363,
    697,
   -122,
    380,
    368,
    220,
     58,
    408,
    606,
   -429,
    191,
    340,
    148,
   -536,
     52,
     78,
   -124,
    273,
   -796,
   -456,
   -274,
   -645,
    136,
    579,
    -62,
    415,
   -179,
    493,
    325,
   -478,
    496,
   -359,
   -370,
   -150,
   -423,
     73,
    121,
     46,
   -187,
   -293,
   -283,
   -353,
    909,
    277,
    362,
     12,
    414,
     -2,
    389,
    259,
   -363,
    374,
    -34,
    114,
    569,
   -688,
   -153,
    475,
    241,
   -227,
    519,
   -151,
    859,
    336,
    470,
    221,
    229,
     61,
    791,
    291,
   -460,
    161,
    473,
   -308,
    244,
   1029,
   -151,
     40,
    407,
    -24,
   -657,
    205,
    849,
    563,
   -401,
    175,
     89,
    620,
    246,
    101,
    451,
     24,
    254,
    450,
   -277,
   -321,
    875,
   -107,
    607,
    288,
     80,
    247,
   -498,
   -592,
    -66,
   1040,
    -22,
    493,
    -16,
    803,
    -19,
    107,
   -286,
    437,
   -706,
    798,
   -493,
   1032,
    217,
   -279,
    660,
    465,
    423,
   -553,
    -63,
    134,
    309,
     34,
    559,
    384,
    312,
   -682,
   -183,
    -72,
    348,
   -218,
    637,
   -103,
    439,
    386,
    108,
     92,
    738,
    287,
    375,
     81,
     58,
    432,
   -137,
    702,
    537,
     46,
   -701,
    451,
    815,
   -316,
     -1,
   -440,
    -95,
    236,
   -444,
   -262,
     84,
      6,
    497,
   -506,
     96,
    786,
    417,
    257,
    649,
    327,
    -10,
   -356,
   -196,
   -316,
   1134,
    218,
    428,
   -306,
   -476,
   -879,
    541,
  -1048,
    811,
     -9,
    156,
   -143,
   -754,
    529,
    -21,
    247,
   -513,
    826,
     37,
    -71,
   -269,
    -12,
   -345,
    349,
   -116,
    -45,
   -539,
   -216,
    221,
    222,
    -94,
    695,
    753,
    850,
    132,
   -352,
   -555,
    341,
   -674,
   -490,
    222,
    -11,
   -228,
     93,
    105,
      9,
   1031,
    115,
   -165,
    468,
    587,
    -48,
    -27,
    758,
    307,
   -103,
    533,
   -132,
    646,
   -598,
     27,
    206,
    529,
    391,
    713,
    451,
   -244,
    598,
    746,
   -192,
    597,
    -57,
    221,
  -1063,
   -381,
    383,
    210,
   -462,
   -115,
     55,
   -407,
    216,
    421,
    353,
   -500,
    114,
   -487,
    218,
   -154,
    732,
     82,
    462,
    851,
   -131,
    304,
    210,
    349,
    765,
    337,
    448,
   1099,
   -156,
   -109,
    293,
    -13,
     36,
   -555,
     18,
     48,
     60,
   -502,
   1007,
   -454,
  -1077,
   -124,
   -579,
   -259,
    503,
    570,
    352,
   1193,
     11,
    242,
    465,
    352,
   -269,
    322,
    796,
   -342,
    187,
     46,
    494,
   -372,
    259,
    482,
   -180,
     72,
    304,
    337,
   -334,
   -179,
   -691,
    239,
    729,
    101,
   -334,
    -75,
    322,
    531,
    218,
   -270,
    330,
    475,
    482,
    -13,
    454,
   -335,
    266,
    -25,
   -131,
    361,
    101,
     90,
   1175,
    173,
    707,
     91,
    250,
   -410,
    295,
    207,
    -60,
    266,
    229,
    115,
   1240,
    481,
     12,
    -59,
   1173,
     38,
    829,
    439,
    108,
     91,
    888,
    599,
    161,
     16,
   -373,
    615,
    310,
    150,
    367,
    121,
    857,
    515,
    174,
    634,
    913,
    425,
    -30,
    430,
    304,
   -302,
    202,
    850,
    301,
    718,
     10,
   -134,
    286,
    501,
    614,
   -296,
     23,
    918,
    331,
    541,
   -952,
   -678,
    108,
   -421,
     82,
    301,
   -792,
    555,
     -3,
    347,
     95,
    199,
    172,
     95,
    745,
   -389,
    297,
   -104,
    492,
    656,
    764,
    152,
    -25,
    180,
    608,
   -362,
    -44,
    780,
    383,
    480,
    524,
    218,
    196,
    420,
    635,
     35,
    434,
    789,
   -183,
    234,
     60,
   -114,
     90,
    272,
    318,
    142,
    -82,
    297,
     68,
    640,
    -20,
   -204,
   -404,
     76,
    443,
   -262,
    733,
    148,
   -449,
    614,
     79,
    156,
    243,
    806,
   -112,
   -233,
   -272,
    647,
    837,
    238,
      8,
   -150,
    550,
    533,
    353,
    170,
    237,
   -231,
     27,
   -117,
    992,
    321,
    -28,
    159,
    -67,
   -420,
   -147,
    391,
    710,
    -96,
    291,
    154,
     87,
   -155,
   -292,
    417,
     55,
   -247,
   -328,
    345,
    229,
   -121,
    110,
   -161,
    592,
    159,
    -13,
    326,
     99,
    324,
   -379,
   1103,
    185,
   -152,
    158,
    -38,
    462,
    348,
     43,
    392,
      2,
   -572,
    335,
    240,
    306,
    256,
    494,
    155,
    311,
   -406,
    191,
    -72,
    755,
      9,
    600,
    250,
    -10,
    -49,
   -392,
   -757,
    147,
    166,
    246,
   -449,
     61,
   -335,
    314,
     93,
   -117,
    121,
   -282,
    -92,
   1032,
    146,
    309,
   -647,
     79,
    636,
     16,
   -438,
    653,
     61,
    701,
   -263,
   -353,
    341,
   -328,
    549,
    359,
    -67,
    633,
    486,
     55,
   -470,
    -30,
   -218,
    843,
   -109,
     52,
    100,
    363,
   1168,
    296,
    278,
    -27,
    105,
   1063,
    747,
    656,
   -365,
    519,
    319,
    -15,
    330,
    392,

//};

};// gsa_EC_Train_Seq
DATA_MAP_END

#endif
