/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   fdq_init.c
;
;  Routine to perform frequency-domain equalization (FDQ) initialization.
;
;****************************************************************************/

#include "common.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rx_ops.h"
#include "bufmisc.h"
#include "fdq_init.h"
#include "cmv.h"
#include "pll.h"

/*****************************************************************************
;  Subroutine Name: FDQTrain(void)
;
;  Description:
;     This routine uses the accumulated frequency domain frames and
;     calls a subroutine to calculate the FDQ coefficients.
;
;  Prototype:
;     void FDQTrain(void);
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;     gsa_RxRepFDQTrainBuf - received representative frame from FFT output
;                          (this array of data is lost in this program)
;     gsa_pre_FDQ_coef[RX_NUM_TONES*2] (O) -- FDQ coefficient matissas stored in the order of:
;           {Wr[0], Wi[0], Wr[1], Wi[1], ..., Wr[2*RX_NUM_TONES-2], Wi[2*RX_NUM_TONES-1]}
;     gsa_pre_FDQ_exp[RX_NUM_TONES] (O) -- FDQ coefficient exponent stored in the order of
;           {Ws[0], Ws[1], ..., Ws[RX_NUM_TONES-1]
;     gsa_CReverbRefTones[]   -- C Reverb reference tones
;
;****************************************************************************/
C_SCOPE void FDQTrain(void)
{
   /* ========================================================================================= */
   /* Compute FDQ coefficients */
   /* ========================================================================================= */
   FDQcoef(gsa_RxRepFDQTrainBuf, gsa_CReverbRefTones);

   guc_FdqTrainingState = TRAINING_DONE;

   return;
}

/*****************************************************************************
;  Subroutine Name: FDQcoef(int16 *psa_in_tones, int16 *psa_ref_tones)
;
;  Description:
;     This routine calls FDQcoefPerTone() to calculate the coefficients of
;     FDQ_coef[i] for i from gs_RxFirstChannel to gs_RxLastChannel.
;
;  Prototype:
;     void FDQcoef(int16 *psa_in_tones, int16 *psa_ref_tones);
;
;  Input Arguments:
;     psa_in_tones - pointer to received representative DMT tones
;     psa_ref_tones -- pointer to reference DMT tones
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;     gsa_pre_FDQ_coef[RX_NUM_TONES*2] (O) -- FDQ coefficient matissas stored in the order of:
;           {Wr[0], Wi[0], Wr[1], Wi[1], ..., Wr[2*RX_NUM_TONES-2], Wi[2*RX_NUM_TONES-1]}
;     gsa_pre_FDQ_exp[RX_NUM_TONES] (O) -- FDQ coefficient exponent stored in the order of
;           {Ws[0], Ws[1], ..., Ws[RX_NUM_TONES-1]
;
;****************************************************************************/

C_SCOPE void FDQcoef(int16 *psa_in_tones, int16 *psa_ref_tones)
{

   int16 i, i2;

   /* ================================================================================ */
   /* Start the loop to compute each FDQ coefficient as psa_ref_tones[i]/psa_in_tones[i] */
   /* and represent the result in al_mant[i] * 2**as_exp[i] */
   /* Warning: gs_RxFirstChannel must be greater than 0 */
   /* ================================================================================ */
   for(i = gs_RxFirstChannel; i<= gs_RxLastChannel; i++) {

      /* If DD Pilot is active, do not train fdq on the pilot tone      */
      /* Note: During the first FDQ train ie before turning on DD Pilot */
      /* FDQ will indeed be trained on the pilot tone                */
      if (gft_DDPilot == DD_PILOT_ON && (i == gs_AuxPilotToneIdx || i == gs_CPilotTone))
         continue;

      i2= i*2;

      /* If the given tone has the zero energy, set the FDQ for set channel to the maximum) */
      if((psa_in_tones[i2] == 0) && (psa_in_tones[i2+1] == 0)) {
         guca_pre_FDQ_exp[i]=FDQ_EXPONENT_MAX;
         gsa_pre_FDQ_coef[i2] = FDQ_MANTISSA_MAX;
         gsa_pre_FDQ_coef[i2+1] = 0;
      }
      else /* Compute the current FDQ coefficient = (ref_tone)/(in_tone)   */
      {
         FDQcoefPerTone(&(psa_in_tones[i2]), &(psa_ref_tones[i2]), &(gsa_pre_FDQ_coef[i2]), &guca_pre_FDQ_exp[i]);
      }
   }

   /* Zero out the FDQ coefficients for unused tones */
   for(i=0; i < gs_RxFirstChannel; i++) {
      i2 = i*2;
      guca_pre_FDQ_exp[i]=0;
      gsa_pre_FDQ_coef[i2] = 0;
      gsa_pre_FDQ_coef[i2+1] = 0;
   }

   for(i= gs_RxLastChannel+1; i < gs_RxNumTones; i++) {
      i2 = i*2;
      guca_pre_FDQ_exp[i]=0;
      gsa_pre_FDQ_coef[i2] = 0;
      gsa_pre_FDQ_coef[i2+1] = 0;
   }
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to scale FDQ accumulation
 *
 *  Prototype: void BgAvgFDQAccumulation(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void BgAvgFDQAccumulation(void)
{
   /* shift to average of the accumulated frames */
   RightShiftAndRound32to16(gsa_RxRepFDQTrainBuf, 0, gla_RxAccumBuf, 0,
               (int16)(2*gs_RxNumTones), gs_log2_num_fdq_training_symbols);

   guc_FdqTrainingState = TRAINING_DONE;

}
