/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: fpconv48.c
*
*   This file contains the fixed point circular convolution (used in tdq_init.c).
*
*******************************************************************************/

#include "common.h"
#include "ieee_flt.h"
#include "gdata.h"
#include "round_acc48.h"
#include "dsp_op.h"
#include "ccloop.h"

/*******************************************************************************
*
*   Prototype: Float32 FixedPointConvolve48(int16 *psa_input, int16 *psa_filter, Float32 *faz_buf,
*                 Float32 f_MaxCoeff, int16 s_CPLen, int16 s_filterlen, int16 s_round)
*
*   Description:
*       Fixed point convolve using 48-bit math and rms power calculation.
*
*   Arguments:
*       int16 *psa_input   - pointer to 16-bit input data array
*     int16 *psa_filter - pointer to 16-bit filter array
*     Float32 f_MaxCoeff   - maximum filter coefficient
*     int16 s_CPLen     - length of cyclic prefix (CP)
*     int16 s_filterlen - length of filter
*     int16 s_round     - bits to shift during multiply-accumulate state to
*                    prevent overflow
*  Output Arguments:
*     Float32 *faz_buf  - convolution result (Float32)
*
*   Return Value:
*     rms power (Float32)
*
*   Global Variables:
*
*******************************************************************************/

extern int32 l_acc48H;
extern int32 l_acc48L;

Float32 FixedPointConvolve48(int16 *psa_input, int16 *psa_filter, Float32 *faz_buf,
                  Float32 f_MaxCoeff, int16 s_CPLen, int16 s_filterlen, int16 s_round) {

   int16 i, Index, s_MaxCoeffValue=1;
   int32 l_accpow, l_tmpmpy, l_tmp32;
   Float32 l_rmspow;

   s_MaxCoeffValue <<= s_round;

   Index = s_CPLen - s_filterlen;
   if(Index < 0){
      Index += gs_RxSamplesPerFrame;
   }

   l_accpow = 0;
   for(i=0; i<gs_RxSamplesPerFrame; i++){
      Index++;
      if(Index >= gs_RxSamplesPerFrame){
         Index -= gs_RxSamplesPerFrame;
      }

      l_acc48L = 0;
      l_acc48H = 0;

      CircCorrLoop(psa_filter, psa_input, s_filterlen, gs_RxSamplesPerFrame, Index);

      l_tmp32 = round_acc48(l_acc48H, l_acc48L, s_round);
      faz_buf[i] = int32toFloat32(l_tmp32);
      faz_buf[i] = mpyf32(faz_buf[i], f_MaxCoeff);

      l_tmp32 = round(l_tmp32, s_round);
      l_tmpmpy = (int32)l_tmp32 * (int32)l_tmp32;
      l_accpow = l_add(l_accpow, l_tmpmpy);

   }

   l_rmspow = int32toFloat32(l_accpow);
   l_rmspow = divf32(l_rmspow, int2f32(gs_RxSamplesPerFrame));
   l_rmspow = sqrtf32(l_rmspow);
   l_rmspow = mpyf32(l_rmspow, int2f32(s_MaxCoeffValue));
   l_rmspow = mpyf32(l_rmspow, f_MaxCoeff);

   return l_rmspow;

}
