/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   frm_sync.c
 *
 *   Description:   Routines used in obtaining frame (symbol)
 *   synchronization with the received ATU-R.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "fifo.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : FrameAlign
 *
 *  Description:
 *    Frame Alignment: gus_SyncOffset is always positive therefore we move
 *       buffer pointers forward for frame alignment.
 *
 *  Prototype:  void FrameAlign(void)
 *
 *
 *  Input Arguments: None
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *    gus_SyncOffset    - Amount to move the synch point
 *    gus_AlignmentOffset - total number of samples to move forward
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void FrameAlign(void)
{

   gs_AlignmentOffset = gus_SyncOffset;

   /* If decimator is used to run TDQ at 1104 */
   if ((STATArray[STAT_Misc] & STAT_TDQ_at_1104) && (gs_RxFftLength != 256))
      gs_AlignmentOffset <<= 1;

   /* ================================================================= */
   /* Perform Frame realignment by adjusting buffer pointer */
   /* ================================================================= */
   AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignmentForward);

}

