/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   frm_sync_b.c
*
*   Functions for BG Tasks from frm_sync.c
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// frm_sync_b.c
//
// History
//
// 10/08/2010  Nihar: Implemented the TDQ extrapolation to a generalized model
//             that will attempt to detect if the CO is sending OOB reverb energy
//             Grep for IOP_DS_DMT_ALL_GeneralizedTDQExtrapolation
//
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//          1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//          After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//          Then CPE will select the first option from the C-RatesRA.
//          2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//       incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//       Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//       frame sync and TDQ calculation incorrect.
//       The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//       zero response for the reference tones.
//          3. Change near-end vendor ID to "AWARE" to improve US rate.
//          4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//       so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//          Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement.
//
// ******************************************************************
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "dsp_op.h"
#include "fft_bg.h"
#include "ifft_fix.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "dsp_op2.h"
#include "gdata_bis_diag.h"
#include "trail.h"
#include "tssi_rx.h"
#include "bitload_const.h"
#include "pll.h"
#include "fdq_init.h"
#include "fdq_adj.h"
#include "fdq_adap.h"
#include "rcmedley_Data.h"
#include "platform.h"
#include "snr.h"
#include "hndshk_Data.h"
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
#include "gpersistent.h"
#include "const.h"
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)

#define UNITY_FDQ_MANTISSA (0x1 << (FDQ_MANTISSA_FRAC_BITS - 1))
#define UNITY_FDQ_EXPONENT 1

extern void DoFDExtrap(int16* sa_h_in);
C_SCOPE void smooth_pilot(int16 *psa_CapturedReverbFrame, int16 tone_idx)
{
    int32 l_Acc0, l_Acc1;
    int16 i, j, *ps_tmp, s_Magnitude[3];
    int16 s_exp_num, s_exp_den, s_mant_scale, s_exp_scale;

    ps_tmp = (int16*) (psa_CapturedReverbFrame + 2*(tone_idx - 1));
    for(i=0; i<3; i++) {
        for(j=0, l_Acc1=0; j<2; j++) {
            l_Acc0 = (int32)(*ps_tmp)*(*ps_tmp);
            l_Acc1 += l_Acc0 ;
            ps_tmp++;
        }
        s_Magnitude[i] = sqrt32(l_Acc1);
    }
    // Average magnitude of -1, +1
    l_Acc0 = ((int32)s_Magnitude[0] + (int32)s_Magnitude[2]) >>1;

    // Normalize for division
    s_exp_num = -norm_l(l_Acc0) ;
    l_Acc0 <<= -s_exp_num ;
    s_exp_den = -norm_16bit(s_Magnitude[1]) ;
    s_Magnitude[1] <<= -s_exp_den ;
    Divide_32by16bit(   l_Acc0,        s_exp_num,
    s_Magnitude[1], s_exp_den,
    &s_mant_scale,   &s_exp_scale) ;

    // Apply scale to channel estimate of this tone
    ps_tmp = (int16*) (psa_CapturedReverbFrame + 2*tone_idx );
    for (i=0; i<2 ; i++) {
        l_Acc0 =  (int32)(*ps_tmp)*s_mant_scale ;
        l_Acc0 >>= -s_exp_scale ;
        *ps_tmp++ = sature16(l_Acc0) ;
    }
}


/*^^^
*------------------------------------------------------------------------
*
*  Name: FindUnityTdqExp
*
*  Description:
*
*  Prototype: void FindUnityTdqExp(int16 *psa_CapturedReverbFrame)
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*     gs_PGA_required_RxOnly (I)
*     gs_PGA_required (I)
*     gs_UnityTDQExp (O)
*
*------------------------------------------------------------------------
*^^^
*/
C_SCOPE void FindUnityTdqExp(int16 *psa_CapturedReverbFrame)
{
    int32 i;
    int16 s_DigitalGain, s_DigitalGainFD;

    /* Find maximum frequency domain absolute value. */
    s_DigitalGainFD = 1;
    for (i = gs_RxSamplesPerFrame-1; i >= 0; i--)
    {
        s_DigitalGain = abs_s(psa_CapturedReverbFrame[i]);
        if (i == 0)
        {
            s_DigitalGain >>= 2;
            /* For debug purposes, calculate the ratio of DC value contribution to the */
            /* contribution from all other tones. */
            gs_UnityTDQScalingDCRatio = 2*(ConvertToDB((int32)s_DigitalGain) - ConvertToDB((int32)s_DigitalGainFD));
        }
        if (s_DigitalGainFD < s_DigitalGain)
        s_DigitalGainFD = s_DigitalGain;
    }
    /* Calculate possible digital gain such that max frequency value equals TDQ_SCALE_FACTOR. */
    s_DigitalGainFD = 2*(ConvertToDB((int32)TDQ_SCALE_FACTOR) - ConvertToDB((int32)s_DigitalGainFD));
    /* Store this value for debug purposes. */
    gs_UnityTDQScalingFD = s_DigitalGainFD;

    /* Calculate and limit possible digital gain based on RMS criterion assuming 30dB */
    /* echo attenuation by DEC. At this point we use results of PGA calculation since */
    /* it is based on the same RMS based formula as the TDQ gain calculation. */
    s_DigitalGain = gs_PGA_required_RxOnly - gs_PGA_required;
    if (s_DigitalGain > 0x1E00)
    s_DigitalGain = 0x1E00;
    /* Store this value for debug purposes. */
    gs_UnityTDQScalingRMS = s_DigitalGain;

    /* Select the minimum of the digital gains calculated using the above two methods. */
    if (s_DigitalGain > s_DigitalGainFD)
    s_DigitalGain = s_DigitalGainFD;

    /* For Geminax CO use 3dB digital gain cutback to avoid FFT clipping (the same as */
    /* will be done for other TDQs later in medley). */
    if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)
    s_DigitalGain -= 0x0300;

    /* Increase the TDQ exponent until digital gain is in [0,6.02) dB range. */
    while ((s_DigitalGain >= 0x605) && (gs_UnityTDQExp > LOWERBOUND_TDQEXP))
    {
        s_DigitalGain -= 0x605;
        gs_UnityTDQExp--;
    }
}

/*^^^
*------------------------------------------------------------------------
*
*  Name: EstimateChannel
*
*  Prototype: void EstimateChannel(int16 *)
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*
*  Description: Estimate Rx channel/impulse response.  This estimate includes
*  the effect of the entire analog and digital Rx path.
*  Input to this function is an averaged Rx Reverb signal.  This routine removes
*  the effect of any DS tssi from this Rx Reverb.
*
*  Note that for ADSL2 this function is called twice.  The variable gft_ADSL2_doingHlinEstimate,
*  set external to this function, is used to indicate whether it is the first or second call.
*  See below for details.  For DMT, there is only one call and the value of gft_ADSL2_doingHlinEstimate
*  is ignored. (The only obstacle to using the same approach for DMT is a time constraint: there may
*  not be enough time in the RCReverb2 state to perform two accumulations.)
*
*  Update (11/19/07): This function is called twice also in DMT. Accumulation takes 64 frames.
*  --------------------
*  1st call: (gft_ADSL2_doingHlinEstimate == 0).  Output is time-domain impulse response.
*
*  The first time is to calculate the impulse
*  response for the actual AFE/Strymon settings.  This impulse response is used for
*  frame alignment and TDQ calculation.
*
*  2nd call: (gft_ADSL2_doingHlinEstimate == 1).  Output is complex frequency domain response.
*
*  The second call is made to calculate HLINds.
*  The input Rx Reverb data for this calculation is captured using reference AFE/Strymon
*  settings which may be different from the trained AFE/Strymon settings.  By using the
*  same reference AFE/Strymon settings for HLINds we simplify the task of Rx filter compensation.
*  --------------------
*------------------------------------------------------------------------
*^^^
*/

C_SCOPE void EstimateChannel(int16 *psa_CapturedReverbFrame)
{
    // The complex multiply and the IFFT are both done in place.
    // Required size of psa_CapturedReverbFrame is [RX_FFT_LENGTH + FFT_IMPLEMENTATION_OVERHEAD] words.
    // Required size of psa_ChannelImpulseResponse is [RX_FFT_LENGTH + FFT_IMPLEMENTATION_OVERHEAD] words.

    int32 l_Acc0, l_Acc1, l_MaxMag;
    int16 i, j, sa_XReal, sa_XImag, s_temp1, s_temp2;
    int16 s_RightShift, *s_ptr;
    int16 sa_UnityFDQCoef[2];
    //   FILE* hFile;

    int16  s_Sign, s_Denom, s_Denom_exp, s_Num_exp, s_result, s_result_exp, result;
    int32  l_Num;
    // IOP_DS_DMT_ALL_GeneralizedTDQExtrapolation (Start)
#ifndef ISDN   // Only for Anx-A
    int16 sa_OriginalReverbTones[36];
    int16 s_NumExtrapTones, s_StartExtrapTone;
    int16 s_RefFirstTone;
    int32 l_MaxReverbCorr;
    int32 l_ReverbCorr;
#endif // ifndef ISDN
    // IOP_DS_DMT_ALL_GeneralizedTDQExtrapolation (End)

    /* Set flag gft_ChanRespBeyondNyquist if CPE's FFT is oversampled */
    if(gs_RxSamplesPerFrame >= (4*gs_RxNumTones))
    gft_ChanRespBeyondNyquist = TRUE;

#ifndef FD_ACCUM_FOR_FRAMEALIGN
    /*  convert to representative frame to freq. domain */
    BgFftReal(psa_CapturedReverbFrame, psa_CapturedReverbFrame, (int16)(gs_RxSamplesPerFrame>>1), (int16)(gs_Log2RxSamplesPerFrame-1));
#endif
    // Note: At this point psa_CapturedReverbFrame (= gsa_RxRepFrameAlignBuf) holds the averaged, unequalized, freq domain
    //   Rx Reverb signal.


    if ((!gft_ADSL2_doingHlinEstimate))
    // Don't do this stuff when calculating Hlog.  Only done when calculating impulse response for
    // actual AFE/Strymon configuration.
    {
        for (i = 0; i < gs_RxSamplesPerFrame; i++)
        {
           DebugTrail(1, DEBUG_LOG_REVERBSIGNAL, gsa_RxRepFrameAlignBuf[i]);
        }
        // XDSLRTFW-3974 Wrong Hlog reporting with DPBO in ADSL
        // Make a backup of first measurement
        memcpy(&gsa_ChannelEstimateBkp[0], gsa_RxRepFrameAlignBuf, sizeof(int16)*(2*gs_RxNumTones));

        /* Calculate unity TDQ exponent using frequency and time domain data. */
        FindUnityTdqExp(psa_CapturedReverbFrame);

        /* ==================================================================================== */
        /*  Compute FDQ now since we have accumulated frequency domain signal ready          */
        /* ==================================================================================== */
        // because of FFT_IMPLEMENTATION_OVERHEAD(=2), the first 2 words of gsa_RxRepFDQTrainBuf
        // store saved copyof channel estimate and we should be careful not to overwrite it.
        // Hence we do not copy the frequency domain signal for first 2*gs_RxFirstChannel words into
        // gsa_RxRepFDQTrainBuf since these are not required anyways
        for (i = 2*gs_RxFirstChannel; i < 2*(gs_RxLastChannel+1); i++)
        {
            /* Upshift by the unity TDQ exponent that will be loaded along with re-trained FDQs. */
            gsa_RxRepFDQTrainBuf[i] = gsa_RxRepFrameAlignBuf[i] << (14 - gs_UnityTDQExp);
        }
        FDQTrain();

        /* If DD pilot is on, FDQ training is not performed for pilot and aux pilot tones. Update */
        /* pilot and aux pilot FDQs manually with the unity TDQ exponent. */
        if (gft_DDPilot == DD_PILOT_ON)
        {
            sa_UnityFDQCoef[0] = UNITY_FDQ_MANTISSA;
            sa_UnityFDQCoef[1] = 0;

            FdqUpdate(&gsa_pre_FDQ_coef[(gs_CPilotTone<<1)], &guca_pre_FDQ_exp[gs_CPilotTone],
            sa_UnityFDQCoef, UNITY_FDQ_EXPONENT - (14 - gs_UnityTDQExp));
            if (gs_AuxPilotToneIdx != gs_CPilotTone)
            {
                FdqUpdate(&gsa_pre_FDQ_coef[(gs_AuxPilotToneIdx<<1)], &guca_pre_FDQ_exp[gs_AuxPilotToneIdx],
                sa_UnityFDQCoef, UNITY_FDQ_EXPONENT - (14 - gs_UnityTDQExp));
            }
        }
    }

    /* ==================================================================================== */
    /*  Complex multiply psa_CapturedReverbFrame and conjugate of C_Reverb reference tones  */
    /*  This loop is done in-place.                                                         */
    /* ==================================================================================== */

    // Do a "dry run" to get the largest magnitude of a real or imag component.  Don't save results.

    l_MaxMag = 0;
    for (i = 0; i < gs_RxNumTones; i++) {
        /*  real part */
        sa_XReal = psa_CapturedReverbFrame[2*i];
        sa_XImag = psa_CapturedReverbFrame[2*i + 1];

        l_Acc0 = (int32)gsa_CReverbRefTones[2*i]     * sa_XReal;
        l_Acc1 = (int32)gsa_CReverbRefTones[2*i + 1] * sa_XImag;
        l_Acc0 = l_Acc0 + l_Acc1;
        if (l_Acc0 > l_MaxMag)
        l_MaxMag = l_Acc0;
        else if (-l_Acc0 > l_MaxMag)
        l_MaxMag = -l_Acc0;

        /*  imaginary part */
        l_Acc0 = (int32)gsa_CReverbRefTones[2*i]     * sa_XImag;
        l_Acc1 = (int32)gsa_CReverbRefTones[2*i + 1] * sa_XReal;
        l_Acc0 = l_Acc0 - l_Acc1;

        if (l_Acc0 > l_MaxMag)
        l_MaxMag = l_Acc0;
        else if (-l_Acc0 > l_MaxMag)
        l_MaxMag = -l_Acc0;
    }

    // Find power of 2 scale factor that will scale the largest magnitude to the desired magnitude.
    // Here we choose 0x800 as the desired magnitude.  This might not be optimal.

    s_RightShift = 0;

    while (l_MaxMag > 0x800){
        s_RightShift++;
        l_MaxMag >>= 1;
    }



    for (i = 0; i < gs_RxNumTones; i++) {
        /*  real part */
        sa_XReal = psa_CapturedReverbFrame[2*i];
        sa_XImag = psa_CapturedReverbFrame[2*i + 1];

        l_Acc0 = (int32)gsa_CReverbRefTones[2*i]     * sa_XReal;
        l_Acc1 = (int32)gsa_CReverbRefTones[2*i + 1] * sa_XImag;
        l_Acc0 = l_Acc0 + l_Acc1;
        l_Acc0 = round(l_Acc0,s_RightShift);
        psa_CapturedReverbFrame[2*i] = sature16(l_Acc0);

        /*  imaginary part */
        l_Acc0 = (int32)gsa_CReverbRefTones[2*i]     * sa_XImag;
        l_Acc1 = (int32)gsa_CReverbRefTones[2*i + 1] * sa_XReal;
        l_Acc0 = l_Acc0 - l_Acc1;
        l_Acc0 = round(l_Acc0,s_RightShift);
        psa_CapturedReverbFrame[2*i + 1] = sature16(l_Acc0);
    }


    /* Get the channel frequency-domain response beyond Nyquist frequency */
    if(gft_ChanRespBeyondNyquist == TRUE)
    {
        s_temp1 = 2*gs_RxNumTones;

        for (i = (gs_RxNumTones+1); i < s_temp1;  i++)
        {
            /*  real part */
            sa_XReal = psa_CapturedReverbFrame[2*i];
            sa_XImag = psa_CapturedReverbFrame[2*i + 1];

            l_Acc0 = (int32)gsa_CReverbRefTones[2*(s_temp1-i)] * sa_XReal;
            l_Acc1 = (int32)gsa_CReverbRefTones[2*(s_temp1-i) + 1] * sa_XImag;
            l_Acc0 = l_Acc0 - l_Acc1;
            l_Acc0 = round(l_Acc0,s_RightShift);
            psa_CapturedReverbFrame[2*i] = sature16(l_Acc0);

            /*  imaginary part */
            l_Acc0 = (int32)gsa_CReverbRefTones[2*(s_temp1-i)] * sa_XImag;
            l_Acc1 = (int32)gsa_CReverbRefTones[2*(s_temp1-i) + 1] * sa_XReal;
            l_Acc0 = l_Acc0 + l_Acc1;
            l_Acc0 = round(l_Acc0,s_RightShift);
            psa_CapturedReverbFrame[2*i + 1] = sature16(l_Acc0);
        }
    }

    // Store s_RightShift for use in channel response computation for Hlin test parameter.
    if ((gft_ADSL2_doingHlinEstimate))
    gus_Hlin_scale = (uint16) s_RightShift - 13;  //DEC_QPSK_GAIN=0x2000 (Q3.13)

    if (( gl_SelectedMode & (MODE_ADSL2)  )) /* BIS or Plus mode */
    {
        uint16 usa_DS_Tssi_Value[RX_NUM_TONES];

        // Convert Log Tssi values to Linear format on stack (to be used during channel extimate computation)
        DefineLinearTssiSet(usa_DS_Tssi_Value, gusa_DS_Tssi_Value, gs_RxNumTones);
        if (gft_ADSL2_doingHlinEstimate)
        // i.e., do this on the second pass through EstimateChannel().  It's not related to
        // HLINds calculation, but it must be done only once.
        {
            // Now, adjust Log Tssi to max(ceiled_log_tssi_CL_msg, ceiled_log_tssi_DS_mask)
            // for use while meeting NOMATP constraint through bitload & bitswaps
            if (gs_tssiMaskCeil==1)
            {
                int16 s_DsPcb, s_DsMaskCeilLogTssi;

                // DS power cutback (dB)
                s_DsPcb = (gt_RCMsgPcb_bis.us_C_MIN_PCB_DS > gt_RMsgPcb_bis.us_R_MIN_PCB_DS) ?
                gt_RCMsgPcb_bis.us_C_MIN_PCB_DS: gt_RMsgPcb_bis.us_R_MIN_PCB_DS;

                for(i=0, j=0; i < gs_RxNumTones; i++)
                {
                    if (i == gsa_DsMaskCeilLogTssiBrkptIndx[j])
                    j++;

                    // Compute ceiled log tssi corresponding to DS mask for tone index i
                    s_DsMaskCeilLogTssi = gsa_DsMaskCeilLogTssiBrkptVal[j-1];
                    s_DsMaskCeilLogTssi += (int16)(((int32)(gsa_DsMaskCeilLogTssiBrkptVal[j] - gsa_DsMaskCeilLogTssiBrkptVal[j-1])*(i - gsa_DsMaskCeilLogTssiBrkptIndx[j-1])) / (gsa_DsMaskCeilLogTssiBrkptIndx[j] - gsa_DsMaskCeilLogTssiBrkptIndx[j-1]));
                    // Adjust DS Mask tssi for DS PCB
                    if (IS_TONEFLAGSET(p_SUPPORTEDset_DS, i))
                    {
                        s_DsMaskCeilLogTssi -= (s_DsPcb<<9);
                        if (s_DsMaskCeilLogTssi < 0)
                        s_DsMaskCeilLogTssi = 0;
                    }

                    if (s_DsMaskCeilLogTssi > gusa_DS_Tssi_Value[i])
                    gusa_DS_Tssi_Value[i] = s_DsMaskCeilLogTssi;
                }
            }
            // Convert Log Tssi values to Linear format in global array (to be used during gain allocation in bitloading)
            DefineLinearTssiSet(gusa_DS_Tssi_Value, gusa_DS_Tssi_Value, gs_RxNumTones);
        }
        // Account for DS spectral shaping (tssi)

        s_ptr = psa_CapturedReverbFrame;

        // Do "dry run" to find largest product magnitude.
        l_MaxMag = 0;

        for (i=0; i<2*gs_RxNumTones; i++, s_ptr++) {
            l_Acc0 = (int32) (*s_ptr) * ((int16)(int32) 32768/usa_DS_Tssi_Value[i>>1]);
            if (l_Acc0 > l_MaxMag)
            l_MaxMag = l_Acc0;
            else if (-l_Acc0 > l_MaxMag)
            l_MaxMag = -l_Acc0;
        }

        // Find power of 2 scale factor that will scale the largest magnitude to the desired magnitude.
        // Here we choose 0x800 as the desired magnitude.  This might not be optimal.

        s_RightShift = 0;
        while (l_MaxMag > 0x800){
            s_RightShift++;
            l_MaxMag >>= 1;
        }

        // Store s_RightShift for use in channel response computation for Hlin test parameter.
        if (gft_ADSL2_doingHlinEstimate)                                      // HLog calculation, but it must be done only once.
        gus_Hlin_scale += (uint16) s_RightShift - 5;  //TSSI in (Q11.5)

        // Scale by inverse tssi values.
        s_ptr = psa_CapturedReverbFrame;
        for (i=0; i<2*gs_RxNumTones; i++, s_ptr++) {
            s_Denom = usa_DS_Tssi_Value[i>>1];
            s_Denom_exp = norm_16bit(s_Denom);
            l_Num = (*s_ptr)<<(15-s_RightShift);
            s_Sign = 1;
            if (l_Num < 0)
            {
                l_Num = -l_Num;
                s_Sign = -1;
            }
            s_Num_exp = norm_l(l_Num);

            result = Divide_32by16bit(l_Num<<s_Num_exp, (int16)(-s_Num_exp),
            (int16)(s_Denom<<s_Denom_exp), (int16)(-s_Denom_exp),
            &s_result, &s_result_exp);

            if (s_Sign == -1)
            s_result = -s_result;

            *s_ptr = round((int32)s_result, -s_result_exp);

        }

        // Scale by inverse tssi values for tones beyond Nyquist frequency.
        if(gft_ChanRespBeyondNyquist == TRUE)
        {
            s_ptr = &psa_CapturedReverbFrame[2*(gs_RxNumTones+1)];
            s_temp2 = 4*gs_RxNumTones+1;
            for (i=2*(gs_RxNumTones+1); i<4*gs_RxNumTones; i++, s_ptr++)
            {
                *s_ptr = (int16)(((int32) (*s_ptr) * (int16)(int32)32768/usa_DS_Tssi_Value[(s_temp2-i)>>1]) >> s_RightShift);
            }
        }
    }
    else /* DMT mode */
    {
        // Mode is g.992.1 or g.992.2.  No spectral shaping is done.
        // Zero tones < gs_RxFirstChannel)
        memset(psa_CapturedReverbFrame, 0, sizeof(int16)*2*gs_RxFirstChannel);
        // Zero tones >= (gs_RxLastChannel+1))
        memset(psa_CapturedReverbFrame+ 2*(gs_RxLastChannel+1), 0, sizeof(int16)*2*(gs_RxNumTones-1-gs_RxLastChannel));


        if(gft_ChanRespBeyondNyquist == TRUE)
        {
            // Zero tones >=(2*gs_RxNumTones - gs_RxFirstChannel+1)
            memset(psa_CapturedReverbFrame + 2*(2*gs_RxNumTones - gs_RxFirstChannel+1), 0, sizeof(int16)*2*(gs_RxFirstChannel-1));
            // Zero tones between gs_RxNumTones and (2*gs_RxNumTones - gs_RxLastChannel)(exclusive)
            memset(psa_CapturedReverbFrame+ 2*(gs_RxNumTones+1), 0, sizeof(int16)*2*(gs_RxNumTones-1-gs_RxLastChannel));
        }

    }

    if ((!gft_ADSL2_doingHlinEstimate))
    {
        if(gft_ChanRespBeyondNyquist == TRUE)
        {  /* Estimate the phase at Nyquist Frequency */
            psa_CapturedReverbFrame[2*gs_RxNumTones]   = ((psa_CapturedReverbFrame[2*(gs_RxNumTones-1)]+1)>>1) + ((psa_CapturedReverbFrame[2*(gs_RxNumTones+1)]+1)>>1);
            psa_CapturedReverbFrame[2*gs_RxNumTones+1] = ((psa_CapturedReverbFrame[2*(gs_RxNumTones-1)+1]+1)>>1) + ((psa_CapturedReverbFrame[2*(gs_RxNumTones+1)+1]+1)>>1);
            /* Normalize the magnitude of channel response at Nyquist Frequency */
            smooth_pilot(psa_CapturedReverbFrame, gs_RxNumTones) ;
        }


        // Normalize magnitude of channel freq. response at pilot tone, as average of adjacent magnitudes.
        // Any discontinuity in the freq response could lead to a null in the TDQ at that frequency, so be
        // extra sure that freq response is smooth at pilot tone.
        smooth_pilot(psa_CapturedReverbFrame, gs_PilotToneIdx) ;

        // At this point psa_CapturedReverbFrame (= gsa_RxRepFrameAlignBuf) holds the estimated complex
        // channel reponse (freq domain).
        // IOP_DS_DMT_ALL_GeneralizedTDQExtrapolation (Start)
#ifndef ISDN   // only for Anx-A
        if ((gft_extrap) && (!(gl_SelectedMode & MODE_ADSL2)))
        {
            s_NumExtrapTones = 18;
            s_RefFirstTone = 33;
            //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
            //Shift the indices of the reference tones.
#ifndef ISDN   // Only for Annex-A
            if (gft_NVLTC_T1413_fix == TRUE)
               s_RefFirstTone += FDEXTRP_OFFSET;
#endif
            //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
            s_StartExtrapTone = s_RefFirstTone - s_NumExtrapTones;
            j = s_StartExtrapTone * 2;

            // Save the received contents of the tones in the extrapolation band
            // from the accumulated reverb signal
            for (i = 0; i < (s_NumExtrapTones * 2); i++)
            sa_OriginalReverbTones[i] = gsa_RxRepFrameAlignBuf[i + j];

            // Do the extrapolation
            DoFDExtrap(gsa_RxRepFrameAlignBuf);

            l_MaxReverbCorr = 0;
            l_ReverbCorr = 0;
            for (i = 0; i < (s_NumExtrapTones * 2); i++)
            {
                // Compute the correlation between the original recevied signal and the extrapolated
                // signal
                l_ReverbCorr +=
                sa_OriginalReverbTones[i] * gsa_RxRepFrameAlignBuf[i + j];

                // Compute the highest possible result for the above correlation (for comparison)
                l_MaxReverbCorr +=
                ((sa_OriginalReverbTones[i] * sa_OriginalReverbTones[i]) +
                (gsa_RxRepFrameAlignBuf[i + j] *
                gsa_RxRepFrameAlignBuf[i + j])) >> 1;
            }
            // If the correlation result is within 24dB of the maximum, put the original
            // received signal back into our accumulated reverb signal
            //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
            //The extrapolation result should be always taken for frame sync and TDQ calculation for better performance.
            //if (l_ReverbCorr > (l_MaxReverbCorr >> 4))
            //{
            //   for (i = 0; i < (s_NumExtrapTones * 2); i++)
            //      gsa_RxRepFrameAlignBuf[i + j] = sa_OriginalReverbTones[i];
            //}
            //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
        }
#endif // ifndef ISDN
        // IOP_DS_DMT_ALL_GeneralizedTDQExtrapolation (End)
        //  hFile = fopen("channel_estimate_result.dat", "w");
        for (i = 0; i < gs_RxSamplesPerFrame; i++)
        {
            DebugTrail(1, DEBUG_LOG_CHANNELESTIMATE, gsa_RxRepFrameAlignBuf[i]);
            //    fprintf(hFile, "%d\n", gsa_RxRepFrameAlignBuf[i]);
        }
    }

    //   fclose(hFile);

#ifdef DEBUG_CHANNEL
    //overwrite the estimated channel impulse response with the known BIS version
    hFile = fopen("channel_estimate_bis.dat", "r");
    for (i = 0; i < gs_RxSamplesPerFrame; i++)
    {
        fscanf(hFile, "%d\n", &gsa_RxRepFrameAlignBuf[i]);
    }
    fclose(hFile);


    hFile = fopen("channel_estimate_result.dat", "w");
    for (i = 0; i < gs_RxSamplesPerFrame; i++)
    {
        DebugTrail(1, DEBUG_LOG_CHANNELESTIMATE, gsa_RxRepFrameAlignBuf[i]);
        fprintf(hFile, "%d\n", gsa_RxRepFrameAlignBuf[i]);
    }
    fclose(hFile);
#endif

    // Zero out high frequency component in non-lite mode to avoid noise enhancement
    if((gft_ChanRespBeyondNyquist == TRUE) && (gs_RxNumTones >= 256))
    {
        memset(&(psa_CapturedReverbFrame[2*(2*gs_RxNumTones-gs_RxFirstChannel+1)]), 0, sizeof(int16)*(2*(gs_RxFirstChannel-1)));
    }


    /* ==================================================================== */
    /* Do IFFT to get crosscorrelation s_cxy */
    /* ==================================================================== */
    if ((!gft_ADSL2_doingHlinEstimate))
    IfftReal(psa_CapturedReverbFrame, psa_CapturedReverbFrame, (int16)(gs_RxSamplesPerFrame>>1), (int16)(gs_Log2RxSamplesPerFrame-1));
}


/*^^^
*------------------------------------------------------------------------
*
*  Name : RxFrameSync
*
*  Description:    Determines the offset necessary to achieve frame
*  (symbol) synchronization with the signal received from the ATU-C.
*  In this function, two frame synchronization algorithms are used.
*
*  First Method:
*  First a crosscorrelation, sa_cyx, is computed between the received
*  representative frame and the reference signal (C_Reverb).  Next the
*  power of sa_cyx in a sliding window of length (Cyclic Prefix + 1) is
*  calculated for each sample. The symbol boundary, first sample of
*  received frame, is defined as the location of the first sample
*  in the window with the maximum power.  In this manner the
*  maximum energy of the channel response will be located within the
*  cyclic prefix.  This offset is stored in the output location pointed
*  by ps_maxindx.
*
*  Second Method:
*
*  As in the first method, a crosscorrelation, sa_cyx, is computed.
*  Then, the location of the maximum x-correlation value, indx0, and
*  s_maxcorr = sa_cyx[indx0] are found. Furthermore, the limited number
*  of sample locations before (left side of) indx0 is searched.
*  The symbol boundary, first sample of received frame, is defined as
*  k, such that sa_cyx[k-1] < threshold*s_maxcor in the first time.
*
*  Prototype:
*     void RxFrameSync(int16 *psa_X, uint16 *ps_maxindx, uint16 *ps_maxindx2)
*
*  Input Arguments:
*      psa_X[RX_FFT_LENGTH+2]  --   frequency domain samples of
*                                  representative received frame
*
*  Output Arguments:
*      ps_maxindx          -- pointer to offset to from current frame boundary to new
*                          frame boundary; (Max correlation method used)
*                          0 <= *ps_maxindx <= (RX_FFT_LENTGH - 1)
*      ps_maxindx2            -- pointer to offset to from current frame boundary to new
*                          frame boundary; (Max energy method used)
*                          0 <= *ps_maxindx <= (RX_FFT_LENTGH - 1)
*  Return:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

C_SCOPE void RxFrameSync(int16 *psa_X, uint16 *ps_maxindx, uint16 *ps_maxindx2)
{
    int16 *sa_cyx = psa_X;

    int32 l_Acc0;
    int16 i, indx;
    int16 s_CPlen;

    int32 l_maxcorr;
    int16 s_maxcorr;
    int16 indx0 = 0;
    int16 indx_final;

    int32 l_WindowPower, l_MaxWindowPower;
    uint16 us_MaxPowerIndex;

    s_CPlen = gs_RxSamplesPerFrame >> 4;

    /* ==================================================================== */
    /* ********** MAX_CORR_METHOD **********/
    /* ==================================================================== */

    /* ==================================================================== */
    /* Find the maximum x-correlation point */
    /* ==================================================================== */

    s_maxcorr = 0;
    for(i=0; i<gs_RxSamplesPerFrame; i++) {
        if(abs(sa_cyx[i]) > s_maxcorr) {
            s_maxcorr = abs(sa_cyx[i]);
            indx0 = i;
        }
    }

    /* ==================================================================== */
    /* Search the synchronization point, k, such that  */
    /* sa_cyx[(k-1)%2*gs_RxNumTones] < threshold*s_maxcorr */
    /* ==================================================================== */

    l_maxcorr = (int32)s_maxcorr*gs_CXY_Threshold;
    s_maxcorr = (int16)(l_maxcorr >> gs_CXY_Threshold_Rsh);

    indx_final = indx0;
    if(s_maxcorr > 0) {
        for(i=s_CPlen;i>=3;i--) {
            indx = indx0-i;
            if(indx < 0)
            indx += gs_RxSamplesPerFrame;
            if(abs(sa_cyx[indx]) < s_maxcorr)
            indx_final = indx;
            else
            break;
        }
    }

    *ps_maxindx = (uint16) indx_final;


    /* ==================================================================== */
    /* ********** MAX_ENERGY_METHOD **********/
    /* ==================================================================== */

    /* ==================================================================== */
    /* Find the max power in any of the (Cyclic Prefix + 1) length windows of s_cxy */
    /* l_window[n] = sum(sa_cyx[i]*sa_cyx[i]), i = n, n+1, ..., n + Cyclic Prefix */
    /* ==================================================================== */

    l_WindowPower = 0;

    /*  get power in first window (from 0 to cyclic prefix) */

    for (i = 0; i <= s_CPlen; i++) {
        l_Acc0 = (int32)sa_cyx[i] * sa_cyx[i];
        l_Acc0 >>= 2;         /* prevent overflow */
        l_WindowPower += l_Acc0;
    }

    l_MaxWindowPower = l_WindowPower;
    us_MaxPowerIndex = 0;

    /*  Compare power in all other windows */
    for (i = 1; i < gs_RxSamplesPerFrame; i++) {

        /*  subtract the left most term */
        l_Acc0 = (int32)sa_cyx[i-1] * sa_cyx[i-1];
        l_Acc0 >>= 2;
        l_WindowPower -= l_Acc0;

        /*  add the new term */
        indx = (i+s_CPlen) % gs_RxSamplesPerFrame;
        l_Acc0 = (int32)sa_cyx[indx] * sa_cyx[indx];
        l_Acc0 >>= 2;

        l_WindowPower += l_Acc0;
        if (l_WindowPower > l_MaxWindowPower-(l_MaxWindowPower>>gs_MaxEnergyRsh)) {
            l_MaxWindowPower = l_WindowPower;
            us_MaxPowerIndex = i;
        }
    }
    *ps_maxindx2 = (uint16) us_MaxPowerIndex;
}

/*^^^
*------------------------------------------------------------------------
*
*  Description: Background function to perform second stage of
*
*  frame alignment, i.e., cross correlation and alignment offset.
*
*  Prototype: void BgAlignmentTraining(void)
*
*  Input Arguments: none
*
*  Output Arguments: none
*
*  Return: none
*
*------------------------------------------------------------------------
*^^^
*/

C_SCOPE void BgAlignmentTraining(void)
{
    int16 i, s_syncoffset_corr, s_syncoffset_win;
    int16 s_HalfCPLen;

    gft_ADSL2_doingHlinEstimate = FALSE;  // For ADSL2, controls behavior of EstimateChannel().
    /*  estimate the channel impulse response */
    EstimateChannel(gsa_RxRepFrameAlignBuf);

    /*  find alignment offset */
    RxFrameSync(gsa_RxRepFrameAlignBuf, &gus_SyncOffset_Corr_Method, &gus_SyncOffset);

    /* Adjust the value of gus_SyncOffset_Corr_Method such that */
    /* (gus_SyncOffset_Corr_Method - gus_SyncOffset) < gs_tdqlen/2  */

    s_syncoffset_corr = gus_SyncOffset_Corr_Method;
    s_syncoffset_win = gus_SyncOffset;

    if((s_syncoffset_win > 3*(gs_RxFftLength >>2))
            && (s_syncoffset_corr < (gs_RxFftLength >>2)))
    {
        s_syncoffset_corr = s_syncoffset_corr + gs_RxFftLength;
    }

    gs_SyncOffsetDelta = s_syncoffset_corr - s_syncoffset_win;
    s_HalfCPLen = gs_RxCPLength>>1;

    // If the delta between these two sync points is too large, it indicates a problem.  We have
    // seen the accuracy of the max_window_energy sync point be affected by a noisy channel estimate
    // (e.g. for short Anx A loops with ANFP tssi).
    // To protect against this we assume that the peak_energy sync point is less affected by noise,
    // and we force the max_window_energy sync point to be within CPLen/2 of the peak_energy sync
    // point.

    if (gs_SyncOffsetDelta > s_HalfCPLen)
    {
        s_syncoffset_win = s_syncoffset_corr - s_HalfCPLen;
        gus_SyncOffset = s_syncoffset_win;
    }

    if(s_syncoffset_corr > s_syncoffset_win + (gs_TDQLen>>1))
    {
        s_syncoffset_corr = s_syncoffset_win + (gs_TDQLen>>1);
    }

    if(s_syncoffset_corr > gs_RxFftLength)
    s_syncoffset_corr = s_syncoffset_corr - gs_RxFftLength;

    gus_SyncOffset_Corr_Method = s_syncoffset_corr;

    // Store impulse response in array to be later used for TDQ calculation.
    memcpy(gsa_MultiTdqRxSignal, &gsa_RxRepFrameAlignBuf[gus_SyncOffset_Corr_Method], sizeof(int16)*(gs_RxSamplesPerFrame - gus_SyncOffset_Corr_Method));
    memcpy(&gsa_MultiTdqRxSignal[gs_RxSamplesPerFrame - gus_SyncOffset_Corr_Method], gsa_RxRepFrameAlignBuf, sizeof(int16)*gus_SyncOffset_Corr_Method);

    /* ==================================================================================== */
    /*  Adjust FDQ now based on the frame sync        */
    /* ==================================================================================== */
    for(i=gs_RxFirstChannel; i<=gs_RxLastChannel; i++)
    {
        FdqAdjustPerTone(&gsa_pre_FDQ_coef[i<<1], &guca_pre_FDQ_exp[i],
        &gsa_pre_FDQ_coef[i<<1], &guca_pre_FDQ_exp[i],
        i, gus_SyncOffset);
    }

#ifndef FD_ACCUM_FOR_FRAMEALIGN
    //*************** Can stop here if doing HLin calculation elsewhere**************************
    //*************** Can stop here if doing HLin calculation elsewhere**************************
    //*************** Can stop here if doing HLin calculation elsewhere**************************

    /* Convert aligned impulse response back to frequency domain for Hlin calculation. */
    BgFftReal(gsa_MultiTdqRxSignal, gsa_RxRepFrameAlignBuf, (int16)(gs_RxSamplesPerFrame>>1), (int16)(gs_Log2RxSamplesPerFrame-1));

    /* Compensate for IFFT/FFT scaling factor to magnitude expected by ComputeHlin()
        Would be better to compute s_shift as a function of gs_RxSamplesPerFrame. */
    if (gs_RxSamplesPerFrame == 512)
    s_shift = 3;
    else // 1024
    s_shift = 2;

    for (i = 0; i < gs_RxSamplesPerFrame; i++)
    {
        gsa_RxRepFrameAlignBuf[i] <<= s_shift;
    }

    /* Store frequency response data for Hlin calculation. */
    if(( gl_SelectedMode & (MODE_G992_5)  ))
    {
        //Copy subsampled version channel estimate starting from tone 1 to fit into 256 tones
        s_ptr = gpsa_RxHlin;
        for (i=2; i<2*gs_RxNumTones; i+=4) {
            *s_ptr++ = gsa_RxRepFrameAlignBuf[i];
            *s_ptr++ = gsa_RxRepFrameAlignBuf[i+1];
        }
    }
    else
    {
        //Copy this for initial uncompensated channel response for diagnostic mode.
        memcpy(gpsa_RxHlin, gsa_RxRepFrameAlignBuf, sizeof(int16)*2*256);
    }
#endif //FD_ACCUM_FOR_FRAMEALIGN
    guc_AlignmentTrainingState = TRAINING_DONE;


#ifdef ISI_ANALYSIS_ON
    if (gft_ISIanalysis == TRUE) {
        memcpy(gsa_RxChannelEstimateBuf,gsa_RxRepFrameAlignBuf,sizeof(int16)*gs_RxSamplesPerFrame);
    }
#endif
}


C_SCOPE void BgChannelEstimateForHLin(void)
// Input: gsa_RxRepFrameAlignBuf, containing average Rx time-domain Reverb.
// Output: In-place computation of channel estimate.  This estimate is compensated for tssi and DS PCB, but not
// Rx filter or PGA.
{
    int16 i;
    int16 *s_ptr;

    /* Downshift the accumulation to get the average rx time signal. Note this */
    /* is done front to back, since the downshift is done in place. */
    RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0,
    gla_RxAccumBuf, 0, gs_RxSamplesPerFrame, gs_RxLog2AccumLenHLin);


    /*  estimate the channel impulse response */
    gft_ADSL2_doingHlinEstimate = TRUE;   // For ADSL2, controls behavior of EstimateChannel().
    // XDSLRTFW-3974 Use signal of first channel estimation due to its higher resolution for HLOG computation
    EstimateChannel((int16 *)&gsa_ChannelEstimateBkp[0]); // Returns freq domain estimate.

    /* Store frequency response data for Hlin calculation. */
    if(( gl_SelectedMode & (MODE_G992_5)  ))
    {
        //Copy subsampled version channel estimate starting from tone 1 to fit into 256 tones
        s_ptr = gpsa_RxHlin;
        for (i=2; i<2*gs_RxNumTones; i+=4) {
            *s_ptr++ = gsa_ChannelEstimateBkp[i];   // XDSLRTFW-3974 Use signal of first channel estimation
            *s_ptr++ = gsa_ChannelEstimateBkp[i+1];
        }
    }
    else
    {
        memcpy(gpsa_RxHlin, &gsa_ChannelEstimateBkp[0], sizeof(int16)*2*256); // XDSLRTFW-3974 Use signal of first channel estimation
    }

    guc_BkgdTaskState = TRAINING_DONE;

}

#undef UNITY_FDQ_MANTISSA
#undef UNITY_FDQ_EXPONENT
