/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   frm_sync_proc_b.c
 *
 *   Functions for BG Tasks for pre and post processing to be done for frame sync
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "dsp_op.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "frm_sync.h"
#include "cmv.h"
#include "const.h"
#include "bufmisc.h"
#include "Decim_Phase_Data.h"
#include <string.h>
#include "pll.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to perform first stage of
 *
 * frame alignment, i.e., representative frame initialization.
 *
 *  Prototype: void BgAlignmentPreProc(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void BgGen_Reverb_Ref_fd(void)
{
   // restore C-Reverb reference which may have been obliterated by floating
   // point signal. Also needed in BIS because a different pilot tone may have be chosen after handshake.

   if (( gl_SelectedMode & (MODE_ADSL2)  ))
      Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
         0, (int16)(gs_RxNumTones-1), (int16)(DEC_QPSK_GAIN));
   else
      Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
         gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));

   guc_BkgdTaskState = BKGDTASK_DONE;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to perform first stage of
 *
 * frame alignment, i.e., representative frame initialization.
 *
 *  Prototype: void BgAlignmentPreProc(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void BgAlignmentPreProc(void)
{
#ifndef FD_ACCUM_FOR_FRAMEALIGN
   int16 *psa_RxTmpFrameAlignBuf;

   psa_RxTmpFrameAlignBuf = &(gsa_RxRepFrameAlignBuf[gs_RxSamplesPerFrame]);
   psa_RxTmpFrameAlignBuf += FFT_IMPLEMENTATION_OVERHEAD;
#endif
   /* Downshift the accumulation to get the average received signal. Note this */
   /* is done front to back, since the downshift is done in place. The average */
   /* received signal is then copied to the second half of the Accum Buffer, so */
   /* that it can be restored after the sync point has been calculated. */
   RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0, gla_RxAccumBuf, 0,
                        gs_RxSamplesPerFrame, (int16)gs_RxLog2AccumLenChanEst);
#ifndef FD_ACCUM_FOR_FRAMEALIGN
   memcpy(psa_RxTmpFrameAlignBuf, gsa_RxRepFrameAlignBuf, sizeof(int16)*gs_RxSamplesPerFrame);
#endif
   guc_AlignmentPreProcState = TRAINING_DONE;

#ifdef ISI_ANALYSIS_ON
   if (gft_ISIanalysis == TRUE) {
      memcpy(gsa_RxRepFrameCaptureBuf,gsa_RxRepFrameAlignBuf,sizeof(int16)*gs_RxSamplesPerFrame);
   }
#endif

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to perform third stage of
 *
 * frame alignment, i.e., re-aligning representative frame.
 *
 *  Prototype: void BgAlignmentPostProc(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void BgAlignmentPostProc(void)
{
#ifndef FD_ACCUM_FOR_FRAMEALIGN
   int16 *psa_RxTmpFrameAlignBuf;

   psa_RxTmpFrameAlignBuf = &(gsa_RxRepFrameAlignBuf[gs_RxSamplesPerFrame]);
   psa_RxTmpFrameAlignBuf += FFT_IMPLEMENTATION_OVERHEAD;

   /* restore representative frame from tmpbuf.  Rotate around sync point while doing so.*/
   if(gs_RxSamplesPerFrame > gus_SyncOffset)
      memcpy(gsa_RxRepFrameAlignBuf, &psa_RxTmpFrameAlignBuf[(int16)gus_SyncOffset],
            sizeof(int16)*(gs_RxSamplesPerFrame-gus_SyncOffset));
   if(gus_SyncOffset > 0)
      memcpy(&gsa_RxRepFrameAlignBuf[(int16)(gs_RxSamplesPerFrame-gus_SyncOffset)], &psa_RxTmpFrameAlignBuf[0],
            sizeof(int16)*(gus_SyncOffset));
#endif
   guc_AlignmentPostProcState = TRAINING_DONE;
}


C_SCOPE void BgSetReferenceAFE(void)
{

#ifdef DANUBE_AFE
   WriteAfe(DANUBEA_SOFT_RESETS, 0x0008); // reset tx afe noise shaper - to prevent spurius tones.
   gs_HybA_actual = ReadAfe(DANUBEA_HYB_SET_A); //save actual setting

   WriteAfe(DANUBEA_HYB_SET_A, 0x0D00);
   gs_HybB_actual = ReadAfe(DANUBEA_HYB_SET_B); //save actual setting

   WriteAfe(DANUBEA_HYB_SET_B, 0x000C);
   // Turn HPF off and equalizer off and set HPF corner frequency
   gs_HPFEq_actual = ReadAfe(DANUBEA_HPF_EQ_SET);
    WriteAfe(DANUBEA_HPF_EQ_SET,0x0);
#endif
   guc_BkgdTaskState = BKGDTASK_DONE;
}

C_SCOPE void BgSetActualAFE(void)
{
#ifdef DANUBE_AFE
   //re-enable tx shaper
   WriteAfe(DANUBEA_SOFT_RESETS, 0x0000);
    // retore hyb hpf with setting from afeini
    WriteAfe(DANUBEA_HYB_SET_A, gs_HybA_actual);
   WriteAfe(DANUBEA_HYB_SET_B, gs_HybB_actual);
   WriteAfe(DANUBEA_HPF_EQ_SET,gs_HPFEq_actual);
#endif
   guc_BkgdTaskState = BKGDTASK_DONE;
}

