/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   xcvr_rx1_b.c
 *
 *   Functions for BG Tasks from RCReverb1RxF.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fft_bg.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "aec_init.h"
#include "const.h"
#include "compiler.h"
#include "T1413.h"




/* =============================================== */
/* static variable declarations */
/* =============================================== */
int16 gs_aec_order, gs_log2_aec_order;

/* ======================================================= */
/* Background function to scale down 32 bit accumulation   */
/* ======================================================= */
void BgAvgAecLmsSequences(void){

   int32 *pl_Acc, *ph_Acc;
   int16 i, *ps_temp;

   if (STATArray[STAT_Misc] & STAT_TDQ_at_1104){
      gs_aec_order = AEC_ORDER>>1;
      gs_log2_aec_order = LOG2_AEC_ORDER-1;
   }
   else{
      gs_aec_order = AEC_ORDER;
      gs_log2_aec_order = LOG2_AEC_ORDER;
   }

   pl_Acc = &gla_RxAccumBuf[0];
   ph_Acc = &gla_RxDECXcorr[0];

   /* |------ gla_RxAccumBuf-------|---gla_RxDECXcorrbuf ------|   */
   /* |0                        N-1|N                      2N-1|   */
   /* |---------Hybrid path--------|-----AEC + Hybrid path-----|   */

   for(i=gs_RxSamplesPerFrame; i>0; i--){
      *ph_Acc  -=  *pl_Acc;
      *ph_Acc++ >>= LOG2_NUM_AEC_LMS_SYMBOLS;
      *pl_Acc++ >>= LOG2_NUM_AEC_LMS_SYMBOLS;
   }

   /* |------ gla_RxAccumBuf-------|---gla_RxDECXcorrbuf ------|   */
   /* |0                        N-1|N                      2N-1|   */
   /* |---------Hybrid path--------|----------AEC path---------|   */


   /*  =================================================================== */
   /*  pack (int16) hybrid sequence into first 1/4 of (int32) RxAccumBuf   */
   /*  =================================================================== */

   pl_Acc  = &gla_RxAccumBuf[0];
   ps_temp = (int16 *)(void *)pl_Acc;

   for(i=(gs_RxSamplesPerFrame); i>0; i--){
      *ps_temp++ = (int16) *pl_Acc++;
   }

   /*  =============================================================== */
   /*  pack (int16) AEC sequence into next 1/4 of (int32) RxAccumBuf   */
   /*  =============================================================== */

#ifdef FIXED_POINT_AEC
   /* Append the first AEC_ORDER-1 samples of the LMS input
      sequence used in AEC training to obviate the use of a
      circular buffer in AecLmsTrain(). */
   ph_Acc  = &gla_RxDECXcorr[0];
   ph_Acc  += gs_RxSamplesPerFrame-(gs_aec_order-1);

   for (i=gs_aec_order-1; i>0; i--){
      *ps_temp++ = (int16) *ph_Acc++;
   }
#endif

   ph_Acc  = &gla_RxDECXcorr[0];
   ps_temp = (int16 *)(void *)(&gla_RxAccumBuf[gs_RxSamplesPerFrame>>1]);
#ifdef FIXED_POINT_AEC
   ps_temp += gs_aec_order-1;
#endif

   for (i=gs_RxSamplesPerFrame; i>0; i--){
      *ps_temp++ = (int16) *ph_Acc++;
   }

   /* |------ gla_RxAccumBuf, N= gs_RxSamplesPerFrame ---------|   */
   /* |0     (N/2)-1|           N-1|N                      2N-1|   */
   /* |-Hybrid path-|---AEC Path---|---------------------------|   */
   /*       (int16)       (int16)                                   */

   guc_AvgAecLmsSequences = TRAINING_DONE;
}

/* ============================================================= */
/* Background function to train AEC using LMS. For g992_2,       */
/* the AEC filter training length is AEC_ORDER/2. After training */
/* the taps are stretched (simple interpolation) by two.         */
/* ============================================================= */
void BgAECTrain(void){

   int16 i;
   int16 *sa_LMS_inbuf;
   int16 *sa_LMS_ref;
#ifndef FIXED_POINT_AEC
   Float32 f_InvLmsStep;
#endif

#ifdef AEC_ANALYSIS_ON
   int16 cnt_LMS;
#endif

   sa_LMS_ref = (int16 *)(void *)gla_RxAccumBuf;
   sa_LMS_inbuf = (int16 *)(void *)(&gla_RxAccumBuf[gs_RxSamplesPerFrame>>1]);

#ifdef FIXED_POINT_AEC
   for (i=0;i<(gs_numAecLMSIterations);i++){
      AecLmsTrain(sa_LMS_ref, sa_LMS_inbuf,
         (int16)(gs_RxSamplesPerFrame+gs_aec_order-1), gsa_pre_aec_h,
         gs_aec_order, (int16) gs_log2_aec_order);

   #ifdef AEC_ANALYSIS_ON
      cnt_LMS=i*(gs_aec_order+3);
      memcpy(gsa_RxLMSCaptureBuf+cnt_LMS,gsa_pre_aec_h,sizeof(int16)*gs_aec_order);
      gsa_RxLMSCaptureBuf[cnt_LMS+gs_aec_order]=gs_pre_aec_h_exp;
      gsa_RxLMSCaptureBuf[cnt_LMS+gs_aec_order+1]=(int16)(gl_error & (int32)0x0000FFFF);
      gsa_RxLMSCaptureBuf[cnt_LMS+gs_aec_order+2]=(int16)((gl_error>>16) & (int32)0x0000FFFF);
   #endif
   }
#else /*floating point*/
   f_InvLmsStep =  mpyf32(int32toFloat32((int32)1 << 30),int32toFloat32((int32)(AEC_ORDER))) ;
   for (i=0;i<(gs_numAecLMSIterations);i++){
      AecLmsTrain(sa_LMS_ref, sa_LMS_inbuf,
         gs_RxSamplesPerFrame, gfa_aec_h,
         gs_aec_order, f_InvLmsStep);
   }
   Aec(gfa_aec_h, s_aec_order);
#endif  /*FIXED_POINT_AEC*/

   /* Negate taps before AEC summing junction */

   if (STATArray[STAT_Misc] & STAT_TDQ_at_1104){
      /* simple interpolation by two for lite mode */
      for (i=gs_aec_order-1; i>=0;i--){
         gsa_pre_aec_h[2*i]=-gsa_pre_aec_h[i];
         gsa_pre_aec_h[2*i+1]=0;
         }
      }
   else{
      for (i=0;i<gs_aec_order;i++)
         gsa_pre_aec_h[i]=-gsa_pre_aec_h[i];
   }

   guc_AecTrainingState = TRAINING_DONE;

}
