/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   XTC_setup.C
 *
 *   Set up input structures for XTC
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "const_bis.h"
#include "typedef.h"
#include "cmv.h"
#include "dsp_op.h"
#include "dsp_op2.h"

#ifdef IFX_XTC

static int32 ConvertBitsPerSecToBytesPerSym(int32 l_BitsPerSec)
{
   // This routine will return at least 1 for any BitsPerSec value > 100.

   int16 s_quot_mantissa, s_quot_exponent, s_lshift;

   s_lshift = norm_l(l_BitsPerSec);
   // To convert from bits/sec to bytes/frame, conversion factor is 1/32000.
   Divide_32by16bit(l_BitsPerSec << s_lshift, -s_lshift, (int16)32000 , 0, &s_quot_mantissa, &s_quot_exponent);

   // Round result up to next highest integer
   return(((int32)s_quot_mantissa + (1<< -s_quot_exponent) - 1) >> -s_quot_exponent);
}


C_SCOPE  void SetupTxXtcInput(void)
{
   int i;

   gt_TxXtcIfConfigInput.s_BCtoTPS[0] = (STATArray[STAT_ACTIVEBCLP_US]>>8) & 0x1;
   gt_TxXtcIfConfigInput.s_BCtoTPS[1] = (STATArray[STAT_ACTIVEBCLP_US]>>9) & 0x1;
   gt_TxXtcIfConfigInput.s_PmdFrameRate = 0;    // 4kHz frame rate

   for (i=0 ; i<NUM_BEARER_CHANNELS ; i++)
   {
      gt_TxXtcIfConfigInput.l_NetPayloadRate[i] = ConvertBitsPerSecToBytesPerSym(gla_USDataRate[i]);
   }
}

C_SCOPE void SetupRxXtcInput(void)
{
   int i;

   gt_RxXtcIfConfigInput.s_BCtoTPS[0] = (STATArray[STAT_ACTIVEBCLP_DS]>>8) & 0x1;
   gt_RxXtcIfConfigInput.s_BCtoTPS[1] = (STATArray[STAT_ACTIVEBCLP_DS]>>9) & 0x1;
   gt_RxXtcIfConfigInput.s_PmdFrameRate = 0;    // 4kHz frame rate
   for (i=0 ; i<NUM_BEARER_CHANNELS ; i++)
   {
      gt_RxXtcIfConfigInput.l_NetPayloadRate[i] = ConvertBitsPerSecToBytesPerSym(gla_DSDataRate[i]);
   }
}

#endif
