@echo off
rem **COPYRIGHT*****************************************************************
rem    INTEL CONFIDENTIAL
rem    Copyright (C) 2017 Intel Corporation
rem *****************************************************************COPYRIGHT**
rem **DISCLAIMER****************************************************************
rem  The source code contained or described herein and all documents related
rem  to the source code ("Material") are owned by Intel Corporation or its
rem  suppliers or licensors. Title to the Material remains with Intel
rem  Corporation or its suppliers and licensors. The Material may contain
rem  trade secrets and proprietary and confidential information of Intel
rem  Corporation and its suppliers and licensors, and is protected by
rem  worldwide copyright and trade secret laws and treaty provisions. No part
rem  of the Material may be used, copied, reproduced, modified, published,
rem  uploaded, posted, transmitted, distributed, or disclosed in any way
rem  without Intel's prior express written permission.
rem
rem  No license under any patent, copyright, trade secret or other
rem  intellectual property right is granted to or conferred upon you by
rem  disclosure or delivery of the Materials, either expressly, by
rem  implication, inducement, estoppel or otherwise. Any license under
rem  such intellectual property rights must be express and approved by
rem  Intel in writing.
rem ****************************************************************DISCLAIMER**
@echo on
REM Check an OS - it works only on Windows-2000 and XP so far.
ver|sed s'/.*Windows \(2000\) .*/set WHICHOS=\1/'>temp_set.bat
call temp_set.bat
if "%WHICHOS%" == "2000" goto OS_OK
ver|sed s'/.*Windows \(XP\) .*/set WHICHOS=\1/'>temp_set.bat
call temp_set.bat
if "%WHICHOS%" == "XP" goto OS_OK
echo Builds have not run!!! Please, use Windows-2000 or Windows-XP machine for these builds.
goto CDNOCHK

:OS_OK


REM **************** VR 9 ARC Builds start ************************

REM VR9 hw Annex A build


if "%VR9_HW_AnnexA%" == "NO" goto BDVR9ANOCHK
if "%VR9_HW_AnnexA%" == "No" goto BDVR9ANOCHK
if "%VR9_HW_AnnexA%" == "no" goto BDVR9ANOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_vr9_hw.bat

type ModemHWE.log > ModemHWE_VR9_A_hw_build.log

if exist .\obj\ModemHWE.out goto vr9abddone
echo Error: The ModemHWE.out was not built. >> ModemHWE_VR9_A_hw_build.log
goto vr9bskipvr9

:vr9abddone

rm -f -r ..\..\Arc_Release
if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexA.out
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\adsl_vdsl_cpe_AnnexA.out
copy /v .\obj\adsl_vdsl_cpe.bin ..\..\Arc_Release\adsl_vdsl_cpe_AnnexA.bin
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexA.bin
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release
copy /v .\map\ModemHWE.map ..\..\Arc_Release
xcopy /V /Y /I /S .\obj\acpe_*.out ..\..\Arc_Release
xcopy /V /Y /I /S .\obj\VR9_*.bin ..\..\Arc_Release
xcopy /V /Y /I /S .\obj\xcpe_*.bin ..\..\Arc_Release


:vr9bskipvr9

if "%AUTOPOST%" == "" goto BDANNOCHK

xcopy /V /Y /I /S ModemHWE_VR9_A_hw_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A"

set OK=NO
if not exist ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexA.out goto vr9BDANBLDERR
if not exist ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexA.bin goto vr9BDANIMGERR
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
REM AppendString.exe ..\..\Arc_Release\ModemHWE.bin %LABEL%%CURTIME%
echo ModemHWE Annex A VR9 build is done (%LABEL%).>mes

REM xcopy /V /Y /I /S ..\..\Arc_Release\LNTQ_VR9_adsl_cpe*.*  "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\adsl_vdsl*.*  "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\VR9_*.*   "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\*cpe_*.*   "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\*.xls   "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\*.map   "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"

echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries>>mes
set OK=YES
goto vr9BDANOK

:vr9BDANBLDERR
echo ModemHWE VR9 Annex A hw build failed (%LABEL%). Please, see the file "<X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\ModemHWE_VR9_A_hw_build.log>".>mes
goto vr9BDANOK

:vr9BDANIMGERR
echo ModemHWE VR9 Annex A hw build failed in generating image (%LABEL%).>mes

:vr9BDANOK

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto vr9BDAN_NO
smtpmail  -s"'VR9 Annex A hw' Build is Done (automated e-mail)" "NagendraKumar.Perabattula@lantiq.com" "Bindu.Chandna@lantiq.com"  "yang.cao@lantiq.com" "John.Greszczuk@lantiq.com" <mes
goto BDVR9ANOCHK

:vr9BDAN_NO

smtpmail  -s"'VR9 Annex A hw' Build has Failed (automated e-mail)" "NagendraKumar.Perabattula@lantiq.com" "Bindu.Chandna@lantiq.com"  "yang.cao@lantiq.com" "John.Greszczuk@lantiq.com"<mes

:BDVR9ANOCHK


if "%VR9_HW_AnnexB%" == "NO" goto BDVR9BNOCHK
if "%VR9_HW_AnnexB%" == "No" goto BDVR9BNOCHK
if "%VR9_HW_AnnexB%" == "no" goto BDVR9BNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_vr9_b_hw.bat

type ModemHWE.log > ModemHWE_VR9_B_hw_build.log

if exist .\obj\ModemHWE.out goto vr9bbddone
echo Error: The ModemHWE.out was not built. >> ModemHWE_VR9_B_hw_build.log
goto vr9bskipvr9_annxB

:vr9bbddone

rm -f -r ..\..\Arc_Release
if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexB.out
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\adsl_vdsl_cpe_AnnexB.out
copy /v .\obj\adsl_vdsl_cpe.bin ..\..\Arc_Release\adsl_vdsl_cpe_AnnexB.bin
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexB.bin
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release
copy /v .\map\ModemHWE.map ..\..\Arc_Release
xcopy /V /Y /I /S .\obj\VR9_*.out ..\..\Arc_Release
xcopy /V /Y /I /S .\obj\VR9_*.bin ..\..\Arc_Release
xcopy /V /Y /I /S .\obj\*cpe_*.* ..\..\Arc_Release

:vr9bskipvr9_annxB

if "%AUTOPOST%" == "" goto BDBNNOCHK

xcopy /V /Y /I /S ModemHWE_VR9_B_hw_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B"

set OK=NO
if not exist ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexB.out goto vr9BDANBLDERR_annxB
if not exist ..\..\Arc_Release\LNTQ_VR9_adsl_cpe_AnnexB.bin goto vr9BDANIMGERR_annxB
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
REM AppendString.exe ..\..\Arc_Release\ModemHWE.bin %LABEL%%CURTIME%
echo ModemHWE Annex B VR9 build is done (%LABEL%).>mes
REM xcopy /V /Y /I /S ..\..\Arc_Release\LNTQ_VR9_adsl_cpe*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\adsl_vdsl_cpe*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\VR9_*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\*cpe_*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\*.xls "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
xcopy /V /Y /I /S ..\..\Arc_Release\*.map "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"

echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries>>mes
set OK=YES
goto vr9BDANOK_annxB

:vr9BDANBLDERR_annxB
echo ModemHWE VR9 Annex B hw build failed (%LABEL%). Please, see the file "<X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\ModemHWE_VR9_B_hw_build.log>".>mes
goto vr9BDANOK_annxB

:BDANIMGERR_annxB
echo ModemHWE VR9 Annex B hw build failed in generating image (%LABEL%).>mes

:vr9BDANOK_annxB

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto vr9BDAN_AnnexB_NO
smtpmail  -s"'VR9 Annex B hw' Build is Done (automated e-mail)" "NagendraKumar.Perabattula@lantiq.com" "Bindu.Chandna@lantiq.com"  "yang.cao@lantiq.com" "John.Greszczuk@lantiq.com"<mes
goto BDVR9BNOCHK

:vr9BDAN_AnnexB_NO

smtpmail  -s"'VR9 Annex B hw' Build has Failed (automated e-mail)" "NagendraKumar.Perabattula@lantiq.com" "Bindu.Chandna@lantiq.com"  "yang.cao@lantiq.com" "John.Greszczuk@lantiq.com"<mes

:BDVR9BNOCHK


REM **************** VR 9 ARC Builds Done   ************************

cd ..


REM Vinax IFX Annex A
cd modem_infx

if "%VINEX_IFX_AnnexA%" == "NO" goto VINNOCHK
if "%VINEX_IFX_AnnexA%" == "No" goto VINNOCHK
if "%VINEX_IFX_AnnexA%" == "no" goto VINNOCHK

set BASEPJDIR=X:\Dev Cocomo Projects\PrototypeLantiq\VinaxADSLCPE
set BASEPJ=%BASEPJDIR%\VinaxADSLCPE.pj
set BASEVER=%BASEPJDIR%\CPE\sandbox\soc_test\versions.h

if "%AUTOPOST%" == "" goto NOVER
REM Set the %LABEL%
cd ..\..\..\..
pwd|sed 's/.*\(...._bc.*\)/set LABEL=ARC_\1/'>temp_set.bat
call temp_set.bat
del temp_set.bat

pj co -l -P"%BASEPJ%" -y -2 "%BASEVER%"
if not errorlevel 1 goto LOGPATH
echo Could not check out file 'version.h' (%LABEL%)>mes
smtpmail  -s"'Vinax CPE Build (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com

:LOGPATH

REM Set the directory arc_bld\modem path for the automated e-mail messages
REM For the branches (checkpoint and builds)
REM pwd|sed 's/.*:\/\(.*\)/\1/'|sed 's/\(.*\)\/\(.*\)/set SNDB_DIR=\1\\\2/'>set_env.bat
REM For the main line (builds from existing checkpoint)
pwd|sed 's/.*:\/\(.*\)/set SNDB_DIR=\1/'>set_env.bat
uname -n|sed 's/\(.*\)/set PC_NAME=\1/'>>set_env.bat
call set_env.bat
set BUILD_LOGS=\\%PC_NAME%\Results\%SNDB_DIR%\CPE\sandbox\arc_bld
del set_env.bat
cd CPE\sandbox\arc_bld

:NOVER

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_vinax_ifx.bat

REM unlock and checkin version.h file
pj ci -m"Automated check in by BuildAll_3.0.bat." -P"%`%" -y -2 "%BASEVER%"

type ModemHWE.log > ModemHWE_Vinax_IFX_build.log

if exist .\obj\ModemHWE.out goto vindone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Vinax_IFX_build.log
goto skipvin

:vindone

if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_A.out
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_A.bin
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_A_no_App_Str.bin
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_A_no_App_Str.out
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release\ModemHWE_Vinax_IFX_A_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\Arc_Release\ModemHWE_Vinax_IFX_A.map

:skipvin

if "%AUTOPOST%" == "" goto VINNOCHK

xcopy /V /Y /I /S ModemHWE_Vinax_IFX_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A"

set OK=NO
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_A.out goto VINBLDERR
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_A.bin goto VINIMGERR
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
AppendString.exe ..\..\Arc_Release\ModemHWE_Vinax_IFX_A.bin %LABEL%%CURTIME%
echo ModemHWE Vinax IFX Annex A build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\Arc_Release\ModemHWE_Vinax_IFX_A*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A>>mes
set OK=YES
goto VINOK

:VINBLDERR
echo ModemHWE Vinax IFX Annex A build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_Vinax_IFX_build.log>".>mes
goto VINOK

:VINIMGERR
echo ModemHWE Vinax IFX Annex A build failed in generating image (%LABEL%).>mes

:VINOK

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto VIN_NO
smtpmail  -s"'Vinax IFX Annex A' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto VINNOCHK

:VIN_NO

smtpmail  -s"'Vinax IFX Annex A' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes


:VINNOCHK

cd ..

REM Vinax IFX soccmv Annex A

cd modem_infx

if "%VINEX_IFX_soccmv_AnnexA%" == "NO" goto SVINNOCHK
if "%VINEX_IFX_soccmv_AnnexA" == "No" goto SVINNOCHK
if "%VINEX_IFX_soccmv_AnnexA%" == "no" goto SVINNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_vinax_IFX_soccmv.bat

type ModemHWE.log > ModemHWE_Vinax_IFX_soccmv_build.log

if exist .\obj\ModemHWE.out goto svindone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Vinax_IFX_soccmv_build.log
goto sskipvin

:svindone

if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A.out
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A.bin
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A_no_App_Str.bin
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A_no_App_Str.out
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A.map

:sskipvin

if "%AUTOPOST%" == "" goto SVINNOCHK

xcopy /V /Y /I /S ModemHWE_Vinax_IFX_soccmv_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A"

set OK=NO
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A.out goto SVINBLDERR
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A.bin goto SVINIMGERR
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
AppendString.exe ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A.bin %LABEL%%CURTIME%
echo ModemHWE Vinax IFX soccmv Annex A build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_A*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A>>mes
set OK=YES
goto SVINOK

:SVINBLDERR
echo ModemHWE Vinax IFX soccmv Annex A build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_Vinax_IFX_soccmv_build.log>".>mes
goto SVINOK

:SVINIMGERR
echo ModemHWE Vinax IFX soccmv Annex A build failed in generating image (%LABEL%).>mes

:SVINOK

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto SVIN_NO
smtpmail  -s"'Vinax IFX soccmv Annex A' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto SVINNOCHK

:SVIN_NO

smtpmail  -s"'Vinax IFX soccmv Annex A' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes

:SVINNOCHK

cd ..

REM Vinax IFX Annex B

cd modem_infx

if "%VINEX_IFX_AnnexB%" == "NO" goto BVINNOCHK
if "%VINEX_IFX_AnnexB%" == "No" goto BVINNOCHK
if "%VINEX_IFX_AnnexB%" == "no" goto BVINNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_vinax_ifx_b.bat

type ModemHWE.log > ModemHWE_Vinax_IFX_build_B.log

if exist .\obj\ModemHWE.out goto bvindone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Vinax_IFX_build_B.log
goto bskipvin

:bvindone

if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_B.out
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_B.bin
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_B_no_App_Str.bin
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_B_no_App_Str.out
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release\ModemHWE_Vinax_IFX_B_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\Arc_Release\ModemHWE_Vinax_IFX_B.map

:bskipvin

if "%AUTOPOST%" == "" goto BVINNOCHK

xcopy /V /Y /I /S ModemHWE_Vinax_IFX_build_B.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B"

set OK=NO
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_B.out goto BVINBLDERR
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_B.bin goto BVINIMGERR
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
AppendString.exe ..\..\Arc_Release\ModemHWE_Vinax_IFX_B.bin %LABEL%%CURTIME%
echo ModemHWE Vinax IFX Annex B build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\Arc_Release\ModemHWE_Vinax_IFX_B*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B>>mes
set OK=YES
goto BVINOK

:BVINBLDERR
echo ModemHWE Vinax IFX Annex B build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_Vinax_IFX_build_B.log>".>mes
goto BVINOK

:BVINIMGERR
echo ModemHWE Vinax IFX Annex B build failed in generating image (%LABEL%).>mes

:BVINOK

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto BVIN_NO
smtpmail  -s"'Vinax IFX Annex B' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto BVINNOCHK

:BVIN_NO

smtpmail  -s"'Vinax IFX Annex B' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes

:BVINNOCHK

cd ..

REM Vinax IFX soccmv Annex B\Binaries

cd modem_infx

if "%VINEX_IFX_soccmv_AnnexB%" == "NO" goto BSVINNOCHK
if "%VINEX_IFX_soccmv_AnnexB" == "No" goto BSVINNOCHK
if "%VINEX_IFX_soccmv_AnnexB%" == "no" goto BSVINNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_vinax_IFX_soccmv_b.bat

type ModemHWE.log > ModemHWE_Vinax_IFX_soccmv_build_B.log

if exist .\obj\ModemHWE.out goto bsvindone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Vinax_IFX_soccmv_build_B.log
goto bsskipvin

:bsvindone

if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B.out
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B.bin
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B_no_App_Str.bin
copy /v .\obj\ModemHWE.out ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B_no_App_Str.out
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B.map

:bsskipvin

if "%AUTOPOST%" == "" goto BSVINNOCHK

xcopy /V /Y /I /S ModemHWE_Vinax_IFX_soccmv_build_B.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B"

set OK=NO
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B.out goto BSVINBLDERR
if not exist ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B.bin goto BSVINIMGERR
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
AppendString.exe ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B.bin %LABEL%%CURTIME%
echo ModemHWE Vinax IFX soccmv Annex B\Binaries build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\Arc_Release\ModemHWE_Vinax_IFX_soccmv_B*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B>>mes
set OK=YES
goto BSVINOK

:BSVINBLDERR
echo ModemHWE Vinax IFX soccmv Annex B\Binaries build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_Vinax_IFX_soccmv_build_B.log>".>mes
goto BSVINOK

:BSVINIMGERR
echo ModemHWE Vinax IFX soccmv Annex B\Binaries build failed in generating image (%LABEL%).>mes

:BSVINOK

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto BSVIN_NO
smtpmail  -s"'Vinax IFX soccmv Annex B\Binaries' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto BSVINNOCHK

:BSVIN_NO

smtpmail  -s"'Vinax IFX soccmv Annex B\Binaries' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes

:BSVINNOCHK

cd ..

REM BIS INFINEON AnnexA

cd modem_infx

if "%BIS_INFINEON_AnnexA%" == "NO" goto BISINNOCHK
if "%BIS_INFINEON_AnnexA%" == "No" goto BISINNOCHK
if "%BIS_INFINEON_AnnexA%" == "no" goto BISINNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c
call build_socrates_infx.bat

type ModemHWE.log > ModemHWE_INFINEON_build.log

if exist .\obj\ModemHWE.out goto indone
echo Error: The ModemHWE.out was not built. >> ModemHWE_INFINEON_build.log
goto skipin

:indone

if not exist ..\..\soc3.0_Release\* mkdir ..\..\soc3.0_Release
copy /v .\obj\ModemHWE.out ..\..\soc3.0_Release\ModemHWE_INFINEON_A.out
copy /v .\obj\ModemHWE.bin ..\..\soc3.0_Release\ModemHWE_INFINEON_A.bin
copy /v .\map\ModemHWE_mem.xls ..\..\soc3.0_Release\ModemHWE_INFINEON_A_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\soc3.0_Release\ModemHWE_INFINEON_A.map

:skipin

xcopy /V /Y /I /E ..\* ..\..\..\..\sandbox_INFINEON\arc_bld
rm -f -R ..\..\..\..\sandbox_INFINEON\arc_bld\modem_infx\asm
xcopy /V /Y /I /E ..\..\soc_src\modem\codeswap\* ..\..\..\..\sandbox_INFINEON\soc_src\modem\codeswap
xcopy /V /Y /I ..\..\soc_src\modem\Platform\timestmp.c* ..\..\..\..\sandbox_INFINEON\soc_src\modem\platform
copy /V ..\..\soc_src\modem\Platform\checkpnt_label.c ..\..\..\..\sandbox_INFINEON\soc_src\modem\platform

if "%AUTOPOST%" == "" goto BISINNOCHK

REM ********************************************************
REM *** Check the BIS INFINEON codeswap build success/failure
REM ********************************************************

xcopy /V /Y /I /S ModemHWE_INFINEON_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A"

set OK=NO
if not exist ..\..\soc3.0_Release\ModemHWE_INFINEON_A.out goto BISINBLDERR
if not exist ..\..\soc3.0_Release\ModemHWE_INFINEON_A.bin goto BISINIMGERR
type "%BASEVER%"|grep BIS_INFINEON_A|sed 's/#define BIS_INFINEON_A *\([0-9,aA-fF]*\)/set SOCR_VERSION=\1/'>set_env.bat
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>>set_env.bat
call set_env.bat
AppendString.exe ..\..\soc3.0_release\ModemHWE_INFINEON_A.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
AppendString.exe ..\..\soc3.0_release\ModemHWE_INFINEON_A_le.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
..\modem\Socr_Version.exe "%BASEVER%" BIS_INFINEON_A
echo ModemHWE 'INFINEON' build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\soc3.0_release\ModemHWE_INFINEON_A*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A>>mes
set OK=YES
goto BISINOK

:BISINBLDERR
echo ModemHWE 'INFINEON' build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_INFINEON_build.log>".>mes
goto BISINOK

:BISINIMGERR
echo ModemHWE 'INFINEON' build failed in generating image (%LABEL%).>mes

:BISINOK

echo Regards,>>mes
echo SocUser>>mes

if "%OK%" == "NO" goto BIN_NO
smtpmail  -s"'Socrates INFINEON' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto BISINNOCHK

:BIN_NO

smtpmail  -s"'Socrates INFINEON' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes

:BISINNOCHK

cd ..

REM BIS INFINEON AnnexB

cd modem_infx

if "%BIS_INFINEON_AnnexB%" == "NO" goto BINNOCHK
if "%BIS_INFINEON_AnnexB%" == "No" goto BINNOCHK
if "%BIS_INFINEON_AnnexB%" == "no" goto BINNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c
call build_socrates_infx_b.bat

type ModemHWE.log > ModemHWE_INFINEON_build_B.log

if exist .\obj\ModemHWE.out goto inbdone
echo Error: The ModemHWE.out was not built. >> ModemHWE_INFINEON_build_B.log
goto skipinb

:inbdone

if not exist ..\..\soc3.0_Release\* mkdir ..\..\soc3.0_Release
copy /v .\obj\ModemHWE.out ..\..\soc3.0_Release\ModemHWE_INFINEON_B.out
copy /v .\obj\ModemHWE.bin ..\..\soc3.0_Release\ModemHWE_INFINEON_B.bin
copy /v .\map\ModemHWE_mem.xls ..\..\soc3.0_Release\ModemHWE_INFINEON_B_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\soc3.0_Release\ModemHWE_INFINEON_B.map

:skipinb

xcopy /V /Y /I /E ..\* ..\..\..\..\sandbox_INFINEON_B\arc_bld
rm -f -R ..\..\..\..\sandbox_INFINEON_B\arc_bld\modem_infx\asm
xcopy /V /Y /I /E ..\..\soc_src\modem\codeswap\* ..\..\..\..\sandbox_INFINEON_B\soc_src\modem\codeswap
xcopy /V /Y /I ..\..\soc_src\modem\Platform\timestmp.c* ..\..\..\..\sandbox_INFINEON_B\soc_src\modem\platform
copy /V ..\..\soc_src\modem\Platform\checkpnt_label.c ..\..\..\..\sandbox_INFINEON_B\soc_src\modem\platform

if "%AUTOPOST%" == "" goto BINNOCHK

REM ********************************************************
REM *** Check the BIS INFINEON codeswap build success/failure
REM ********************************************************

xcopy /V /Y /I /S ModemHWE_INFINEON_build_B.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B"

set OK=NO
if not exist ..\..\soc3.0_Release\ModemHWE_INFINEON_B.out goto BINBLDERR
if not exist ..\..\soc3.0_Release\ModemHWE_INFINEON_B.bin goto BINIMGERR
type "%BASEVER%"|grep BIS_INFINEON_B|sed 's/#define BIS_INFINEON_B *\([0-9,aA-fF]*\)/set SOCR_VERSION=\1/'>set_env.bat
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>>set_env.bat
call set_env.bat
AppendString.exe ..\..\soc3.0_release\ModemHWE_INFINEON_B.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
AppendString.exe ..\..\soc3.0_release\ModemHWE_INFINEON_B_le.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
..\modem\Socr_Version.exe "%BASEVER%" BIS_INFINEON_B
echo ModemHWE AnnexB 'INFINEON' build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\soc3.0_release\ModemHWE_INFINEON_B*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B>>mes
set OK=YES
goto BINOK

:BINBLDERR
echo ModemHWE AnnexB 'INFINEON' build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_INFINEON_build_B.log>".>mes
goto BINOK

:BINIMGERR
echo ModemHWE AnnexB 'INFINEON' build failed in generating image (%LABEL%).>mes

:BINOK

echo Regards,>>mes
echo SocUser>>mes

if "%OK%" == "NO" goto BBIN_NO
smtpmail  -s"'Socrates AnnexB INFINEON' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto BINNOCHK

:BBIN_NO

smtpmail  -s"'Socrates AnnexB INFINEON' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes

:BINNOCHK

cd ..

REM BIS AMAZON AnnexA

cd modem_infx

if "%BIS_AMAZON_AnnexA%" == "NO" goto BISAMNOCHK
if "%BIS_AMAZON_AnnexA%" == "No" goto BISAMNOCHK
if "%BIS_AMAZON_AnnexA%" == "no" goto BISAMNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c
call build_socrates_amazon.bat

type ModemHWE.log > ModemHWE_Amazon_build.log

if exist .\obj\ModemHWE.out goto amdone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Amazon_build.log
goto skipam

:amdone

if not exist ..\..\soc3.0_Release\* mkdir ..\..\soc3.0_Release
copy /v .\obj\ModemHWE.out ..\..\soc3.0_Release\ModemHWE_Amazon_A.out
copy /v .\obj\ModemHWE.bin ..\..\soc3.0_Release\ModemHWE_Amazon_A.bin
copy /v .\map\ModemHWE_mem.xls ..\..\soc3.0_Release\ModemHWE_Amazon_A_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\soc3.0_Release\ModemHWE_Amazon_A.map

:skipam

xcopy /V /Y /I /E ..\* ..\..\..\..\sandbox_Amazon\arc_bld
rm -f -R ..\..\..\..\sandbox_Amazon\arc_bld\modem_infx\asm
xcopy /V /Y /I /E ..\..\soc_src\modem\codeswap\* ..\..\..\..\sandbox_Amazon\soc_src\modem\codeswap
xcopy /V /Y /I ..\..\soc_src\modem\Platform\timestmp.c* ..\..\..\..\sandbox_Amazon\soc_src\modem\platform
copy /V ..\..\soc_src\modem\Platform\checkpnt_label.c ..\..\..\..\sandbox_Amazon\soc_src\modem\platform

if "%AUTOPOST%" == "" goto BISAMNOCHK

REM ********************************************************
REM *** Check the BIS amazon codeswap build success/failure
REM ********************************************************

xcopy /V /Y /I /S ModemHWE_AMAZON_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A"

set OK=NO
if not exist ..\..\soc3.0_Release\ModemHWE_AMAZON_A.out goto BISAMBLDERR
if not exist ..\..\soc3.0_Release\ModemHWE_AMAZON_A.bin goto BISAMIMGERR
type "%BASEVER%"|grep BIS_AMAZON|sed 's/#define BIS_AMAZON *\([0-9,aA-fF]*\)/set SOCR_VERSION=\1/'>set_env.bat
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>>set_env.bat
call set_env.bat
AppendString.exe ..\..\soc3.0_release\ModemHWE_AMAZON_A.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
AppendString.exe ..\..\soc3.0_release\ModemHWE_AMAZON_A_le.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
..\modem\Socr_Version.exe  "%BASEVER%" BIS_AMAZON
echo ModemHWE 'AMAZON' build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\soc3.0_release\ModemHWE_AMAZON_A*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A>>mes
set OK=YES
goto BISAMOK

:BISAMBLDERR
echo ModemHWE 'AMAZON' build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_AMAZON_build.log>".>mes
goto BISAMOK

:BISAMIMGERR
echo ModemHWE 'AMAZON' build failed in generating image (%LABEL%).>mes

:BISAMOK

echo Regards,>>mes
echo SocUser>>mes

if "%OK%" == "NO" goto BAM_NO
smtpmail  -s"'Socrates AMAZON' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto BISAMNOCHK

:BAM_NO

smtpmail  -s"'Socrates AMAZON' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes

:BISAMNOCHK

cd ..

REM BIS AMAZON AnnexB

cd modem_infx

if "%BIS_AMAZON_AnnexB%" == "NO" goto BAMNOCHK
if "%BIS_AMAZON_AnnexB%" == "No" goto BAMNOCHK
if "%BIS_AMAZON_AnnexB%" == "no" goto BAMNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c
call build_socrates_amazon_b.bat

type ModemHWE.log > ModemHWE_Amazon_build_B.log

if exist .\obj\ModemHWE.out goto ambdone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Amazon_build_B.log
goto skipamb

:ambdone

if not exist ..\..\soc3.0_Release\* mkdir ..\..\soc3.0_Release
copy /v .\obj\ModemHWE.out ..\..\soc3.0_Release\ModemHWE_Amazon_B.out
copy /v .\obj\ModemHWE.bin ..\..\soc3.0_Release\ModemHWE_Amazon_B.bin
copy /v .\map\ModemHWE_mem.xls ..\..\soc3.0_Release\ModemHWE_Amazon_B_mem_sum.xls
copy /v .\map\ModemHWE.map ..\..\soc3.0_Release\ModemHWE_Amazon_B.map

:skipamb

xcopy /V /Y /I /E ..\* ..\..\..\..\sandbox_Amazon_B\arc_bld
rm -f -R ..\..\..\..\sandbox_Amazon_B\arc_bld\modem_infx\asm
xcopy /V /Y /I /E ..\..\soc_src\modem\codeswap\* ..\..\..\..\sandbox_Amazon_B\soc_src\modem\codeswap
xcopy /V /Y /I ..\..\soc_src\modem\Platform\timestmp.c* ..\..\..\..\sandbox_Amazon_B\soc_src\modem\platform
copy /V ..\..\soc_src\modem\Platform\checkpnt_label.c ..\..\..\..\sandbox_Amazon_B\soc_src\modem\platform

if "%AUTOPOST%" == "" goto BAMNOCHK

REM ********************************************************
REM *** Check the BIS amazon codeswap build success/failure
REM ********************************************************

xcopy /V /Y /I /S ModemHWE_AMAZON_build_B.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B"

set OK=NO
if not exist ..\..\soc3.0_Release\ModemHWE_AMAZON_B.out goto BAMBLDERR
if not exist ..\..\soc3.0_Release\ModemHWE_AMAZON_B.bin goto BAMIMGERR
type "%BASEVER%"|grep BIS_ANNEXB_AMAZON|sed 's/#define BIS_ANNEXB_AMAZON *\([0-9,aA-fF]*\)/set SOCR_VERSION=\1/'>set_env.bat
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>>set_env.bat
call set_env.bat
AppendString.exe ..\..\soc3.0_release\ModemHWE_AMAZON_B.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
AppendString.exe ..\..\soc3.0_release\ModemHWE_AMAZON_B_le.bin %SOCR_VERSION%****1****%LABEL%****%CURTIME%****
..\modem\Socr_Version.exe  "%BASEVER%" BIS_ANNEXB_AMAZON
echo ModemHWE AnnexB 'AMAZON' build is done (%LABEL%).>mes
xcopy /V /Y /I /S ..\..\soc3.0_release\ModemHWE_AMAZON_B*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B>>mes
set OK=YES
goto BAMOK

:BAMBLDERR
echo ModemHWE AnnexB 'AMAZON' build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_AMAZON_build_B.log>".>mes
goto BAMOK

:BAMIMGERR
echo ModemHWE AnnexB 'AMAZON' build failed in generating image (%LABEL%).>mes

:BAMOK

echo Regards,>>mes
echo SocUser>>mes

if "%OK%" == "NO" goto BBAM_NO
smtpmail  -s"'Socrates AnnexB AMAZON' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes
goto BAMNOCHK

:BBAM_NO

smtpmail  -s"'Socrates AnnexB AMAZON' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com <mes

:BAMNOCHK

cd ..

REM Danube hw

cd modem_infx

if "%DANUBE_HW_AnnexA%" == "NO" goto DANNOCHK
if "%DANUBE_HW_AnnexA%" == "No" goto DANNOCHK
if "%DANUBE_HW_AnnexA%" == "no" goto DANNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_danube_hw.bat

type ModemHWE.log > ModemHWE_Danube_hw_build.log

if exist .\obj\ModemHWE.out goto dandone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Danube_hw_build.log
goto skipdan

:dandone

if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release
copy /v .\map\ModemHWE.map ..\..\Arc_Release
xcopy /v /I /S .\obj\Danube_*.out ..\..\Arc_Release
xcopy /v /I /S .\obj\Danube_*.bin ..\..\Arc_Release

:skipdan

if "%AUTOPOST%" == "" goto DANNOCHK

xcopy /V /I /S ModemHWE_Danube_hw_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A"

set OK=NO
if not exist ..\..\Arc_Release\ModemHWE.out goto DANBLDERR
if not exist ..\..\Arc_Release\ModemHWE.bin goto DANIMGERR
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
REM AppendString.exe ..\..\Arc_Release\ModemHWE.bin %LABEL%%CURTIME%
echo ModemHWE Danube build is done (%LABEL%).>mes
xcopy /V /I /S ..\..\Arc_Release\ModemHWE.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
xcopy /V /I /S ..\..\Arc_Release\Danube_*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex A\Binaries>>mes
set OK=YES
goto DANOK

:DANBLDERR

echo ModemHWE Danube hw build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_Danube_hw_build.log>".>mes
goto DANOK

:DANIMGERR

echo ModemHWE Danube hw build failed in generating image (%LABEL%).>mes

:DANOK

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto DAN_NO
smtpmail  -s"'Danube hw' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com<mes
goto DANNOCHK

:DAN_NO

smtpmail  -s"'Danube hw' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com<mes

:DANNOCHK

cd ..

REM Danube hw Annex B

cd modem_infx

if "%DANUBE_HW_AnnexB%" == "NO" goto BDANNOCHK
if "%DANUBE_HW_AnnexB%" == "No" goto BDANNOCHK
if "%DANUBE_HW_AnnexB%" == "no" goto BDANNOCHK

if exist ..\..\soc_src\modem\platform\checkpnt_label.c attrib ..\..\soc_src\modem\Platform\checkpnt_label.c -r
if exist ..\..\soc_src\modem\platform\checkpnt_label.c del ..\..\soc_src\modem\Platform\checkpnt_label.c
getcurtime.exe hex "char guca_checkpnt_label[] = \"%LABEL%__" \";>..\..\soc_src\modem\Platform\checkpnt_label.c

call build_danube_b_hw.bat

type ModemHWE.log > ModemHWE_Danube_B_hw_build.log

if exist .\obj\ModemHWE.out goto bdandone
echo Error: The ModemHWE.out was not built. >> ModemHWE_Danube_B_hw_build.log
goto bskipdan

:bdandone

rm -f -r ..\..\Arc_Release
if not exist ..\..\Arc_Release\* mkdir ..\..\Arc_Release
copy /v .\obj\ModemHWE.out ..\..\Arc_Release
copy /v .\obj\ModemHWE.bin ..\..\Arc_Release
copy /v .\map\ModemHWE_mem.xls ..\..\Arc_Release
copy /v .\map\ModemHWE.map ..\..\Arc_Release
xcopy /v /I /S .\obj\Danube_*.out ..\..\Arc_Release
xcopy /v /I /S .\obj\Danube_*.bin ..\..\Arc_Release

:bskipdan

if "%AUTOPOST%" == "" goto BDANNOCHK

xcopy /V /I /S ModemHWE_Danube_B_hw_build.log* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B"

set OK=NO
if not exist ..\..\Arc_Release\ModemHWE.out goto BDANBLDERR
if not exist ..\..\Arc_Release\ModemHWE.bin goto BDANIMGERR
type ..\..\soc_src\modem\Platform\checkpnt_label.c|sed 's/char guca_checkpnt_label\[\] = \".*__\(.*\)\";/set CURTIME=\1/'>set_env.bat
call set_env.bat
REM AppendString.exe ..\..\Arc_Release\ModemHWE.bin %LABEL%%CURTIME%
echo ModemHWE Annex B Danube build is done (%LABEL%).>mes
xcopy /V /I /S ..\..\Arc_Release\ModemHWE.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
xcopy /V /I /S ..\..\Arc_Release\Danube_*.* "X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries"
echo Log and binaries have been posted to the server:>>mes
echo X:\Dev Cocomo Release\ADSL - 6207\ARC_%LABEL%\Annex B\Binaries>>mes
set OK=YES
goto BDANOK

:BDANBLDERR
echo ModemHWE Danube Annex B hw build failed (%LABEL%). Please, see the file "<%BUILD_LOGS%\modem_infx\ModemHWE_Danube_B_hw_build.log>".>mes
goto BDANOK

:BDANIMGERR
echo ModemHWE Danube Annex B hw build failed in generating image (%LABEL%).>mes

:BDANOK

echo Regards,>>mes
echo RelEng>>mes

if "%OK%" == "NO" goto BDAN_NO
smtpmail  -s"'Danube Annex B hw' Build is Done (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com<mes
goto BDANNOCHK

:BDAN_NO

smtpmail  -s"'Danube Annex B hw' Build has Failed (automated e-mail)" "SocFirm@aware.com" RelEng@Aware.com<mes

:BDANNOCHK




cd ..

del set_env.bat
del modem_infx\mes
del modem\mes
del mes
set UP_DIR=
set SNDB_DIR=
set PC_NAME=
set BUILD_LOGS=

:CDNOCHK
