//CombineAdslVdslImage.sc
//
// History
//
//
//11/07/2013 Kannan : Implemented New Memory Layout Type - 2
//         It is common for both VR9 & VRX318.
//         Grep for "XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2"
//         

// XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (START)
// BOOT LOADER
// boot loader already loaded in the simulator memory at the start of cache
eval gl_StartOfCache = (long)&_StartOfFlash
eval gl_CurImageStart = gl_StartOfCache 
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

// VDSL CACHE
// attaching vdsl cache
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\vcpe\vcpe_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

//UPDATE VDSL CACHE header table
// updating loader header entry for VDSL CACHE SIZE
// offset set to beginning of VDSL cache
// size equals vdsl_cache in long words
eval *((long*)(gl_StartOfCache + 33*4)) = (gl_CurImageStart - gl_StartOfCache) //Offset in bytes to beginning of VDSL cache (ARC)
eval *((long*)(gl_StartOfCache + 34*4)) = (gl_CurImageStart - gl_StartOfCache)  //Offset in bytes to beginning of VDSL cache (FW-image)
eval *((long*)(gl_StartOfCache + 35*4)) = (gl_CurImageSize)  //Size in bytes


//UPDATE ADSL CACHE header table ARC access word offset 36
// updating loader header entry for ADSL CACHE SIZE
// word offset 36 = offset of boot loader size. 
eval *((long*)(gl_StartOfCache + 36*4)) = (gl_CurImageStart - gl_StartOfCache) //Offset in bytes to beginning of ADSL cache (ARC)

// ADSL CACHE
// attaching adsl cache
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\adsl_cpe_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

//UPDATE ADSL CACHE header table word offset 37 & 38
// updating loader header entry for ADSL CACHE SIZE
// offset set to beginning of ADSL cache
// size equals vdsl_cache in long words
eval *((long*)(gl_StartOfCache + 37*4)) = (gl_CurImageStart - gl_StartOfCache)  //Offset in bytes to beginning of ADSL cache (FW-image)
eval *((long*)(gl_StartOfCache + 38*4)) = (gl_CurImageSize)  //Size in bytes


//UPDATE VDSL FULL IMAGE header table offset 27
// updating VDSL header entry of the bootloader swap header table
//Page 4: Offset in bytes to beginning of VDSL image (ARC), i.e offset from 0x80000
eval *((long*)(gl_StartOfCache + 27*4)) = ((((gl_CurImageStart - gl_StartOfCache)/(64*1024))+1) * 64*1024) 


//VDSL FULL IMAGE
// attaching vdsl image
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\vcpe\vcpe_non_cache.bin
//file2mem (long*)(*((long*)&gl_CurImageStart)) obj\adsl_cpe_non_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

//UPDATE VDSL FULL IMAGE header table offset 28 & 29
// updating VDSL header entry of the bootloader swap header table
//Page 4: Offset in bytes to beginning of VDSL image (FW-image)
eval *((long*)(gl_StartOfCache + 28*4)) = (gl_CurImageStart - gl_StartOfCache)
eval *((long*)(gl_StartOfCache + 29*4)) = (gl_CurImageSize)  //Size in bytes


//ADSL FULL IMAGE
// attaching adsl image
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\adsl_cpe_non_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

//UPDATE ADSL FULL IMAGE header table offset 30, 31 & 32
// updating VDSL header entry of the bootloader swap header table
//Page 4: Offset in bytes to beginning of ADSL image (ARC), i.e offset from 0x80000
// ((int)((Size of boot loader + size of ADSL cache)/64K)+1)*64K
eval *((long*)(gl_StartOfCache + 30*4)) = ((( (*((long*)(gl_StartOfCache + 21*4)) + *((long*)(gl_StartOfCache + 38*4))) /(64*1024))+1) * 64*1024)
//Page 4: Offset in bytes to beginning of VDSL image (FW-image)
eval *((long*)(gl_StartOfCache + 31*4)) = (gl_CurImageStart - gl_StartOfCache)
eval *((long*)(gl_StartOfCache + 32*4)) = (gl_CurImageSize)  //Size in bytes


//Update word offset 19 to indicate the Firmware Meory Layout(FML) Type and FML types are 0, 1 & 2 as defined
//in the Jira DSLCPE_SW-723, FML Type 2 is reduce BAR usage in both VDSL & ADSL modes since
//BAR's are being reused across VDSL & ADSL modes.
//This is done as a part of boot loader

//Word offset 20: Size of debug data memory required for the Firmware and to be allocated by
//the MEI driver for BAR16 in words. Required memory = 512K bytes 
// reserved for DSL FW usage.
eval *((long*)(gl_StartOfCache + 20*4)) = (512*1024) //Size in bytes
// XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (END)

// updating the size field of the combined image
eval *((long*)gl_StartOfCache) = gl_CurImageEnd - gl_StartOfCache - 8
eval gl_CurImageSize = gl_CurImageEnd - gl_StartOfCache
mem2file &_StartOfFlash gl_CurImageSize   obj\adsl_vdsl_cpe.bin

exit
