#! /opt/TWWfsw/bin/python
# ImagePatch.py
# Author: R. Heilmann, 26.10.2018

import sys

patch_octets = [0,0,0,0]

print 'ImagePatch.py started ...'

if len(sys.argv) != 2:                          # check number of arguments
    print 'Wrong number of arguments !!!'
    print 'Usage: python ImagePatch.py <bin file>'
    print 'MyError: Wrong argument !!!'
    sys.exit(1)

# my own pattern:    
def generate_patch():
    global patch_octets
    patch_octets[0] = 0xCA    # start with 'CAFEBABE'
    patch_octets[1] = 0xFE
    patch_octets[2] = 0xBA
    patch_octets[3] = 0xBE
    
    for i in range(4,64*1024-4,4):
        patch_octets.append((patch_octets[i-4] + 5) % 256)    # add octet-wise prime numbers modulo 256
        patch_octets.append((patch_octets[i-3] + 11) % 256)
        patch_octets.append((patch_octets[i-2] + 19) % 256)
        patch_octets.append((patch_octets[i-1] + 29) % 256)
        
    patch_octets.append(0xDE)    # ends with 'DEADBEEF'
    patch_octets.append(0xAD)
    patch_octets.append(0xBE)
    patch_octets.append(0xEF)
    
    
# same pattern as old ImagePatch1.exe tool:    
def generate_patch_old():
    words = [0x02060A0F]
    for i in range(1,16*1024,1):
        words.append(words[i-1] + 0x01010101)
    #print words[-16:]
        
    global patch_octets
    patch_octets = []
    for word in words:
        patch_octets.append(word & 0xFF)
        patch_octets.append((word & 0xFF00) >> 8)
        patch_octets.append((word & 0xFF0000) >> 16)
        patch_octets.append((word & 0xFF000000) >> 24)
    

filename = sys.argv[1]

file = open(filename,'r+b')
bytes = bytearray(file.read())
# Update the binary size in the bin file (octets[0:3])
size = bytes[0] + (bytes[1] << 8) + (bytes[2] << 16) + (bytes[3] << 24)
size = size + 64*1024
bytes[0:4] = [(size & 0xFF), (size & 0xFF00) >> 8, (size & 0xFF0000) >> 16,(size & 0xFF000000) >> 24]
generate_patch_old()    # use the old pattern
# Append the patch bytes
for octet in patch_octets:
    bytes.append(octet)
file.seek(0)
file.write(bytes)
file.close()
           
print 'ImagePatch.py ended.'
