@echo off
rem **COPYRIGHT*****************************************************************
rem    INTEL CONFIDENTIAL
rem    Copyright (C) 2017 Intel Corporation
rem *****************************************************************COPYRIGHT**
rem **DISCLAIMER****************************************************************
rem  The source code contained or described herein and all documents related
rem  to the source code ("Material") are owned by Intel Corporation or its
rem  suppliers or licensors. Title to the Material remains with Intel
rem  Corporation or its suppliers and licensors. The Material may contain
rem  trade secrets and proprietary and confidential information of Intel
rem  Corporation and its suppliers and licensors, and is protected by
rem  worldwide copyright and trade secret laws and treaty provisions. No part
rem  of the Material may be used, copied, reproduced, modified, published,
rem  uploaded, posted, transmitted, distributed, or disclosed in any way
rem  without Intel's prior express written permission.
rem
rem  No license under any patent, copyright, trade secret or other
rem  intellectual property right is granted to or conferred upon you by
rem  disclosure or delivery of the Materials, either expressly, by
rem  implication, inducement, estoppel or otherwise. Any license under
rem  such intellectual property rights must be express and approved by
rem  Intel in writing.
rem ****************************************************************DISCLAIMER**
@echo on
if not "%ARC4DIR%" == "" (
    if "%ARC_OPT%" == "ARC4" set ARCDIR=%ARC4DIR%
)

if not "%ARC6DIR%" == "" (
    if "%ARC_OPT%" == "ARC6" set ARCDIR=%ARC6DIR%
)


	echo %ARC6DIR%
	echo %ARCDIR%

if "%ARCDIR%" == "" goto SET_ARCDIR_B4_BUILD

REM pause

setlocal

rem check for build info; if not the same with previous build, force a CLEAN_ALL


@echo @set TARGET_OPT=%TARGET_OPT%> .temp_build_info.txt
@echo @set TARGET_EXT=%TARGET_EXT%>> .temp_build_info.txt
@echo @set ITUX=%ITUX%>> .temp_build_info.txt
@echo @set ARC_OPT=%ARC_OPT%>> .temp_build_info.txt
@echo @set ARC6_VER=%ARC6_VER%>> .temp_build_info.txt
@echo @set CACHE_OPT=%CACHE_OPT%>> .temp_build_info.txt
@echo @set MEM_MAP=%MEM_MAP%>> .temp_build_info.txt
@echo @set LIB_VER=%LIB_VER%>> .temp_build_info.txt
@echo @set MSVC_CFG=%MSVC_CFG%>> .temp_build_info.txt
@echo @set AFE_OPT=%AFE_OPT%>> .temp_build_info.txt
@echo @set CODESWAP_CMD_INFILE=%CODESWAP_CMD_INFILE%>> .temp_build_info.txt
@echo @set CODESWAP_MEM_INFILE=%CODESWAP_MEM_INFILE%>> .temp_build_info.txt
@echo @set EXTRA_COMPILE_OPTIONS=%EXTRA_COMPILE_OPTIONS%>> .temp_build_info.txt
@echo @set ANNEX_B=%ANNEX_B%>> .temp_build_info.txt
@echo @set DR_DSL=%DR_DSL%>> .temp_build_info.txt
@echo @set IMAGE_TYPE=%IMAGE_TYPE%>> .temp_build_info.txt

if not exist .build_info.txt goto START_BUILD

fc .temp_build_info.txt .build_info.txt
if %ERRORLEVEL% NEQ 0 (
    .\gmake_3.80.exe -f project.mak CLEAN_ALL_EXCEPT_IMAGES
)

:START_BUILD
@if exist obj\%ITUX%%TARGET_EXT%.a del obj\%ITUX%%TARGET_EXT%.a
@if exist obj\%ITUX%%TARGET_EXT%.out del obj\%ITUX%%TARGET_EXT%.out
@if exist obj\%ITUX%%TARGET_EXT%.bin del obj\%ITUX%%TARGET_EXT%.bin
move .temp_build_info.txt .build_info.txt


:UPDATE_SRC_INC
.\gmake_3.80.exe  -f project.mak UPDATE_SRC_INC 
@if %ERRORLEVEL% NEQ 0 goto UPDATE_SRC_INC_FAIL

perl perl\sleep.pl 3

:SETUP_CODESWAP
.\gmake_3.80.exe  -f project.mak SET_UP_CODESWAP 
@if %ERRORLEVEL% NEQ 0 goto SET_UP_CODESWAP_FAIL

:CHECK_SOURCE_TIMESTAMPS_REBUILD
.\gmake_3.80.exe  -f project.mak CHECK_SOURCE_TIMESTAMPS FORCE_REBUILD=1
@if %ERRORLEVEL% NEQ 0 goto CHECK_SOURCE_TIMESTAMPS_FAIL

perl perl\sleep.pl 3

@if "%SKIP_BUILD_TIMESTAMP%" == "" (
    .\gmake_3.80.exe  -f project.mak BUILD_TIMESTAMP 
    @if %ERRORLEVEL% NEQ 0 goto BUILD_TIMESTAMP_FAIL
)

perl perl\sleep.pl 3

:UPDATE_ALL_RLS
.\gmake_3.80.exe  -f project.mak UPDATE_ALL_RLS 
@if %ERRORLEVEL% NEQ 0 goto RLS_FAIL_UPDATE

perl perl\sleep.pl 3

:CHECK_SOURCE_TIMESTAMPS_NO_REBUILD
.\gmake_3.80.exe  -f project.mak CHECK_SOURCE_TIMESTAMPS FORCE_REBUILD=0
@if %ERRORLEVEL% NEQ 0 goto CHECK_SOURCE_TIMESTAMPS_FAIL

perl perl\sleep.pl 3

:CODESWAP_MODEM
.\gmake_3.80.exe  -f project.mak CODESWAP_MODEM  > %ITUX%%TARGET_EXT%.log
:: .\gmake_3.80.exe  -f project.mak CODESWAP_MODEM
@if %ERRORLEVEL% NEQ 0 goto BUILD_MODEM_FAIL

@if not exist obj\%ITUX%%TARGET_EXT%.out goto BUILD_MODEM_FAIL
@if not exist obj\%ITUX%%TARGET_EXT%.bin goto BUILD_MODEM_FAIL

@echo          
@echo         !!! Successfully build the modem !!!
@echo
@echo

@dir obj\%ITUX%%TARGET_EXT%.out
@dir obj\%ITUX%%TARGET_EXT%.bin


goto END

:UPDATE_SRC_INC_FAIL
   @echo         ********************************************************************
   @echo         *** FAILED TO UPDATE *.SRC and *.INC files from MSVC *.DSP files ***
   @echo         ********************************************************************
   goto END_FAIL

:CHECK_SOURCE_TIMESTAMPS_FAIL
   @echo         **************************************************
	@echo         *** FAILED TO CHECK TIMESTAMPS ON SOURCE FILES ***
   @echo         **************************************************   
	goto END_FAIL

:SET_UP_CODESWAP_FAIL
   @echo         *******************************************
	@echo         *** FAILED TO setting up codeswap build ***
   @echo         *******************************************
	goto END_FAIL

:RLS_FAIL_UPDATE
   @echo         ************************************
   @echo         *** FAILED TO update *.RLS files ***
   @echo         ************************************
   goto END_FAIL

:BUILD_MODEM_FAIL
   @echo         ***********************************
   @echo         *** FAILED TO build modem image ***
   @echo         ***********************************
   goto END_FAIL

:BUILD_TIMESTAMP_FAIL
   @echo         ************************************
	@echo         *** FAILED TO generate TIMESTAMP ***
   @echo         ************************************   
	goto END_FAIL

:SET_ARCDIR_B4_BUILD
    @if exist obj\%ITUX%%TARGET_EXT%.out del obj\%ITUX%%TARGET_EXT%.out
    @if exist obj\%ITUX%%TARGET_EXT%.bin del obj\%ITUX%%TARGET_EXT%.bin
   @echo         ********************************************************
   @echo         *** set ARCDIR env variable before running the build ***
   @echo         ********************************************************
    goto END_FAIL

:END_FAIL
@EXIT /B 1

:END


