@echo off
rem **COPYRIGHT*****************************************************************
rem    INTEL CONFIDENTIAL
rem    Copyright (C) 2017 Intel Corporation
rem *****************************************************************COPYRIGHT**
rem **DISCLAIMER****************************************************************
rem  The source code contained or described herein and all documents related
rem  to the source code ("Material") are owned by Intel Corporation or its
rem  suppliers or licensors. Title to the Material remains with Intel
rem  Corporation or its suppliers and licensors. The Material may contain
rem  trade secrets and proprietary and confidential information of Intel
rem  Corporation and its suppliers and licensors, and is protected by
rem  worldwide copyright and trade secret laws and treaty provisions. No part
rem  of the Material may be used, copied, reproduced, modified, published,
rem  uploaded, posted, transmitted, distributed, or disclosed in any way
rem  without Intel's prior express written permission.
rem
rem  No license under any patent, copyright, trade secret or other
rem  intellectual property right is granted to or conferred upon you by
rem  disclosure or delivery of the Materials, either expressly, by
rem  implication, inducement, estoppel or otherwise. Any license under
rem  such intellectual property rights must be express and approved by
rem  Intel in writing.
rem ****************************************************************DISCLAIMER**
@echo on
REM=================================================================
REM      build_danube_hw.bat
REM
REM	Top level script for building the Annex B binary for the Danube target HW.
REM========================================================================

setlocal

@if /I "%1" == "no_timestamp" set SKIP_BUILD_TIMESTAMP=%1

set TARGET_OPT=TARGET_HW

rem for asim build the extension will be SIM, for HW build, it's null
set TARGET_EXT=

set ITUX=ModemHWE


rem Processor and cache type; for ARC4 (4) and ARC6 (6)
set ARC_OPT=ARC6
set ARC6_VER=8_2
set CACHE_OPT=USE_CACHE

rem to be changed
set MEM_MAP=ADSL_62_MEM

rem HW EngineLib Version: SOC and STRATIFY lib=3.0, HERC lib=5.0
set LIB_VER=6.2
set MSVC_CFG="Release 62"

rem AFE specific
set AFE_OPT=VR9_AFE

rem gmake -f project.mak test

rem passing *.cmd file for sleep build
set CODESWAP_CMD_INFILE=harvardArch_biscs.cmd

rem to be changed.
set CODESWAP_MEM_INFILE=ADSL_62.mem

rem ANNEX-B
set EXTRA_COMPILE_OPTIONS=-DHERC_API -DVRX218 -DADSL_VDSL_MODE_SWITCH


@if "%IMAGE_TYPE%" EQU "ADSL_ONLY" (
    @cp -f obj\vcpe\empty_vcpe_cache.bin obj\vcpe\vcpe_cache.bin
) else (
    @cp -f obj\vcpe\released_vcpe_cache.bin obj\vcpe\vcpe_cache.bin
    @cp -f obj\vcpe\released_vcpe_non_cache.bin obj\vcpe\vcpe_non_cache.bin
)

call .\build_codeswap_hw.bat
@if errorlevel 1 goto END_FAIL

@if not exist obj\%ITUX%%TARGET_EXT%.out goto END
@if not exist obj\%ITUX%%TARGET_EXT%.bin goto END

python.exe .\ImagePatch.py obj\%ITUX%%TARGET_EXT%.bin

@if "%IMAGE_TYPE%" NEQ "ADSL_ONLY" (
    call build_adslvdsl_image.bat

    rem temporary work-around for the SRAM byte reversal problem
    if exist "obj\adsl_vdsl_cpe.bin" python.exe .\ImagePatch.py obj\adsl_vdsl_cpe.bin

    rem this part of scrip will search adsl_cpe_non_cache.bin and vcpe_non_cache.bin for
    rem their FW version string. Then copy adsl_vdsl_cpe.bin to the new file name formed
    rem by combining the two version strings.

    if exist "obj\adsl_vdsl_cpe.bin" perl perl\version_combined_bin_file.pl obj\vcpe\vcpe_non_cache.bin obj\adsl_cpe_non_cache.bin
)

rem Copy ModemHWE.bin & ModemHWE.out to new names with version info attached
rem perl perl\gen_target_version_VR9.pl VR9
GOTO END

:END_FAIL
@EXIT /B 1

:END
