# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
MEMORY {
//***********************************************************
//***************** Customer Swap pages *********************
// Attention! These pages are not fragmented in 4k blocks !!!!

   // IFX Overlays
   //Resident Memory
   CUST_MAIN_IRAM:              ORIGIN = ADDR(IRAM) + SIZEOF(IRAM), LENGTH = 21*1K

   //Codeswap Memory for config 1
   CUST_ISWAP_CUST_1:           ORIGIN = ADDR(CUST_MAIN_IRAM) + SIZEOF(CUST_MAIN_IRAM), LENGTH = 3*1K

   //Codeswap Memory for config 2
   CUST_ISWAP_CUST_2:           ORIGIN = ADDR(CUST_ISWAP_CUST_1) + SIZEOF(CUST_ISWAP_CUST_1), LENGTH = 3*1K

   //Codeswap Memory showtime / reset
   CUST_ISWAP_STEADY_RESET:     ORIGIN = ADDR(CUST_ISWAP_CUST_2) + SIZEOF(CUST_ISWAP_CUST_2), LENGTH = 9*1K

//***********************************************************
//***********************************************************

        __CUST_IBRAM__ :         ORIGIN = ADDR(CUST_IBRAM), LENGTH = SIZEOF(CUST_IBRAM)
        __CUST_MAIN_ISWAP__:     ORIGIN = ADDR(CUST_IRAM),  LENGTH = SIZEOF(CUST_IRAM)
        __CUST_1_ISWAP__:        ORIGIN = ADDR(CUST_ISWAP_CUST_1), LENGTH = SIZEOF(CUST_ISWAP_CUST_1)
        __CUST_2_ISWAP__:        ORIGIN = ADDR(CUST_ISWAP_CUST_2), LENGTH = SIZEOF(CUST_ISWAP_CUST_2)
        __CUST_RESET_ISWAP__:    ORIGIN = ADDR(CUST_ISWAP_STEADY_RESET), LENGTH = SIZEOF(CUST_ISWAP_STEADY_RESET)
        __CUST_STEADY_ISWAP__:   ORIGIN = ADDR(CUST_ISWAP_STEADY_RESET), LENGTH = SIZEOF(CUST_ISWAP_STEADY_RESET)
        __CUST_TEST_ISWAP__:     ORIGIN = ADDR(CUST_ISWAP_CUST_2), LENGTH = SIZEOF(CUST_ISWAP_CUST_2)
}

SECTIONS {
   // Only present in reset state
   GROUP LOAD((ADDR(VCPE_CUST_RESET_FADX_PM_BT))): {
      .VCPE_CUST_RESET_PMSWAP ALIGN(4): {
      }
   } > __CUST_RESET_ISWAP__


   // Only present in showtime
   GROUP LOAD((ADDR(VCPE_CUST_STEADY_FADX_PM))): {
      .VCPE_CUST_STEADY_PMSWAP ALIGN(4): {
      }
   } > __CUST_STEADY_ISWAP__

   GROUP LOAD((ADDR(VCPE_CUST_TEST_FADX_PM))): {
      .VCPE_CUST_TEST_PMSWAP ALIGN(4): {
      }
   } > __CUST_TEST_ISWAP__  


      // Config 1: xMII, MAC, EFM, HDLC
   GROUP LOAD((ADDR(VCPE_CUST_1_FADX_PM))): {
      .VCPE_CUST_1_PMSWAP ALIGN(4): {

      }
   } > __CUST_1_ISWAP__


   // Config 2: Utopia, POS-PHY, ATM
   GROUP LOAD((ADDR(VCPE_CUST_2_FADX_PM_BT))): {
      .VCPE_CUST_2_PMSWAP ALIGN(4): {

      }
   } > __CUST_2_ISWAP__


   // Resident (always present)
   GROUP LOAD((ADDR(VCPE_CUST_MAIN_FADX_PM_BT))): {
      .VCPE_CUST_MAIN_PMSWAP ALIGN(4): {
//
            ConfigXtcIfRxPath.o(.text)
            ConfigXtcIfTxPath.o(.text)
            CustomerTasks.o(.text)
      }
   } > __CUST_MAIN_ISWAP__


   // Data memory (should contain all files)
   GROUP LOAD((ADDR(VCPE_CUST_IBRAM_FADX_DM_BT))): {
      .VCPE_CUST_IBRAM_DMSWAP ALIGN(4) : {
//         afe_if_dd.o(.data)
//         afeini.o(.data)
         ConfigXtcIfRxPath.o(.data)
         ConfigXtcIfTxPath.o(.data)
         CustomerTasks.o(.data)

         ConfigXtcIfRxPath.o(.bss)
         ConfigXtcIfTxPath.o(.bss)
         CustomerTasks.o(.bss)
      }
   } > __CUST_IBRAM__
}
