# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
//****************************************************************************


//harvardArch_biscs.cmd
//
// History
//

// 17/11/2010 Balabath:
//          1. Moved some functions from SHOW to SHOW2
//                           Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 21/11/2011 Hanyu: Added MFD state to integrate MFD state functions to VRx "SLEEP" state.
//   Grep for XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect
//
//09/02/2012 Balabath: Jira XDSLRTFW-415 changes has HNSHK1_CODE_MEM memory crunch
//                     So moved hndshk1.o(.text)  to Cache
//            For code changes grep for "XDSLRTFW-415 Enh_all_all_STAT1_update"
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 27/11/2012 Kannan:
// VRX318 specific changes:
// (1) Introduced 2 new code swap pages for VRX318 to keep the
// functions which was available in cache at VR9.
// (i)Page "RES_1PORT_FADX_PM_BT" to keep cache resident functions.
//    (ii) Page "SHOW_1PORT_FADX_PM" to keep showtime only related functions.
// (2) Moved the functions from cache to newly introduced  code swap pages. Newly introduced
//     CS pages are common to both VR9 & VRX318, since VR9 doesn't support on chip bonding. So
//     VR9 is also allowed use other port memory.
// (3) For VRX318 "CACHE" is equivalent to  PDBRAM.
// (4) Total memory size of PDBRAM is 140K
// (5) BG_CACHE_1 page is allowed to use 96K of PDBRAM, this memory is fully available for VRX318
// (6) BG_CACHE_2 page is allowed to use upto 44K (S_44K) of PDBRAM only during training and in showtime
//     S_44K memory will be used by PPE for data traffic. Hence we should not keep showtime related
//     functions in S_44K memory. Memory Section "ARC_PPE_SHARED_CACHE" is already defined in
//     VRX318_ADSL_62.mem
// (7) #ifdef VRX318 is used to have VRX318 specific changes. DSL accelerator cores of VRX318
//     is almost the same as in VR9.
// Grep VRX318 specific changes "XDSLRTFW-541: Platform_VRX318"  &
// Grep VR9 & VRX318 common changes "XDSLRTFW-541: Platform_VR9_VRX318"
// 16/05/2013: Kannan
//    AdcTrimming.c & VR9_Afe.c functions are moved from External (VR9)/PDBRAM(VRX318)
//    to IIBRAM to execute faster, since some of the functions in adc trimming
//    needs to executed as fast as possible.
//    Grep for "XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException"
// 16/07/2013: Ram - Added fix for Micro filter dection failure in FW 5.6.0.F.3.1_010E
//                   File STR_ReconfigDecim2_HPF.o (function ReconfigDecim2_HPF() is being called
//                   during Microfilter detection) is not present in page SLEEP_PMSWAP leading to CODE CRASH !!
//                   Grep for: XDSLRTFW-1089: Bugfix_ALL_ALL_ALL_MicroFilterDetectionFails
// 07/03/2018: Ram: Increased memory allocated to PM,DM sections by utilizing addtional memory
//                  availalble in VRx518. Made sure that max occupancy is less than 90%.
//                  * Removed unused memory section VRX318_SHOW_2 
//                  * Removed memory section PILOT_518_RAM, page BULK_O10. Variables originally
//                    in this page moved to BULK_DATA_RAM2.
//                  * Moved files from BG_CACHE_1 to BG_CACHE_2 to make sure that occupancy level of
//                    BG_CACHE_1 is less than 90%
//*****************************************************************************************
// NOTE: any comment line with the identifier CODESWAP_LABEL is used by the codeswap build tools
// modify with caution

// Overview of Socrates memory map
// 0x00000 - 0x0FFFF    64K    Instruction Memory
// 0x10000 - 0x15FFF    24K    Bulk Data Memory
// 0x16000 - 0x17FFF    8K    Unused
// 0x18000 - 0x19FFF    8K    X Memory
// 0x1A000 - 0x1BFFF    8K    Y Memory
// 0x1C000 - 0x1C3FF    1K    MEI Memory
// 0x1C400 - 0x2BFFF    64K    Unused
// 0x2C000 - 0x4FFFF    196K    ADSL Accelerator (ADSL Memory Map)
// 0x50000 - 0xFDFFF    712K    Unused
// 0xFE000 - 0xFFFFF    8K    Local Load/Store Memory

#ifdef STRAT_MEM
    #include "STRATIPHY.mem"
#endif

#ifdef DANUBE_MEM
    #include "DANUBE.mem"
#endif

#ifdef AMAZON_SE_MEM
    #include "AMAZON_SE.mem"
#endif

#ifdef HERCULES_MEM
    #include "HERCULES.mem"
#endif

#ifdef ADSL_62_MEM
    #include "ADSL_62.mem"
#endif

//XDSLRTFW-541: Platform_VRX318 (START)
#ifdef VRX318_ADSL_62_MEM
    #include "VRX318_ADSL_62.mem"
#endif
//XDSLRTFW-541: Platform_VRX318 (END)

#ifdef VRX518_ADSL_62_MEM
    #include "VRX518_ADSL_62.mem"
#endif

MEMORY {

//
// Swap Pages and their link time addresses
//
    // interrupt vector and isr
    INTR_CODE_MEM:           ORIGIN = ADDR(CK)    LENGTH = SIZEOF(CK)



    //
    // overlay group 1
    //
    R_NOSHOW_CODE_MEM:       ORIGIN = ADDR(CI_1)    LENGTH = SIZEOF(CI_1)

    SHOWBG2_CODE_MEM:        ORIGIN = ADDR(CI_2)    LENGTH = SIZEOF(CI_2)

    RES_CODE_MEM:            ORIGIN = ADDR(CA)      LENGTH = SIZEOF(CA)

    //
    // overlay group 2.0
    //
    //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
    //INIT_CODE_MEM:           ORIGIN = ADDR(CB_1)    LENGTH = SIZEOF(CB_1)
    //SHOW_1PORT Page will swaped in after link activation, i.e CNTL 0 0 2,
    //Initialization related functions will be swap in before link activation which
    //is available in the page "INIT" Page, hence "SHOW_1PORT" memory
    //can be used for Initialization.
    INIT_CODE_MEM:           ORIGIN = ADDR(SHOW_1PORT)    LENGTH = SIZEOF(SHOW_1PORT)
    //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)

    //
    // overlay group 2.1
    //
    HNSHK1_CODE_MEM:         ORIGIN = ADDR(CM_1)    LENGTH = SIZEOF(CM_1)
    //XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
    //SLEEP_CODE_MEM:          ORIGIN = ADDR(CM_2)    LENGTH = SIZEOF(CM_2)
    SLEEP_CODE_MEM:          ORIGIN = ADDR(CB_1)    LENGTH = SIZEOF(CB_1)  //Same length as Init page length.

    HWTESTS_1_CODE_MEM:      ORIGIN = ADDR(CM_3)    LENGTH = SIZEOF(CM_3)
    ATM_LOOPBACK_MEM:        ORIGIN = ADDR(CM_4)    LENGTH = SIZEOF(CM_4)
    MTE_FCI_LOOPBACK:        ORIGIN = ADDR(CM_5)    LENGTH = SIZEOF(CM_5)

    HNSHK2_CODE_MEM:         ORIGIN = ADDR(CN_1)    LENGTH = SIZEOF(CN_1)
    MODEM_TEST_CODE_MEM:     ORIGIN = ADDR(CN_2)    LENGTH = SIZEOF(CN_2)

    //
    // overlay group 2.2
    //
    R_NOGHS_CODE_MEM:        ORIGIN = ADDR(CJ_1)    LENGTH = SIZEOF(CJ_1)

    XCVR0_CODE_MEM:          ORIGIN = ADDR(CC_1)    LENGTH = SIZEOF(CC_1)
    DISC1_CODE_MEM:          ORIGIN = ADDR(CC_2)    LENGTH = SIZEOF(CC_2)
    DISC3_CODE_MEM:          ORIGIN = ADDR(CC_3)    LENGTH = SIZEOF(CC_3)
    XCVR1EXT_CODE_MEM:       ORIGIN = ADDR(CC_4)    LENGTH = SIZEOF(CC_4)
    ANAL_CODE_MEM:           ORIGIN = ADDR(CC_5)    LENGTH = SIZEOF(CC_5)
    TDQTEST_CODE_MEM:        ORIGIN = ADDR(CC_6)    LENGTH = SIZEOF(CC_6)
    EXCH1_CODE_MEM:          ORIGIN = ADDR(CC_7)    LENGTH = SIZEOF(CC_7)
    SHOW1_CODE_MEM:          ORIGIN = ADDR(CC_8)    LENGTH = SIZEOF(CC_8)
    ANL1DMT_CODE_MEM:        ORIGIN = ADDR(CC_9)    LENGTH = SIZEOF(CC_9)
    BTLDDMT1_CODE_MEM:       ORIGIN = ADDR(CC_a)    LENGTH = SIZEOF(CC_a)
    SHT1DMT_CODE_MEM:        ORIGIN = ADDR(CC_b)    LENGTH = SIZEOF(CC_b)

    //
    // overlay group 2.2.0
    //
    DISC2_CODE_MEM:          ORIGIN = ADDR(CD_1)    LENGTH = SIZEOF(CD_1)
    XCVR1_CODE_MEM:          ORIGIN = ADDR(CD_2)    LENGTH = SIZEOF(CD_2)
    XCVR2_CODE_MEM:          ORIGIN = ADDR(CD_3)    LENGTH = SIZEOF(CD_3)
    MTDQ_CODE_MEM:           ORIGIN = ADDR(CD_4)    LENGTH = SIZEOF(CD_4)
    XCVRDMT_CODE_MEM:        ORIGIN = ADDR(CD_5)    LENGTH = SIZEOF(CD_5)


    //
    // overlay group 2.2.1
    //
    RXINIT_CODE_MEM:         ORIGIN = ADDR(CG_1)    LENGTH = SIZEOF(CG_1)

    EXCH3_CODE_MEM:          ORIGIN = ADDR(CG_2)    LENGTH = SIZEOF(CG_2)
    EXCHDMT_CODE_MEM:        ORIGIN = ADDR(CG_3)    LENGTH = SIZEOF(CG_3)


    SHOWBG1_CODE_MEM:        ORIGIN = ADDR(CG_4)    LENGTH = SIZEOF(CG_4)
    SHOWBG1DMT_CODE_MEM:     ORIGIN = ADDR(CG_5)    LENGTH = SIZEOF(CG_5)


    TXINIT_CODE_MEM:         ORIGIN = ADDR(CH_1)    LENGTH = SIZEOF(CH_1)
    EXCH2_CODE_MEM:          ORIGIN = ADDR(CH_2)    LENGTH = SIZEOF(CH_2)
    SHOW2_CODE_MEM:          ORIGIN = ADDR(CH_3)    LENGTH = SIZEOF(CH_3)
    SHT2DMT_CODE_MEM:        ORIGIN = ADDR(CH_4)    LENGTH = SIZEOF(CH_4)
    BTLD_CODE_MEM:           ORIGIN = ADDR(CH_5)    LENGTH = SIZEOF(CH_5)
    BTLDDMT_CODE_MEM:        ORIGIN = ADDR(CH_6)    LENGTH = SIZEOF(CH_6)

    //XDSLRTFW-541: Platform_VR9_VRX318 (START)
    //Resident cache partition, using 2nd port memory
    RES_1PORT_MEM:     ORIGIN = ADDR(RES_1PORT)     LENGTH = SIZEOF(RES_1PORT)
//NEW MEMORY SECTION defined in VRx318 XDSLRTFW-1727
#ifndef VRX218
    VRX318_SHOW_1_MEM: ORIGIN = ADDR(VRX318_SHOW_1)     LENGTH = SIZEOF(VRX318_SHOW_1)
#endif
    SHOW_1PORT_MEM:    ORIGIN = ADDR(SHOW_1PORT)    LENGTH = SIZEOF(SHOW_1PORT)
    //XDSLRTFW-541: Platform_VR9_VRX318 (END)

    // cache page
    BG_CACHE_1_CODE_MEM:     ORIGIN = ADDR(BG_CACHE_1)  LENGTH = SIZEOF(BG_CACHE_1)
    BG_CACHE_2_CODE_MEM:     ORIGIN = ADDR(BG_CACHE_2)  LENGTH = SIZEOF(BG_CACHE_2)

    //
    // Data Pages and their link time addresses
    //
    //SECRODATA_DATA_MEM:    ORIGIN = ADDR(DA)    LENGTH = SIZEOF(DA)
    BIS_RAM:                 ORIGIN = ADDR(DA)    LENGTH = SIZEOF(DA)
    DMT_RAM:                 ORIGIN = ADDR(DA)    LENGTH = SIZEOF(DA)

    BULK_O1:                 ORIGIN = ADDR(DB)    LENGTH = SIZEOF(DB)
    BULK_O2:                 ORIGIN = ADDR(DB)    LENGTH = SIZEOF(DB)

    //
    // swap pages and their addresses/offsets inside the .bin image
    //
#ifdef ADSL_62
    ADSL_IMAGE_HEADER_FADX:     ORIGIN = 0x00400800, LENGTH = SIZEOF(.ADSL_IMAGE_HEADER)


#endif

    // show and show init pages
    SHOW1_FADX_PM:
                        LENGTH = (((SIZEOF(.SHOW1_PMSWAP)+ 3)/4)*4)
    SHOW2_FADX_PM:
                        LENGTH = (((SIZEOF(.SHOW2_PMSWAP)+ 3)/4)*4)
    TXINIT_FADX_PM:
                        LENGTH = (((SIZEOF(.TXINIT_PMSWAP)+ 3)/4)*4)
    SHOWBG1_FADX_PM:
                        LENGTH = (((SIZEOF(.SHOWBG1_PMSWAP)+ 3)/4)*4)
    SHOWBG2_FADX_PM:
                        LENGTH = (((SIZEOF(.SHOWBG2_PMSWAP)+ 3)/4)*4)
    SHOWBG1DMT_FADX_PM:
                        LENGTH = (((SIZEOF(.SHOWBG1DMT_PMSWAP)+ 3)/4)*4)
    SHT1DMT_FADX_PM:
                        LENGTH = (((SIZEOF(.SHT1DMT_PMSWAP)+ 3)/4)*4)
    SHT2DMT_FADX_PM:
                        LENGTH = (((SIZEOF(.SHT2DMT_PMSWAP)+ 3)/4)*4)

    // training pages
    HNSHK1_FADX_PM:
                        LENGTH = (((SIZEOF(.HNSHK1_PMSWAP)+ 3)/4)*4)
    HNSHK2_FADX_PM:
                        LENGTH = (((SIZEOF(.HNSHK2_PMSWAP)+ 3)/4)*4)
    XCVR0_FADX_PM:
                        LENGTH = (((SIZEOF(.XCVR0_PMSWAP)+ 3)/4)*4)
    DISC1_FADX_PM:
                        LENGTH = (((SIZEOF(.DISC1_PMSWAP)+ 3)/4)*4)
    DISC2_FADX_PM:
                        LENGTH = (((SIZEOF(.DISC2_PMSWAP)+ 3)/4)*4)
    DISC3_FADX_PM:
                        LENGTH = (((SIZEOF(.DISC3_PMSWAP)+ 3)/4)*4)
    XCVR1_FADX_PM:
                        LENGTH = (((SIZEOF(.XCVR1_PMSWAP)+ 3)/4)*4)
    XCVR1EXT_FADX_PM:
                        LENGTH = (((SIZEOF(.XCVR1EXT_PMSWAP)+ 3)/4)*4)
    XCVR2_FADX_PM:
                        LENGTH = (((SIZEOF(.XCVR2_PMSWAP)+ 3)/4)*4)
    ANAL_FADX_PM:
                        LENGTH = (((SIZEOF(.ANAL_PMSWAP)+ 3)/4)*4)
    ANL1DMT_FADX_PM:
                        LENGTH = (((SIZEOF(.ANL1DMT_PMSWAP)+ 3)/4)*4)
    MTDQ_FADX_PM:
                        LENGTH = (((SIZEOF(.MTDQ_PMSWAP)+ 3)/4)*4)
    TDQTEST_FADX_PM:
                        LENGTH = (((SIZEOF(.TDQTEST_PMSWAP)+ 3)/4)*4)
    BTLD_FADX_PM:
                        LENGTH = (((SIZEOF(.BTLD_PMSWAP)+ 3)/4)*4)
    BTLDDMT_FADX_PM:
                        LENGTH = (((SIZEOF(.BTLDDMT_PMSWAP)+ 3)/4)*4)
    BTLDDMT1_FADX_PM:
                        LENGTH = (((SIZEOF(.BTLDDMT1_PMSWAP)+ 3)/4)*4)
    RXINIT_FADX_PM:
                        LENGTH = (((SIZEOF(.RXINIT_PMSWAP)+ 3)/4)*4)
    EXCH1_FADX_PM:
                        LENGTH = (((SIZEOF(.EXCH1_PMSWAP)+ 3)/4)*4)
    EXCH2_FADX_PM:
                        LENGTH = (((SIZEOF(.EXCH2_PMSWAP)+ 3)/4)*4)
    EXCH3_FADX_PM:
                        LENGTH = (((SIZEOF(.EXCH3_PMSWAP)+ 3)/4)*4)
    EXCHDMT_FADX_PM:
                        LENGTH = (((SIZEOF(.EXCHDMT_PMSWAP)+ 3)/4)*4)
    R_NOGHS_FADX_PM:
                        LENGTH = (((SIZEOF(.R_NOGHS_PMSWAP)+ 3)/4)*4)
//XDSLRTFW-1727
  #ifndef VRX218
   VRX318_SHOW_1_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.VRX318_SHOW_1_PMSWAP)+ 3)/4)*4)
  #endif

   //XDSLRTFW-541: Platform_VR9_VRX318 (START)
   SHOW_1PORT_FADX_PM:
                        LENGTH = (((SIZEOF(.SHOW_1PORT_PMSWAP)+ 3)/4)*4)
   //XDSLRTFW-541: Platform_VR9_VRX318 (END)

    SLEEP_FADX_PM:
                        LENGTH = (((SIZEOF(.SLEEP_PMSWAP)+ 3)/4)*4)
    MODEM_TEST_FADX_PM:
                        LENGTH = (((SIZEOF(.MODEM_TEST_PMSWAP)+ 3)/4)*4)
    HWTESTS_1_FADX_PM:
                        LENGTH = (((SIZEOF(.HWTESTS_1_PMSWAP)+ 3)/4)*4)
    ATM_LOOPBACK_FADX_PM:
                        LENGTH = (((SIZEOF(.ATM_LOOPBACK_PMSWAP)+ 3)/4)*4)
    MTE_FCI_LOOPBACK_FADX_PM:
                        LENGTH = (((SIZEOF(.MTE_FCI_LOOPBACK_PMSWAP)+ 3)/4)*4)

    XCVRDMT_FADX_PM:
                        LENGTH = (((SIZEOF(.XCVRDMT_PMSWAP)+ 3)/4)*4)

    DMT_RAM_FADX_DM:
                        LENGTH = (((SIZEOF(.DMT_RAM_DMSWAP)+ 3)/4)*4)
    BULK_O1_FADX_DM:
                        LENGTH = (((SIZEOF(.BULK_O1_DMSWAP)+ 3)/4)*4)

    GHS_TO_SHOW_FADX_DM:
                        LENGTH = (((SIZEOF(.GHS_TO_SHOW_DMSWAP)+ 3)/4)*4)

#ifdef ADSL_62

    ZEP_TX_UCODE_ADSL2_2BC_FADX_DM_BT:
                                LENGTH = (((SIZEOF(.ZEP_TX_UCODE_ADSL2_2BC_DMSWAP)+ 3)/4)*4)

    ZEP_RX_UCODE_ADSL2_2BC_FADX_DM_BT:
                                LENGTH = (((SIZEOF(.ZEP_RX_UCODE_ADSL2_2BC_DMSWAP)+ 3)/4)*4)

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
    ZEP_RX_RETX_LP1_UCODE_FADX_DM:
                                LENGTH = (((SIZEOF(.ZEP_RX_RETX_LP1_UCODE_DMSWAP)+ 3)/4)*4)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)


    ZEP_TX_UCODE_ADSL1_LP0_FADX_DM:
                                LENGTH = (((SIZEOF(.ZEP_TX_UCODE_ADSL1_LP0_DMSWAP)+ 3)/4)*4)

    ZEP_RX_UCODE_ADSL1_LP0_FADX_DM:
                                LENGTH = (((SIZEOF(.ZEP_RX_UCODE_ADSL1_LP0_DMSWAP)+ 3)/4)*4)

    ZEP_TX_UCODE_ADSL1_LP1_FADX_DM:
                                LENGTH = (((SIZEOF(.ZEP_TX_UCODE_ADSL1_LP1_DMSWAP)+ 3)/4)*4)

    ZEP_RX_UCODE_ADSL1_LP1_FADX_DM:
                                LENGTH = (((SIZEOF(.ZEP_RX_UCODE_ADSL1_LP1_DMSWAP)+ 3)/4)*4)

#endif

    // boot pages
    INTR_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.INTR_PMSWAP)+ 3)/4)*4)
    RES_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.RES_PMSWAP)+ 3)/4)*4)

   //XDSLRTFW-541: Platform_VR9_VRX318 (START)
   RES_1PORT_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.RES_1PORT_PMSWAP)+ 3)/4)*4)
   //XDSLRTFW-541: Platform_VR9_VRX318 (END)

#ifdef ADSL_62
    ADSL_62_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.ADSL_62_PMSWAP)+ 3)/4)*4)
#endif
    R_NOSHOW_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.R_NOSHOW_PMSWAP)+ 3)/4)*4)
    INIT_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.INIT_PMSWAP)+ 3)/4)*4)
    BIS_RAM_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.BIS_RAM_DMSWAP)+ 3)/4)*4)
    BULK_O2_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.BULK_O2_DMSWAP)+ 3)/4)*4)

//PILOT_CAPTURE_518
    BULK_DATA_RAM_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.BULK_DATA_RAM_DMSWAP)+ 3)/4)*4)
    BULK_DATA_RAM2_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.BULK_DATA_RAM2_DMSWAP)+ 3)/4)*4)
    ONE_PORT_DEBUG_DATA_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.ONE_PORT_DEBUG_DATA_DMSWAP)+ 3)/4)*4)
    ILV1_GHS_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.ILV1_GHS_DMSWAP)+ 3)/4)*4)
    ILV2_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.ILV2_DMSWAP)+ 3)/4)*4)
    deILV_PTR_SPACE_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.deILV_PTR_SPACE_DMSWAP)+ 3)/4)*4)
    deILV1_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.deILV1_DMSWAP)+ 3)/4)*4)
    deILV2_BISDBG_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.deILV2_BISDBG_DMSWAP)+ 3)/4)*4)
    deILV3_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.deILV3_DMSWAP)+ 3)/4)*4)
#ifndef ADSL_62
    XDMA_TEST_FADX_PM:
                        LENGTH = (((SIZEOF(.XDMA_TEST_PMSWAP)+ 3)/4)*4)
#endif

#ifdef ADSL_62

    STR_IIR_COEFS_FADX_DM_BT:
                                LENGTH = (((SIZEOF(.STR_IIR_COEFS_DMSWAP)+ 3)/4)*4)

    SHOW_N_TRAIN_FADX_DM_BT:
                                LENGTH = (((SIZEOF(.SHOW_N_TRAIN_DMSWAP)+ 3)/4)*4)

    SRC_COEFS_4KHZ_FADX_DM_BT:
                        LENGTH = ((SIZEOF(.SRC_COEFS_4KHZ_DMSWAP)+ 3)/4)*4;

    HMP_MBOXES_FADX_DM_BT:
                         LENGTH = (((SIZEOF(.HMP_MBOXES_DMSWAP)+ 3)/4)*4)
   HMP_BUFFERS_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.HMP_BUFFERS_DMSWAP)+ 3)/4)*4)



#endif

#ifdef TARGET_ASIM
    SIM_IRAM_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.SIM_IRAM_PMSWAP)+ 3)/4)*4)
    SIM_RAM_FADX_DM_BT:
                        LENGTH = (((SIZEOF(.SIM_RAM_DMSWAP)+ 3)/4)*4)
#endif

    BG_CACHE_2_FADX_PM_BT:
                        LENGTH = (((SIZEOF(.BG_CACHE_2_PMSWAP)+ 3)/4)*4);


#ifdef ADSL_62
    ADSL_CACHE_HEADER_FADX:
                                LENGTH = ((SIZEOF(.ADSL_CACHE_HEADER)+ 3)/4)*4;
    BG_CACHE_1_FADX:
                        LENGTH = (((SIZEOF(.BG_CACHE_1_PMSWAP)+ 3)/4)*4);
#endif

    LAST_FADX:
                        LENGTH = 0

}

SECTIONS {

    GROUP LOAD(ADDR(INTR_FADX_PM_BT)) : {
        .INTR_PMSWAP: {
#ifdef ADSL_62
            interrupts_62.o(.INTVECS)
#else
            int_tables.o(.text)
#endif
        }
    } > INTR_CODE_MEM

#ifdef ADSL_62
    // no swap page for this
    GROUP : {
//        .DMSWAP_VCPE_PORTMODECONTROL ALIGN(4): {
        .PORTMODECONTROL_DMSWAP ALIGN(4): {
            gdata.o(PORTMODECONTROL_DATA)
        }

    } > PORT_MODE_CONTROL_DATA
// XDSLRTFW-1942 (Start)
    // this is a dummy swap buffer to get the SRAM address
    // for WRITE_DATA_TO_SRAM page
    GROUP : {
        .DMSWAP_VCPE_WRITE_DATA_TO_SRAM ALIGN(4) : {
        }
    } > SRAM_BAR15

#ifdef ALLOW_READ_FROM_SRAM
    // this is a dummy swap buffer to get the SRAM address
    // for READ_DATA_FROM_SRAM page
    GROUP : {
        .DMSWAP_VCPE_READ_DATA_FROM_SRAM ALIGN(4) : {
        }
    } > SRAM_BAR15
#endif
   // these pages are real pages for SRAM buffers and MUST start after the above dummy pages
    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA ALIGN(4) : {
            __StartOfSramBAR15 = .;
            *(.SRAM_BAR15)
        }
    } > SRAM_BAR15
// XDSLRTFW-1942 (End)
#endif
// XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL (Start)
    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR16 ALIGN(4) : {
            __StartOfSramBAR16 = .;
            *(.SRAM_BAR16)
        }
    } > SRAM_BAR16

   GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR17 ALIGN(4) : {
            __StartOfSramBAR17 = .;
            *(.SRAM_BAR17)
        }
    } > SRAM_BAR17

// XDSLRTFW-3286 (Start)
    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR18 ALIGN(4) : {
            __StartOfSramBAR18 = .;
            *(.SRAM_BAR18)
        }
    } > SRAM_BAR18
// XDSLRTFW-3286 (End)
    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR19 ALIGN(4) : {
            __StartOfSramBAR19 = .;
            *(.SRAM_BAR19)
        }
    } > SRAM_BAR19
// XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL (End)
    GROUP LOAD(ADDR(MODEM_TEST_FADX_PM)) : {
        .MODEM_TEST_PMSWAP: {
#ifndef ADSL_62
            testModeOperation.o(.text)
            testModeOperation.o(.rodata)
#endif
        }
    } > MODEM_TEST_CODE_MEM

    GROUP LOAD(ADDR(HWTESTS_1_FADX_PM)) : {
        .HWTESTS_1_PMSWAP: {
#ifndef ADSL_62
            HWtest_SE.o(.text)
            HWtest_SE.o(.rodata)
#endif
        }
    } > HWTESTS_1_CODE_MEM

    GROUP LOAD(ADDR(ATM_LOOPBACK_FADX_PM)) : {
        .ATM_LOOPBACK_PMSWAP: {
#ifndef ADSL_62
            atm_loopbackSE.o(.text)
            atm_loopbackSE.o(.rodata)
#endif
        }
    } > ATM_LOOPBACK_MEM

    GROUP LOAD(ADDR(MTE_FCI_LOOPBACK_FADX_PM)) : {
        .MTE_FCI_LOOPBACK_PMSWAP: {
#ifndef ADSL_62
            Test_Danube_loopback.o(.text)
            Test_Danube_loopback.o(.rodata)
#endif
        }
    } > MTE_FCI_LOOPBACK

 //XDSLRTFW-541: Platform_VR9_VRX318 (START)
    GROUP LOAD(ADDR(RES_1PORT_FADX_PM_BT)) : {
        .RES_1PORT_PMSWAP: {

            DebugBuffer.o(.text)

            tx_ib_bis_b.o(.text)
            //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (START)
       AFED_PgaHandlerUtilities.o(.text)
            //AdcTrimming.o(.text)
            //VR9_Afe.o(.text)
            //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (END)

           .RES_1PORT_MULT_DEF: {

            //RES
            logmips.o(.text)  // Newly added, split from trail.o
            states.o(.text)
            CheckShowtimeSnrUpdate.o(.text)
            arctan.o(.text)
            dsp_op2.o(.text)
            RunBackground.o(.text)   // Newly added, split from Modem_hw.o
            FormTestParameterMsg.o(.text)
            dec_adap_Data.o(.text)
            PreSelectReverbSegueDetector.o(.text)
       dataswap.o(.text)

             // From R_NOSHOW_CODE_MEM, Kannan
             ovflw.o(.rodata)
             load_codeswap.o(.text)
             codeswap_nost.o(.text)
             noiseacc.o(.text)
             vecmult.o(.text)
             bufmisc_ext.o(.text)  // Added newly split from bufmisc.o

#ifndef VRX218
//XDSLRTFW-541: Platform_VRX318 (START)
            // C_/SCOPE_NULL
            cmv.o(.text)
            nmp_plfm_init.o(.text)
            InitModem_PreHandshake.o(.text)
//XDSLRTFW-541: Platform_VRX318 (END)
#endif //#ifndef VRX218
          }
      STR_DecAdapt.o(.text)
      STR_DecAdapt.o(.rodata)

            tx_ib_bis_b.o(.rodata)
            //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (START)
            AFED_PgaHandlerUtilities.o(.rodata)
               //AdcTrimming.o(.rodata)
               //VR9_Afe.o(.rodata)
            //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (END)
        }
    } > RES_1PORT_MEM

//XDSLRTFW-1727
 #ifndef VRX218
    GROUP LOAD(ADDR(VRX318_SHOW_1_FADX_PM_BT)) : {
        .VRX318_SHOW_1_PMSWAP: {
                rx_ovhd_bis.o(.text)

                // Moved from BG CACHE 1
                 tx_ib.o(.text)
        }
    } > VRX318_SHOW_1_MEM
#endif

    GROUP LOAD(ADDR(SHOW_1PORT_FADX_PM)) : {
        .SHOW_1PORT_PMSWAP: {
                tx_ovhd_form_msg_bis.o(.text)

            .SHOW_1PORT_MULT_DEF: {

                //show2 files
                // C_/SCOPE_NULL
                showinit_tx_olr.o(.text)    // part is BG needs to split JAG.
                rx_plam_bis.o(.text)       // Moved to Cache
                showtime_tx_bis.o(.text)   // Added Newly, split from showtime_tx_bis.o  //Ar9 changes name from showtime_tx_bis_ext.o to showtime_tx_bis.o
                //tone_reord_load.o(.text)
                Distributefinegains.o(.text)
                olr_Lp_check.o(.text)

                TxHDLC_Queue.o(.text)
                rx_ovhd1_bis.o(.text)
                showtime_rx_b_bis.o(.text)
                rx_olr_decision.o(.text)

                //from SHOWBG1
                tx_ovhd_form_ctrl_msg_bis.o(.text)
//                tx_ovhd_form_msg_bis.o(.text)
                tx_ovhd_bis.o(.text)
                TxHDLCProcessor.o(.text)

                // from SHT1DMT, Kannan
                rx_ib.o(.text)
                rx_eoc.o(.text)
                trail_st.o(.text)
                tx_ib_b.o(.text)
                rx_aoc.o(.text)

                // from SHT2DMT, Kannan
//                tx_ib.o(.text)
                bitswap.o(.text)
                tx_aoc.o(.text)
                tx_eoc.o(.text)
                tx_ceoc.o(.text)
                //tx_m3oh.o(.text) //Sriram move to BG_CACHE_1_PMSWAP

                //jordi
                tx_plam.o(.text)
                rx_plam.o(.text)

                //SHOW1
                showtime_rx_b.o(.text)

            }

        }
    } > SHOW_1PORT_MEM
//XDSLRTFW-541: Platform_VR9_VRX318 (END)

#ifdef USE_CACHE
#ifdef ADSL_62
    GROUP LOAD(ADDR(BG_CACHE_1_FADX)) : {
#else
    GROUP LOAD(ADDR(BG_CACHE_1_FADX_PM)) : {
#endif
        .BG_CACHE_1_PMSWAP: {

#ifdef ADSL_62
            *(.BG_CACHE_1)
#endif
            decxcorr.o(.text)
            nmp_handlemsg.o(.text)      // Added newly,Split from nmp_plfm.c
            RReverb34TxF_bis.o(.text)   // Sriram:Moved from  ANAL_PMSWAP
            RReverb34TxF_bis.o(.rodata) // Sriram:Moved from  ANAL_PMSWAP
            STR_Dec.o(.text)
            STR_Dec.o(.rodata)

            .BG_CACHE_1_0_MULT_DEF: {
                // hw io needed during training, sleep or hwtests
                IRI_sync.o(.text)
                IRI_seqgen.o(.text)

                // from xcvr2
                // C_/SCOPE_NULL
                frm_sync_proc_b.o(.text)
                frm_sync_b.o(.text)
                //convert.o(.text)
                sqrt32.o(.text)
                log2lintssi.o(.text)
                ReverbSnr_b.o(.text)
                ieee_flt.o(.text)
                matrix.o(.text)
                tx_m3oh.o(.text)   //Sriram Moved from SHOW_1PORT_PMSWAP section
#ifndef ADSL_62
                afe_b.o(.text)
#endif

                // C_/SCOPE_STATIC
                fft_bg.o(.text)

                // BG FuNCTIONS all in DISC1_2

                // C_/SCOPE_NULL
                BgDetectMultiTones_Comb.o(.text)
                CombSnrCalc_bis.o(.text)
                tssi_rx.o(.text)
                GenRReverb_XcvrTrain_b.o(.text)
                ComputeDsPcb.o(.text)
                ///log2lintssi.o(.text)
                CalcQlnDiag.o(.text)
                ///RxfilterComp.o(.text)
                //afe_b.o(.text)
                SetPgaForToneDetection.o(.text)            // need to be in BG in RCTonesRxF.c
                ///rxinvfiltcoef.o(.text)

                //from xcvr0
                //CalcQlnDiag.o(.text)
                //RxfilterComp.o(.text)
                //rxinvfiltcoef.o(.text)

                // C_/SCOPE_NULL
                xcvr_rx1_b.o(.text)
                medley_b.o(.text)
                med2rev.o(.text)

                // C_/SCOPE_NULL
                DoFDExtrap.o(.text)
                FDExtrapolate.o(.text)


                //res no ghs
                //interrupt_control.o(.text)

                // C_/SCOPE_NULL
                bitload_support.o(.text)
                forceeven1bit.o(.text)
                minmaxmargin.o(.text)
                snr_b.o(.text)
#ifdef ADSL_62
                acc40.o(.text)
#endif

                // C_/SCOPE_NULL
                misc.o(.text)


                //res

                // C_/SCOPE_NULL
                rndnoiseacc.o(.text)
                snr.o(.text)
                Simext_IOf.o(.text)
                xception.o(.text)


                // 8, 9  from rxinit

                // C_/SCOPE_NULL
                rx_ovhd_ini_bis.o(.text)
                //rx_ib_ini_bis.o(.text)
                aoc_rx_ini.o(.text)
                eoc_rx_ini.o(.text)
                rx_ib_ini.o(.text)
                rx_m3oh.o(.text)

                // Yang add from txinit
                tx_ib_ini.o(.text)
                eoc_tx_ini.o(.text)
                aoc_tx_ini.o(.text)


                // C_/SCOPE_NULL
                showinitrx.o(.text)
                ss_snrfdq.o(.text)
                fdq_adap.o(.text)
                //datapumpsetup_rx.o(.text)
                RCMedleyRxF_RXINIT_BIS.o(.text)
                bgdiagparam_bis.o(.text)
                CalcActatpDiag.o(.text)
#ifdef DANUBE
                BgIlvInit.o(.text)
                BgDilvInit.o(.text)
#endif

                // C_/SCOPE_STATIC
                latency.o(.text)
                tone_ord.o(.text)
                olr_Bpn_check_rx.o(.text)
                CheckForBpnReconfig.o(.text)
                showinit_rx_qam.o(.text)
                dec_gain.o(.text)
                iri_InsertCP.o(.text)
                SetUpRxTonesRegister.o(.text)
                Configure_TCM_Bits.o(.text)
                ApplyFineGains.o(.text)
                decimalgain.o(.text)
                CalcNOMATP.o(.text)
                tone_reord_load.o(.text)
                ComputeRMSFineGain.o(.text)
                CalcAttndrDiag.o(.text)
                CalcSigAttnDiag.o(.text)
                //logtolin.o(.text)
                //bitload3.o(.text)
                //Moved from HNDSHK1
                hndshk1.o(.text)            // XDSLRTFW-415 Enh_all_all_STAT1_update

                // From SHOW2, Kannan
                UpdateFailure_bis.o(.text)   // Added Newly, split from tx_plam_bis_ext.o //AR9 changes name from tx_plam_bis_ext.c to UpdateFailure_bis.c


                // from SHOWBG2, Kannan
                dec_adap_b.o(.text)
                dd_snrfdq.o(.text)
                olrpm_RxProcessing.o(.text)
                LogShowtimeEventA.o(.text)
                iri_iof_ddSnrFdqUtils.o(.text)

                // from SHT2DMT, Kannan
                // tx_ib.o(.text)
                //XDSLRTFW-541: Platform_VR9_VRX318 (START)

                // From RES_CODE_MEM, Kannan
                //int_service.o(.text)


                // from INit

                // C_/SCOPE_NULL
                electra_ini.o(.text)

                LinkStartForTest.o(.text)     //clc
                LinkStart.o(.text)      //clc
                alp_enableaai_tpmode.o(.text)

#ifdef ADSL_62
                STR_ReconfigTxHPF.o(.text)
#endif

                // C_/SCOPE_STATIC
#ifndef ADSL_62
                afe_reconfig.o(.text)
#endif
                STR_ReconfigTx.o(.text)
                Reconfig_fft.o(.text)
#ifdef DANUBE
                Reconfig_IRI_IFFT_Size.o(.text)
#endif

                STR_cleardec.o(.text)
                STR_clearaec.o(.text)
                //SetUpRxTonesRegister.o(.text)
                STR_ReconfigRx.o(.text)
                Config_Interp3_4.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                STR_LoadHPF.o(.text)
                Configure_1024RxFFTLength.o(.text)
                reconfig_fft1.o(.text)
                alp_reconfig_aai.o(.text)


                //        SHOW1
                STR_show.o(.text)

                // C_/SCOPE_NULL
                //XDSLRTFW-541: Platform_VR9_VRX318 (START)

#ifdef VRX218
                rx_ovhd_bis.o(.text)    //MOVED to VRX318_SHOW_1 for VRX318
#endif
                //olr_Bpn_check_rx.o(.text)
                //dec_gain.o(.text)
                enc_gain.o(.text)
                //showinit_rx_qam.o(.text)
                showinit_tx_qam.o(.text)
                //ApplyFineGains.o(.text)
                changebat.o(.text)

                //XDSLRTFW-541: Platform_VR9_VRX318 (END)
                updatefinegainlinsq.o(.text)
                ChooseFineGains_BIS.o(.text)
                CalcRate_BIS.o(.text)

                //XDSLRTFW-541: Platform_VR9_VRX318 (START)

                //CalcAttndrDiag.o(.text)
                bitload2.o(.text)
                AllocateBiGi_desiredLp.o(.text)

                // C_/SCOPE_NULL
                //XDSLRTFW-541: Platform_VR9_VRX318 (START)
//#ifdef VRX218
//              //Given below files were moved to Page: SHOW_1PORT_FADX_PM
//              //and is available in IIBRAM
//              //These functiona are valid in showtime only.
//              tx_ovhd_form_ctrl_msg_bis.o(.text)
//#endif   //#ifdef VRX218
                //XDSLRTFW-541: Platform_VR9_VRX318 (END)

                //tx_ovhd_form_msg_bis.o(.text)
                //XDSLRTFW-541: Platform_VR9_VRX318 (START)

                SetUpSWRSDetectBins.o(.text)

                // tle added
                bitload3.o(.text)
                synsymbl_b.o(.text)
                CalcAvgMargin.o(.text)
                //dec_dap_b.o(.text)


                //btld files

                // C_/SCOPE_NULL
                // tle added
                bitload.o(.text)
                bitload_bis.o(.text)
                bitload_dmt.o(.text)
                RxBtswpDecision.o(.text)    // part of bitswap.c

                // short init
                RQuiet2SITxF_bis.o(.text)

                // new files
                tssi_DefineSupportedSet.o(.text)
                round_acc48.o(.text)
                BinarySearch.o(.text)
                hdlc_deframer.o(.text)
#ifndef ADSL_62
                dataswap_b.o(.text)
#endif
                plam.o(.text)
                train_reinimmunity.o(.text)
#ifdef ADSL_62
#endif //#ifdef ADSL_62
            }
#ifndef ADSL_62
            SWAP_BG_CACHE_1_0.o(.rodata)
#endif
        }
    } > BG_CACHE_1_CODE_MEM

#ifdef VRX518
    GROUP LOAD(ADDR(BG_CACHE_2_FADX_PM_BT)) : {
        .BG_CACHE_2_PMSWAP: {
            //XDSLRTFW-541: Platform_VRX318 (START)
            //handshake
            // C_/SCOPE_NULL
            hs_resp.o(.text)
            hs_CopyInfoField.o(.text)
            hs_mesg.o(.text)
            hs_mesg_bis.o(.text)
            post_hsk.o(.text)

            // From HNSHK2, Kannan
            stateini.o(.text)
            hs_rx.o(.text)
            hs_tx.o(.text)
            TxMTnSt.o(.text)
            HSMsgTx_Util.o(.text)     // Split from RHSMsgTxF.o and Newly Added  //AR9 change name from RHSMsgTxF_ext to HmsgTx_util
            DetectTones_Ghs.o(.text)  // Split from RCTonesRxF.o and Newly Added //AR9 change name from RCTonesRxF_ext to DetectTones_Ghs
            tmnt_hndshk.o(.text)      // Split from tmnt_hndshk.o and Newly Added //AR9: change the name from tmnt_hndshk_ext to tmnt_hndsk
            RSilent1TxF.o(.text)      // SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong
            act_T1413.o(.text)        //R4_HS_PM_REDUCTION_Shakil

            IRI_Ini.o(.text)
            STR_Ini.o(.text)
            eng_ini.o(.text)

            STR_Afe.o(.text)
            rx_ops.o(.text)
            ALP_Ini.o(.text)
            cri_ini.o(.text)
            zph_ini.o(.text)
            AllocateDataBuffers_PreHndshk.o(.text)
            cnfg_task.o(.text)
            codeswap_sinit.o(.text)

            //BGChooseRevSegBin.o(.text)    //anal
            ec_init.o(.text)
            ec_sequence.o(.text)
            DecTrain_b.o(.text)
            STR_reorderdec.o(.text)
            dxc_init.o(.text)
            dxc_comp.o(.text)
            CalcDECPathDelay.o(.text)

            RxfilterComp.o(.text)
            logtolin.o(.text)
            rxinvfiltcoef.o(.text)
            BGChooseRevSegBin.o(.text)
            fft.o(.text)
            ifft_fix.o(.text)
            fdq_init.o(.text)
            FDQcoefPerTone.o(.text)
            fdq_adj.o(.text)
            fdq_update.o(.text)
            find_sintbl.o(.text)
            CalcHlinDiag.o(.text)
            CalcHlogDiag.o(.text)
            RQuiet1TxF_bis.o(.text)
            rndnoiseacc2.o(.text)
            convert.o(.text)
            AFED_ModeConfig.o(.text)
            AFED_AnalogRegInit.o(.text)
            AFED_FilterTune.o(.text)
            AFED_EfuseCopy.o(.text)
            AFED_RcMeasure.o(.text)
            iri_dec_adap.o(.text)
            iri_dec_adap.o(.rodata)

            //XDSLRTFW-3717 (Start)
#ifdef ADSL_62
            main_hw.o(.text)
#else
            nmp.o(.text)
#endif
            gpio.o(.text)
            CompFramingConstraints.o(.text)
            pll.o(.text)

            // From TXINIT, Kannan
            showinittx.o(.text)

            // From BTLDDMT, Kannan
            DecodCInfoRA.o(.text)
            RCReverbRARxF.o(.text)
            SelectDsRateOption.o(.text)
            VerifyRateWithTwoCG.o(.text)

            // From EXCH3, Kannan
            RReverb7TxF_wait_bis.o(.text)

            // From EXCH1, Kannan
            FormRMsgLD_bis.o(.text)
            InterpolateLDInfo.o(.text)
            //XDSLRTFW-3717 (End)
        }
    } > BG_CACHE_2_CODE_MEM
#endif

    GROUP LOAD(ADDR(RES_FADX_PM_BT)) : {
        .RES_PMSWAP: {
#ifdef ADSL_62
            interrupts_62.o(.text)
#endif

            trail.o(.text)
            trailphaserr.o(.text)

#ifndef ADSL_62
            main_hw.o(.text)   // Moved to Cache for ADSL_62
#endif

            modem_hw.o(.text)
            Simext_IOf.o(.text)

//            gpio.o(.text)     // Moved to Cache
#ifndef ADSL_62
            int_service.o(.text)   // Moved to Cache
            mp.o(.text)
            // modem OS routines
            adsl_int.o(.text)
            adsl_int_body.o(.text)
#endif

            fifo.o(.text)
            mtkernel.o(.text)
//            states.o(.text)   // Moved to Cache
//            FormTestParameterMsg.o(.text)
            xception.o(.text)

            // codeswap routines
            codeswap.o(.text)
//            CheckShowtimeSnrUpdate.o(.text)   // Moved to Cache

            // Winhost routines
//            nmp.o(.text)    // Moved to Cache
#ifndef ADSL_62
            nmp_plfm.o(.text)
#endif
            // math routines
            dsp_op.o(.text)
//            dsp_op2.o(.text)  // Moved to Cache

            // memory routines
#ifndef ADSL_62
            // dataswap routines


            ll_iofarc.o(.text)
            LL_IOf.o(.text)
            dma_iof.o(.text)
            mei_iof.o(.text)
            memcopy.o(.text)
            memsetbf.o(.text)
#endif

            // assembly routines
//            arctan.o(.text)   // Moved to Cache
            round64.o(.text)
            nacc.o(.text)
            vecmultloop.o(.text)


            // HWEngine routines
            cri_iof.o(.text)
            interrupt_control_showtime.o(.text)
            //JG STR_show.o(.text)
            IRI_IOf_FFT.o(.text)
            IRI_IOf.o(.text)
            iri_iof1.o(.text) //Yang moved updateRTV() to showbg2
            iri_timer.o(.text)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): moved to BG cache
//            pll.o(.text)
            timercov.o(.text)
            ALP_IOf.o(.text)
            SetUpRxTonesRegister.o(.text)
            ReverbSegueDetectorSetup.o(.text)
//            PreSelectReverbSegueDetector.o(.text)

            // signal routines
            detect_rs.o(.text)

            // assorted
            gdata.o(.text)
            gpersistent.o(.text)
            delay.o(.text)
//            dec_adap_Data.o(.text)
            gdata_bis.o(.text)
            gdata_dmt.o(.text)

            // misc
            norm_acc48.o(.text)
            fcs.o(.text)
            snr.o(.text)
            rndnoiseacc.o(.text)

            mem_funcs_A6.o(.text)           // Danube only file

#ifndef ADSL_62
            crt1.o(.text)
            f_memset.o(.text)               // SOC only
            _memclr.o(.text)                // SOC only
            memcpy.o(.text)                 // SOC only
            memmove.o(.text)                // SOC only
            _setvect.o(.text)
            _cleanup.o(.text)
#endif

            _enable.o(.text)
            _disable.o(.text)
            divnorm.o(.text)
#ifndef ADSL_62
            arith.o(.text)
            exit.o(.text)
            invcache.o(.text)
            mc_epi.o(.text)
            mc_epi4.o(.text)
            mc_pro.o(.text)
            _exit.o(.text)
            ac_mc_13.o(.text)
            ac_mc_va.o(.text)
#endif
            div0max.o(.text)
            div.o(.text)
            ldiv.o(.text)
            d16mpy32.o(.text)
            xcheckno.o(.text)

#ifdef ADSL_62
          //  ThreeGLP_status.o(.text)  //VRX518_OPEN
     AFED_ReadWriteModify.o(.text)
#endif

            *(.text)
        }
    } > RES_CODE_MEM

#ifdef ADSL_62
    GROUP LOAD(ADDR(ADSL_62_FADX_PM_BT)) : {
        .ADSL_62_PMSWAP: {
            IRI_IOf_tables.o(.text)
            LL_IOf_62.o(.text)
            xdma_62.o(.text)
            ZPH_IOf.o(.text)
         cmv_remap.o(.text)
         nmp_plfm.o(.text)

         AFED_PgaHandlerUtilities.o(.text)
         AFED_LineDriverConfig.o(.text)
         AFED_PofiPocoConfg.o(.text)

        // VR9_Afe.o(.text)
         //SetLDMode.o(.text)

        }
    } > ADSL_62_IRAM

#endif


    GROUP LOAD(ADDR(R_NOSHOW_FADX_PM_BT)) : {
        .R_NOSHOW_PMSWAP: {
//            codeswap_nost.o(.text)   // Moved to Cache
            statestc.o(.text)
            pll_misc.o(.text)
            tx_ops_bis.o(.text)
//            load_codeswap.o(.text)  // Moved to Cache
            IRI_IOf_FFT_train.o(.text)
            IRI_IOf_train.o(.text)
            trail_nost.o(.text)
            tx_ops.o(.text)
            tx_ops2.o(.text)
            detect.o(.text)
            accum32.o(.text)
            bufmisc.o(.text)
#ifndef ADSL_62
            afe.o(.text)
#endif
            TxTneSt.o(.text)
            InitTDQfilter.o(.text)

            // overflow counter update
            IRI_Ovflow.o(.text)
//           ovflw.o(.text)           // Moved to Cache

            // assembly routines
            acc32.o(.text)
            m2r.o(.text)
            vp.o(.text)

            // HWEngine routines
            interrupt_control.o(.text)

            // XY memory routines
            xy_iof.o(.text)
            xy_iof_asm.o(.text)

            // Assembly wrapper routines during training
            vecpwr.o(.text)
//            noiseacc.o(.text)      // Moved to Cache
//            vecmult.o(.text)       // Moved to Cache


            // rodata for this page
//            codeswap_nost.o(.rodata)  // Moved to Cache
            statestc.o(.rodata)
            pll_misc.o(.rodata)
            tx_ops_bis.o(.rodata)
//            load_codeswap.o(.rodata)  // Moved to Cache
            IRI_IOf_FFT_train.o(.rodata)
            IRI_IOf_train.o(.rodata)
            trail_nost.o(.rodata)
            tx_ops.o(.rodata)
            tx_ops2.o(.rodata)
            detect.o(.rodata)
            accum32.o(.rodata)
            bufmisc.o(.rodata)
#ifndef ADSL_62
            afe.o(.rodata)
#endif
            TxTneSt.o(.rodata)
            InitTDQfilter.o(.rodata)

            // overflow counter update
            IRI_Ovflow.o(.rodata)
//            ovflw.o(.rodata)         // Moved to Cache

            // assembly routines
            acc32.o(.rodata)
            m2r.o(.rodata)
            vp.o(.rodata)

            // HWEngine routines
            interrupt_control.o(.rodata)

            // XY memory routines
            xy_iof.o(.rodata)
            xy_iof_asm.o(.rodata)

            // Assembly wrapper routines during training
            vecpwr.o(.rodata)
//            noiseacc.o(.rodata)     // Moved to Cache
//            vecmult.o(.rodata)      // Moved to Cache
        }
    } > R_NOSHOW_CODE_MEM

    GROUP LOAD(ADDR(R_NOGHS_FADX_PM)) : {

        .R_NOGHS_PMSWAP: {
            //Part of the Resident page. However, it will not be loaded at boot stage,
            //but codeswapped in when hndshake is finished. Therefore, the files contained here
            //should be the ones that are not used in Init, Hnshk stage. The advantage here is
            //that we can gain more room for handshake.

            // R_NOGHS shouldn't contain any resident files that will be called during Channel Disovery
            // signal routines

            bitload_support.o(.text)
            forceeven1bit.o(.text)
            minmaxmargin.o(.text)
            snr_b.o(.text)
            ApplyBlackoutBits.o(.text)

            // rodata
            bitload_support.o(.rodata)
            forceeven1bit.o(.rodata)
            minmaxmargin.o(.rodata)
            snr_b.o(.rodata)
            ApplyBlackoutBits.o(.rodata)
        }
    } > R_NOGHS_CODE_MEM

    GROUP LOAD(ADDR(INIT_FADX_PM_BT)) : {
        .INIT_PMSWAP: {
            cmv.o(.text)
            STR_Afe.o(.text)
            rx_ops.o(.text)
            ALP_Ini.o(.text)
            cri_ini.o(.text)
            initfifo.o(.text)
            zph_ini.o(.text)
            AllocateDataBuffers_PreHndshk.o(.text)
            cnfg_task.o(.text)
            //cnfg_eng.o(.text)
            InitModem_PreHandshake.o(.text)
            codeswap_sinit.o(.text)
            nmp_plfm_init.o(.text)
            gpio_ini.o(.text)
#ifndef ADSL_62
            XdmaDiag_funcs.o(.text)
#endif


            .INIT_MULT_DEF: {
                //C_SCOPE_NULL
                IRI_Ini.o(.text)
                STR_Ini.o(.text)
                electra_ini.o(.text)
                eng_ini.o(.text)
                LinkStartForTest.o(.text)
                LinkStart.o(.text)

                //C_SCOPE_STATIC
#ifndef ADSL_62
                afe_reconfig.o(.text)
#endif
                STR_ReconfigTx.o(.text)
                Reconfig_fft.o(.text)
#ifdef DANUBE
                Reconfig_IRI_IFFT_Size.o(.text)
#endif
                STR_cleardec.o(.text)
                STR_clearaec.o(.text)
                SetUpRxTonesRegister.o(.text)
                STR_ReconfigRx.o(.text)
                Config_Interp3_4.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                STR_LoadHPF.o(.text)
                Configure_1024RxFFTLength.o(.text)
                reconfig_fft1.o(.text)
                alp_reconfig_aai.o(.text)

                //C_SCOPE_NULL
#ifndef ADSL_62
                afeini.o(.text)
#endif

#ifndef ADSL_62
                //C_SCOPE_STATIC
                afe_b.o(.text)
#endif

                //C_SCOPE_NULL
                statein1.o(.text)
                hybrid_settings.o(.text)

                //C_SCOPE_STATIC
                hndshk1.o(.text)
            }

            // rodata
            cmv.o(.rodata)
            STR_Afe.o(.rodata)
            rx_ops.o(.rodata)
            ALP_Ini.o(.rodata)
            cri_ini.o(.rodata)
            initfifo.o(.rodata)
            zph_ini.o(.rodata)
            AllocateDataBuffers_PreHndshk.o(.rodata)
            cnfg_task.o(.rodata)
            //cnfg_eng.o(.rodata)
            InitModem_PreHandshake.o(.rodata)
            codeswap_sinit.o(.rodata)
            nmp_plfm_init.o(.rodata)
            gpio_ini.o(.rodata)
        }
    } > INIT_CODE_MEM

    GROUP LOAD(ADDR(HNSHK1_FADX_PM)) : {

        .HNSHK1_PMSWAP: {
            hs_resp.o(.text)
            hndshk.o(.text)
            hndshk2.o(.text)
            hs_CopyInfoField.o(.text)
            hs_misc.o(.text)
            MapInputtoINP_CLR.o(.text)

            .HNSHK1_MULT_DEF: {
                //C_SCOPE_NULL
                RTonesReqTxF.o(.text)
                RTone1TxF.o(.text)
                RFlag1TxF.o(.text)
                RCFlag1RxF.o(.text)
                RCGalf1RxF.o(.text)

                //C_SCOPE_NULL
                RCHSMsgRxF.o(.text)

                //C_SCOPE_STATIC
//              hndshk1.o(.text)       //Moved to cache, XDSLRTFW-415 Enh_all_all_STAT1_update

                //C_SCOPE_NULL
                hs_mesg.o(.text)

                //C_SCOPE_STATIC
                hs_mesg_bis.o(.text)
                tssi_DefineSupportedSet.o(.text)
            }

            // rodata
            hs_resp.o(.rodata)
            hndshk.o(.rodata)
            hndshk2.o(.rodata)
            hs_CopyInfoField.o(.rodata)
            hs_misc.o(.rodata)
        }
    } > HNSHK1_CODE_MEM

    GROUP LOAD(ADDR(HNSHK2_FADX_PM)) : {

        .HNSHK2_PMSWAP: {
            RHSMsgTxF.o(.text)
            RFlag2TxF.o(.text)
            RGalf2TxF.o(.text)
            RCFlag2RxF.o(.text)
            RCGalf2RxF.o(.text)
            SetSelectedMode.o(.text) //AR9 change name from tmnt_hndshk to setselectedmode.c
            hs_tx.o(.text)
            TxMTnSt.o(.text)

            .HNSHK2_MULT_DEF: {
                //C_SCOPE_NULL
//                stateini.o(.text)  // Moved to CACHE, Kannan
                post_hsk.o(.text)
                RCSilent1RxF.o(.text)
                RCTonesRxF.o(.text)
                RCQuiet2RxF_CW.o(.text)
                RSilent0TxF.o(.text)
//                RSilent1TxF.o(.text)  //Moved to cache, SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong
//                act_T1413.o(.text)   //Moved to cache Shakil
                RQuiet2TxF.o(.text)

                //C_SCOPE_STATIC
                STR_ReconfigRx.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                STR_LoadHPF.o(.text)
                SetPgaForToneDetection.o(.text)
#ifndef ADSL_62

                afe_b.o(.text)
#endif

                //C_SCOPE_NULL
//                hs_rx.o(.text)  // Moved to CACHE, Kannan

                //C_SCOPE_STATIC
                find_sintbl.o(.text)
            }

            // rodata
            RHSMsgTxF.o(.rodata)
            RFlag2TxF.o(.rodata)
            RGalf2TxF.o(.rodata)
            RCFlag2RxF.o(.rodata)
            RCGalf2RxF.o(.rodata)
            SetSelectedMode.o(.rodata)
//            hs_tx.o(.rodata)  // Moved to CACHE, Kannan
//            TxMTnSt.o(.rodata) // Moved to CACHE, Kannan

        }
    } > HNSHK2_CODE_MEM

    GROUP LOAD(ADDR(XCVR0_FADX_PM)) : {

        .XCVR0_PMSWAP: {
            RQuiet2TxF_CS.o(.text)
            RReverb1TxF.o(.text)
            statein1_dmt.o(.text)
            eoc_ini_b.o(.text)

            .XCVR0_MULT_DEF: {
                //C_SCOPE_NULL
                RCQuiet2RxF.o(.text)
                RCPilot1InitRxF.o(.text)
                RCPilot1RxF.o(.text)

                //C_SCOPE_STATIC
                Reconfig_fft.o(.text)
                Configure_1024RxFFTLength.o(.text)
                SetUpRxTonesRegister.o(.text)
#ifdef DANUBE
                Reconfig_IRI_IFFT_Size.o(.text)
#endif
                reconfig_fft1.o(.text)
#ifdef ADSL_62
            Reconfig_CRI.o(.text)
#endif
                STR_ReconfigRx.o(.text)
                STR_ReconfigTx.o(.text)
                Config_Interp3_4.o(.text)
                STR_InitFilter.o(.text)
                STR_Tdq.o(.text)
                STR_LoadHPF.o(.text)
                CalcQlnDiag.o(.text)
                RxfilterComp.o(.text)
                rxinvfiltcoef.o(.text)

#ifndef ADSL_62
                afe_b.o(.text)
#endif
            }

            // rodata
            RQuiet2TxF_CS.o(.rodata)
            RReverb1TxF.o(.rodata)
            statein1_dmt.o(.rodata)
            eoc_ini_b.o(.rodata)

        }
    } > XCVR0_CODE_MEM

    GROUP LOAD(ADDR(DISC1_FADX_PM)) : {

        .DISC1_PMSWAP: {
            ifft_cutback.o(.text)
            RCQuiet2RxF_bis.o(.text)
            RCComb1RxF_bis.o(.text)
            BgDetectMultiTones_Comb.o(.text)
            RQuiet2TxF_bis_A.o(.text)

            .DISC1_MULT_DEF: {
                //C_SCOPE_NULL
                RCQuiet1RxF_bis.o(.text)
                tssi_rx.o(.text)
                rndnoiseacc2.o(.text)
                // not static
                RQuiet1TxF_bis.o(.text)


                //C_SCOPE_STATIC
                log2lintssi.o(.text)
                CalcQlnDiag.o(.text)
                RxfilterComp.o(.text)
                Reconfig_fft.o(.text)
#ifdef DANUBE
                Reconfig_IRI_IFFT_Size.o(.text)
#endif
                SetUpRxTonesRegister.o(.text)
                Configure_1024RxFFTLength.o(.text)
                reconfig_fft1.o(.text)
#ifdef ADSL_62
            Reconfig_CRI.o(.text)
#endif
                STR_ReconfigRx.o(.text)
                STR_Tdq.o(.text)
                STR_LoadHPF.o(.text)
                STR_ReconfigTx.o(.text)
                Config_Interp3_4.o(.text)
                STR_InitFilter.o(.text)
                rxinvfiltcoef.o(.text)

#ifndef ADSL_62
                afe_b.o(.text)
#endif
                SetPgaForToneDetection.o(.text)

                //C_SCOPE_NULL
                RComb1TxF_bis.o(.text)

                //C_SCOPE_STATIC
                GenerateComb.o(.text)
            }
            // rodata
            GenerateComb.o(.rodata)
            RCQuiet2RxF_bis.o(.rodata)
            RCComb1RxF_bis.o(.rodata)
            BgDetectMultiTones_Comb.o(.rodata)
        }
    } > DISC1_CODE_MEM

    GROUP LOAD(ADDR(DISC2_FADX_PM)) : {

        .DISC2_PMSWAP: {
            ComputeDsPcb.o(.text)
            CombSnrCalc_bis.o(.text)
            RCQuiet1RxF_CW_bis.o(.text)
            RQuiet2TxF_bis_B.o(.text)

            .DISC2_MULT_DEF: {
                //C_SCOPE_NULL
                RCComb2RxF_bis.o(.text)

                //C_SCOPE_STATIC
                DetectComb.o(.text)
#ifndef ADSL_62
                afe_b.o(.text)
#endif

            }
            // rodata
            ComputeDsPcb.o(.rodata)
        }
    } > DISC2_CODE_MEM

    GROUP LOAD(ADDR(DISC3_FADX_PM)) : {

        .DISC3_PMSWAP: {
            FormRMsgFmt_bis.o(.text)
            FormRMsgPcb_bis.o(.text)
            GenRReverb_XcvrTrain_b.o(.text)
            DecodeCMsgFmt_bis.o(.text)
            DecodeCMsgPcb_bis.o(.text)
            RQuiet3TxF_bis.o(.text)
            RLineProbeTxF_bis.o(.text)

            .DISC3_MULT_DEF: {
                //C_SCOPE_NULL
                RCQuiet3RxF_bis.o(.text)
                RCQuiet4RxF_bis.o(.text)

                //C_SCOPE_STATIC

#ifndef ADSL_62
                afe_b.o(.text)
#endif
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)

                //C_SCOPE_NULL
                RCMsgFmtRxF_bis.o(.text)
                RMsgFmtTxF_bis.o(.text)
                RCComb3RxF_bis.o(.text)
                RCombTxF_bis.o(.text)

                //C_SCOPE_STATIC
                GenerateComb.o(.text)
                DetectComb.o(.text)
                crc16.o(.text)
            }

            // rodata
            FormRMsgFmt_bis.o(.rodata)
            FormRMsgPcb_bis.o(.rodata)
            GenRReverb_XcvrTrain_b.o(.rodata)
            DecodeCMsgFmt_bis.o(.rodata)
            DecodeCMsgPcb_bis.o(.rodata)
        }
    } > DISC3_CODE_MEM

    GROUP LOAD(ADDR(XCVR1_FADX_PM)) : {

        .XCVR1_PMSWAP: {
//            aec_init.o(.text)        // Moved to XCVR1EXT
            xcvr_rx1_b.o(.text)
            RReverb1TxF_bis.o(.text)   //AR9: change the name from RReverb12TxF_bis.o to RReverb1TxF_bis.o
//            RReverb2TxF_bis.o(.text)  // Newly added split from RReverb12TxF_bis.o
//            RCReverb2RxF_bis.o(.text) // Moved to XCVR1EXT
//            RCEctRxF.o(.text)         // Moved to XCVR1EXT

            .XCVR1_MULT_DEF: {
                //C_SCOPE_NULL
                RReverb1TxF_Wait.o(.text)     // Newly added spilit from RReverb1TxF.o */
                RCReverb1RxF_bis.o(.text)
//                RCTref1RxF_bis.o(.text)  // Split and Newly Added from RCReverb1RxF_bis.o
                RQuiet4TxF_bis.o(.text)
//                RQuiet5TxF_XCVR1_bis.o(.text)  // Moved to XCVR1EXT
                RCReverb1RxF.o(.text)
//                RCPilot2RxF.o(.text)// Split and Newly added from RCReverb1RxF.o
//                RQuiet3TxF.o(.text)// Moved to XCVR1EXT
                HybridTraining.o(.text)
                STR_ReconfigDecim2_HPF.o(.text)
//                STR_Aec.o(.text)// Moved to XCVR1EXT
#ifdef ADSL_62
                  AFED_HybTrainUtilities.o(.text)
                  //VR9_AfeHybr.o(.text)
#endif

                //C_SCOPE_STATIC
//                RQuiet5TxF_bis.o(.text)  // Moved to XCVR1EXT
#ifndef ADSL_62
                afe_b.o(.text)
                afe_hyb.o(.text)
#endif
                STR_LoadHPF.o(.text)
                STR_InitFilter.o(.text)
#ifdef ADSL_62
                DoubleTrainingPGAHandler.o(.text)   // Added new file for DoublePGA Training
#endif
            }

            // rodata
//            aec_init.o(.rodata)// Moved to XCVR1EXT
            xcvr_rx1_b.o(.rodata)
            RReverb1TxF_bis.o(.rodata)
//            RReverb2TxF_bis.o(.rodata)   // Newly added split from RReverb12TxF_bis.o
//            RCReverb2RxF_bis.o(.rodata)  // Moved to XCVR1EXT
//            RCEctRxF.o(.rodata)          // Moved to XCVR1EXT

        }
    } > XCVR1_CODE_MEM

    GROUP LOAD(ADDR(XCVR1EXT_FADX_PM)) : {

        .XCVR1EXT_PMSWAP: {
            aec_init.o(.text)
            RCEctRxF.o(.text)
            RCReverb2RxF_bis.o(.text)

           .XCVR1EXT_MULT_DEF: {
                //C_SCOPE_NULL
                RReverb2TxF_bis.o(.text)    // Newly added split from RReverb12TxF_bis.o
                RQuiet5TxF_XCVR1_bis.o(.text)
//                RReverb1TxF_Wait.o(.text)     // Newly added spilit from RReverb1TxF.o */
                RQuiet3TxF.o(.text)
                RCTref1RxF_bis.o(.text)  // Split and Newly Added from RCReverb1RxF_bis.o
                RCPilot2RxF.o(.text)// Split and Newly added from RCReverb1RxF.o
                STR_Aec.o(.text)

                //C_SCOPE_STATIC
                RQuiet5TxF_bis.o(.text)

#ifndef ADSL_62
                afe_b.o(.text)
                afe_hyb.o(.text)
#endif
                STR_LoadHPF.o(.text)
                STR_InitFilter.o(.text)
            }

            // rodata
            aec_init.o(.rodata)
            RCEctRxF.o(.rodata)
            RCReverb2RxF_bis.o(.rodata)
        }
    } > XCVR1EXT_CODE_MEM

    GROUP LOAD(ADDR(XCVR2_FADX_PM)) : {

        .XCVR2_PMSWAP: {
            .XCVR2_MULT_DEF: {
                //C_SCOPE_NULL
                RCReverb3RxF_bis.o(.text)
                CalcHlinDiag.o(.text)
                CalcHlogDiag.o(.text)

                //C_SCOPE_STATIC
                RCReverbFrameSyncFdq.o(.text)
                train_reinimmunity.o(.text)
                frm_sync_proc_b.o(.text)
                frm_sync.o(.text)
                frm_sync_b.o(.text)
                sqrt32.o(.text)
                log2lintssi.o(.text)
                ReverbSnr_b.o(.text)
                STR_decimphase.o(.text)
                ifft_fix.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                fft_bg.o(.text)
                fft.o(.text)

#ifndef ADSL_62
                afe_b.o(.text)
#endif
                RxfilterComp.o(.text)
                logtolin.o(.text)
                rxinvfiltcoef.o(.text)
                BGChooseRevSegBin.o(.text)
//                iri_dec_adap.o(.text)
                STR_RxTxAlign.o(.text)
                ieee_flt.o(.text)
                matrix.o(.text)
                find_sintbl.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                STR_TdqExp.o(.text)

                //C_SCOPE_NULL
                RQuiet5TxF_XCVR2_bis.o(.text)

                //C_SCOPE_STATIC
                RQuiet5TxF_bis.o(.text)
            }

            // rodata
        }
    } > XCVR2_CODE_MEM

    GROUP LOAD(ADDR(XCVRDMT_FADX_PM)) : {

        .XCVRDMT_PMSWAP: {
            RSegueTxF.o(.text)
            ClrTxBuf.o(.text)
            .XCVRDMT_MULT_DEF: {
                //C_SCOPE_NULL
                RReverb2TxF.o(.text)
                RCReverb2RxF.o(.text)
                RCReverb3RxF.o(.text)
                convert.o(.text)
                DoFDExtrap.o(.text)
                FDExtrapolate.o(.text)

                //C_SCOPE_STATIC
                RCReverbFrameSyncFdq.o(.text)
                train_reinimmunity.o(.text)
                frm_sync_proc_b.o(.text)
                frm_sync.o(.text)
                frm_sync_b.o(.text)
                sqrt32.o(.text)
                find_sintbl.o(.text)
                ReverbSnr_b.o(.text)
                STR_decimphase.o(.text)
                ifft_fix.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                fft_bg.o(.text)
                fft.o(.text)
#ifndef ADSL_62
                afe_b.o(.text)
#endif
                BGChooseRevSegBin.o(.text)
//                iri_dec_adap.o(.text)
                STR_RxTxAlign.o(.text)
                ieee_flt.o(.text)
                matrix.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                STR_TdqExp.o(.text)
            }

            // rodata
            RSegueTxF.o(.rodata)
            ClrTxBuf.o(.rodata)
        }
    } > XCVRDMT_CODE_MEM

    GROUP LOAD(ADDR(ANAL_FADX_PM)) : {

        .ANAL_PMSWAP: {
            //STR_Dec.o(.text)
            decxcorr.o(.text)           // need to split init and decxcor
            DecodeCMsg1_bis.o(.text)
            dxc_init.o(.text)
            RCReverb5RxF_bis.o(.text)
            //RReverb34TxF_bis.o(.text)      // Sriram : Moved to BG_CACHE_1_PMSWAP
            RSegue12TxF_bis.o(.text)
            dxc_comp.o(.text)
            CalcDECPathDelay.o(.text)
            FormRMsg1_bis.o(.text)

            .ANAL_MULT_DEF: {
                //C_SCOPE_NULL
                RCReverb4RxF_bis.o(.text)
                RReverb5TxF_bis.o(.text)
                REctTxF.o(.text)
                RCPilot3Tref2RxF.o(.text)
                ec_init.o(.text)
                ec_sequence.o(.text)

                //C_SCOPE_STATIC

                medley.o(.text)
                GenMedly.o(.text)
                ReverbSnr_b.o(.text)
                STR_mask.o(.text)
                STR_cleardec.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                iri_InsertCP.o(.text)
                reconfig_fft1.o(.text)
                BGChooseRevSegBin.o(.text)
                STR_TdqExp.o(.text)

                //C_SCOPE_NULL
                RCMsg1RxF_bis.o(.text)
                RMsg1TxF_bis.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                TxInfoBit.o(.text)

                //C_SCOPE_NULL
                DecTrain_b.o(.text)

                //C_SCOPE_STATIC
                STR_reorderdec.o(.text)
            }

            // rodata
            //STR_Dec.o(.rodata)
            decxcorr.o(.rodata)           // need to split init and decxcor
            DecodeCMsg1_bis.o(.rodata)
            dxc_init.o(.rodata)
            RCReverb5RxF_bis.o(.rodata)
            RReverb34TxF_bis.o(.rodata)      // // Sriram : Moved to BG_CACHE_1_PMSWAP
            RSegue12TxF_bis.o(.rodata)
            dxc_comp.o(.rodata)
            CalcDECPathDelay.o(.rodata)
            FormRMsg1_bis.o(.rodata)

        }
    } > ANAL_CODE_MEM

    GROUP LOAD(ADDR(ANL1DMT_FADX_PM)) : {

        .ANL1DMT_PMSWAP: {
            RCCrc1RxF.o(.text)
            DecodCInfo1.o(.text)
            FormRRates.o(.text)
            RCrc1TxF.o(.text)
            RSegue3TxF.o(.text)
            RReverb4TxF.o(.text)
            FormRMsgs1.o(.text)
            RSegue2TxF.o(.text)

            .ANL1DMT_MULT_DEF: {
                //C_SCOPE_NULL
                RMsgs1TxF.o(.text)
                RRates1TxF.o(.text)
                RCRates1RxF.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                TxInfoBit.o(.text)

                //C_SCOPE_NULL
                RCMedleyRxF_TDQTest.o(.text)
                RMedleyTxF.o(.text)
                RReverb3TxF.o(.text)

                //C_SCOPE_STATIC
                GenMedly.o(.text)
                medley_b.o(.text)
                train_reinimmunity.o(.text)
                decimalgain.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                find_sintbl.o(.text)
                med2rev.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                BGChooseRevSegBin.o(.text)
            }

            // rodata
            RCCrc1RxF.o(.rodata)
            DecodCInfo1.o(.rodata)
            FormRRates.o(.rodata)
            RCrc1TxF.o(.rodata)
            RSegue3TxF.o(.rodata)
            RReverb4TxF.o(.rodata)
            FormRMsgs1.o(.rodata)
            RSegue2TxF.o(.rodata)

        }
    } > ANL1DMT_CODE_MEM

    GROUP LOAD(ADDR(MTDQ_FADX_PM)) : {

        .MTDQ_PMSWAP: {
            ieee_flt.o(.text)
            matrix.o(.text)
            matrix_tdq.o(.text)
            ieee_flt_tdq.o(.text)
            ccl.o(.text)
            tdq_init_hndlr.o(.text)
            fpconv48.o(.text)
            fpc48_ini.o(.text)
            CCloop.o(.text)
            circor48.o(.text)
            corrseq.o(.text)
            int48toFloat32.o(.text)

            .MTDQ_MULT_DEF: {
                //C_SCOPE_NULL
                tdq_init.o(.text)
                rcmedly2.o(.text)
                RCMedleyRxF_bis.o(.text)
                RCMedleyRxF.o(.text)

                //C_SCOPE_STATIC
                round_acc48.o(.text)
                fft_bg.o(.text)
                fft.o(.text)
                ifft_fix.o(.text)
                medley.o(.text)
                pwr_ctbk.o(.text)

                //C_SCOPE_NULL
                RMedleyTxF_MTDQ_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
            }

            // rodata
            ieee_flt.o(.rodata)
            matrix.o(.rodata)
            matrix_tdq.o(.rodata)
            ieee_flt_tdq.o(.rodata)
            ccl.o(.rodata)
            tdq_init_hndlr.o(.rodata)
            fpconv48.o(.rodata)
            fpc48_ini.o(.rodata)
            CCloop.o(.rodata)
            circor48.o(.rodata)
            corrseq.o(.rodata)
            int48toFloat32.o(.rodata)
        }
    } > MTDQ_CODE_MEM

    GROUP LOAD(ADDR(TDQTEST_FADX_PM)) : {

        .TDQTEST_PMSWAP: {
            .TDQTEST_MULT_DEF: {
                //C_SCOPE_NULL
                RCMedleyRxF_TDQTest_bis.o(.text)

                //C_SCOPE_STATIC
                medley_b.o(.text)
                train_reinimmunity.o(.text)
                bitload2.o(.text)
                updatefinegainlinsq.o(.text)
                ChooseFineGains_BIS.o(.text)
                decimalgain.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                med2rev.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                find_sintbl.o(.text)
                BGChooseRevSegBin.o(.text)

                //C_SCOPE_NULL
                RMedleyTxF_TDQTest_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
            }
            // rodata
        }
    } > TDQTEST_CODE_MEM

    GROUP LOAD(ADDR(BTLD_FADX_PM)) : {

        .BTLD_PMSWAP: {
           .BTLD_MULT_DEF: {
                //C_SCOPE_NULL
                bitload_bis.o(.text)
                RCMedleyRxF_Bitload_BIS.o(.text)

                //C_SCOPE_STATIC
                bitload.o(.text)
                bitload2.o(.text)
                bitload3.o(.text)
                changebat.o(.text)
                decimalgain.o(.text)
                CalcAttndrDiag.o(.text)
                ComputeRMSFineGain.o(.text)
                updatefinegainlinsq.o(.text)
                AllocateBiGi_desiredLp.o(.text)
                ChooseFineGains_BIS.o(.text)

                //C_SCOPE_NULL
                RMedleyTxF_Bitload_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
           }

           // rodata
        }
    } > BTLD_CODE_MEM

    GROUP LOAD(ADDR(BTLDDMT_FADX_PM)) : {

        .BTLDDMT_PMSWAP: {
            RSegueRATxF.o(.text)
//            DecodCInfoRA.o(.text)     // Moved to Cache
            RReverbRATxF.o(.text)
            FormRRatesRA.o(.text)
            FormRMsgRA.o(.text)
//            RReverb5TxF.o(.text)    // Moved to BTLDDMT1, since It is being used there
//            DecodCInfo2.o(.text)    // Moved to BTLDDMT1
            DecodCBGMsg.o(.text)


            .BTLDDMT_MULT_DEF: {
                //C_SCOPE_NULL
//                RMsgs2TxF.o(.text)  // Moved to BTLDDMT1
//                RCrc3TxF.o(.text)   // Moved to BTLDDMT1
                RCrcRATxF.o(.text)
                RCCrcRARxF.o(.text)
                RCRatesRARxF.o(.text)
                RRatesRATxF.o(.text)
//                RCBGRxF.o(.text)    // Moved to BTLDDMT1
//                RCMsg2RxF.o(.text)  // Moved to BTLDDMT1
//                RCCrc3RxF.o(.text)  // Moved to BTLDDMT1

                //C_SCOPE_STATIC
                crc16.o(.text)
                exchsig.o(.text)

                //C_SCOPE_NULL
//                SelectDsRateOption.o(.text)    // Moved to Cache
//                VerifyRateWithTwoCG.o(.text) // Moved to Cache
//                RCReverbRARxF.o(.text)
                bitload_dmt.o(.text)
                RCMedleyRxF_Bitload.o(.text)
//                FormRInfo2.o(.text)  // Moved to BTLDDMT1

                //C_SCOPE_STATIC
                bitload.o(.text)
                bitload2.o(.text)
                tone_ord.o(.text)
                minmaxmargin.o(.text)
                bitload3.o(.text)
                changebat.o(.text)
                decimalgain.o(.text)
                updatefinegainlinsq.o(.text)
            }
            // rodata
            RSegueRATxF.o(.rodata)
//            DecodCInfoRA.o(.rodata)    // Moved to Cache
            RReverbRATxF.o(.rodata)
            FormRRatesRA.o(.rodata)
            FormRMsgRA.o(.rodata)
            DecodCBGMsg.o(.rodata)

        }
    } > BTLDDMT_CODE_MEM

    GROUP LOAD(ADDR(BTLDDMT1_FADX_PM)) : {

        .BTLDDMT1_PMSWAP: {
            RReverb5TxF.o(.text)
            DecodCInfo2.o(.text)
            DecodCBGMsg.o(.text)


            .BTLDDMT1_MULT_DEF: {
                //C_SCOPE_NULL
                RMsgs2TxF.o(.text)
                RCrc3TxF.o(.text)
                RCBGRxF.o(.text)
                RCMsg2RxF.o(.text)
                RCCrc3RxF.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                exchsig.o(.text)
                FormRInfo2.o(.text)

                //C_SCOPE_STATIC
                bitload.o(.text)
                bitload2.o(.text)
                tone_ord.o(.text)
                minmaxmargin.o(.text)
                bitload3.o(.text)
                changebat.o(.text)
                decimalgain.o(.text)
                updatefinegainlinsq.o(.text)
            }
            // rodata
            RReverb5TxF.o(.rodata)
            DecodCInfo2.o(.rodata)
            DecodCBGMsg.o(.rodata)

        }
    } > BTLDDMT1_CODE_MEM


    GROUP LOAD(ADDR(RXINIT_FADX_PM)) : {

        .RXINIT_PMSWAP: {
            rx_ovhd_ini_bis.o(.text)
            rx_ib_ini_bis.o(.text)
            aoc_rx_ini.o(.text)
            eoc_rx_ini.o(.text)
            rx_ib_ini.o(.text)
            rx_m3oh.o(.text)


            .RXINIT_MULT_DEF: {
                //C_SCOPE_NULL
                showinitrx.o(.text)
                datapumpsetup_rx.o(.text)
                RCMedleyRxF_RXINIT_BIS.o(.text)
                bgdiagparam_bis.o(.text)
                CalcActatpDiag.o(.text)
                //BgDilvInit.o(.text)

                //C_SCOPE_STATIC
                latency.o(.text)
                tone_ord.o(.text)
                olr_Bpn_check_rx.o(.text)
                CheckForBpnReconfig.o(.text)
                showinit_rx_qam.o(.text)
                dec_gain.o(.text)
                iri_InsertCP.o(.text)
                SetUpRxTonesRegister.o(.text)
                Configure_TCM_Bits.o(.text)
                ApplyFineGains.o(.text)
                decimalgain.o(.text)
                CalcNOMATP.o(.text)
                tone_reord_load.o(.text)
                ComputeRMSFineGain.o(.text)
                CalcAttndrDiag.o(.text)
                CalcSigAttnDiag.o(.text)
                logtolin.o(.text)
                bitload3.o(.text)


                //C_SCOPE_NULL
                RMedleyTxF_RxInit_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
            }
            // rodata
            rx_ovhd_ini_bis.o(.rodata)
            rx_ib_ini_bis.o(.rodata)
            aoc_rx_ini.o(.rodata)
            eoc_rx_ini.o(.rodata)
            rx_ib_ini.o(.rodata)
            rx_m3oh.o(.rodata)
        }
    } > RXINIT_CODE_MEM

    GROUP LOAD(ADDR(EXCH1_FADX_PM)) : {

        .EXCH1_PMSWAP: {
            RCExchMarkerRxF_bis.o(.text)
            RExchMarkerTxF_bis.o(.text)
            FormRMsg2_bis.o(.text)
            Scramble_bis.o(.text)

            //diag mode
            RSegueLDTxF_bis.o(.text)
            RCTref1LDRxF_bis.o(.text)
            RCTref2LDRxF_bis.o(.text)
            RCSegueLDRxF_bis.o(.text)
            RCQuietL3RxF_bis.o(.text)
            RCTref3LDRxF_bis.o(.text)

            .EXCH1_MULT_DEF: {
                //C_SCOPE_NULL
                RCMedleyRxF_CSWap_BIS.o(.text)
                RMedleyTxF_CSwap_bis.o(.text)
                FormRParams_bis.o(.text)
                RCMsg2RxF_bis.o(.text)
                RMsg2TxF_bis.o(.text)

                //diag mode
                RMsgLDTxF_bis.o(.text)
                RCMsgLDRxF_bis.o(.text)
//                FormRMsgLD_bis.o(.text)   // Moved to Cache

                RQuiet1LDTxF_bis.o(.text)
                RQuiet2LDTxF_bis.o(.text)
                RQuiet3LDTxF_bis.o(.text)
                RAckNAckLDTxF_bis.o(.text)
                RQuietL3TxF_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                CalcCRC16_Byte.o(.text)
                crc16.o(.text)
                //formtestparametermsg.o(.text)
                decimalgain.o(.text)
                Gen_MedleyBisTones.o(.text)
                TxInfoBit.o(.text)
//               InterpolateLDInfo.o(.text)
            }

            // rodata
            RCExchMarkerRxF_bis.o(.rodata)
            RExchMarkerTxF_bis.o(.rodata)
            FormRMsg2_bis.o(.rodata)
            Scramble_bis.o(.rodata)

            //diag mode
            RSegueLDTxF_bis.o(.rodata)
            RCTref1LDRxF_bis.o(.rodata)
            RCTref2LDRxF_bis.o(.rodata)
            RCSegueLDRxF_bis.o(.rodata)
            RCQuietL3RxF_bis.o(.rodata)
            RCTref3LDRxF_bis.o(.rodata)
        }
    } > EXCH1_CODE_MEM

    GROUP LOAD(ADDR(EXCH2_FADX_PM)) : {

        .EXCH2_PMSWAP: {
            RParamsTxF_bis.o(.text)
            RCReverb6RxF_bis.o(.text)
            RReverb6TxF_bis.o(.text)
            RSegue3TxF_bis.o(.text)
            RCParamsRxF_bis.o(.text)
            DeScramble_bis.o(.text)

            .EXCH2_MULT_DEF: {

                //C_SCOPE_NULL
                ParamsSig_bis.o(.text)

                //C_SCOPE_STATIC
                CalcCRC16_Byte.o(.text)
                crc16.o(.text)
            }
            // rodata
            RParamsTxF_bis.o(.rodata)
            RCReverb6RxF_bis.o(.rodata)
            RReverb6TxF_bis.o(.rodata)
            RSegue3TxF_bis.o(.rodata)
            RCParamsRxF_bis.o(.rodata)
            DeScramble_bis.o(.rodata)
        }
    } > EXCH2_CODE_MEM

    GROUP LOAD(ADDR(EXCH3_FADX_PM)) : {

        .EXCH3_PMSWAP: {
            RReverb7TxF_bis.o(.text)
//            RReverb7TxF_wait_bis.o(.text)   // Moved to Cache
            RSegue4TxF_bis.o(.text)

            .EXCH3_MULT_DEF: {

                //C_SCOPE_NULL
                RCReverb7RxF_bis.o(.text)

                //C_SCOPE_STATIC
                RxFFTBufSTrans.o(.text)

                //C_SCOPE_NULL
                DecodeCParams.o(.text)

                //C_SCOPE_STATIC
                CalcRate_BIS.o(.text)
            }

            // rodata
            RReverb7TxF_bis.o(.rodata)
//            RReverb7TxF_wait_bis.o(.rodata)   // Moved to Cache
            RSegue4TxF_bis.o(.rodata)
        }
    } > EXCH3_CODE_MEM

    GROUP LOAD(ADDR(EXCHDMT_FADX_PM)) : {

        .EXCHDMT_PMSWAP: {
            RSegue4TxF.o(.text)
            RReverb6TxF.o(.text)

            .EXCHDMT_MULT_DEF: {

                //C_SCOPE_NULL
                RBGTxF.o(.text)
                RCrc5TxF.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                exchsig.o(.text)

                //C_SCOPE_NULL
                RCReverb5RxF.o(.text)

                //C_SCOPE_STATIC
                RxFFTBufSTrans.o(.text)

                //C_SCOPE_NULL
                RSegue5TxF.o(.text)
                ZPH_IOf_showinit_dmt.o(.text)

                //C_SCOPE_STATIC
#ifndef ADSL_62
                ZPH_IOf.o(.text)
#endif
                alp_enableaai_txrx.o(.text)
            }

            // rodata
            RSegue4TxF.o(.rodata)
            RReverb6TxF.o(.rodata)
        }
    } > EXCHDMT_CODE_MEM

        // The common functions between SHOW1 and SHOW2 should in SHOW1 because
        // SHOW1 is loaded earlier. It can save memory since we don't need to
        // duplicate the common functions.
    GROUP LOAD(ADDR(SHOW1_FADX_PM)) : {

        .SHOW1_PMSWAP: {
#ifndef ADSL_62
            ZPH_IOf.o(.text)
#endif
            ZPH_IOf_bis.o(.text)
            showtime_rx_tc_bis.o(.text)
            showtime_rx_bis.o(.text)
            ZPH_IOf_HDLC_bis.o(.text)
            plam.o(.text)
            iri_CalcBitsInRCB.o(.text)
            qos.o(.text)
            olr_Bpn_check_rx.o(.text)
            CheckForBpnReconfig.o(.text)
            dec_gain.o(.text)
            enc_gain.o(.text)
            showinit_rx_qam.o(.text)
            showinit_tx_qam.o(.text)
            ApplyFineGains.o(.text)
            changebat.o(.text)
            decimalgain.o(.text)
            IRI_IOf_FFT_showtime.o(.text)
            IRI_IOf_showtime.o(.text)
            alp_ResetARCellCnt.o(.text)
            GenerateTxATM_HEC.o(.text)
            updatefinegainlinsq.o(.text)
            ChooseFineGains_BIS.o(.text)
            CalcRate_BIS.o(.text)
            pll_show.o(.text)
            impulse_detect_bis.o(.text)
            ZPH_IOf_HDLC_bis_tx.o(.text)
            CalcAttndrDiag.o(.text)
            olr_Lp_check.o(.text)

            // rodata
#ifndef ADSLS_62
            ZPH_IOf.o(.rodata)
#endif
            ZPH_IOf_bis.o(.rodata)
            showtime_rx_tc_bis.o(.rodata)
            showtime_rx_bis.o(.rodata)
            ZPH_IOf_HDLC_bis.o(.rodata)
            plam.o(.rodata)
            iri_CalcBitsInRCB.o(.rodata)
            qos.o(.rodata)
            rx_ovhd_bis.o(.rodata)
            olr_Bpn_check_rx.o(.rodata)
            CheckForBpnReconfig.o(.rodata)
            dec_gain.o(.rodata)
            enc_gain.o(.rodata)
            showinit_rx_qam.o(.rodata)
            showinit_tx_qam.o(.rodata)
            ApplyFineGains.o(.rodata)
            changebat.o(.rodata)
            decimalgain.o(.rodata)
            IRI_IOf_FFT_showtime.o(.rodata)
            IRI_IOf_showtime.o(.rodata)
            alp_ResetARCellCnt.o(.rodata)
            //alp_ResetATCellCnt.o(.rodata) // Moved to SHOW2 ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
            GenerateTxATM_HEC.o(.rodata)
            updatefinegainlinsq.o(.rodata)
            ChooseFineGains_BIS.o(.rodata)

            CalcRate_BIS.o(.rodata)
            //IRI_IOf_showtime_tx.o(.rodata) // Moved to SHOW2 ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
            pll_show.o(.rodata)
            impulse_detect_bis.o(.rodata)
            ZPH_IOf_HDLC_bis_tx.o(.rodata)
            CalcAttndrDiag.o(.rodata)
            olr_Lp_check.o(.rodata)

        }
    } > SHOW1_CODE_MEM

    GROUP LOAD(ADDR(TXINIT_FADX_PM)) : {

        .TXINIT_PMSWAP: {
            tx_ovhd_ini_bis.o(.text)
            tx_ib_ini.o(.text)
            eoc_tx_ini.o(.text)
            tx_ib_ini_bis.o(.text)
            aoc_tx_ini.o(.text)
            tx_m3oh_b.o(.text)

            .TXINIT_MULT_DEF: {

                //C_SCOPE_NULL
//                showinittx.o(.text)   // Moved to Cache
                datapumpsetup_tx.o(.text)
                //CompFramingConstraints.o(.text)
                //BgIlvInit.o( .text)

                //C_SCOPE_STATIC
                latency.o(.text)
                tone_ord.o(.text)
                tone_reord_load.o(.text)
                CheckForBpnReconfig.o(.text)
                showinit_tx_qam.o(.text)
                enc_gain.o(.text)
                iri_InsertCP.o(.text)
                CalcNOMATP.o(.text)
                ComputeRMSFineGain.o(.text)
                decimalgain.o(.text)
                BinarySearch.o(.text)
            }

            // rodata
            tx_ovhd_ini_bis.o(.rodata)
            tx_ib_ini.o(.rodata)
            eoc_tx_ini.o(.rodata)
            tx_ib_ini_bis.o(.rodata)
            aoc_tx_ini.o(.rodata)
            tx_m3oh_b.o(.rodata)
        }
    } > TXINIT_CODE_MEM

    GROUP LOAD(ADDR(SHOW2_FADX_PM)) : {

        .SHOW2_PMSWAP: {
//#ifdef VRX218
              //XDSLRTFW-541: Platform_VR9_VRX318 (START_END)
//            tx_ovhd_bis.o(.text)
//#endif //#ifdef VRX218
//          showtime_tx_tc_bis.o(.text)       //AR9, split into two files, atm_tx_processing shared with showtime_tx_tc_dmt.c
            StartTxDataPump_BIS.o(.text)
            RShowtimeTxF_bis.o(.text)      //AR9, change name form showtime_tx_bis to RShowtimeTxF_bis
            olr_datapumpsetup.o(.text)
            olr_datapumpsetup1.o(.text)
            Configure_TCM_Bits.o(.text)
            //setuprxtonesregister.o(.text)    // moved from here to Resident Memory for lack of space
//            showinit_tx_olr.o(.text)   // Moved to Cache
            tx_plam_bis.o(.text)
//            rx_plam_bis.o(.text)       // Moved to Cache
            alp_ResetATCellCnt.o(.text) //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
            GenerateTxATM.o(.text)
            IRI_IOf_showtime_tx.o(.text) //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
            tone_reord_load.o(.text)
            //hs_mesg_bis.o(.text)
            CorruptFirstByteOfCWInIntlvBuffer.o(.text)
            Distributefinegains.o(.text)
            pm_rx_tc_bis.o(.text)
            //L3StatMachine.o(.text)

            // rodata
//#ifdef VRX218
              //XDSLRTFW-541: Platform_VR9_VRX318 (START_END)
//            tx_ovhd_bis.o(.rodata)
//#endif //#ifdef VRX218
//          showtime_tx_tc_bis.o(.rodata)      //AR9
            StartTxDataPump_BIS.o(.rodata)
            RShowtimeTxF_bis.o(.rodata)        //AR9
            olr_datapumpsetup.o(.rodata)
            olr_datapumpsetup1.o(.rodata)
            Configure_TCM_Bits.o(.rodata)
            //setuprxtonesregister.o(.rodata)    // moved from here to Resident Memory for lack of space
//            showinit_tx_olr.o(.rodata)  // Moved to Cache
            tx_plam_bis.o(.rodata)
//            rx_plam_bis.o(.rodata)   // Moved to Cache
            alp_ResetATCellCnt.o(.rodata) //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
            GenerateTxATM.o(.rodata)
            IRI_IOf_showtime_tx.o(.rodata) //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
            tone_reord_load.o(.rodata)
            //hs_mesg_bis.o(.rodata)
            CorruptFirstByteOfCWInIntlvBuffer.o(.rodata)
            Distributefinegains.o(.rodata)
            pm_rx_tc_bis.o(.rodata)
            //L3StatMachine.o(.rodata)

//AR9
       .SHOW2_MULT_DEF: {
                //C_SCOPE_NULL
                showtime_tx_tc_bis.o(.text)

                //C_SCOPE_STATIC
                atm_tx_processing.o(.text)
            }
        }
    } > SHOW2_CODE_MEM

    GROUP LOAD(ADDR(SHOWBG1_FADX_PM)) : {

        .SHOWBG1_PMSWAP: {
            showinit_rx_olrpm.o(.text)   // from SHOW1, Kannan

            .SHOWBG1_MULT_DEF: {
#ifndef ADSL_62
        //C_SCOPE_NULL
       olr_datapumpsetup2.o(.text)   // New file added, spilt from olr_datamupmsetup.o
#endif

            }

            // rodata
            showinit_rx_olrpm.o(.rodata)   // from SHOW1, Kannan

        }
    } > SHOWBG1_CODE_MEM

    GROUP LOAD(ADDR(SHOWBG1DMT_FADX_PM)) : {

        .SHOWBG1DMT_PMSWAP: {

            .SHOWBG1DMT_MULT_DEF: {

        //C_SCOPE_NULL

            }

            // rodata
        }
    } > SHOWBG1DMT_CODE_MEM

    GROUP LOAD(ADDR(SHOWBG2_FADX_PM)) : {

        .SHOWBG2_PMSWAP: {
        //!! SHOWBG2 is a common codeswap page of DMT and BIS mode during showtime. Generally, files considered
        // to be put in this page are the ones that have functions needed by both DMT and BIS. Files needed to be
        // moved out of this page should be aware that you should update both DMT and BIS codeswap page if they
        // include DMT and BIS common functions. If you know some files have functions that are not needed for both
        // BIS and DMT, and there is room to contain them in other corresponding mode showtime codeswap page, please
        // do remove them from this page.


            synsymbl.o(.text)
            datasymbl.o(.text)
            synsymbl_b.o(.text)
//            dd_snrfdq.o(.text)           // Moved to Cache
//            LogShowtimeEventA.o(.text)   // Moved to Cache
            showtime_rx_b.o(.text)
//            SetUpSWRSDetectBins.o(.text)
            CalcAvgMargin.o(.text)
            bitload3.o(.text)
//            dec_adap_b.o(.text)          // Moved to Cache
//            iri_dec_adap.o(.text)
//            iri_iof_ddSnrFdqUtils.o(.text)  // Moved to Cache
            dec_adap.o(.text)
            //STR_DecAdapt.o(.text)
            noiseacc_st.o(.text)
            vecmult_st.o(.text)
            cmplxvecmult.o(.text)
            cmplxvecmultloop.o(.text)
//            olrpm_RxProcessing.o(.text)   // Moved to Cache
            RxCEOC_com.o(.text)
            fdqmult.o(.text)
            fdqmultloop.o(.text)
            DoRxSyncSymbolOLRPM.o(.text)
       UpdateRTV.o(.text)               //Yang: split from iri_iof1.c in Res
      L3StatMachine.o(.text)
            // rodata
            synsymbl.o(.rodata)
            datasymbl.o(.rodata)
            synsymbl_b.o(.rodata)
//          dd_snrfdq.o(.rodata)           // Moved to Cache
//          LogShowtimeEventA.o(.rodata)   // Moved to Cache
            showtime_rx_b.o(.rodata)
            CalcAvgMargin.o(.rodata)
            bitload3.o(.rodata)
//          dec_adap_b.o(.rodata)          // Moved to Cache
//            iri_dec_adap.o(.rodata)
//          iri_iof_ddSnrFdqUtils.o(.rodata)  // Moved to Cache
            dec_adap.o(.rodata)
            //STR_DecAdapt.o(.rodata)
            noiseacc_st.o(.rodata)
            vecmult_st.o(.rodata)
            cmplxvecmult.o(.rodata)
            cmplxvecmultloop.o(.rodata)
//          olrpm_RxProcessing.o(.rodata)   // Moved to Cache
            RxCEOC_com.o(.rodata)
            fdqmult.o(.rodata)
            fdqmultloop.o(.rodata)
            DoRxSyncSymbolOLRPM.o(.rodata)
       UpdateRTV.o(.rodata)           //Yang: split from iri_iof1.c in Res
      L3StatMachine.o(.rodata)
        }
    } > SHOWBG2_CODE_MEM

#ifndef VRX518
    GROUP: {
        .SHWBG3A: {
            * (BG_CACHE_2)
        }
    } > BG_CACHE_2

    GROUP: {
        .SHWBG3B: {
            * (BG_CACHE_2)
        }
    } > BG_CACHE_2
#endif

    GROUP LOAD(ADDR(SHT1DMT_FADX_PM)) : {

        .SHT1DMT_PMSWAP: {
            iri_BitswapLoad.o(.text)
            iri_RemoveCP.o(.text)
            rx_eoc1.o(.text)
            fifo_dmt.o(.text)


            .SHT1DMT_MULT_DEF: {

                //C_SCOPE_NULL
                showtime_dmt.o(.text)

                //C_SCOPE_STATIC
                IRI_IOf_dmt.o(.text)
                //olrpm_RxProcessing.o(.text)
                impulse_detect.o(.text)


                //C_SCOPE_NULL
                showtime_tc_dmt.o(.text)
                ZPH_IOf_dmt.o(.text)

                //C_SCOPE_STATIC
                qos.o(.text)
#ifndef ADSL_62
                ZPH_IOf.o(.text)
#endif
                alp_enableaai_txrx.o(.text)
                alp_ResetARCellCnt.o(.text)
                IRI_IOf_FFT_showtime.o(.text)
                IRI_IOf_showtime.o(.text)
                GenerateTxATM.o(.text)
                pll_show.o(.text)
            }

            // rodata
            iri_BitswapLoad.o(.rodata)
            iri_RemoveCP.o(.rodata)
            rx_eoc1.o(.rodata)
            fifo_dmt.o(.rodata)

        }
    } > SHT1DMT_CODE_MEM

    GROUP LOAD(ADDR(SHT2DMT_FADX_PM)) : {

        .SHT2DMT_PMSWAP: {
            .SHT2DMT_MULT_DEF: {
                //C_SCOPE_NULL
                showtime_dmt_tx.o(.text)
                showtime_tx_tc_dmt.o(.text)

                //C_SCOPE_STATIC
                IRI_IOf_dmt.o(.text)
                IRI_IOf_showtime_tx.o(.text)
                alp_ResetATCellCnt.o(.text)
      atm_tx_processing.o(.text)

// for DANUBE build, this page is pretty small, so some of SHT1DMT page goes here
//#ifdef DANUBE_MEM   // we want this to apply for SE and SEoD.

                //C_SCOPE_NULL
//                bitswap.o(.text)   // Moved to Cache

                //C_SCOPE_STATIC
                tone_ord.o(.text)
                decimalgain.o(.text)
                dec_gain.o(.text)
                //olrpm_rxprocessing.o(.text)
//#endif
            }

            // rodata
        }
    } > SHT2DMT_CODE_MEM

    GROUP LOAD(ADDR(SLEEP_FADX_PM)) : {
        .SLEEP_PMSWAP: {
            .SLEEP_MULT_DEF: {
                //C_SCOPE_NULL
                sleep.o(.text)
                IRI_sleep.o(.text)
                GenRvbTwoDisjointBands.o(.text)
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (START_END)
                nlnf.o(.text)

                //C_SCOPE_STATIC
                //XDSLRTFW-1089: Bugfix_ALL_ALL_ALL_MicroFilterDetectionFails (Start_End)
                STR_ReconfigDecim2_HPF.o(.text)
                IRI_sync.o(.text)
                STR_clearaec.o(.text)
                STR_cleardec.o(.text)
                STR_reorderdec.o(.text)
                medley.o(.text)
                GenMedly.o(.text)
                STR_Dec.o(.text)
                STR_Aec.o(.text)
                frm_sync.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                STR_DecAdapt.o(.text)
//                iri_dec_adap.o(.text)
                stateini.o(.text)
      //XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start)
      RCReverb1RxF.o(.text)
      HybridTraining.o(.text)
#ifdef ADSL_62
                AFED_HybTrainUtilities.o(.text)
                //VR9_AfeHybr.o(.text)
      DoubleTrainingPGAHandler.o(.text)   //Added new file for sleep state DoublePGA Training
#endif
      //XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (End)
#ifndef ADSL_62
                afe_b.o(.text)
#endif
            }

            // rodata

        }
    } > SLEEP_CODE_MEM



    GROUP LOAD(ADDR(BIS_RAM_FADX_DM_BT)): {
        .BIS_RAM_DMSWAP ALIGN(4): {
            *(BIS_RAM)
        }
    } > BIS_RAM

    GROUP LOAD(ADDR(DMT_RAM_FADX_DM)): {

        .DMT_RAM_DMSWAP ALIGN(4): {
            gdata.o(DMT_RAM)
            gdata_dmt.o(DMT_RAM)
            SWAP_SHT1DMT.o(DMT_RAM)
            rinfotbl.o(DMT_RAM)
            exchdata.o(DMT_RAM)
            exchdata.o(DMT_RAM)
            *(DMT_RAM)
        }
    } > DMT_RAM

    GROUP LOAD(ADDR(BULK_O1_FADX_DM)): {

        .BULK_O1_DMSWAP ALIGN(4): {
            *(BULK_O1)
        }
    } > BULK_O1

    GROUP LOAD(ADDR(BULK_O2_FADX_DM_BT)): {
        .BULK_O2_DMSWAP ALIGN(4): {
            *(BULK_O2)
        }
    } > BULK_O2

    GROUP: {
        .PERSISTENT_MEM ALIGN(4): {
            *(PERSISTENT_RAM)
        }
    } > PERSISTENT_MEM

    GROUP: {
        .PERSISTENT_MEM_VDSL ALIGN(4): {
            *(PERSISTENT_RAM_VDSL)
        }
    } > PERSISTENT_MEM_VDSL

    GROUP: {
        .PERSISTENT_MEM_COMMON ALIGN(4): {
            *(PERSISTENT_RAM_COMMON)
        }
    } > PERSISTENT_MEM_COMMON

    GROUP: {
        .X_MEM ALIGN(4): {
            *(X_RAM)
        }
    } > X_MEM

    GROUP: {
        .Y_MEM ALIGN(4): {
            *(Y_RAM)
        }
    } > Y_MEM


    GROUP LOAD(ADDR(GHS_TO_SHOW_FADX_DM)): {

        .GHS_TO_SHOW_DMSWAP ALIGN(4): {
            *(GHS_TO_SHOW)
        }
    } > GHS_TO_SHOW

    GROUP LOAD(ADDR(ILV1_GHS_FADX_DM_BT)): {
        .ILV1_GHS_DMSWAP ALIGN(4): {
            * (ILV1_GHS_RAM)
        }
    } > ILV1_PTR_SPACE

    GROUP LOAD(ADDR(ILV2_FADX_DM_BT)): {
        .ILV2_DMSWAP ALIGN(4): {
            * (ILV2_RAM)
        }
    } > ILV2

    GROUP LOAD(ADDR(deILV_PTR_SPACE_FADX_DM_BT)): {
        .deILV_PTR_SPACE_DMSWAP ALIGN(4): {
            * (deILV_PTR_SPACE_RAM)
        }
    } > deILV_PTR_SPACE

    GROUP LOAD(ADDR(deILV1_FADX_DM_BT)): {
        .deILV1_DMSWAP ALIGN(4): {
            * (deILV1_RAM)
        }
    } > deILV1

    GROUP LOAD(ADDR(deILV2_BISDBG_FADX_DM_BT)): {
        .deILV2_BISDBG_DMSWAP ALIGN(4): {
            * (deILV2_BISDBG_RAM)
      SWAP_BG_CACHE_1_0.o(deILV2_BISDBG_RAM)
        }
    } > deILV2_BISDBG

    GROUP: {
        .deILV2_OBIS_BSS ALIGN(4): {
            * (BIS_deILV2_BSS)
        }
    } > deILV2_OBIS_BSS

    GROUP: {
        .deILV2_ODMT_BSS ALIGN(4): {
            * (DMT_deILV2_BSS)
        }
    } > deILV2_ODMT_BSS

    GROUP LOAD(ADDR(deILV3_FADX_DM_BT)): {
        .deILV3_DMSWAP ALIGN(4): {
            * (deILV3_RAM)
        }
    } > deILV3

#ifdef ADSL_62

    // place holder for Tx/RX Ucode
    GROUP : {
        .ZEP_TX_UCODE_DMSWAP ALIGN(4) : {
            fci_prog_tx =.;
        }
    } > ZEP_TX_UCODE_DM

    GROUP : {
        .ZEP_RX_UCODE_DMSWAP ALIGN(4) : {
            fci_prog_rx =.;
        }
    } > ZEP_RX_UCODE_DM

    // no swap-page
    GROUP:{
        .EXTENDED_RES_BSS ALIGN(4): {
          __gl_ExtendedResBssStart = .;
            *(EXTENDED_RES_BSS)
          __gl_ExtendedResBssEnd = .;
        }
    } > SHOW_N_TRAIN_DM

    GROUP LOAD((ADDR(SHOW_N_TRAIN_FADX_DM_BT))): {
        .SHOW_N_TRAIN_DMSWAP ALIGN(4) : {
            *(.SHOW_N_TRAIN_DM)
        }
    } > SHOW_N_TRAIN_DM

    GROUP LOAD((ADDR(STR_IIR_COEFS_FADX_DM_BT))): {
        .STR_IIR_COEFS_DMSWAP ALIGN(4) : {
            STR_Filt.o(.data*)
        }
    } > SHOW_N_TRAIN_DM

    // no swap-page
    GROUP: {
        .EXTENDED_TRAIN_BSS ALIGN(4): {
            __gl_ExtendedTrainBssStart = .;
            *(EXTENDED_TRAIN_BSS)
            __gl_ExtendedTrainBssEnd = .;
        }
    } > SHOW_N_TRAIN_DM

    // ADSL2_2BC
    GROUP LOAD((ADDR(ZEP_TX_UCODE_ADSL2_2BC_FADX_DM_BT))): {
        .ZEP_TX_UCODE_ADSL2_2BC_DMSWAP ALIGN(4) : {
            Zep_microCodeDataAdsl2.o(.ZEP_TX_UCODE)
        }
    } > ZEP_TX_UCODE_ADSL2_2BC_DM

    GROUP LOAD((ADDR(ZEP_RX_UCODE_ADSL2_2BC_FADX_DM_BT))): {
        .ZEP_RX_UCODE_ADSL2_2BC_DMSWAP ALIGN(4) : {
            Zep_microCodeDataAdsl2.o(.ZEP_RX_UCODE)
        }
    } > ZEP_RX_UCODE_ADSL2_2BC_DM


   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
    GROUP LOAD((ADDR(ZEP_RX_RETX_LP1_UCODE_FADX_DM))): {
        .ZEP_RX_RETX_LP1_UCODE_DMSWAP ALIGN(4) : {
            Zep_microCodeDataAdsl2.o(.ZEP_RX_RETX_LP1_UCODE)
        }
    } > ZEP_RX_RETX_LP1_UCODE_DM
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)


    // ADSL1 LP0
    GROUP LOAD((ADDR(ZEP_TX_UCODE_ADSL1_LP0_FADX_DM))): {
        .ZEP_TX_UCODE_ADSL1_LP0_DMSWAP ALIGN(4) : {
            Zep_microCodeDataAdsl1_lp0.o(.ZEP_TX_UCODE)
        }
    } > ZEP_TX_UCODE_ADSL1_LP0_DM

    GROUP LOAD((ADDR(ZEP_RX_UCODE_ADSL1_LP0_FADX_DM))): {
        .ZEP_RX_UCODE_ADSL1_LP0_DMSWAP ALIGN(4) : {
            Zep_microCodeDataAdsl1_lp0.o(.ZEP_RX_UCODE)
        }
    } > ZEP_RX_UCODE_ADSL1_LP0_DM

    // ADSL1 LP1
    GROUP LOAD((ADDR(ZEP_TX_UCODE_ADSL1_LP1_FADX_DM))): {
        .ZEP_TX_UCODE_ADSL1_LP1_DMSWAP ALIGN(4) : {
            Zep_microCodeDataAdsl1_lp1.o(.ZEP_TX_UCODE)
        }
    } > ZEP_TX_UCODE_ADSL1_LP1_DM

    GROUP LOAD((ADDR(ZEP_RX_UCODE_ADSL1_LP1_FADX_DM))): {
        .ZEP_RX_UCODE_ADSL1_LP1_DMSWAP ALIGN(4) : {
            Zep_microCodeDataAdsl1_lp1.o(.ZEP_RX_UCODE)
        }
    } > ZEP_RX_UCODE_ADSL1_LP1_DM

    GROUP LOAD((ADDR(SRC_COEFS_4KHZ_FADX_DM_BT))): {
        .SRC_COEFS_4KHZ_DMSWAP ALIGN(4) : {
            *(.SRC_COEFS_4KHZ)
        }
    } > STR_SRC_COEFS_4KHZ

    GROUP: {
       .LD_ST_MKERNEL_DMSWAP ALIGN(4): {
           * (LD_ST_MKERNEL)
       }
    } > LOCAL_LD_ST

    GROUP : {
        .ZEP_TX_RX_UCODE_MEM ALIGN(4) : {
            __gla_ZepTxRxUcodeStart = .;
        }
    } > TX_RX_UCODE

    GROUP: {
        .ZEP_PRAM_MEM ALIGN(4): {
            __gla_ZepPramStart = .;
        }
    } > ZEP_PRAM


    GROUP : {
        .ZEP_OVHD_FIFO ALIGN(4) : {
            __gla_ZepOhvdFifoStart = .;
        }
    } > ZEP_OVHD_FIFO

    // note that DILV is on top of ILV
    GROUP : {
        .SHOW_HW_DILV_MEM ALIGN(4) : {
            __gla_HwIlvDilvStart = .;
            __gla_ShowHwDilvStart = .;
        }
    } > Z_DILV

    GROUP : {
        .SHOW_HW_ILV_MEM ALIGN(4) : {
            __gla_ShowHwIlvStart = .;
        }
    } > Z_ILV


#endif

    GROUP: {
       .LOCAL_LD_ST_DMSWAP ALIGN(4): {
            __gl_LdStDmSwapStart = .;
           * (LOCAL_LD_ST)
            __gl_LdStDmSwapEnd = .;
       }
    } > LOCAL_LD_ST

#ifdef ADSL_62
    GROUP: {
        .stack SIZE(DEFINED _STACKSIZE?_STACKSIZE:7*1024):{}
    } > STACK_RAM
#else
    GROUP: {
        .stack SIZE(DEFINED _STACKSIZE?_STACKSIZE:7680):{}
    } > STACK_RAM
#endif

#ifdef TARGET_ASIM
    GROUP LOAD(ADDR(SIM_IRAM_FADX_PM_BT)) : {
#else
    GROUP: {
#endif
        .SIM_IRAM_PMSWAP: {
            Gen_PNMedley_14thorder.o(.text, .rodata*)
            RQuietEF1TxF.o(.text, .rodata*)
            RCQuietEF1RxF.o(.text, .rodata*)
            RReverbFrTx3F.o(.text, .rodata*)
            RCReverbFR6RxF.o(.text, .rodata*)
            RSegueFR5TxF.o(.text, .rodata*)
            RSegueFrTx3F.o(.text, .rodata*)
            RCMedleyFRRxF.o(.text, .rodata*)
            RMsgs1FrTxF.o(.text, .rodata*)
            RCMsgFRRxF.o(.text, .rodata*)
            medley.o(.text, .rodata*)
            profile3.o(.text, .rodata*)
            RCrc1FrTxF.o(.text, .rodata*)
            profile2.o(.text, .rodata*)
            TxInfoBit.o(.text, .rodata*)
            crc16.o(.text, .rodata*)
            RCCrcFr1RxF.o(.text, .rodata*)
            RQuietFR1TxF.o(.text, .rodata*)
            RCReverbFR8RxF.o(.text, .rodata*)
            RCReverbFR3RxF.o(.text, .rodata*)
            RReverbFrTxF.o(.text, .rodata*)
            RxFFTBufSTrans.o(.text, .rodata*)
            frm_sync.o(.text, .rodata*)
            RCPilotFR2RxF.o(.text, .rodata*)
            RSegueFrTxF.o(.text, .rodata*)
            RQuietFR2TxF.o(.text, .rodata*)
            RCReverbFR4RxF.o(.text, .rodata*)
            RLineProbeTxF.o(.text, .rodata*)
            RCEctFRRxF.o(.text, .rodata*)
            RCReverbFR5RxF.o(.text, .rodata*)
        }
    } > SIM_IRAM


#ifdef TARGET_ASIM
    GROUP LOAD(ADDR(SIM_RAM_FADX_DM_BT)): {
#else
    GROUP: {
#endif
        .SIM_RAM_DMSWAP ALIGN(4): {
            // any variables with the DATA_MAP_SIM macro
            * (SIM_RAM)
            * (STMBUF_RAM)
            Gen_PNMedley_14thorder.o(.bss*, .data*)
            RQuietEF1TxF.o(.bss*, .data*)
            RCQuietEF1RxF.o(.bss*, .data*)
            RReverbFrTx3F.o(.bss*, .data*)
            RCReverbFR6RxF.o(.bss*, .data*)
            RSegueFR5TxF.o(.bss*, .data*)
            RSegueFrTx3F.o(.bss*, .data*)
            RCMedleyFRRxF.o(.bss*, .data*)
            RMsgs1FrTxF.o(.bss*, .data*)
            RCMsgFRRxF.o(.bss*, .data*)
            medley.o(.bss*, .data*)
            profile3.o(.bss*, .data*)
            RCrc1FrTxF.o(.bss*, .data*)
            profile2.o(.bss*, .data*)
            TxInfoBit.o(.bss*, .data*)
            crc16.o(.bss*, .data*)
            RCCrcFr1RxF.o(.bss*, .data*)
            RQuietFR1TxF.o(.bss*, .data*)
            RCReverbFR8RxF.o(.bss*, .data*)
            RCReverbFR3RxF.o(.bss*, .data*)
            RReverbFrTxF.o(.bss*, .data*)
            RxFFTBufSTrans.o(.bss*, .data*)
            frm_sync.o(.bss*, .data*)
            RCPilotFR2RxF.o(.bss*, .data*)
            RSegueFrTxF.o(.bss*, .data*)
            RQuietFR2TxF.o(.bss*, .data*)
            RCReverbFR4RxF.o(.bss*, .data*)
            RLineProbeTxF.o(.bss*, .data*)
            RCEctFRRxF.o(.bss*, .data*)
            RCReverbFR5RxF.o(.bss*, .data*)
        }
    } > SIM_RAM

#ifdef ADSL_62
    GROUP LOAD((ADDR(HMP_MBOXES_FADX_DM_BT))): {
    //GROUP : {
        .HMP_MBOXES_DMSWAP ALIGN(4): {
            // do NOT remove or change the following symbol !!!
            __gt_HmpHeader = .;
                SHORT((0x1 << 8) | 0x1);             // version, num_of_mbox_pairs
                SHORT((0x1 << 8) | 0x4);             // offset_to_first_desc, size_of_desc,

            __gta_HmpMboxDescriptor = .;
                LONG(ADDR(ARC_TO_MEI_MBOX));
                LONG(SIZEOF(ARC_TO_MEI_MBOX)/2);
                LONG(ADDR(MEI_TO_ARC_MBOX));
                LONG(SIZEOF(MEI_TO_ARC_MBOX)/2);

            __gs_Me2ArcMboxCode = .;
            __gt_Me2ArcMboxMsg = .;
                SHORT(0);           // mbox_code
                SHORT(0);            // word0
                SHORT(0);            // word1
                SHORT(0);            // word2
                SHORT(0);            // word3
                SHORT(0);            // word4
                FILL(128*2);        // payload; FILL directive fills in BYTES!

            __gs_Arc2MeMboxCode = .;
            __gt_Arc2MeMboxMsg = .;
                SHORT(0);           // mbox_code
                SHORT(0);            // word0
                SHORT(0);            // word1
                SHORT(0);            // word2
                SHORT(0);            // word3
                SHORT(0);            // word4
                FILL(128*2);        // payload; FILL directive fills in BYTES!
        }
    } > HMP_MBOXES

    GROUP LOAD((ADDR(HMP_BUFFERS_FADX_DM_BT))): {
    //GROUP : {
        .HMP_BUFFERS_DMSWAP ALIGN(4): {
            hmp_data.o(.data)
            hmp_data.o(.bss)
        }
    } > HMP_MEM
#endif

// Flash/Sram Image section

    GROUP: {
        .ADSL_IMAGE_HEADER ALIGN(4): {
        _StartOfFlash = .;

#ifdef ADSL_62
            LONG(ADDR(ADSL_CACHE_HEADER_FADX) - ADDR(ADSL_IMAGE_HEADER_FADX) - 8);   // IMAGE SIZE in bytes
            LONG(0x00000000)                                            // the checksum

            // Num of Swap Pages - LONG(N) to be filled out by setup_codeswap.pl

#endif
            // The rest of ADSL_IMAGE_HEADER_BLOCK will be generated by setup_codeswap.pl
        }
    } > ADSL_IMAGE_HEADER_FADX


#ifndef ADSL_62
    GROUP LOAD(ADDR(XDMA_TEST_FADX_PM)): {
        .XDMA_TEST_PMSWAP ALIGN(4): {
#include "xdma_test.cmd"
        }
    } > INIT_CODE_MEM
#endif


    GROUP LOAD(ADDR(ONE_PORT_DEBUG_DATA_FADX_DM_BT)): {
        .ONE_PORT_DEBUG_DATA_DMSWAP ALIGN(4): {
            Vr9_1port_debug_data.o (.data*)
            Vr9_1port_debug_data.o (.bss*)
            }
    } > ONE_PORT_DEBUG_DATA

    GROUP LOAD(ADDR(BULK_DATA_RAM_FADX_DM_BT)): {
        .BULK_DATA_RAM_DMSWAP ALIGN(4): {
            *(.data*)
            *(.bss*)
            *(.rodata*)
            *(.lit*)
            *(.rdata*)
            *(.initdat*)
         *(HERC_API_RAM)

        }
    } > BULK_DATA_RAM

    GROUP LOAD(ADDR(BULK_DATA_RAM2_FADX_DM_BT)): {
        .BULK_DATA_RAM2_DMSWAP ALIGN(4): {
           __gla_BULK_DATA_RAM2_Start = .;
            *(BULK_DATA2)
        }
    } > BULK_DATA_RAM2


#ifdef ADSL_62
    // we will manually maintain the cache pages; probably won't change much.
    GROUP: {
        .ADSL_CACHE_HEADER ALIGN(4): {
        _AdslCacheHeader = .;
            LONG(ADDR(LAST_FADX) - ADDR(ADSL_CACHE_HEADER_FADX) - 8);   // IMAGE SIZE in bytes
            LONG(0x00000000)                      // image checksum
            LONG(1)                               // number of cache pages - hardcoded

            LONG(ADDR(BG_CACHE_1_FADX) - ADDR(ADSL_CACHE_HEADER_FADX));
            LONG(ADDR(.BG_CACHE_1_PMSWAP));
            LONG(SIZEOF(BG_CACHE_1_FADX)/4);
            LONG(0);
            LONG(0);
            LONG(0);
        }
    } > ADSL_CACHE_HEADER_FADX
#endif
}
