# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
//harvardArch_biscs.cmd
//
// History
//
// 21/11/2011 Hanyu: Added MFD state to integrate MFD state functions to VRx "SLEEP" state.
//   Grep for XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect
//
//****************************************************************************

// NOTE: any comment line with the identifier CODESWAP_LABEL is used by the codeswap build tools
// modify with caution

// Overview of Socrates memory map
// 0x00000 - 0x0FFFF    64K    Instruction Memory
// 0x10000 - 0x15FFF    24K    Bulk Data Memory
// 0x16000 - 0x17FFF    8K    Unused
// 0x18000 - 0x19FFF    8K    X Memory
// 0x1A000 - 0x1BFFF    8K    Y Memory
// 0x1C000 - 0x1C3FF    1K    MEI Memory
// 0x1C400 - 0x2BFFF    64K    Unused
// 0x2C000 - 0x4FFFF    196K    ADSL Accelerator (ADSL Memory Map)
// 0x50000 - 0xFDFFF    712K    Unused
// 0xFE000 - 0xFFFFF    8K    Local Load/Store Memory

#ifdef STRAT_MEM
    #include "STRATIPHY.mem"
#endif

#ifdef DANUBE_MEM
    #include "DANUBE_sleep.mem"
#endif

#ifdef HERCULES_MEM
    #include "HERCULES.mem"
#endif



MEMORY {

//
// Swap Pages and their link time addresses
//
    // interrupt vector and isr
    INTR_CODE_MEM:           ORIGIN = ADDR(CK)    LENGTH = SIZEOF(CK)

    //
    // overlay group 1
    //
    R_NOSHOW_CODE_MEM:       ORIGIN = ADDR(CI)    LENGTH = SIZEOF(CI)
    SHOWBG2_CODE_MEM:        ORIGIN = ADDR(CI)    LENGTH = SIZEOF(CI)

    RES_CODE_MEM:            ORIGIN = ADDR(CA)    LENGTH = SIZEOF(CA)

    //
    // overlay group 2.0
    //
    INIT_CODE_MEM:           ORIGIN = ADDR(CB)    LENGTH = SIZEOF(CB)

    //
    // overlay group 2.1
    //
    HNSHK1_CODE_MEM:         ORIGIN = ADDR(CM)    LENGTH = SIZEOF(CM)
    SLEEP_CODE_MEM:          ORIGIN = ADDR(CM)    LENGTH = SIZEOF(CM)
    HWTESTS_1_CODE_MEM:      ORIGIN = ADDR(CM)    LENGTH = SIZEOF(CM)

    HNSHK2_CODE_MEM:         ORIGIN = ADDR(CN)    LENGTH = SIZEOF(CN)
    MODEM_TEST_CODE_MEM:     ORIGIN = ADDR(CN)    LENGTH = SIZEOF(CN)

    //
    // overlay group 2.2
    //
    R_NOGHS_CODE_MEM:        ORIGIN = ADDR(CJ)    LENGTH = SIZEOF(CJ)

    XCVR0_CODE_MEM:          ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    DISC1_CODE_MEM:          ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    DISC2_CODE_MEM:          ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    XCVR2_CODE_MEM:          ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    XCVRDMT_CODE_MEM:        ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    MTDQ_CODE_MEM:           ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    BTLD_CODE_MEM:           ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    BTLDDMT_CODE_MEM:        ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    EXCH1_CODE_MEM:          ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    SHOW1_CODE_MEM:          ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)
    SHT1DMT_CODE_MEM:        ORIGIN = ADDR(CC)    LENGTH = SIZEOF(CC)

    //
    // overlay group 2.2.0
    //
    XCVR1_CODE_MEM:          ORIGIN = ADDR(CD)    LENGTH = SIZEOF(CD)
    ANAL_CODE_MEM:           ORIGIN = ADDR(CD)    LENGTH = SIZEOF(CD)
    ANL1DMT_CODE_MEM:        ORIGIN = ADDR(CD)    LENGTH = SIZEOF(CD)
    TDQTEST_CODE_MEM:        ORIGIN = ADDR(CD)    LENGTH = SIZEOF(CD)
    RXINIT_CODE_MEM:         ORIGIN = ADDR(CD)    LENGTH = SIZEOF(CD)

    //
    // overlay group 2.2.1
    //
    EXCHDMT_CODE_MEM:        ORIGIN = ADDR(CG)    LENGTH = SIZEOF(CG)
    SHOWBG1_CODE_MEM:        ORIGIN = ADDR(CG)    LENGTH = SIZEOF(CG)
    EXCH3_CODE_MEM:          ORIGIN = ADDR(CG)    LENGTH = SIZEOF(CG)

    TXINIT_CODE_MEM:         ORIGIN = ADDR(CH)    LENGTH = SIZEOF(CH)
    EXCH2_CODE_MEM:          ORIGIN = ADDR(CH)    LENGTH = SIZEOF(CH)
    SHOW2_CODE_MEM:          ORIGIN = ADDR(CH)    LENGTH = SIZEOF(CH)
    SHT2DMT_CODE_MEM:        ORIGIN = ADDR(CH)    LENGTH = SIZEOF(CH)

    // cache page
    BG_CACHE_1_CODE_MEM:     ORIGIN = ADDR(BG_CACHE_1)  LENGTH = SIZEOF(BG_CACHE_1)
    BG_CACHE_2_CODE_MEM:     ORIGIN = ADDR(BG_CACHE_2)  LENGTH = SIZEOF(BG_CACHE_2)

    //
    // Data Pages and their link time addresses
    //
    //SECRODATA_DATA_MEM:    ORIGIN = ADDR(DA)    LENGTH = SIZEOF(DA)
    BIS_RAM:                 ORIGIN = ADDR(DA)    LENGTH = SIZEOF(DA)
    DMT_RAM:                 ORIGIN = ADDR(DA)    LENGTH = SIZEOF(DA)

    BULK_O1:                 ORIGIN = ADDR(DB)    LENGTH = SIZEOF(DB)
    BULK_O2:                 ORIGIN = ADDR(DB)    LENGTH = SIZEOF(DB)

    
    //
    // swap pages and their addresses/offsets inside the .bin image
    //
    ADSL_IMAGE_HEADER_FADX: ORIGIN = 0x00080000, LENGTH = SIZEOF(.ADSL_IMAGE_HEADER)

    // permanent pages after reaching showtime
    BG_CACHE_1_FADX_PM:       ORIGIN = ADDR(ADSL_IMAGE_HEADER_FADX) + SIZEOF(ADSL_IMAGE_HEADER_FADX), LENGTH = (((SIZEOF(.BG_CACHE_1_PMSWAP)+3)/4)*4)
    BG_CACHE_2_FADX_PM:       ORIGIN = ADDR(BG_CACHE_1_FADX_PM) + SIZEOF(BG_CACHE_1_FADX_PM), LENGTH = (((SIZEOF(.BG_CACHE_2_PMSWAP)+3)/4)*4)

    // show and show init pages
    SHOW1_FADX_PM:          ORIGIN = ADDR(BG_CACHE_2_FADX_PM) + SIZEOF(BG_CACHE_2_FADX_PM), LENGTH = (((SIZEOF(.SHOW1_PMSWAP1)+3)/4)*4)
    SHOW2_FADX_PM:          ORIGIN = ADDR(SHOW1_FADX_PM) + SIZEOF(SHOW1_FADX_PM), LENGTH = (((SIZEOF(.SHOW2_PMSWAP1)+3)/4)*4)
    TXINIT_FADX_PM:         ORIGIN = ADDR(SHOW2_FADX_PM) + SIZEOF(SHOW2_FADX_PM), LENGTH = (((SIZEOF(.TXINIT_PMSWAP1)+3)/4)*4)
    SHOWBG1_FADX_PM:        ORIGIN = ADDR(TXINIT_FADX_PM) + SIZEOF(TXINIT_FADX_PM), LENGTH = (((SIZEOF(.SHOWBG1_PMSWAP1)+3)/4)*4)
    SHOWBG2_FADX_PM:        ORIGIN = ADDR(SHOWBG1_FADX_PM) + SIZEOF(SHOWBG1_FADX_PM), LENGTH = (((SIZEOF(.SHOWBG2_PMSWAP1)+3)/4)*4)
    SHT1DMT_FADX_PM:        ORIGIN = ADDR(SHOWBG2_FADX_PM) + SIZEOF(SHOWBG2_FADX_PM), LENGTH = (((SIZEOF(.SHT1DMT_PMSWAP1)+3)/4)*4)
    SHT2DMT_FADX_PM:        ORIGIN = ADDR(SHT1DMT_FADX_PM) + SIZEOF(SHT1DMT_FADX_PM), LENGTH = (((SIZEOF(.SHT2DMT_PMSWAP1)+3)/4)*4)

    // training pages
    HNSHK1_FADX_PM:         ORIGIN = ADDR(SHT2DMT_FADX_PM) + SIZEOF(SHT2DMT_FADX_PM), LENGTH = (((SIZEOF(.HNSHK1_PMSWAP1)+3)/4)*4)
    HNSHK2_FADX_PM:         ORIGIN = ADDR(HNSHK1_FADX_PM) + SIZEOF(HNSHK1_FADX_PM), LENGTH = (((SIZEOF(.HNSHK2_PMSWAP1)+3)/4)*4)
    XCVR0_FADX_PM:          ORIGIN = ADDR(HNSHK2_FADX_PM) + SIZEOF(HNSHK2_FADX_PM), LENGTH = (((SIZEOF(.XCVR0_PMSWAP1)+3)/4)*4)
    DISC1_FADX_PM:          ORIGIN = ADDR(XCVR0_FADX_PM) + SIZEOF(XCVR0_FADX_PM), LENGTH = (((SIZEOF(.DISC1_PMSWAP1)+3)/4)*4)
    DISC2_FADX_PM:          ORIGIN = ADDR(DISC1_FADX_PM) + SIZEOF(DISC1_FADX_PM), LENGTH = (((SIZEOF(.DISC2_PMSWAP1)+3)/4)*4)
    XCVR1_FADX_PM:          ORIGIN = ADDR(DISC2_FADX_PM) + SIZEOF(DISC2_FADX_PM), LENGTH = (((SIZEOF(.XCVR1_PMSWAP1)+3)/4)*4)
    XCVR2_FADX_PM:          ORIGIN = ADDR(XCVR1_FADX_PM) + SIZEOF(XCVR1_FADX_PM), LENGTH = (((SIZEOF(.XCVR2_PMSWAP1)+3)/4)*4)
    ANAL_FADX_PM:           ORIGIN = ADDR(XCVR2_FADX_PM) + SIZEOF(XCVR2_FADX_PM), LENGTH = (((SIZEOF(.ANAL_PMSWAP1)+3)/4)*4)
    ANL1DMT_FADX_PM:        ORIGIN = ADDR(ANAL_FADX_PM) + SIZEOF(ANAL_FADX_PM), LENGTH = (((SIZEOF(.ANL1DMT_PMSWAP1)+3)/4)*4)
    MTDQ_FADX_PM:           ORIGIN = ADDR(ANL1DMT_FADX_PM) + SIZEOF(ANL1DMT_FADX_PM), LENGTH = (((SIZEOF(.MTDQ_PMSWAP1)+3)/4)*4)
    TDQTEST_FADX_PM:        ORIGIN = ADDR(MTDQ_FADX_PM) + SIZEOF(MTDQ_FADX_PM), LENGTH = (((SIZEOF(.TDQTEST_PMSWAP1)+3)/4)*4)
    BTLD_FADX_PM:           ORIGIN = ADDR(TDQTEST_FADX_PM) + SIZEOF(TDQTEST_FADX_PM), LENGTH = (((SIZEOF(.BTLD_PMSWAP1)+3)/4)*4)
    BTLDDMT_FADX_PM:        ORIGIN = ADDR(BTLD_FADX_PM) + SIZEOF(BTLD_FADX_PM), LENGTH = (((SIZEOF(.BTLDDMT_PMSWAP1)+3)/4)*4)
    RXINIT_FADX_PM:         ORIGIN = ADDR(BTLDDMT_FADX_PM) + SIZEOF(BTLDDMT_FADX_PM), LENGTH = (((SIZEOF(.RXINIT_PMSWAP1)+3)/4)*4)
    EXCH1_FADX_PM:          ORIGIN = ADDR(RXINIT_FADX_PM) + SIZEOF(RXINIT_FADX_PM), LENGTH = (((SIZEOF(.EXCH1_PMSWAP1)+3)/4)*4)
    EXCH2_FADX_PM:          ORIGIN = ADDR(EXCH1_FADX_PM) + SIZEOF(EXCH1_FADX_PM), LENGTH = (((SIZEOF(.EXCH2_PMSWAP1)+3)/4)*4)
    EXCH3_FADX_PM:          ORIGIN = ADDR(EXCH2_FADX_PM) + SIZEOF(EXCH2_FADX_PM), LENGTH = (((SIZEOF(.EXCH3_PMSWAP1)+3)/4)*4)
    EXCHDMT_FADX_PM:        ORIGIN = ADDR(EXCH3_FADX_PM) + SIZEOF(EXCH3_FADX_PM), LENGTH = (((SIZEOF(.EXCHDMT_PMSWAP1)+3)/4)*4)
    R_NOGHS_FADX_PM:        ORIGIN = ADDR(EXCHDMT_FADX_PM) + SIZEOF(EXCHDMT_FADX_PM), LENGTH = (((SIZEOF(.R_NOGHS_PMSWAP1)+3)/4)*4)

    SLEEP_FADX_PM:          ORIGIN = ADDR(R_NOGHS_FADX_PM) + SIZEOF(R_NOGHS_FADX_PM), LENGTH = (((SIZEOF(.SLEEP_PMSWAP)+3)/4)*4)
 MODEM_TEST_FADX_PM:        ORIGIN = ADDR(SLEEP_FADX_PM) + SIZEOF(SLEEP_FADX_PM), LENGTH = (((SIZEOF(.MODEM_TEST_PMSWAP)+3)/4)*4)
 HWTESTS_1_FADX_PM:         ORIGIN = ADDR(MODEM_TEST_FADX_PM) + SIZEOF(MODEM_TEST_FADX_PM), LENGTH = (((SIZEOF(.HWTESTS_1_PMSWAP)+3)/4)*4)
    XCVRDMT_FADX_PM:        ORIGIN = ADDR(HWTESTS_1_FADX_PM) + SIZEOF(HWTESTS_1_FADX_PM), LENGTH = (((SIZEOF(.XCVRDMT_PMSWAP1)+3)/4)*4)
    DMT_RAM_FADX_DM:        ORIGIN = ADDR(XCVRDMT_FADX_PM) + SIZEOF(XCVRDMT_FADX_PM), LENGTH = (((SIZEOF(.DMT_RAM_DMSWAP1)+3)/4)*4)
    BULK_O1_FADX_DM:        ORIGIN = ADDR(DMT_RAM_FADX_DM) + SIZEOF(DMT_RAM_FADX_DM), LENGTH = (((SIZEOF(.BULK_O1_DMSWAP1)+3)/4)*4)

    // boot pages
    INTR_FADX_PM_BT:        ORIGIN = ADDR(BULK_O1_FADX_DM) + SIZEOF(BULK_O1_FADX_DM), LENGTH = (((SIZEOF(.INTR_PMSWAP)+3)/4)*4)
    RES_FADX_PM_BT:         ORIGIN = ADDR(INTR_FADX_PM_BT) + SIZEOF(INTR_FADX_PM_BT), LENGTH = (((SIZEOF(.RES_PMSWAP)+3)/4)*4)
    R_NOSHOW_FADX_PM_BT:    ORIGIN = ADDR(RES_FADX_PM_BT) + SIZEOF(RES_FADX_PM_BT), LENGTH = (((SIZEOF(.R_NOSHOW_PMSWAP)+3)/4)*4)
    INIT_FADX_PM_BT:        ORIGIN = ADDR(R_NOSHOW_FADX_PM_BT) + SIZEOF(R_NOSHOW_FADX_PM_BT), LENGTH = (((SIZEOF(.INIT_PMSWAP)+3)/4)*4)
    BIS_RAM_FADX_DM_BT:     ORIGIN = ADDR(INIT_FADX_PM_BT) + SIZEOF(INIT_FADX_PM_BT), LENGTH = (((SIZEOF(.BIS_RAM_DMSWAP)+3)/4)*4)
    BULK_O2_FADX_DM_BT:        ORIGIN = ADDR(BIS_RAM_FADX_DM_BT) + SIZEOF(BIS_RAM_FADX_DM_BT), LENGTH = (((SIZEOF(.BULK_O2_DMSWAP)+3)/4)*4)
    BULK_DATA_RAM_FADX_DM_BT:  ORIGIN = ADDR(BULK_O2_FADX_DM_BT) + SIZEOF(BULK_O2_FADX_DM_BT), LENGTH = (((SIZEOF(.BULK_DATA_RAM_DMSWAP)+3)/4)*4)
    deILV1_FADX_DM_BT:     ORIGIN = ADDR(BULK_DATA_RAM_FADX_DM_BT) + SIZEOF(BULK_DATA_RAM_FADX_DM_BT), LENGTH = (((SIZEOF(.deILV1_DMSWAP)+3)/4)*4)
      ILV1_FADX_DM_BT:     ORIGIN = ADDR(deILV1_FADX_DM_BT) + SIZEOF(deILV1_FADX_DM_BT), LENGTH = (((SIZEOF(.ILV1_DMSWAP)+3)/4)*4)
    deILV2_BISDBG_FADX_DM_BT: ORIGIN = ADDR(ILV1_FADX_DM_BT) + SIZEOF(ILV1_FADX_DM_BT), LENGTH = (((SIZEOF(.deILV2_BISDBG_DMSWAP)+3)/4)*4)
    deILV3_FADX_DM_BT:        ORIGIN = ADDR(deILV2_BISDBG_FADX_DM_BT) + SIZEOF(deILV2_BISDBG_FADX_DM_BT), LENGTH = (((SIZEOF(.deILV3_DMSWAP)+3)/4)*4)
#ifdef TARGET_ASIM
    XDMA_TEST_FADX_PM:         ORIGIN = ADDR(deILV3_FADX_DM_BT) + SIZEOF(deILV3_FADX_DM_BT), LENGTH = (((SIZEOF(.XDMA_TEST_PMSWAP)+3)/4)*4)
    SIM_IRAM_FADX_PM_BT:       ORIGIN = ADDR(XDMA_TEST_FADX_PM) + SIZEOF(XDMA_TEST_FADX_PM), LENGTH = (((SIZEOF(.SIM_IRAM_PMSWAP)+3)/4)*4)
    SIM_RAM_FADX_DM_BT:        ORIGIN = ADDR(SIM_IRAM_FADX_PM_BT) + SIZEOF(SIM_IRAM_FADX_PM_BT), LENGTH = (((SIZEOF(.SIM_RAM_DMSWAP)+3)/4)*4)
    LAST_FADX:                 ORIGIN = ADDR(SIM_RAM_FADX_DM_BT) + SIZEOF(SIM_RAM_FADX_DM_BT), LENGTH = 0
#else
    XDMA_TEST_FADX_PM:         ORIGIN = ADDR(deILV3_FADX_DM_BT) + SIZEOF(deILV3_FADX_DM_BT), LENGTH = (((SIZEOF(.XDMA_TEST_PMSWAP)+3)/4)*4)
    LAST_FADX:                 ORIGIN = ADDR(XDMA_TEST_FADX_PM) + SIZEOF(XDMA_TEST_FADX_PM), LENGTH = 0
    //LAST_FADX:                 ORIGIN = ADDR(deILV3_FADX_DM_BT) + SIZEOF(deILV3_FADX_DM_BT), LENGTH = 0
#endif

}

SECTIONS {

    GROUP LOAD(ADDR(INTR_FADX_PM_BT)) : {
        .INTR_PMSWAP: {
            int_tables.o(.text)
        }
    } > INTR_CODE_MEM

    GROUP LOAD(ADDR(MODEM_TEST_FADX_PM)) : {
        .MODEM_TEST_PMSWAP: {
            //testModeOperation.o(.text)
        }
    } > MODEM_TEST_CODE_MEM

    GROUP LOAD(ADDR(HWTESTS_1_FADX_PM)) : {
        .HWTESTS_1_PMSWAP: {
            atm_loopback.o(.text)
            atm_loopback.o(.rodata)
        }
    } > HWTESTS_1_CODE_MEM

#ifdef USE_CACHE
    GROUP LOAD(ADDR(BG_CACHE_1_FADX_PM)) : {
        .BG_CACHE_1_PMSWAP: {

            decxcorr.o(.text)    
            memmove.o(.text)

            .BG_CACHE_1_0_MULT_DEF: {
                // hw io needed during training, sleep or hwtests
                IRI_sync.o(.text)

                // from xcvr2
                // C_/SCOPE_NULL
                frm_sync_proc_b.o(.text)    
                frm_sync_b.o(.text)    
                log2lintssi.o(.text)    
                ReverbSnr_b.o(.text)    
                ieee_flt.o(.text)    
                matrix.o(.text)    
                afe_b.o(.text)    
                RxfilterComp.o(.text)    
                logtolin.o(.text)    
                rxinvfiltcoef.o(.text)    
                BGChooseRevSegBin.o(.text)    
                fft.o(.text)    
                ifft_fix.o(.text)    
                fdq_init.o(.text)    
                FDQcoefPerTone.o(.text)    
                fdq_adj.o(.text)    
                fdq_update.o(.text)    
                find_sintbl.o(.text)    
                CalcHlinDiag.o(.text)    
                CalcHlogDiag.o(.text)    
            
                // C_/SCOPE_STATIC
                fft_bg.o(.text)    

                // BG FuNCTIONS all in DISC1_2
            
                // C_/SCOPE_NULL
                BgDetectMultiTones_Comb.o(.text)    
                CombSnrCalc_bis.o(.text)    
                tssi_rx.o(.text)    
                GenRReverb_XcvrTrain_b.o(.text)    
                ComputeDsPcb.o(.text)    
                ///log2lintssi.o(.text)    
                CalcQlnDiag.o(.text)    
                ///RxfilterComp.o(.text)    
                //afe_b.o(.text)    
                SetPgaForToneDetection.o(.text)            // need to be in BG in RCTonesRxF.c
                ///rxinvfiltcoef.o(.text)    

                //from xcvr0
                //CalcQlnDiag.o(.text)    
                //RxfilterComp.o(.text)    
                //rxinvfiltcoef.o(.text)    

            
                // C_/SCOPE_NULL
                xcvr_rx1_b.o(.text)    
                medley_b.o(.text)    

                //BGChooseRevSegBin.o(.text)    //anal
                ec_init.o(.text)    
                DecTrain_b.o(.text)    
                STR_reorderdec.o(.text)    
                dxc_init.o(.text)    
                dxc_comp.o(.text)    
                CalcDECPathDelay.o(.text)    

                //xcvrdmt
                //frm_sync_proc_b.o(.text)    
                //frm_sync_b.o(.text)    
                //find_sintbl.o(.text)    
                //ReverbSnr_b.o(.text)    
                //ifft_fix.o(.text)    
                //fdq_init.o(.text)    
                //FDQcoefPerTone.o(.text)    
                //fft_bg.o(.text)    
                //fft.o(.text)    
                //afe_b.o(.text)    
                //BGChooseRevSegBin.o(.text)    
                //ieee_flt.o(.text)    
                //matrix.o(.text)    
                //find_sintbl.o(.text)    
                //fdq_adj.o(.text)    
                //fdq_update.o(.text)    
            
            
                // C_/SCOPE_NULL
                DoFDExtrap.o(.text)    
                FDExtrapolate.o(.text)    
            

                //res no ghs
            
                // C_/SCOPE_NULL
                bitload_support.o(.text)    
                forceeven1bit.o(.text)    
                minmaxmargin.o(.text)    
                snr_b.o(.text)    
            

                //tdqtest
            
                // C_/SCOPE_NULL
                //medley_b.o(.text)    
                //bitload2.o(.text)    
                //updatefinegainlinsq.o(.text)    
                //ChooseFineGains_BIS.o(.text)    
        

                //handshake
            
                // C_/SCOPE_NULL
                hs_resp.o(.text)    
                hs_CopyInfoField.o(.text)    
                hs_mesg.o(.text)    
                hs_mesg_bis.o(.text)    
                post_hsk.o(.text)    
            

                //res
            
                // C_/SCOPE_NULL
                rndnoiseacc.o(.text)    
                snr.o(.text)    
                Simext_IOf.o(.text)    
                xception.o(.text)    
            

                // 8, 9  from rxinit
            
                // C_/SCOPE_NULL
                rx_ovhd_ini_bis.o(.text)    
                //rx_ib_ini_bis.o(.text)    
                aoc_rx_ini.o(.text)    
                eoc_rx_ini.o(.text)    
                rx_ib_ini.o(.text)    
                rx_m3oh.o(.text)    
            

            
                // C_/SCOPE_NULL
                showinitrx.o(.text)    
                datapumpsetup_rx.o(.text)    
                RCMedleyRxF_RXINIT_BIS.o(.text)    
                bgdiagparam_bis.o(.text)    
                CalcActatpDiag.o(.text)    

                // C_/SCOPE_STATIC
                latency.o(.text)    
                tone_ord.o(.text)    
                olr_Bpn_check_rx.o(.text)    
                CheckForBpnReconfig.o(.text)    
                showinit_rx_qam.o(.text)    
                dec_gain.o(.text)    
                iri_InsertCP.o(.text)    
                SetUpRxTonesRegister.o(.text)    
                Configure_TCM_Bits.o(.text)    
                ApplyFineGains.o(.text)    
                decimalgain.o(.text)    
                CalcNOMATP.o(.text)    
                tone_reord_load.o(.text)    
                ComputeRMSFineGain.o(.text)    
                CalcAttndrDiag.o(.text)    
                CalcSigAttnDiag.o(.text)    
                //logtolin.o(.text)    
                    //bitload3.o(.text)    
            

                // from INit

                // C_/SCOPE_NULL
                cmv.o(.text)    
                STR_Afe.o(.text)    
                rx_ops.o(.text)    
                ALP_Ini.o(.text)    
                cri_ini.o(.text)    
//                initfifo.o(.text)    
                zph_ini.o(.text)    
                AllocateDataBuffers_PreHndshk.o(.text)    
                cnfg_task.o(.text)    
                codeswap_sinit.o(.text)    
                nmp_plfm_init.o(.text)    
                InitModem_PreHandshake.o(.text)    
            

            
                // C_/SCOPE_NULL
                IRI_Ini.o(.text)    
                STR_Ini.o(.text)    
                electra_ini.o(.text)    
                eng_ini.o(.text)    
                LinkStartForTest.o(.text)    
                LinkStart.o(.text)    

                // C_/SCOPE_STATIC
                afe_reconfig.o(.text)    
                STR_ReconfigTx.o(.text)    
                Reconfig_fft.o(.text)    
                Reconfig_IRI_IFFT_Size.o(.text)    
                STR_cleardec.o(.text)    
                STR_clearaec.o(.text)    
                //SetUpRxTonesRegister.o(.text)    
                STR_ReconfigRx.o(.text)    
                Config_Interp3_4.o(.text)    
                STR_Tdq.o(.text)    
                STR_InitFilter.o(.text)    
                STR_LoadHPF.o(.text)    
                Configure_1024RxFFTLength.o(.text)    
                reconfig_fft1.o(.text)    
                alp_reconfig_aai.o(.text)    
            

                //        SHOW1 
            
                // C_/SCOPE_NULL
                TxHDLC_Queue.o(.text)    
                rx_ovhd1_bis.o(.text)    
                showinit_rx_olrpm.o(.text)    
                rx_ovhd_bis.o(.text)    
                //olr_Bpn_check_rx.o(.text)    
                //dec_gain.o(.text)    
                enc_gain.o(.text)    
                //showinit_rx_qam.o(.text)    
                showinit_tx_qam.o(.text)    
                //ApplyFineGains.o(.text)    
                changebat.o(.text)    
                rx_olr_decision.o(.text)    
                updatefinegainlinsq.o(.text)    
                ChooseFineGains_BIS.o(.text)    
                CalcRate_BIS.o(.text)    
                showtime_rx_b_bis.o(.text)    
                //CalcAttndrDiag.o(.text)    
                bitload2.o(.text)    
            
                //show2 files
                // C_/SCOPE_NULL
                //showinit_tx_olr.o(.text)    // part is BG needs to split JAG.
                //tone_reord_load.o(.text)    
                Distributefinegains.o(.text)    
                olr_Lp_check.o(.text)    
            

                //showbg2 files
            
                // C_/SCOPE_NULL
                tx_ovhd_form_ctrl_msg_bis.o(.text)
                tx_ovhd_form_msg_bis.o(.text)    
                tx_ovhd_bis.o(.text)    
                TxHDLCProcessor.o(.text)    
                FormTestParameterMsg.o(.text)    

                // tle added
                bitload3.o(.text)
                synsymbl_b.o(.text)
                showtime_rx_b.o(.text)
                CalcAvgMargin.o(.text)
                //dec_dap_b.o(.text)
            

                //btld files
            
                // C_/SCOPE_NULL
                // tle added
                bitload.o(.text)
                bitload_bis.o(.text)
                bitload_dmt.o(.text)
                RxBtswpDecision.o(.text)    // part of bitswap.c
            }


        }
    } > BG_CACHE_1_CODE_MEM

    GROUP LOAD(ADDR(BG_CACHE_2_FADX_PM)) : {
        .BG_CACHE_2_PMSWAP: {
        }
    } > BG_CACHE_2_CODE_MEM
#endif

    GROUP LOAD(ADDR(RES_FADX_PM_BT)) : {
        .RES_PMSWAP: {
            int_service.o(.text)
	   // DebugBuffer.o(.text)
            trail.o(.text)
            trailphaserr.o(.text)
    
            main_hw.o(.text)
            modem_hw.o(.text)
            Simext_IOf.o(.text)
            mp.o(.text)
            ll_iofarc.o(.text)
            gpio.o(.text)
    
            // modem OS routines
            adsl_int.o(.text)
            adsl_int_body.o(.text)
            fifo.o(.text)
            mtkernel.o(.text)
            states.o(.text)
            FormTestParameterMsg.o(.text)
            xception.o(.text)
	    dataswap.o(.text)
    
            // codeswap routines
            codeswap.o(.text)
            CheckShowtimeSnrUpdate.o(.text)
    
            // Winhost routines
            nmp.o(.text)
            nmp_plfm.o(.text)
    
            // math routines
            dsp_op.o(.text)
            dsp_op2.o(.text)
    
            // memory routines
            LL_IOf.o(.text)
            dma_iof.o(.text)
            mei_iof.o(.text)
            memcopy.o(.text)
            memsetbf.o(.text)
    
            // assembly routines
            arctan.o(.text)
            round64.o(.text)
            nacc.o(.text)
            vecmultloop.o(.text)
    
            // HWEngine routines
            cri_iof.o(.text)
            interrupt_control_showtime.o(.text)
            //JG STR_show.o(.text)
            IRI_IOf_FFT.o(.text)
            IRI_IOf.o(.text)
            iri_iof1.o(.text)
            iri_timer.o(.text)
            //JG pll.o(.text)
            //JG timercov.o(.text)
            ALP_IOf.o(.text)
            SetUpRxTonesRegister.o(.text)
    
            // signal routines
            detect_rs.o(.text)
    
            // assorted
            gdata.o(.text)
            gpersistent.o(.text)
            delay.o(.text)
            dec_adap_Data.o(.text)
            gdata_bis.o(.text)
            gdata_dmt.o(.text)
    
            // misc
            fcs.o(.text)
            snr.o(.text)
            rndnoiseacc.o(.text)

            crt1.o(.text)
            memcpy.o(.text)
            _enable.o(.text)
            _disable.o(.text)
            _setvect.o(.text)
            f_memset.o(.text)
            _cleanup.o(.text)
            arith.o(.text)
            divnorm.o(.text)
            exit.o(.text)
            invcache.o(.text)
            mc_epi.o(.text)
            mc_epi4.o(.text)
            mc_pro.o(.text)
            _exit.o(.text)
            ac_mc_13.o(.text)
            div0max.o(.text)
            div.o(.text)
            ldiv.o(.text)
            _memclr.o(.text)
            d16mpy32.o(.text)
            xcheckno.o(.text)
            ac_mc_va.o(.text)

            // temp moved from MODEM_TEST
            testModeOperation.o(.text)
        }
    } > RES_CODE_MEM

    GROUP LOAD(ADDR(R_NOSHOW_FADX_PM_BT)) : {
        .R_NOSHOW_PMSWAP: {
            codeswap_nost.o(.text)
            statestc.o(.text)
            pll_misc.o(.text)
            tx_ops_bis.o(.text)
            load_codeswap.o(.text)
            IRI_IOf_FFT_train.o(.text)
            IRI_IOf_train.o(.text)
            trail_nost.o(.text)
            tx_ops.o(.text)
            tx_ops2.o(.text)
            detect.o(.text)
            accum32.o(.text)
            bufmisc.o(.text)
            afe.o(.text)
            TxTneSt.o(.text)
    
            // overflow counter update
            IRI_Ovflow.o(.text)
            ovflw.o(.text)
    
            // assembly routines
            acc32.o(.text)
            m2r.o(.text)
            vp.o(.text)
    
            // HWEngine routines
            interrupt_control.o(.text)
    
            // XY memory routines
            xy_iof.o(.text)
            xy_iof_asm.o(.text)
    
            // Assembly wrapper routines during training
            vecpwr.o(.text)
            noiseacc.o(.text)
            vecmult.o(.text)
        }
    } > R_NOSHOW_CODE_MEM

    //GROUP LOAD(ADDR(R_NOGHS_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .R_NOGHS_PMSWAP: {
            //Part of the Resident page. However, it will not be loaded at boot stage,
            //but codeswapped in when hndshake is finished. Therefore, the files contained here
            //should be the ones that are not used in Init, Hnshk stage. The advantage here is
            //that we can gain more room for handshake.
    
            // R_NOGHS shouldn't contain any resident files that will be called during Channel Disovery
            // signal routines

            bitload_support.o(.text)
            forceeven1bit.o(.text)
            minmaxmargin.o(.text)
            snr_b.o(.text)
            ApplyBlackoutBits.o(.text)
        }
    } > R_NOGHS_CODE_MEM

    GROUP LOAD(ADDR(INIT_FADX_PM_BT)) : {
        .INIT_PMSWAP: {
            cmv.o(.text)
            STR_Afe.o(.text)
            rx_ops.o(.text)
            ALP_Ini.o(.text)
            cri_ini.o(.text)
            initfifo.o(.text)
            zph_ini.o(.text)
            AllocateDataBuffers_PreHndshk.o(.text)
            cnfg_task.o(.text)
            //cnfg_eng.o(.text)
            InitModem_PreHandshake.o(.text)
            codeswap_sinit.o(.text)
            nmp_plfm_init.o(.text)
            gpio_ini.o(.text)
    

            .INIT_MULT_DEF: {
                //C_SCOPE_NULL
                IRI_Ini.o(.text)
                STR_Ini.o(.text)
                electra_ini.o(.text)
                eng_ini.o(.text)
                LinkStartForTest.o(.text)
                LinkStart.o(.text)
        
                //C_SCOPE_STATIC
                afe_reconfig.o(.text)
                STR_ReconfigTx.o(.text)
                Reconfig_fft.o(.text)
                Reconfig_IRI_IFFT_Size.o(.text)
                STR_cleardec.o(.text)
                STR_clearaec.o(.text)
                SetUpRxTonesRegister.o(.text)
                STR_ReconfigRx.o(.text)
                Config_Interp3_4.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                STR_LoadHPF.o(.text)
                Configure_1024RxFFTLength.o(.text)
                reconfig_fft1.o(.text)
                alp_reconfig_aai.o(.text)
        
                //C_SCOPE_NULL
                afeini.o(.text)
        
                //C_SCOPE_STATIC
                afe_b.o(.text)

                //C_SCOPE_NULL
                statein1.o(.text)

                //C_SCOPE_STATIC
                hndshk1.o(.text)
            }
        }
    } > INIT_CODE_MEM

    //GROUP LOAD(ADDR(HNSHK1_FADX_PM)) : {
    GROUP  LOAD(ADDR(JUNK)): {
        .HNSHK1_PMSWAP: {
            hs_resp.o(.text)
            hndshk.o(.text)
            hndshk2.o(.text)
            hs_CopyInfoField.o(.text)
            hs_misc.o(.text)

            .HNSHK1_MULT_DEF: {
                //C_SCOPE_NULL
                RTonesReqTxF.o(.text)
                RTone1TxF.o(.text)
                RFlag1TxF.o(.text)
                RCFlag1RxF.o(.text)
                RCGalf1RxF.o(.text)
    
                //C_SCOPE_NULL
                RCHSMsgRxF.o(.text)
        
                //C_SCOPE_STATIC
                hndshk1.o(.text)
        
                //C_SCOPE_NULL
                hs_mesg.o(.text)
        
                //C_SCOPE_STATIC
                hs_mesg_bis.o(.text)
            }
        }
    } > HNSHK1_CODE_MEM

    //GROUP LOAD(ADDR(HNSHK2_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .HNSHK2_PMSWAP: {
            RHSMsgTxF.o(.text)
            RFlag2TxF.o(.text)
            RGalf2TxF.o(.text)
            RCFlag2RxF.o(.text)
            RCGalf2RxF.o(.text)
            tmnt_hndshk.o(.text)
            hs_tx.o(.text)
            TxMTnSt.o(.text)

            .HNSHK2_MULT_DEF: {
                //C_SCOPE_NULL
                stateini.o(.text)
                post_hsk.o(.text)
                RCSilent1RxF.o(.text)
                RCTonesRxF.o(.text)
                RCQuiet2RxF_CW.o(.text)
                RSilent0TxF.o(.text)
                RSilent1TxF.o(.text)
                act_T1413.o(.text)
                RQuiet2TxF.o(.text)

                //C_SCOPE_STATIC
                STR_ReconfigRx.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                STR_LoadHPF.o(.text)
                SetPgaForToneDetection.o(.text)
                afe_b.o(.text)

                //C_SCOPE_NULL
                hs_rx.o(.text)

                //C_SCOPE_STATIC
                find_sintbl.o(.text)
            }
        }
    } > HNSHK2_CODE_MEM

    //GROUP LOAD(ADDR(XCVR0_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .XCVR0_PMSWAP: {
            RQuiet2TxF_CS.o(.text)
            RReverb1TxF.o(.text)
            statein1_dmt.o(.text)
            eoc_ini_b.o(.text)

            .XCVR0_MULT_DEF: {
                //C_SCOPE_NULL
                RCQuiet2RxF.o(.text)
                RCPilot1InitRxF.o(.text)
                RCPilot1RxF.o(.text)

                //C_SCOPE_STATIC
                Reconfig_fft.o(.text)
                Configure_1024RxFFTLength.o(.text)
                SetUpRxTonesRegister.o(.text)
                Reconfig_IRI_IFFT_Size.o(.text)
                reconfig_fft1.o(.text)
                STR_ReconfigRx.o(.text)
                STR_ReconfigTx.o(.text)
                Config_Interp3_4.o(.text)
                STR_InitFilter.o(.text)
                STR_Tdq.o(.text)
                STR_LoadHPF.o(.text)
                CalcQlnDiag.o(.text)
                RxfilterComp.o(.text)
                rxinvfiltcoef.o(.text)
                afe_b.o(.text)
            }
        }
    } > XCVR0_CODE_MEM

    //GROUP LOAD(ADDR(DISC1_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .DISC1_PMSWAP: {
            RCombTxF_bis.o(.text)
            RCComb3RxF_bis.o(.text)
            GenRReverb_XcvrTrain_b.o(.text)
            GenerateComb.o(.text)
            DetectComb.o(.text)
            RCQuiet2RxF_bis.o(.text)
            FormRMsgFmt_bis.o(.text)
            FormRMsgPcb_bis.o(.text)
            RCComb1RxF_bis.o(.text)
            BgDetectMultiTones_Comb.o(.text)
            DecodeCMsgFmt_bis.o(.text)
            DecodeCMsgPcb_bis.o(.text)
            ComputeDsPcb.o(.text)

            .DISC1_MULT_DEF: {
                //C_SCOPE_NULL
                RCQuiet1RxF_bis.o(.text)
                tssi_rx.o(.text)
                RCQuiet3RxF_bis.o(.text)
                RCComb2RxF_bis.o(.text)
                CombSnrCalc_bis.o(.text)
                RCQuiet4RxF_bis.o(.text)

                // not static
                RQuiet1TxF_bis.o(.text)                 
                RLineProbeTxF_bis.o(.text)

                //C_SCOPE_STATIC
                log2lintssi.o(.text)
                CalcQlnDiag.o(.text)
                RxfilterComp.o(.text)
                Reconfig_fft.o(.text)
                Reconfig_IRI_IFFT_Size.o(.text)
                SetUpRxTonesRegister.o(.text)
                Configure_1024RxFFTLength.o(.text)
                reconfig_fft1.o(.text)
                STR_ReconfigRx.o(.text)
                STR_Tdq.o(.text)
                STR_LoadHPF.o(.text)
                STR_ReconfigTx.o(.text)
                Config_Interp3_4.o(.text)
                STR_InitFilter.o(.text)
                rxinvfiltcoef.o(.text)
                afe_b.o(.text)
                SetPgaForToneDetection.o(.text)


                //C_SCOPE_NULL
                RCMsgFmtRxF_bis.o(.text)
                RMsgFmtTxF_bis.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
            }
        }
    } > DISC1_CODE_MEM

    //GROUP LOAD(ADDR(DISC2_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .DISC2_PMSWAP: {
            RCQuiet1RxF_CW_bis.o(.text)
        }
    } > DISC2_CODE_MEM

    //GROUP LOAD(ADDR(XCVR1_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .XCVR1_PMSWAP: {
            aec_init.o(.text)
            xcvr_rx1_b.o(.text)
            RReverb12TxF_bis.o(.text)
            RCReverb2RxF_bis.o(.text)
            RCEctRxF.o(.text)

            .XCVR1_MULT_DEF: {
                //C_SCOPE_NULL
                RCReverb1RxF_bis.o(.text)
                RQuiet4TxF_bis.o(.text)
                RQuiet5TxF_XCVR1_bis.o(.text)
                RCReverb1RxF.o(.text)
                RQuiet3TxF.o(.text)
                HybridTraining.o(.text)
                STR_ReconfigDecim2_HPF.o(.text)
                STR_Aec.o(.text)

                //C_SCOPE_STATIC
                RQuiet5TxF_bis.o(.text)
                afe_b.o(.text)
                afe_hyb.o(.text)
                STR_LoadHPF.o(.text)
                STR_InitFilter.o(.text)
            }
        }
    } > XCVR1_CODE_MEM

    //GROUP LOAD(ADDR(XCVR2_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .XCVR2_PMSWAP: {
            .XCVR2_MULT_DEF: {
                //C_SCOPE_NULL
                RCReverb3RxF_bis.o(.text)
                CalcHlinDiag.o(.text)
                CalcHlogDiag.o(.text)

                //C_SCOPE_STATIC
                RCReverbFrameSyncFdq.o(.text)
                frm_sync_proc_b.o(.text)
                frm_sync.o(.text)
                frm_sync_b.o(.text)
                log2lintssi.o(.text)
                ReverbSnr_b.o(.text)
                STR_decimphase.o(.text)
                ifft_fix.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                fft_bg.o(.text)
                fft.o(.text)
                afe_b.o(.text)
                RxfilterComp.o(.text)
                logtolin.o(.text)
                rxinvfiltcoef.o(.text)
                BGChooseRevSegBin.o(.text)
                iri_dec_adap.o(.text)
                STR_RxTxAlign.o(.text)
                ieee_flt.o(.text)
                matrix.o(.text)
                find_sintbl.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                STR_TdqExp.o(.text)

                //C_SCOPE_NULL
                RQuiet5TxF_XCVR2_bis.o(.text)

                //C_SCOPE_STATIC
                RQuiet5TxF_bis.o(.text)
            }
        }
    } > XCVR2_CODE_MEM

    //GROUP LOAD(ADDR(XCVRDMT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .XCVRDMT_PMSWAP: {
            RSegueTxF.o(.text)
            ClrTxBuf.o(.text)
            .XCVRDMT_MULT_DEF: {
                //C_SCOPE_NULL
                RReverb2TxF.o(.text)
                RCReverb2RxF.o(.text)
                RCReverb3RxF.o(.text)
                convert.o(.text)
                DoFDExtrap.o(.text)
                FDExtrapolate.o(.text)

                //C_SCOPE_STATIC
                RCReverbFrameSyncFdq.o(.text)
                frm_sync_proc_b.o(.text)
                frm_sync.o(.text)
                frm_sync_b.o(.text)
                find_sintbl.o(.text)
                ReverbSnr_b.o(.text)
                STR_decimphase.o(.text)
                ifft_fix.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                fft_bg.o(.text)
                fft.o(.text)
                afe_b.o(.text)
                BGChooseRevSegBin.o(.text)
                iri_dec_adap.o(.text)
                STR_RxTxAlign.o(.text)
                ieee_flt.o(.text)
                matrix.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                STR_TdqExp.o(.text)
            }
        }
    } > XCVRDMT_CODE_MEM

    //GROUP LOAD(ADDR(ANAL_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .ANAL_PMSWAP: {
            STR_Dec.o(.text)
            decxcorr.o(.text)           // need to split init and decxcor
            DecodeCMsg1_bis.o(.text)
            dxc_init.o(.text)
            RCReverb5RxF_bis.o(.text)
            RReverb34TxF_bis.o(.text)
            RSegue12TxF_bis.o(.text)
            dxc_comp.o(.text)
            CalcDECPathDelay.o(.text)
            FormRMsg1_bis.o(.text)

            .ANAL_MULT_DEF: {
                //C_SCOPE_NULL
                RCReverb4RxF_bis.o(.text)
                RReverb5TxF_bis.o(.text)
                REctTxF.o(.text)
                RCPilot3Tref2RxF.o(.text)
                ec_init.o(.text)

                //C_SCOPE_STATIC
                medley.o(.text)
                GenMedly.o(.text)
                ReverbSnr_b.o(.text)
                STR_mask.o(.text)
                STR_cleardec.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                iri_InsertCP.o(.text)
                reconfig_fft1.o(.text)
                BGChooseRevSegBin.o(.text)
                STR_TdqExp.o(.text)

                //C_SCOPE_NULL
                RCMsg1RxF_bis.o(.text)
                RMsg1TxF_bis.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                TxInfoBit.o(.text)

                //C_SCOPE_NULL
                DecTrain_b.o(.text)

                //C_SCOPE_STATIC
                STR_reorderdec.o(.text)
            }
        }
    } > ANAL_CODE_MEM

    //GROUP LOAD(ADDR(ANL1DMT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .ANL1DMT_PMSWAP: {
            RCCrc1RxF.o(.text)
            DecodCInfo1.o(.text)
            FormRRates.o(.text)
            RCrc1TxF.o(.text)
            RSegue3TxF.o(.text)
            RReverb4TxF.o(.text)
            FormRMsgs1.o(.text)
            RSegue2TxF.o(.text)

            .ANL1DMT_MULT_DEF: {
                //C_SCOPE_NULL
                RMsgs1TxF.o(.text)
                RRates1TxF.o(.text)
                RCRates1RxF.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                TxInfoBit.o(.text)

                //C_SCOPE_NULL
                RCMedleyRxF_TDQTest.o(.text)
                RMedleyTxF.o(.text)
                RReverb3TxF.o(.text)

                //C_SCOPE_STATIC
                GenMedly.o(.text)
                medley_b.o(.text)
                decimalgain.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                find_sintbl.o(.text)
                med2rev.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                BGChooseRevSegBin.o(.text)
            }
        }
    } > ANL1DMT_CODE_MEM

    //GROUP LOAD(ADDR(MTDQ_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .MTDQ_PMSWAP: {
            ieee_flt.o(.text)
            matrix.o(.text)
            matrix_tdq.o(.text)
            ieee_flt_tdq.o(.text)
            ccl.o(.text)
            tdq_init_hndlr.o(.text)
            fpconv48.o(.text)
            fpc48_ini.o(.text)
            CCloop.o(.text)
            circor48.o(.text)
            corrseq.o(.text)

            .MTDQ_MULT_DEF: {
                //C_SCOPE_NULL
                tdq_init.o(.text)
                rcmedly2.o(.text)
                RCMedleyRxF_bis.o(.text)
                RCMedleyRxF.o(.text)

                //C_SCOPE_STATIC
                fft_bg.o(.text)
                fft.o(.text)
                ifft_fix.o(.text)
                medley.o(.text)
                pwr_ctbk.o(.text)

                //C_SCOPE_NULL
                RMedleyTxF_MTDQ_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
            }
        }
    } > MTDQ_CODE_MEM

    //GROUP LOAD(ADDR(TDQTEST_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .TDQTEST_PMSWAP: {
            .TDQTEST_MULT_DEF: {
                //C_SCOPE_NULL
                RCMedleyRxF_TDQTest_bis.o(.text)

                //C_SCOPE_STATIC
                medley_b.o(.text)
                bitload2.o(.text)
                updatefinegainlinsq.o(.text)
                ChooseFineGains_BIS.o(.text)
                decimalgain.o(.text)
                fdq_init.o(.text)
                FDQcoefPerTone.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                IRI_sync.o(.text)
                iri_InsertCP.o(.text)
                med2rev.o(.text)
                fdq_adj.o(.text)
                fdq_update.o(.text)
                find_sintbl.o(.text)
                BGChooseRevSegBin.o(.text)

                //C_SCOPE_NULL
                RMedleyTxF_TDQTest_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
            }
        }
    } > TDQTEST_CODE_MEM

    //GROUP LOAD(ADDR(BTLD_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .BTLD_PMSWAP: {
           .BTLD_MULT_DEF: {
                //C_SCOPE_NULL
                bitload_bis.o(.text)
                RCMedleyRxF_Bitload_BIS.o(.text)

                //C_SCOPE_STATIC
                bitload.o(.text)
                bitload2.o(.text)
                bitload3.o(.text)
                changebat.o(.text)
                decimalgain.o(.text)
                CalcAttndrDiag.o(.text)
                ComputeRMSFineGain.o(.text)
                updatefinegainlinsq.o(.text)
                AllocateBiGi_desiredLp.o(.text)
                ChooseFineGains_BIS.o(.text)

                //C_SCOPE_NULL
                RMedleyTxF_Bitload_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
           }
        }
    } > BTLD_CODE_MEM

    //GROUP LOAD(ADDR(BTLDDMT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .BTLDDMT_PMSWAP: {
            RSegueRATxF.o(.text)
            DecodCInfoRA.o(.text)
            RReverbRATxF.o(.text)
            FormRRatesRA.o(.text)
            FormRMsgRA.o(.text)
            RReverb5TxF.o(.text)
            DecodCInfo2.o(.text)
            DecodCBGMsg.o(.text)

            
            .BTLDDMT_MULT_DEF: {
                //C_SCOPE_NULL
                RMsgs2TxF.o(.text)
                RCrc3TxF.o(.text)
                RCrcRATxF.o(.text)
                RCCrcRARxF.o(.text)
                RCRatesRARxF.o(.text)
                RRatesRATxF.o(.text)
                RCBGRxF.o(.text)
                RCMsg2RxF.o(.text)
                RCCrc3RxF.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                exchsig.o(.text)

                //C_SCOPE_NULL
                SelectDsRateOption.o(.text)
                VerifyRateWithTwoCG.o(.text)
                RCReverbRARxF.o(.text)
                bitload_dmt.o(.text)
                RCMedleyRxF_Bitload.o(.text)
                FormRInfo2.o(.text)

                //C_SCOPE_STATIC
                bitload.o(.text)
                bitload2.o(.text)
                tone_ord.o(.text)
                minmaxmargin.o(.text)
                bitload3.o(.text)
                changebat.o(.text)
                decimalgain.o(.text)
                updatefinegainlinsq.o(.text)
            }
        }
    } > BTLDDMT_CODE_MEM

    //GROUP LOAD(ADDR(RXINIT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .RXINIT_PMSWAP: {
                rx_ovhd_ini_bis.o(.text)
                rx_ib_ini_bis.o(.text)
                aoc_rx_ini.o(.text)
                eoc_rx_ini.o(.text)
                rx_ib_ini.o(.text)
                rx_m3oh.o(.text)

                
            .RXINIT_MULT_DEF: {
                //C_SCOPE_NULL
                showinitrx.o(.text)
                datapumpsetup_rx.o(.text)
                RCMedleyRxF_RXINIT_BIS.o(.text)
                bgdiagparam_bis.o(.text)
                CalcActatpDiag.o(.text)

                //C_SCOPE_STATIC
                latency.o(.text)
                tone_ord.o(.text)
                olr_Bpn_check_rx.o(.text)
                CheckForBpnReconfig.o(.text)
                showinit_rx_qam.o(.text)
                dec_gain.o(.text)
                iri_InsertCP.o(.text)
                SetUpRxTonesRegister.o(.text)
                Configure_TCM_Bits.o(.text)
                ApplyFineGains.o(.text)
                decimalgain.o(.text)
                CalcNOMATP.o(.text)
                tone_reord_load.o(.text)
                ComputeRMSFineGain.o(.text)
                CalcAttndrDiag.o(.text)
                CalcSigAttnDiag.o(.text)
                logtolin.o(.text)
                bitload3.o(.text)

                
                //C_SCOPE_NULL
                RMedleyTxF_RxInit_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                Gen_MedleyBisTones.o(.text)
                CalcCRC16_Byte.o(.text)
            }
        }
    } > RXINIT_CODE_MEM

    //GROUP LOAD(ADDR(EXCH1_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .EXCH1_PMSWAP: {
            RCExchMarkerRxF_bis.o(.text)
            RExchMarkerTxF_bis.o(.text)
            FormRMsg2_bis.o(.text)
            Scramble_bis.o(.text)

            //diag mode
            RSegueLDTxF_bis.o(.text)
            RCTref1LDRxF_bis.o(.text)
            RCTref2LDRxF_bis.o(.text)
            RCSegueLDRxF_bis.o(.text)
            RCQuietL3RxF_bis.o(.text)
            RCTref3LDRxF_bis.o(.text)

            .EXCH1_MULT_DEF: {
                //C_SCOPE_NULL
                RCMedleyRxF_CSWap_BIS.o(.text)
                RMedleyTxF_CSwap_bis.o(.text)
                FormRParams_bis.o(.text)
                RCMsg2RxF_bis.o(.text)
                RMsg2TxF_bis.o(.text)

                //diag mode
                RMsgLDTxF_bis.o(.text)
                RCMsgLDRxF_bis.o(.text)
                FormRMsgLD_bis.o(.text)

                RQuiet1LDTxF_bis.o(.text)
                RQuiet2LDTxF_bis.o(.text)
                RQuiet3LDTxF_bis.o(.text)
                RAckNAckLDTxF_bis.o(.text)
                RQuietL3TxF_bis.o(.text)

                //C_SCOPE_STATIC
                RMedleyTxF_bis.o(.text)
                CalcCRC16_Byte.o(.text)
                crc16.o(.text)
                //formtestparametermsg.o(.text)
                decimalgain.o(.text)
                Gen_MedleyBisTones.o(.text)
                TxInfoBit.o(.text)
                InterpolateLDInfo.o(.text)
            }
        }
    } > EXCH1_CODE_MEM

    //GROUP LOAD(ADDR(EXCH2_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .EXCH2_PMSWAP: {
            RParamsTxF_bis.o(.text)
            RCReverb6RxF_bis.o(.text)
            RReverb6TxF_bis.o(.text)
            RSegue3TxF_bis.o(.text)
            RCParamsRxF_bis.o(.text)
            DeScramble_bis.o(.text)

            .EXCH2_MULT_DEF: {
            
                //C_SCOPE_NULL
                ParamsSig_bis.o(.text)

                //C_SCOPE_STATIC
                CalcCRC16_Byte.o(.text)
                crc16.o(.text)
            }
        }
    } > EXCH2_CODE_MEM

    //GROUP LOAD(ADDR(EXCH3_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .EXCH3_PMSWAP: {
            RReverb7TxF_bis.o(.text)
            RReverb7TxF_wait_bis.o(.text)
            RSegue4TxF_bis.o(.text)

            .EXCH3_MULT_DEF: {
            
                //C_SCOPE_NULL
                RCReverb7RxF_bis.o(.text)

                //C_SCOPE_STATIC
                RxFFTBufSTrans.o(.text)

                
                //C_SCOPE_NULL
                DecodeCParams.o(.text)

                //C_SCOPE_STATIC
                CalcRate_BIS.o(.text)
            }
        }
    } > EXCH3_CODE_MEM

    //GROUP LOAD(ADDR(EXCHDMT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .EXCHDMT_PMSWAP: {
            RSegue4TxF.o(.text)
            RReverb6TxF.o(.text)

            .EXCHDMT_MULT_DEF: {
            
                //C_SCOPE_NULL
                RBGTxF.o(.text)
                RCrc5TxF.o(.text)

                //C_SCOPE_STATIC
                crc16.o(.text)
                exchsig.o(.text)

                
                //C_SCOPE_NULL
                RCReverb5RxF.o(.text)

                //C_SCOPE_STATIC
                RxFFTBufSTrans.o(.text)

                
                //C_SCOPE_NULL
                RSegue5TxF.o(.text)
                ZPH_IOf_showinit_dmt.o(.text)

                //C_SCOPE_STATIC
                ZPH_IOf.o(.text)
                alp_enableaai_txrx.o(.text)
            }
        }
    } > EXCHDMT_CODE_MEM

        // The common functions between SHOW1 and SHOW2 should in SHOW1 because
        // SHOW1 is loaded earlier. It can save memory since we don't need to
        // duplicate the common functions.
    //GROUP LOAD(ADDR(SHOW1_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .SHOW1_PMSWAP: {
            ZPH_IOf.o(.text)
            ZPH_IOf_bis.o(.text)
            showtime_rx_tc_bis.o(.text)
            showtime_rx_bis.o(.text)
            ZPH_IOf_HDLC_bis.o(.text)
            plam.o(.text)
            iri_CalcBitsInRCB.o(.text)
            qos.o(.text)
            rx_ovhd1_bis.o(.text)
            showinit_rx_olrpm.o(.text)
            rx_ovhd_bis.o(.text)
            olr_Bpn_check_rx.o(.text)
            CheckForBpnReconfig.o(.text)
            dec_gain.o(.text)
            enc_gain.o(.text)
            showinit_rx_qam.o(.text)
            showinit_tx_qam.o(.text)
            ApplyFineGains.o(.text)
            changebat.o(.text)
            decimalgain.o(.text)
            IRI_IOf_FFT_showtime.o(.text)
            IRI_IOf_showtime.o(.text)
            alp_ResetARCellCnt.o(.text)
            alp_ResetATCellCnt.o(.text)
            GenerateTxATM_HEC.o(.text)
            tx_ib_bis_b.o(.text)
            rx_olr_decision.o(.text)
            updatefinegainlinsq.o(.text)
            ChooseFineGains_BIS.o(.text)
            TxHDLC_Queue.o(.text)
            CalcRate_BIS.o(.text)
            IRI_IOf_showtime_tx.o(.text)
            pll_show.o(.text)
            impulse_detect_bis.o(.text)
            ZPH_IOf_HDLC_bis_tx.o(.text)
            showtime_rx_b_bis.o(.text)
            CalcAttndrDiag.o(.text)
            olr_Lp_check.o(.text)
        }
    } > SHOW1_CODE_MEM

    //GROUP LOAD(ADDR(TXINIT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .TXINIT_PMSWAP: {
            tx_ovhd_ini_bis.o(.text)
            tx_ib_ini.o(.text)
            eoc_tx_ini.o(.text)
            tx_ib_ini_bis.o(.text)
            aoc_tx_ini.o(.text)
            tx_m3oh_b.o(.text)

            .TXINIT_MULT_DEF: {
            
                //C_SCOPE_NULL
                showinittx.o(.text)
                datapumpsetup_tx.o(.text)

                //C_SCOPE_STATIC
                latency.o(.text)
                tone_ord.o(.text)
                tone_reord_load.o(.text)
                CheckForBpnReconfig.o(.text)
                showinit_tx_qam.o(.text)
                enc_gain.o(.text)
                iri_InsertCP.o(.text)
                CalcNOMATP.o(.text)
                ComputeRMSFineGain.o(.text)
                decimalgain.o(.text)
            }
        }
    } > TXINIT_CODE_MEM

    //GROUP LOAD(ADDR(SHOW2_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .SHOW2_PMSWAP: {
            tx_ovhd_bis.o(.text)
            showtime_tx_tc_bis.o(.text)
            StartTxDataPump_BIS.o(.text)
            showtime_tx_bis.o(.text)
            olr_datapumpsetup.o(.text)
            olr_datapumpsetup1.o(.text)
            Configure_TCM_Bits.o(.text)
            //setuprxtonesregister.o(.text)    // moved from here to Resident Memory for lack of space
            showinit_tx_olr.o(.text)
            tx_plam_bis.o(.text)
            rx_plam_bis.o(.text)
            GenerateTxATM.o(.text)
            tone_reord_load.o(.text)
            //hs_mesg_bis.o(.text)
            CorruptFirstByteOfCWInIntlvBuffer.o(.text)
            Distributefinegains.o(.text)
            pm_rx_tc_bis.o(.text)

        }
    } > SHOW2_CODE_MEM

    //GROUP LOAD(ADDR(SHOWBG1_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .SHOWBG1_PMSWAP: {
            tx_ovhd_form_ctrl_msg_bis.o(.text)
            tx_ovhd_form_msg_bis.o(.text)
            TxHDLCProcessor.o(.text)
            //formtestparametermsg.o(.text)
        }
    } > SHOWBG1_CODE_MEM

    //GROUP LOAD(ADDR(SHOWBG2_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .SHOWBG2_PMSWAP: {
        //!! SHOWBG2 is a common codeswap page of DMT and BIS mode during showtime. Generally, files considered
        // to be put in this page are the ones that have functions needed by both DMT and BIS. Files needed to be
        // moved out of this page should be aware that you should update both DMT and BIS codeswap page if they
        // include DMT and BIS common functions. If you know some files have functions that are not needed for both
        // BIS and DMT, and there is room to contain them in other corresponding mode showtime codeswap page, please
        // do remove them from this page.

            
            synsymbl.o(.text)
            datasymbl.o(.text)
            synsymbl_b.o(.text)
            dd_snrfdq.o(.text)
            LogShowtimeEventA.o(.text)
            showtime_rx_b.o(.text)
            CalcAvgMargin.o(.text)
            bitload3.o(.text)
            dec_adap_b.o(.text)
            iri_dec_adap.o(.text)
            iri_iof_ddSnrFdqUtils.o(.text)
            dec_adap.o(.text)
            STR_DecAdapt.o(.text)
            noiseacc_st.o(.text)
            vecmult_st.o(.text)
            cmplxvecmult.o(.text)
            cmplxvecmultloop.o(.text)
            olrpm_RxProcessing.o(.text)
            RxCEOC_com.o(.text)
            // BIS only, Not used by DMT. Hence doesnt *need* to be here
            RxCEOC_bis.o(.text)
            fdqmult.o(.text)
            fdqmultloop.o(.text)
            DoRxSyncSymbolOLRPM.o(.text)
        }
    } > SHOWBG2_CODE_MEM

    //GROUP LOAD(ADDR(SHT1DMT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .SHT1DMT_PMSWAP: {
            tx_ib_b.o(.text)
            iri_BitswapLoad.o(.text)
            iri_RemoveCP.o(.text)
            rx_aoc.o(.text)
            rx_eoc.o(.text)
            rx_ib.o(.text)
            rx_eoc1.o(.text)
            fifo_dmt.o(.text)

            .SHT1DMT_MULT_DEF: {

                
                //C_SCOPE_NULL
                showtime_dmt.o(.text)

                //C_SCOPE_STATIC
                trail_st.o(.text)
                IRI_IOf_dmt.o(.text)
                //olrpm_RxProcessing.o(.text)
                impulse_detect.o(.text)

#ifndef DANUBE_MEM
                //C_SCOPE_NULL
                tx_plam.o(.text)
                rx_plam.o(.text)

                //C_SCOPE_STATIC
                plam.o(.text)

                //C_SCOPE_NULL
                bitswap.o(.text)

                //C_SCOPE_STATIC
                tone_ord.o(.text)
                decimalgain.o(.text)
                dec_gain.o(.text)
                //olrpm_rxprocessing.o(.text)
#endif

                
                //C_SCOPE_NULL
                showtime_tc_dmt.o(.text)
                ZPH_IOf_dmt.o(.text)

                //C_SCOPE_STATIC
                qos.o(.text)
                ZPH_IOf.o(.text)
                alp_enableaai_txrx.o(.text)
                alp_ResetARCellCnt.o(.text)
                IRI_IOf_FFT_showtime.o(.text)
                IRI_IOf_showtime.o(.text)
                GenerateTxATM.o(.text)
                pll_show.o(.text)
            }
        }
    } > SHT1DMT_CODE_MEM

    //GROUP LOAD(ADDR(SHT2DMT_FADX_PM)) : {
    GROUP LOAD(ADDR(JUNK)) : {
        .SHT2DMT_PMSWAP: {
            tx_m3oh.o(.text)
            tx_aoc.o(.text)
            tx_eoc.o(.text)
            tx_ib.o(.text)
            tx_ceoc.o(.text)

            .SHT2DMT_MULT_DEF: {
                //C_SCOPE_NULL
                showtime_dmt_tx.o(.text)
                showtime_tx_tc_dmt.o(.text)

                //C_SCOPE_STATIC
                IRI_IOf_dmt.o(.text)
                IRI_IOf_showtime_tx.o(.text)
                alp_ResetATCellCnt.o(.text)

// for DANUBE build, this page is pretty small, so some of SHT1DMT page goes here
#ifdef DANUBE_MEM
                //C_SCOPE_NULL
                tx_plam.o(.text)
                rx_plam.o(.text)

                //C_SCOPE_STATIC
                plam.o(.text)

                //C_SCOPE_NULL
                bitswap.o(.text)

                //C_SCOPE_STATIC
                tone_ord.o(.text)
                decimalgain.o(.text)
                dec_gain.o(.text)
                //olrpm_rxprocessing.o(.text)
#endif
            }
        }
    } > SHT2DMT_CODE_MEM

    GROUP LOAD(ADDR(SLEEP_FADX_PM)) : {
        .SLEEP_PMSWAP: {
            .SLEEP_MULT_DEF: {
                //C_SCOPE_NULL
                sleep.o(.text)
                IRI_sleep.o(.text)
                GenRvbTwoDisjointBands.o(.text)
//XDSLRTFW-364 Feature_DS_All_All_NLNF_FilterDetect (START_END)
                nlnf.o(.text)

                //C_SCOPE_STATIC
                IRI_sync.o(.text)
                STR_clearaec.o(.text)
                STR_cleardec.o(.text)
                STR_reorderdec.o(.text)
                medley.o(.text)
                GenMedly.o(.text)
                STR_Dec.o(.text)
                STR_Aec.o(.text)
                frm_sync.o(.text)
                STR_Tdq.o(.text)
                STR_InitFilter.o(.text)
                STR_DecAdapt.o(.text)
                iri_dec_adap.o(.text)
                stateini.o(.text)
                afe_b.o(.text)
            }
        }
    } > SLEEP_CODE_MEM


//    GROUP : {
//        .SECRODATA_DMSWAP ALIGN(4): {
//        }
//    } > SECRODATA_DATA_MEM


    GROUP LOAD(ADDR(BIS_RAM_FADX_DM_BT)): {
        .BIS_RAM_DMSWAP ALIGN(4): {
            *(BIS_RAM)
        }
    } > BIS_RAM
    //} > BIS_RAM_DATA_MEM

    //GROUP LOAD(ADDR(DMT_RAM_FADX_DM)): {
    GROUP LOAD(ADDR(JUNK)) : {
        .DMT_RAM_DMSWAP ALIGN(4): {
            gdata.o(DMT_RAM)
            gdata_dmt.o(DMT_RAM)
            SWAP_SHT1DMT.o(DMT_RAM)
            rinfotbl.o(DMT_RAM)
            exchdata.o(DMT_RAM)
            exchdata.o(DMT_RAM)
            *(DMT_RAM)
        }
    } > DMT_RAM
    //} > DMT_RAM_DATA_MEM

    //GROUP LOAD(ADDR(BULK_O1_FADX_DM)): {
    GROUP LOAD(ADDR(JUNK)) : {
        .BULK_O1_DMSWAP ALIGN(4): {
            *(BULK_O1)
        }
    } > BULK_O1

    GROUP LOAD(ADDR(BULK_O2_FADX_DM_BT)): {
        .BULK_O2_DMSWAP ALIGN(4): {
            *(BULK_O2)
        }
    } > BULK_O2

    GROUP: {
        .PERSISTENT_MEM: {
            *(PERSISTENT_RAM)
        }
    } > PERSISTENT_MEM

    
    GROUP: {
        .X_MEM: {
            *(X_RAM)
        }
    } > X_MEM

    GROUP: {
        .Y_MEM: {
            *(Y_RAM)
        }
    } > Y_MEM

    GROUP: {
        .STMBUF_MEM: {
//            * (STMBUF_RAM)
        }
    } > STMBUF_MEM

#ifndef TARGET_ASIM
    GROUP LOAD(ADDR(ILV1_FADX_DM_BT)): {
        .ILV1_DMSWAP ALIGN(4): {
            * (ILV1_RAM)
        }
    } > ILV1

    GROUP LOAD(ADDR(deILV1_FADX_DM_BT)): {
        .deILV1_DMSWAP ALIGN(4): {
            * (deILV1_RAM)
        }
    } > deILV1

    GROUP LOAD(ADDR(deILV2_BISDBG_FADX_DM_BT)): {
        .deILV2_BISDBG_DMSWAP: {
            * (deILV2_BISDBG_RAM)
        }
    } > deILV2_BISDBG


    GROUP: {
        .deILV2_OBIS_BSS: {
            * (BIS_deILV2_BSS)
        }
    } > deILV2_OBIS_BSS

    GROUP: {
        .deILV2_ODMT_BSS: {
            * (DMT_deILV2_BSS)
        }
    } > deILV2_ODMT_BSS

    GROUP LOAD(ADDR(deILV3_FADX_DM_BT)): {
        .deILV3_DMSWAP ALIGN(4): {
            * (deILV3_RAM)
        }
    } > deILV3
#endif

    GROUP: { 
       .LOCAL_LD_ST_DMSWAP ALIGN(4): {
           * (LOCAL_LD_ST)
       }
    } > LOCAL_LD_ST

    GROUP: {
        .stack SIZE(DEFINED _STACKSIZE?_STACKSIZE:7680):{}
    } > STACK_RAM

#ifdef TARGET_ASIM
    GROUP LOAD(ADDR(SIM_IRAM_FADX_PM_BT)) : {
#else
    GROUP: {
#endif
        .SIM_IRAM_PMSWAP: {       
            *(.text)
        }
    } > SIM_IRAM

#ifdef TARGET_ASIM
    GROUP: {
        .heap SIZE(DEFINED _HEAPSIZE?_HEAPSIZE:20480): {}
    } > SIM_RAM
#endif

#ifdef TARGET_ASIM
    GROUP LOAD(ADDR(SIM_RAM_FADX_DM_BT)): {
#else
    GROUP: {
#endif
        .SIM_RAM_DMSWAP ALIGN(4): {
            // any variables with the DATA_MAP_SIM macro
            * (SIM_RAM)
            * (STMBUF_RAM)
#ifdef TARGET_ASIM
            * (ILV1_RAM)
            * (deILV1_RAM)
            * (deILV2_BISDBG_RAM)
            * (BIS_deILV2_BSS)
            * (DMT_deILV2_BSS)
            * (deILV3_RAM)
#endif

#ifdef TARGET_ASIM
            // HWExec files
            byteflip.o(.bss, .data)
            channel.o(.bss, .data)
            cnfgshwt.o(.bss, .data)
            config.o(.bss, .data)
            load_prf.o(.bss, .data)
            modem_hw.o(.bss, .data)
            OLR_Simulation.o(.bss, .data)
            cnfg_task.o(.bss, .data)
            cnfg_eng.o(.bss, .data)
            cnfg_task_utils.o(.bss, .data)
            // Platform files
            trailphaserr.o(.bss, .data)
#endif
        }
    } > SIM_RAM

// Flash/Sram Image section

    GROUP: {
        .ADSL_IMAGE_HEADER ALIGN(4): {
        _StartOfFlash = .;
            LONG(ADDR(LAST_FADX) - ADDR(ADSL_IMAGE_HEADER_FADX) - 8);   // IMAGE SIZE in bytes
            LONG(0x00000000)                                            // the checksum

            // Num of Swap Pages - LONG(N) to be filled out by setup_codeswap.pl

            // entry 0 - dummy and only used by ME on DANUBE
            LONG(ADDR(BG_CACHE_2_FADX_PM) + SIZEOF(BG_CACHE_2_FADX_PM) - ADDR(ADSL_IMAGE_HEADER_FADX));
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(18K/4);                  // size of XDATA in long words

            // The rest of ADSL_IMAGE_HEADER_BLOCK will be generated by setup_codeswap.pl
        }
    } > ADSL_IMAGE_HEADER_FADX

    
    GROUP LOAD(ADDR(XDMA_TEST_FADX_PM)): {
        .XDMA_TEST_PMSWAP ALIGN(4): {
#include "xdma_test.cmd"
        }
    } > INIT_CODE_MEM

    GROUP LOAD(ADDR(BULK_DATA_RAM_FADX_DM_BT)): {
        .BULK_DATA_RAM_DMSWAP ALIGN(4): {
            *(.data*)
            *(.bss*)
            *(.rodata*)
            *(.lit*)
            *(.rdata*)
            *(.initdat*)
        }
    } > BULK_DATA_RAM

}
