# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**

$cmd_file = @ARGV[0];
$ElfDump_file = @ARGV[1];


open(CMD_FILE, "<$cmd_file") || die "Failed to open $cmd_file\n";
open(ELFDUMP_FILE, "<$ElfDump_file") || die "Failed to open $ElfDump_file\n";


#foreach $section (keys %section_start)
#{
#    print "$section start $section_start{$section} size $section_allocated_size{$section}\n";
#}

while (<ELFDUMP_FILE>)
{
    # catch PM_section info
    #^36  0x13f00     8308 LOC  SECT .BULK_O1_DMSWAP       
    if (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+(\.\w+)/)
    {
        $section_allocated_size{$3} = $2;
    }
}
seek(ELFDUMP_FILE, 0, 0);

$state = 0;

_while_0:
{
    while (<CMD_FILE>)
    {
        if ($state == 0)
        {
            if (/^\s*MEMORY\s*\{/)
            {
                $state = 10;
            }
        }
        elsif ($state == 10)
        {
            # get section name first
            if (/^\s*(\w+)\s*:/)
            {
                $section_name = $1;
                $section_list{$section_name} = $section_name;
            }

            # get starting address
            if (/^\s*\w+\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH/)
            {
                ($start = $1) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_allocated_size{$1}/g;
                ($start = $start) =~ s/ADDR\(\s*(\w+)\s*\)/$section_start{$1}/g;
                ($start = $start) =~ s/(\d+)[kK]/$1\*1024/g;
                $section_start{$section_name} = eval("$start");
            }

            # get size
            if ((m%^\s*\w+\s*:.*LENGTH\s*=\s*(.*)//%) || (m%^\s*\w+\s*:.*LENGTH\s*=\s*(.*)$%))
            {
                ($length = $1) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_allocated_size{$1}/g;
                ($length = $length) =~ s/ADDR\(\s*(\w+)\s*\)/$section_start{$1}/g;
                ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
                $section_allocated_size{$section_name} = eval("$length");
            }

            if (/^\s*}/)
            {
#                foreach $name (keys %section_start)
#                {
#                    printf("$name: $section_start{$name} 0x%x\n", $section_allocated_size{$name});
#                }
                $state = 20;
            }

        }
        elsif ($state == 20)
        {
            if (/^\s*(\w+)_CODE_MEM\s*:\s*ORIGIN\s*=\s*ADDR\((\w+)\)/)
            {
                if (defined $section_start{$2})
                {
                    $section_name = $2;
                    $page_name = $1;
                    $PM_section_list{$section_name} .= " $page_name";
                    $PM_page_to_section{$page_name} = $section_name;

                }
            }
            elsif (/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*ADDR\((\w+)\)/)
            {
                if (defined $section_start{$2})
                {
                    $section_name = $2;
                    $page_name = $1;
                    $DM_section_list{$section_name} .= "$page_name ";
                    $DM_page_to_section{$page_name} = $section_name;
#print "data: $section_name $page_name \n"; 
                }
            }
            if (/^\s*\}/)
            {
                last _while_0;
            }
        }
    }
}

while (<ELFDUMP_FILE>)
{
    # catch PM_section info
    #^36  0x13f00     8308 LOC  SECT .BULK_O1_DMSWAP       
    if (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+\.(\w+)_PMSWAP/)
    {
        $page_name = $3;
        $page_start = $1;
        $page_size = $2;
        if (defined $PM_page_to_section{$page_name})
        {
            ${"$PM_page_to_section{$page_name}_PM_summary"}{eval($page_size)} = $page_name;
        }

        if (!defined $pmswap_list{"$3_PMSWAP"})
        {
            $pmswap_list{"$3_PMSWAP"} = 1;
        }
    }
    elsif ((/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+\.(\w+)_DMSWAP/) ||
           (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+\.(\w+)/))
    {
        $page_name = $3;
        $page_start = $1;
        $page_size = $2;
        if (defined $DM_page_to_section{$page_name})
        {
            ${"$DM_page_to_section{$page_name}_DM_summary"}{eval($page_size)} = $page_name;
        }
        elsif (defined $section_list{$page_name})
        {
            ${"$section_list{$page_name}_DM_summary"}{eval($page_size)} = $page_name;
        }

        if (!defined $dmswap_list{"$3_DMSWAP"})
        {
            $dmswap_list{"$3_DMSWAP"} = 1;
        }
    }

    # catch PM swap page details info
    #^111  0x84d8       216 LOC  FUNC .INIT_PMSWAP          Config_Potshpf
    elsif (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+FUNC\s+\.(\w+_PMSWAP)\s+(\w+)/)
    {
        if ($4 ne "\$t")
        {
            $address = sprintf("0x%08x", eval($1));
            $size = sprintf("%05d", eval($2));
            ${"$3"}{"$size\@$4(static)"} = "$address";
        }
    }
    elsif (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+GLOB\s+FUNC\s+\.(\w+_PMSWAP)\s+(\w+)/)
    {
        $address = sprintf("0x%08x", eval($1));
        $size = sprintf("%05d", eval($2));
        ${"$3"}{"$size\@$4"} = "$address";
    }
    elsif (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+GLOB\s+OBJ\s+\.(\w+_DMSWAP)\s+(\w+)/)
    {
        $address = sprintf("0x%08x", eval($1));
        $size = sprintf("%05d", eval($2));
        ${"$3"}{"$size\@$4"} = "$address";
    }

    # catch DM info
}
close (ELFDUMP_FILE);

# output PM section summary
print "\tPM SECTIONS SUMMARY\n\n";

printf("%30s%12s\n", "Overlay Buffer", "Allocated");
printf("%30s%12s%12s%12s\n", "Swap Page", "Actual Size", "Free Bytes", "Percentage");
printf("%30s%12s%12s%12s\n\n", "================", "===========", "===========", "===========");

foreach $section (keys %section_list)
{
    if (defined %{"${section}_PM_summary"})
    {

        $alloc_size = $section_allocated_size{$section};
        printf("\n%30s\n", "PM Overlay $section");
        printf("%20s0x%08x%4s%8d%4s%8s%4s%8s\n", "origin = ", $section_start{$section}, " ", $alloc_size, " ", "Free ", " ", "%  " );
        printf("%30s%4s%8s%4s%8s%4s%8s\n", "--------------------", " ", "------", " ", "------", " ", "------");
        foreach $page_size (sort numeric keys %{"${section}_PM_summary"})
        {
            $temp = ${"${section}_PM_summary"}{$page_size};
            printf("%30s%4s%8d%4s%8d%4s%8.1f\n", "page ${temp}", " ", $page_size, " ",
                   ($alloc_size - $page_size), " ",($page_size*100/$alloc_size));
        }
        print "\n";
    }
}


# output DM section summary

DB_block_:
{
        foreach $page_size (sort numeric keys %DB_DM_summary)
        {
            $max_DB_page = $DB_DM_summary{$page_size};
            $max_DB_size = $page_size;
            last DB_block_;
        }
}


DA_block_:
{
        foreach $page_size (sort numeric keys %DA_DM_summary)
        {
            $max_DA_page = $DA_DM_summary{$page_size};
            $max_DA_size = $page_size;
            last DA_block_;
        }
}

BULK_block_:
{
    foreach $page_size (sort numeric keys %{"BULK_DATA_RAM_DM_summary"})
    {
        $bulk_data_ram_size = $page_size;
        last BULK_block_;
    }
}



$total_bulk_used = $bulk_data_ram_size + $max_DA_size + $max_DB_size;
$total_bulk_alloc = $section_allocated_size{"BULK_DATA_RAM"} +
                    $section_allocated_size{"DA"} +
                    $section_allocated_size{"DB"};

print "\n\n\tDM SECTIONS SUMMARY \n\n\tnote that: total BULK = BULK_DATA_RAM + max(DA) + max(DB)  (excluding PERSISTENT and MBOX)\n\n";


printf("%30sBULK_DATA_RAM + $max_DA_page + $max_DB_page \n", "Total BULK used = ");
printf("%30s%6d + %6d +%6d = %7d\n", "= ", $bulk_data_ram_size , $max_DA_size , $max_DB_size, $total_bulk_used);
printf("%30s%5.1f (%d allocated)\n\n\n", "Percent BULK usage = ", $total_bulk_used*100/$total_bulk_alloc, $total_bulk_alloc);

printf("%30s%12s\n", "Overlay Buffer", "Allocated");
printf("%30s%12s%12s%12s\n", "Swap Page", "Actual Size", "Free Bytes", "Percentage");
printf("%30s%12s%12s%12s\n\n", "================", "===========", "===========", "===========");

foreach $section (keys %section_list)
{
    if (defined %{"${section}_DM_summary"})
    {
        $alloc_size = $section_allocated_size{$section};
        printf("\n%30s\n", "DM Overlay $section");
        printf("%20s0x%08x%4s%8d%4s%8s%4s%8s\n", "origin = ", $section_start{$section}, " ", $alloc_size, " ", "Free ", " ", "%  " );
        printf("%30s%4s%8s%4s%8s%4s%8s\n", "--------------------", " ", "------", " ", "------", " ", "------");
        foreach $page_size (sort numeric keys %{"${section}_DM_summary"})
        {
            $temp = ${"${section}_DM_summary"}{$page_size};
            printf("%30s%4s%8d%4s%8d%4s%8.1f\n", "page ${temp}", " ", $page_size, " ",
                   ($alloc_size - $page_size), " ",($page_size*100/$alloc_size));
        }
        print "\n";
    }
}

print "\n************\n";
print "\nPM details\n";
print "************\n\n";

foreach $pmswap (keys %pmswap_list)
{
    if (%{$pmswap})
    {
        printf("\n$pmswap:\n");
        printf("%50s%4s%10s%4s%5s\n", "Function Name", " ", "Address", " ", "Size(bytes)");
        printf("%50s%4s%10s%4s%5s\n", "-------------", " ", "-------", " ", "-----------");

        foreach $func (sort numeric keys %{$pmswap})
        {
            #print "$func ${$pmswap}{$func}\n";
            ($size = $func) =~ s/\@.*//;
            ($func_name = $func) =~ s/.*@//;
            printf("%50s%4s%10s%4s%5d\n", $func_name, " ", ${"$pmswap"}{$func}, " ", $size);
        }
    }
}

print "\n************\n";
print "DM details\n";
print "************\n\n";

foreach $dmswap (keys %dmswap_list)
{
    if (%{$dmswap})
    {
        printf("\n$dmswap:\n");
        printf("%45s\n", "Top 20");
        printf("%50s%4s%10s%4s%5s\n", "Variable Name", " ", "Address", " ", "Size(bytes)");
        printf("%50s%4s%10s%4s%5s\n", "-------------", " ", "-------", " ", "-----------");

        $i = 0;
        _foreach_0_loop:
        {
            foreach $var (sort numeric keys %{$dmswap})
            {
                $i++;
                ($size = $var) =~ s/\@.*//;
                ($var_name = $var) =~ s/.*@//;
                printf("%50s%4s%10s%4s%5d\n", $var_name, " ", ${"$dmswap"}{$var}, " ", $size);
                if ($i >= 20)
                {
                    last _foreach_0_loop;
                }
            }
        }
    }
}

sub numeric { $b <=> $a; }

sub eval1
{
    print " @_\n";
}
