# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
# The script can handle the following statements:
#
# The general format is:
# '#ifdef A' or '#ifndef A' or '#if defined A' or '#if defined (A)' or '#if defined(A)'
#  ...
# #elif B
#   ...
# #elif C
#   ...
# #else
#   ...
# #endif
#
# The variations:
# #elif defined B
# #elif defined(C)
# #if ((defined A) && (defined B) && ...)
# #if defined(A) || defined(B) || ...
# #ifdef A // Comments or /* Comments */
# The script removes the comments with the variable we want to hide.
# The script can handle the inner #ifdef/#ifndef - #endif statements.  
#
# The known not allowed statements:
#
# #if !(defined MACRO1 || defined MACRO2) could be replaced with the
# #ifndef MACRO1
#	#ifndef MACRO2
#		. . .
#	#endif
# #endif

($sourceDir, $destDir, $listFile) = @ARGV;

$sourceDir =~ s|\\|/|g;
$destDir  =~ s|\\|/|g;

open(outfile,">cleanup.out") or die "Can't open output file: $!\n";

printf outfile "%s\n", $sourceDir;
printf outfile "%s\n", $destDir;
printf outfile "%s\n\n", $listFile;

die "Usage:  $0 sourceDir destDir listFile\n" unless $listFile;
die "Error:  $destDir exists\n" if opendir(TMP, $destDir);
die "Error:  $sourceDir must point to an existing directory\n" unless opendir(SOURCE, $sourceDir);

use File::Copy;

mkdir $destDir;

die "Error:  $listFile must point to an existing file\n" unless open LSTFL, $listFile;

if (open(LSTMACROS, "ListMacros.txt")) {
	close(LSTMACROS);
	open(LSTMACROS, ">>ListMacros.txt");
	print LSTMACROS "\n### Directory $sourceDir ###\n";
}
else {
	open(LSTMACROS,">ListMacros.txt") or die "Can't open output file: $!\n";
	print LSTMACROS "!!! List of macros not encountered in 'defined' and 'undefined' lists !!!\n";
	print LSTMACROS "\n### Directory '$sourceDir' ###\n";
}

$hdr = '#ifdef';
$i = 0;
while ($ln = <LSTFL>) {
    chomp($ln);
    if ($ln eq '#UNDEFINED') {
        $hdr = '#ifndef';
    }
    elsif ($ln ne '#DEFINED' && $ln ne "") {
        $block[$i] = $ln;
        $header[$i] = $hdr;
        $i++;
    }
}
close(LSTFL);

%macros = ();
process($sourceDir, SOURCE, 'fh000000000');
closedir(SOURCE);
close(outfile);
foreach $key (keys(%macros)) {
	if ($macros{$key}) {
		print LSTMACROS "$key\n";
	}
}
print LSTMACROS "\n"; 
foreach $key (keys(%macros)) {
	if (!$macros{$key}) {
		print LSTMACROS "$key\n";
	}
}
close(LSTMACROS);

sub process {
    local($dirname, $dirhandle, $nexthandle) = @_;
    printf outfile "%s %s %s\n", $dirname, $dirhandle, $nexthandle;
    $nexthandle++;
    while ($filename = readdir $dirhandle) {
		printf outfile "%s \n\n", $filename;
		next if $filename =~ /^\.\.?$/;
		$filename = $dirname . "/" . $filename;
		($tmp = $filename) =~ tr/a-z/A-Z/;
		($newname = $filename) =~ s|$sourceDir|$destDir|;
		if (opendir($nexthandle, $filename)) {
			mkdir $newname;
		    process($filename, $nexthandle, $nexthandle);
		}
		else {
		    if ($filename =~ /\.[CcHh]$/) {
				open ORIGFL, $filename;
				open TMPFL, ">temp1";
				while ($ln = <ORIGFL>) {
					print TMPFL $ln;
				}
				close(ORIFL);
				close(TMPFL);
				$fnum1 = 1;
			    $fnum2 = 2;
				for ($k =0;$k<=$i-1;$k++) {
					cleancodeinmacro("temp".$fnum1, "temp".$fnum2, $block[$k], $header[$k]);
				    if ($fnum1 == 1) {
				        $fnum1 = 2;
				        $fnum2 = 1;
					}
					else {
						$fnum1 = 1;
				        $fnum2 = 2;
					}
			    }
				copy("temp".$fnum1,$newname);
				unlink "temp1", "temp2";
		        createmacroslist($newname);
		    }
			else {
				$filename =~ s|/|\\|g;
				$newname =~ s|/|\\|g;
				copy($filename,$newname);
			}
		}
    }
    closedir($dirhandle);
}

sub cleancodeinmacro {
    local($filename, $newname, $key, $macro) = @_;
    open ORIG, $filename;
    open NEW, ">$newname";
    @stack = ();
    while($line = <ORIG>) {
		if (($line =~ /^[ \t]*\#if .*defined *\(*$key\)*/) && ($line =~ /[ \t]&&[ \t]/) && ($macro eq '#ifndef')) {
		    $line = '#ifdef '.$key;
		}
		elsif (($line =~ /^[ \t]*\#if .*defined *\(*$key\)*/) && ($line =~ /[ \t]&&[ \t]/) && ($macro eq '#ifdef')) {
			$line =~ s/defined $key/1/;
		    $line =~ s/defined\($key\)/1/;
		    $line =~ s/defined \($key\)/1/;
			if ($line !~ /\#if .*defined/) {
				$line = '#ifdef '.$key;
		    }
			elsif ($line !~ /\#if .*defined.*defined.*/) {
				$line =~ s/\#if .*defined *\(*(\w+)\)* .*/\#ifdef $1/; # In the middle
				$line =~ s/\#if .*defined *\(*(\w+)\)*/\#ifdef $1/; # At the end
			}
		}
		elsif (($line =~ /^[ \t]*\#if .*defined *\(*$key\)*/) && ($line =~ /[ \t]\|\|[ \t]/) && ($macro eq '#ifndef')) {
		    $line =~ s/defined $key/0/;
			$line =~ s/defined\($key\)/0/;
		    $line =~ s/defined \($key\)/0/;
		    if ($line !~ /\#if .*defined/) {
				$line = '#ifdef '.$key."\n";
		    }
			elsif ($line !~ /\#if .*defined.*defined.*/) {
				$line =~ s/\#if .*defined *\(*(\w+)\)* .*/\#ifdef $1/; # In the middle
				$line =~ s/\#if .*defined *\(*(\w+)\)*/\#ifdef $1/; # At the end
			}
		}
		elsif (($line =~ /^[ \t]*\#if .*defined *\(*$key\)*/) && ($line =~ /[ \t]\|\|[ \t]/) && ($macro eq '#ifdef')) {
			$line = '#ifdef '.$key;
		}
		elsif (($line =~ /^[ \t]*\#elif .*defined *\(*$key\)*/) && ($macro eq '#ifdef')) {
			$line =~ s/defined $key/1/;
		    $line =~ s/defined\($key\)/1/;
		    $line =~ s/defined \($key\)/1/;
		}

		($cmd, $arg, $temp) = split " ", $line; # $temp - for more complex statement (see below)

		$cmd =~ s/(^#\w+)\/\/.*/$1/; # to remove comments in case,
	    $cmd =~ s/(^#\w+)\/\*.*/$1/; # to remove comments in case,
		$arg =~ s/(^\w+)\/\/.*/$1/;  # for instance,
	    $arg =~ s/(^\w+)\/\*.*/$1/;  # for instance,
		$temp =~ s/(^\w+)\/\/.*/$1/; # #endif//End of #ifdef ...
	    $temp =~ s/(^\w+)\/\*.*/$1/; # #endif//End of #ifdef ...

		if ($arg eq "defined") {
		    $arg = $temp;                  # for the "#if/#elif defined XXX" or "#if/#elif defined (XXX)"
			$arg =~ s/^\((\w+)\).*/$1/;	   # for the "#if/#elif defined (XXX)"
			if ($line =~ /^[ \t]*\#if .*defined.*/) {
				$cmd = '#ifdef';
			}
		}

		if ($arg =~ s/^defined\((\w+)\).*/$1/) { # for the "#if/#elif defined(XXX)"
			if ($line =~ /^[ \t]*\#if .*defined.*/) {
				$cmd = '#ifdef';
			}
		}

		if ($cmd eq $macro) {
		    $arg_prev = pop(@stack);
			push(@stack,$arg_prev);
			push(@stack,"!".$arg);
			if ($arg eq $key) {
	            $rem_all{"!".$arg} = 0;
   				$line = "\n";
		    }
			elsif ($rem_all{$arg_prev} == 1) {
				$rem_all{"!".$arg} = 1;
				$rem_all{$arg} = 1;
			}
		}
		elsif ($cmd =~ /^\#if/) {
			push(@stack,$arg);
		    if ($arg eq $key) {
		        $rem_all{"!".$arg} = 0;
		        $rem_all{$arg} = 0;
				if ($line !~ / \|\| /) {
					$repl_elif = 1;
				}
		    }
		}
		elsif ($cmd eq '#elif') {
		    $arg_prev = pop(@stack);
			if ($arg_prev eq "!".$key) {
				$rem_all{$arg_prev} = 1;
	  	        push(@stack,$arg_prev);
				$arg = $arg_prev;
			}
		    else {
		    	push(@stack,$arg);
			    if ($arg eq $key) {
				    $save_else{$arg} = 1;
				}
				else {
					$save_else{$arg_prev} = 0;
				}
		    	if ($skip_prn && $repl_elif) {
					$line = '#ifdef '.$arg."\n";
					if ($line eq '#ifdef 1'."\n") {
						$line = '#if 1'."\n";
					}
				    $repl_elif = 0;
	    		}	
		    }
		}
		elsif ($cmd eq '#else') {
		    $arg = pop(@stack);
			if ($arg =~ s/^!//) {
				push(@stack, $arg);
		    }
		    else {
				push(@stack, "!".$arg);
	        }
		    if (($arg eq $key) && ($save_else{$arg} != 1)) {
			    $line = "";
		    }
		    if ($arg eq $key) {
				$repl_elif = 0;
			}
		}
		elsif ($cmd eq '#endif') {
		    $arg = pop(@stack);
			$arg =~ s/^!//;
		    if ($arg eq $key) {
		        if ($save_else{$arg} != 1) {
				    $line = "\n";
				}
		        $save_else{$arg} = 0;
				$repl_elif = 0;
			}
			if (($rem_all{"!".$arg} == 1) || ($rem_all{$arg} == 1)) {
	            $rem_all{"!".$arg} = 0;
		        $rem_all{$arg} = 0;
				$line = "\n";
			}
		}
		else {
			$arg = pop(@stack);
	       	push(@stack,$arg);
		}

		$line =~ s/(.*)\/\/.*$key.*/$1/;	# to remove from the comments
		$line =~ s/(.*)\/\*.*$key.*/$1/;	# to remove from the comments
		$skip_prn = grep /^$key$/, @stack;
		print NEW $line unless ($skip_prn || ($rem_all{$arg} == 1));
    }
    close(NEW);
    close(ORIG);
    $repl_elif = 0;
    foreach $k (keys(%rem_all)) {
		$rem_all{$k} = 0;
    }
    foreach $k (keys(%save_else)) {
		$save_else{$k} = 0;
    }
}

sub createmacroslist {
    local($filename) = @_;
    open FL, $filename;
    while($line = <FL>) {
		chomp($line);
		if (($line =~ s/^[ \t]*(\#if.*)/$1/) || ($line =~ s/^[ \t]*(\#elif.*)/$1/)) { # Check the #if.* and #elif*, trim leading white spaces
			$line =~ s/(.*)\/\/.*$/$1/; # Remove comments if exist
			$line =~ s/(.*)\/\*.*$/$1/; # Remove comments if exist
				@elems = split " ", $line;
				$j = 0;
				foreach $elem (@elems) {
				if (($elem =~ s/^defined\((.*)\)/$1/) || ($elem =~ s/^\#ifdef\((.*)\)/$1/) || ($elem =~ s/^\#ifndef\((.*)\)/$1/)) {
					if ($elem =~ /.*_H$/) {
						$macros{$elem} = 0;
					}
					else {
						$macros{$elem} = 1;
					}
				}
				elsif (($elem eq "defined") || ($elem eq "\#ifdef") || ($elem eq "\#ifndef")) {
					$elems[$j+1] =~ s/\((.*)\)/$1/;
					if ($elems[$j+1] =~ /.*_H$/) {
						$macros{$elems[$j+1]} = 0;
					}
					else {
						$macros{$elems[$j+1]} = 1;
					}
				}
				$j++;
			}
		}
	}
	close(FL);
}