# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
#
# Extract version information from CPE\sandbox\soc_src\modem\Platform\version.c
# Copy built output ModemHWE.bin & ModemHWE.out to the form of ModemHWE_xxxxxx.* in the same obj directory.
#

$c_path = "..\\..\\soc_src\\modem\\Platform\\";


$obj_path = "obj\\"; 
$debug = 0;					# use to debug this script
$idx = 0;

$new_target = @ARGV[0];		# output file name prefix
$isdn = @ARGV[1];			# " " for Annex A build; "ISDN" for Annex B build

if ($new_target eq 'DANUBE')
{
	$ver_file = "version.c";
}	
elsif ($new_target eq 'AmazonSE')
{
	$ver_file = "version.c";
}
elsif ($new_target eq 'AR9')
{
	$ver_file = "version.c";
}
else
{
	die "Unknown Platform. Must be DANUBE or AmazonSE or AR9";
}

# Open and read in the version.c
open (FILE, "$c_path$ver_file") && (@stream=<FILE>) && close(FILE) || die "Can't open file: $c_path$ver_file!";

# Parse the file stream for version information
for (@stream)
{
   if ($new_target eq 'AR9')
   {
      $major_rev = 4;
   }
   elsif ($new_target eq 'AmazonSE')
   {
      $major_rev = 3;
   }
   elsif ($new_target eq 'DANUBE')
   {
      $major_rev = 2;
   }
   else
   {
	   die "Unknown Platform. Must be DANUBE or AmazonSE or AR9";
   }

#	if (/#define VERSION_MAJOR/)
#	{
#		@line = split(' ', $_);
#		$major_rev = @line[2];
#		if ($debug) {print "Major Revision: $major_rev\n";}
#	}

	if (/#define VERSION_MINOR/)
	{
		@line = split(' ', $_);
		$minor_rev = @line[2];
		if ($debug) {print "Minor Revision: $minor_rev\n";}
	}

	if (/#define SUBVERSION_OF_A_VERSION_MINOR/)
	{
		@line = split(' ', $_);
		$temp = @line[2];
		$subver_minor_rev = sprintf("%X", $temp);
		if ($debug) {print "Sub Revision: $subver_minor_rev\n";}
	}

	if (/#define INTERNALVERSIONS/)
	{
		@line = split(' ', $_);
		$temp = @line[2];
		$int_rev = sprintf("%X", $temp);
		if ($debug) {print "Internal Revision: $int_rev\n";}
	}

	if (/#define RELEASE_STATE_OF_FW/)
	{
		@line = split(' ', $_);
		$rel_state = @line[2];
		if ($debug) {print "Release State: $rel_state\n";}
	}

	if (/#define FIRMWARE_MODE/)
	{
		@line = split(' ', $_);
		$fw_mode_ab[$idx] = @line[2];
		if ($debug) {print "Firmware Mode $idx: $fw_mode_ab[$idx]\n";}
		
		$idx = $idx + 1;
	}					

	if (/#ifdef ISDN/)
	{
		@line = split(' ', $_);
		$ifdef_1 = @line[1];
		if ($debug) {print "Ifdef 1: $ifdef_1\n";}
	}	
   if ($rel_state == 3)    # Extended FW version no.
   {
      if (/#define RELEASE_SOURCE/)
      {
		   @line = split(' ', $_);
   		$rel_source = @line[2];
	   	if ($debug) {print "Release State: $rel_source\n";}
      }
      if (/#define RELEASE_NUMBER/)
      {
		   @line = split(' ', $_);
   		$rel_number = @line[2];
	   	if ($debug) {print "Release State: $rel_number\n";}
      }
   }
}

# A kludge way to solve #ifdef ISDN
if ($ifdef_1 eq $isdn)
{
	# take the first occurrence of FIRMWARE_MODE value
	$fw_mode = $fw_mode_ab[0];
	if ($debug) {print "Firmware Mode: $fw_mode\n";}
}
else
{
	# take the second occurrence of FIRMWARE_MODE value
	$fw_mode = $fw_mode_ab[1];
	if ($debug) {print "Firmware Mode: $fw_mode\n";}
}

# Generate a version string from above
$version = "${major_rev}${minor_rev}${subver_minor_rev}${int_rev}${rel_state}${fw_mode}";
if ($rel_state == 3)    # To append the ext. fw version no. information to the firmware binary and out filename.
{
   $version = "${major_rev}${minor_rev}${subver_minor_rev}${int_rev}${rel_state}${fw_mode}_0${rel_source}0${rel_number}";
}   
$target = "${obj_path}ModemHWE";
$target_ver = "${obj_path}${new_target}_${version}";

# Copy the standard .bin & .out files to the ones with version string attached.
if (-e "$target.bin")
{
	print "\nCopying $target.bin to $target_ver.bin\n";
	system ("copy $target.bin $target_ver.bin");
}
else
{
	print "\nFile $target.bin does not exist\n";
}

if (-e "$target.out")
{
	print "\nCopying $target.out to $target_ver.out\n";
	system ("copy $target.out $target_ver.out");
}
else
{
	print "\nFile $target.out does not exist\n";
}
