# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
#
# extract ADSL version from adsl_cpe_non_cache.bin
# Copy built output ModemHWE.bin & ModemHWE.out to the form of ModemHWE_xxxxxx.* in the same obj directory.
#

open(ADSL, "<obj\\adsl_cpe_non_cache.bin") || die "!!! Error: Can't open  obj\\adsl_cpe_non_cache.bin!!!\n";
binmode(ADSL);
print "\tget ADSL version from $ARGV[1]...\n";

$found = 0;
while(<ADSL>)
{
    if (/\@\(\#\)[V_]*([a-f0-9\.]+)/i)
    {
        $version = $1;
        $version =~ s/\.//g;
        $found = 1;
    }
}
close(ADSL);


if ($found == 1)
{
    print "\t\tfound ADSL version: $version\n\n";
}
else
{
    die "!!! Error: couldn't get the version string from bin file !!!\n";
}

$obj_path = "obj\\";
$new_target = "$ARGV[0]";
   
$target = "${obj_path}adsl_vdsl_cpe";
$target_out = "${obj_path}ModemHWE";
$target_ver = "${obj_path}${new_target}_${version}";
$target_out_ver = "${obj_path}acpe_${version}";

# Copy the standard .bin & .out files to the ones with version string attached.
if (-e "$target.bin")
{
	print "\nCopying $target.bin to $target_ver.bin\n";
	system ("copy $target.bin $target_ver.bin");
}
else
{
	print "\nFile $target.bin does not exist\n";
}

if (-e "$target_out.out")
{
	print "\nCopying $target_out.out to $target_out_ver.out\n";
	system ("copy $target_out.out $target_out_ver.out");
}
else
{
	print "\nFile $target.out does not exist\n";
}
