# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
    $USAGE = " Usage: \n".
             "perl get_src_frm_dsp.pl\n".
             "\tdsp_file_name\n".
             "\tdsp_path_relative_to_arc_bld\n".
             "\tsrc_inc_output_dir\n".
             "\tMSVC_Configuration\n";   
    
    if ($#ARGV == 3)
    {
        $dsp_file_name = @ARGV[0].".dsp";
        $path_to_dsp_file = @ARGV[1];
        $output_basename = @ARGV[0];
        $output_dir = @ARGV[2];
        $MSVC_CFG = @ARGV[3];
    
        ($dsp_in_stat = open(DSP_IN, "<${path_to_dsp_file}/${dsp_file_name}")) || 
                        go_die ("cannot open ${path_to_dsp_file}/${dsp_file_name}\n");
        $src_outfile = "${output_dir}"."/${output_basename}.src";
        $inc_outfile = "${output_dir}"."/${output_basename}.inc";
    }
    else
    {
    	go_die("$USAGE");
    }
    
    $include_string = "";
    $src_output_lines = "${output_basename}_SRC = \\\n";
#    $c_rls_output_lines = "${output_basename}_C_RLS = \\\n";
#    $asm_rls_output_lines = "${output_basename}_ASM_RLS = \\\n";
    $c_vpath_output_lines = "VPATH_FOR_C += \\\n";
    $asm_vpath_output_lines = "VPATH_FOR_ASM += \\\n";
    

    $sub_state = 0;
    
    _while_block:
    while (<DSP_IN>)
    {
         _switch_0:
         {
             #case 0:
             if ($sub_state == 0)
             {
                 if (/\!IF\s+"\$\(CFG\)"\s+==\s+"(\S+\s+)*-\s+Win32 $MSVC_CFG"/)
                 {
                     print"\n ############\n Your configuration is: ".$MSVC_CFG."\n############\n";
                     $sub_state = 10;
                 }
                 elsif (/\!ELSEIF\s+"\$\(CFG\)"\s+==\s+"(\S+\s+)*-\s+Win32 $MSVC_CFG"/)
                 {
		     print"\n ############\n Your configuration is: ".$MSVC_CFG."\n############\n";
		     $sub_state = 10;
                 }
                 last _switch_0;
             }
    
             #case 10:
             elsif ($sub_state == 10)
             {
                 if (/^#\s+ADD\s+CPP\s+((\/[^I]+\s+)*)((\/I\s+\"\S+\"\s+)*)\/D.*$/)
                 {
                     # forming include strings used by hcarc.exe
                     ($include_string = $3) =~ s%\\%/%g;
                     $include_string =~ s%"\s+%\n%g;                     # break into new lines
                     $include_string =~ s%/I\s*"%-I${path_to_dsp_file}/%g;      # syntax change: /I to -I
                     $include_string =~ s%"%%g;                                   # get rid all "
                 }
                 elsif (/\!ENDIF/ || /\!ELSEIF/)
                 {
                     #print "end of IF\n";
                     $sub_state = 20;
                 }
                 last _switch_0;
             }
    
             #case 20:
             elsif ($sub_state == 20)
             {
                 if (/# Begin Group "Source Files"/)
                 {
                     $sub_state = 30;
                 }
                 last _switch_0;
             }
    
             #case 30:
             elsif ($sub_state == 30)
             {
                 #if (/^\s*SOURCE=\s*(\S+)$/)
                 if (/^\s*SOURCE=(\s*\S+\W)(\w+)\.([cC])$/)
                 {
                     #add on to subproject_SRC
                     ($unix_path = $1) =~ tr#\\#/#;
                     $src_output_lines .= "    ${path_to_dsp_file}/${unix_path}${2}.${3} \\\n";
    
                     # add on to subproject_C_RLS
#                     $c_rls_output_lines .= "    $2.rls \\\n";
    
                     # add on to VPATH_FOR_C
                     if (!defined $c_vpath_output_lines{$unix_path})
                     {
                         $c_vpath_output_lines .= "    ${path_to_dsp_file}/$unix_path \\\n";
                         $c_vpath_output_lines{$unix_path} = 1;
                         if (!defined $asm_vpath_output_lines{$unix_path})
                         {
                             $include_string .= "\n-I${path_to_dsp_file}/$unix_path";
                         }
                     }
                 }
                 if (/^\s*SOURCE=(\s*\S+\W)(\w+)\.([sS])$/)
                 {
                     #add on to subproject_SRC
                     ($unix_path = $1) =~ tr#\\#/#;
                     $src_output_lines .= "    ${path_to_dsp_file}/${unix_path}${2}.${3} \\\n";
    
                     # add on to subproject_ASM_RLS
                     $asm_rls_output_lines .= "    $2.rls \\\n";
    
                     # add on to VPATH_FOR_ASM
                     if (!defined $asm_vpath_output_lines{$unix_path})
                     {
                         $asm_vpath_output_lines .= "    ${path_to_dsp_file}/$unix_path \\\n";
                         $asm_vpath_output_lines{$unix_path} = 1;
                         if (!defined $c_vpath_output_lines{$unix_path})
                         {
                             $include_string .= "\n-I${path_to_dsp_file}/$unix_path";
                         }
                     }
                 }
                 elsif (/# End Group/)
                 {
                     last _while_block;
                 }
                 last _switch_0;
             }
         }
    }
    
    ($src_out_stat = open(SRC_OUT, ">$src_outfile")) || 
                 go_die("cannot open $src_outfile\n");
    
    ($inc_out_stat = open(INC_OUT, ">$inc_outfile")) ||
                 go_die("cannot open $inc_outfile\n");
    
    printf (SRC_OUT "%s\n", "# This file is an input file to gmake.exe.\n".
                            "# It is automatically generated by get_src_frm_dsp.pl\n\n");
    printf (SRC_OUT "%s\n", $src_output_lines);
#    printf (SRC_OUT "%s\n", $c_rls_output_lines);
#    printf (SRC_OUT "%s\n", $asm_rls_output_lines);
    
    printf (SRC_OUT "%s\n", $c_vpath_output_lines);
    printf (SRC_OUT "%s\n", $asm_vpath_output_lines);
    
    close SRC_OUT;
    
    printf (INC_OUT "%s\n", $include_string);
    close INC_OUT;
    
    exit;
    
    sub go_die ($output_string)
    {
        local $output_string = shift @_;
    
        if (defined $dsp_in_stat)
        {
            close DSP_IN;
        }
    
        if (defined $src_out_stat)
        {
            close SRC_OUT;
            system("rm $src_outfile");
        }
    
        if (defined $inc_out_stat)
        {
            close INC_OUT;
            system("rm $inc_outfile");
        }
    
        die "$output_string\n";
    }
    
