# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
# this tool will read the harvard cmd file for codeswap build,
# generate the CodeSwap_Source.src and CodeSwap_Source.inc files,
# generate the super files which are used to hide the multiply
# defined objects.
#
# The CodeSwap_Source.src (similar to other *.src) will have
# info about the super files, the path to those files, and some
# info (used by gmake) about objects that are used to form
# these super files. Later on, in the make file, we use this info
# to trim down the object archive for codeswap build.

    $USAGE = "Usage:  perl codeswap_modem_build.pl\n" .
             "\t\tcmd_input_file            // with path\n".
             "\t\tcmd_output_file           // with no path\n".
             "\t\tmake_inputs_path          // with path\n".
             "\t\tBUILD_OPTIONS_LIST        // list of all builds options used in .cmd input file\n";
    
    $cmd_infile = @ARGV[0];
    $cmd_outfile = @ARGV[1];
    $make_inputs_dir = @ARGV[2];
    
    $alias_gen_enabled = 0;
    $use_alias_build = 1;

    if ($#ARGV != 3)
    {
        print("only received $#ARGV args\n");
        die($USAGE);
    }
    
    foreach $bld_opt (split / /,@ARGV[3])
    {
        $build_options{$bld_opt} = 1;
        if ($bld_opt eq "TARGET_ARC")
        {
            $build_options{"TARGET_HW"} = 1;
        }
    }

    @ifxdef_stack = (1);               # by default, things are enabled.

    # read in alias file
    if ($alias_gen_enabled)
    {
        open(ALIAS_INFILE, "<alias_input.txt") ||  die ("can't open alias_input.txt\n");
        while(<ALIAS_INFILE>)
        {
            if (m%^(\w+.c):\s*(\w+)%)
            {
                ($temp1 = $1) =~ tr/A-Z/a-z/;
                if (!defined($aliased_function{$2}))
                {
                    $aliased_function{$2} = 1;
                    $alias_input{$temp1} .= "#pragma Alias($2, \"$2_zzzz\")\n";
                }
            }
        }
        close(ALIAS_INFILE);
    }

    
    # open input and output .cmd files
    open(CMD_INFILE, "<$cmd_infile") || 
        die "cannot open $cmd_infile\n";
    open(CMD_OUTFILE, ">${make_inputs_dir}/$cmd_outfile") || 
        die "cannot open $cmd_outfile\n";
    
    
    $state = 0;
    $num_of_swap_pages = 0;              # each page contains TWO swap blocks: one for PM and one for DM
    $CodeSwapTable_content = "";
    
    _end_of_file_block:
    while(<CMD_INFILE>)
    {

        while (/^\s*[^\/]+(GET_SIZE_OF\(\s*(\S+)\s*\))/)
        {
            if (open(FILE_IN, "<$2"))
            {
                seek(FILE_IN, 0, 2);
                $file_size = tell(FILE_IN);
                close(FILE_IN);
            }
            else
            {
                print "\t!!! Warning: $2 doesn't exist !!!\n\n";
                $file_size = 0;
            }
            ($temp_string = $1) =~ s#\\#.#g;
            ($temp_string = $temp_string) =~ s#\(#.#g;
            ($temp_string = $temp_string) =~ s#\)#.#g;
            $_ =~ s#${temp_string}#${file_size}#;
        }

        _switch_0:
        {
        # ifdef/ifndef SINGLE_CONDITION support
            if (/^\s*\#ifdef\s+(\w+)\s*$/) 
            {
                if (!defined($build_options{$1}))
                {
                    push(@ifxdef_stack, 0);
                }
                else
                {
                    push(@ifxdef_stack, 1);
                }
                last _switch_0;
            }

            if (/^\s*\#ifndef\s+(\w+)\s*$/) 
            {
                if (defined($build_options{$1}))
                {
                    push(@ifxdef_stack, 0);
                }    
                else
                {
                    push(@ifxdef_stack, 1);
                }
                last _switch_0;
            }

        # ifdef (CONDITION_1 || CONDITION_2) support
            if (/^\s*#ifdef\s+\(\s*(\w+) \|\| (\w+)\s*\)\s*$/) 
            {
                if (!defined($build_options{$1}) && !defined($build_options{$2}))
                {
                    push(@ifxdef_stack, 0);
                }
                else
                {
                    push(@ifxdef_stack, 1);
                }
                last _switch_0;
            }

        # ifdef (CONDITION_1 && CONDITION_2) support
            if (/^\s*#ifdef\s+\(\s*(\w+) \&\& (\w+)\s*\)\s*$/) 
            {
                if (!defined($build_options{$1}) || !defined($build_options{$2}))
                {
                    push(@ifxdef_stack, 0);
                }    
                else
                {
                    push(@ifxdef_stack, 1);
                }
                last _switch_0;
            }

            if (/^\s*#else/)
            {
                if ($#ifxdef_stack <= 0)
                {
                    die("Error: unmatched #else detected\n");
                }
                push(@ifxdef_stack, 1^pop(@ifxdef_stack));

                last _switch_0;
            }
        
            # get out if hit endif
            if (/^\s*#endif/)
            {
                if ($#ifxdef_stack <= 0)
                {
                    die("Error: unmatched #endif detected\n");
                }
                pop(@ifxdef_stack);
                last _switch_0;
            }

            if ($ifxdef_stack[$#ifxdef_stack] == 0)
            {
                last _switch_0;
            }

            if (/^(\s*)ASCII\((.+)\)/)
            {
                print (CMD_OUTFILE "$1BYTE(");
                foreach $character (split //, $2)
                {
                    printf(CMD_OUTFILE "0x%x,", ord($character));
                }
                printf(CMD_OUTFILE "0x%x)\n", ord("\n"));
                last _switch_0;
            }

            if (/^\s*#include\s*"(\S+)"/)
            {
                IncludeFile($1);
                last _switch_0;
            }

            # output the line
            printf(CMD_OUTFILE "$_");
        }
    }
    
    close(CMD_OUTFILE);
    if ($#ifxdef_stack != 0)
    {
        die("Error: unmatched #if/#else/#endif detected\n");
    }

    exit;








sub numeric { $a <=> $b; }

sub IncludeFile
{
    local ($file_name) = @_;

    open(INCLUDE_FILE, "<${make_inputs_dir}/$file_name") || die "Failed to read in included file $file_name\n";
    while(<INCLUDE_FILE>)
    {
        if (/^\s*[^\/]+(GET_SIZE_OF\(\s*(\S+)\s*\))/)
        {
            if (open(FILE_IN, "<$2"))
            {
                seek(FILE_IN, 0, 2);
                $file_size = tell(FILE_IN);
                close(FILE_IN);
            }
            else
            {
                print "\t!!! Warning: $2 doesn't exist !!!\n\n";
                $file_size = 0;
            }
            $_ =~ s#GET_SIZE_OF\(\s*\S+\s*\)#${file_size}#;
        }
        print (CMD_OUTFILE $_);
    }
}
