# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**

$map_file = @ARGV[0] . ".map";
$sym_file = @ARGV[0] . ".sym";

($itux = @ARGV[2]) =~ tr/a-z/A-Z/;


open(MAP_FILE, "<$map_file") || die "Failed to open $map_file\n";



$state = 0;

_while_0:
{
    while (<MAP_FILE>)
    {
        if ($state == 0)
        {
            if (/^\s*SECTION SUMMARY\s*$/)
            {
                $state = 10;
            }

        }
        elsif ($state == 10)
        {
            if (/^SECTION DETAILS/)
            {
                last _while_0;
            }
#.PMSWAP_VCPE_MAIN
#         text   00000000  000068f1  000068f2
#.text    text   000068f4  00006953  0000006

            # catch PM_section info
            #^36  0x13f00     8308 LOC  SECT .DMSWAP_BULK_O1
            if ((/^\s*(\.\w+_PMSWAP$)/) || (/^\s*(\.PMSWAP_\w+$)/))
            {
                $_ = <MAP_FILE>;
                ($dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
            }
            elsif ((/^\s*(\.\w+_DMSWAP$)/) || (/^\s*(\.DMSWAP_\w+$)/))
            {
                $_ = <MAP_FILE>;
                ($dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
            }
            elsif (/^\s*(\.\w+_MEM$)/)
            {
                $_ = <MAP_FILE>;
                ($dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
#print "$1\t$addr_of{$1}\t$section_sizes{$1}\n";
            }
            elsif (/^\s*(\.\w+_BSS$)/)
            {
                $_ = <MAP_FILE>;
                ($dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
            }
            elsif ((/^\s*(\.\w+_PMSWAP)/) || (/^\s*(\.PMSWAP_\w+)/))
            {
#                $_ = <MAP_FILE>;
                ($dummy0, $dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
            }
            elsif ((/^\s*(\.\w+_DMSWAP)/) || (/^\s*(\.DMSWAP_\w+)/))
            {
#                $_ = <MAP_FILE>;
                ($dummy0, $dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
            }
            elsif (/^\s*(\.\w+_MEM)/)
            {
#                $_ = <MAP_FILE>;
                ($dummy0, $dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
#print "$1\t$addr_of{$1}\t$section_sizes{$1}\n";
            }
            elsif (/^\s*(\.\w+_BSS)/)
            {
#                $_ = <MAP_FILE>;
                ($dummy0, $dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
                $addr_of{$1} = hex($dummy2);
            }
            elsif (/^\s*(\.text)/)
            {
                ($dummy0, $dummy1, $dummy2, $dummy3, $dummy4) = split ' ', $_;
                $section_sizes{$1} = hex("0x$dummy4");
            }
        }
        
    }
}

seek(MAP_FILE, 0, 0);


$state = 0;

#get mapping between swap pages and physical buffers
_while_1:
{
    while (<MAP_FILE>)
    {
        if (/^\s*GROUP.*:\s*{\s*$/)
        {
            $temp = "";
            $size = 0;
            $page_type = "dont_care";
_while_1a:
            {
                undef(%page_list);
                while(<MAP_FILE>)
                {
                    if ((/^\s*(\.\w+_PMSWAP).*:\s*{\s*/) || (/^\s*(\.PMSWAP_\w+).*:\s*{\s*/))
                    {
                        $page_list{$1} = 1;
                        $pmswap_vcpe_pages{$1} = 1;
                        $page_type = "pmswap";
                    }
                    elsif ((/^\s*(\.\w+_DMSWAP).*:\s*{\s*/) ||
                           (/^\s*(\.DMSWAP_\w+).*:\s*{\s*/) ||
                           (/^\s*(\.\w+_BSS).*:\s*{\s*/) ||
                           (/^\s*(\.\w+_MEM).*:\s*{\s*/))
                    {
                        $page_list{$1} = 1;
                        $dmswap_vcpe_pages{$1} = 1;
                        $page_type = "dmswap";
                    }
                    elsif(/^\s*(\.\w+).*:\s*{\s*/)
                    {
                        $page_list{$1} = 1;
                    }
                    elsif (/^\s*}\s*>\s*(\w+)/)
                    {
                        $buffer_types{$1} = $page_type;

                        foreach $page (keys %page_list)
                        {
                            if (!defined($section_sizes{$page}))
                            {
                                # some of the pages declared but not used
                                $section_sizes{$page} = 0;
                            }
                            ${"buffer_usages_$1"}{$page} = $section_sizes{$page};
                        }
                        last _while_1a;
                    }
                }
            }
        }
    }
}

# get physical section size
seek(MAP_FILE, 0, 0);
_while_2a:
{
    while (<MAP_FILE>)
    {
            if ((/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)\/\//) ||
                (/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)$/))
            {
                $phy_section_name = $1;


                $length = $3;

                $addr = $2;

                ($addr = $addr) =~ s#\/\/.*$##g;
                ($addr = $addr) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                ($addr = $addr) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                ($addr = $addr) =~ s/(\d+)[kK]/$1\*1024/g;
#print "addr_of = $addr\n";
                $addr_of{$phy_section_name} = eval("$addr");
#print "addr_ofA= $addr_of{$phy_section_name}\n";



                ($length = $length) =~ s#\/\/.*$##g;
                ($length = $length) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
                $section_sizes{$phy_section_name} = eval("$length");
#print "section: $phy_section_name, $section_sizes{$phy_section_name}\n";
            }
            elsif (/^\s*(\w+_FADX\w*)\s*:/)
            {
                $phy_section_name = $1;

                _while_2a_0:
                {
                    while (<MAP_FILE>)
                    {
                        if (/^\s*ORIGIN\s*=\s*(.+)\s*[,]/)
                        {
                            $addr = $1;

                            ($addr = $addr) =~ s#\/\/.*$##g;
                            ($addr = $addr) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                            ($addr = $addr) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                            ($addr = $addr) =~ s/(\d+)[kK]/$1\*1024/g;
                            $addr_of{$phy_section_name} = eval("$addr");
                            last _while_2a_0;
                        }
                    }
                }

                _while_2a_1:
                {
                    while (<MAP_FILE>)
                    {
                        if (/^\s*LENGTH\s*=\s*(.*)$/)
                        {
                            $length = $1;
                            ($length = $length) =~ s#\/\/.*$##g;
                            ($length = $length) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                            ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                            ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
                            $section_sizes{$phy_section_name} = eval("$length");
                            last _while_2a_1;
                        }
                    }
                }
            }
    }
}

# second path
seek(MAP_FILE, 0, 0);
_while_2b:
{
    while (<MAP_FILE>)
    {
            if ((/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)\/\//) ||
                (/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)$/))
            {
#print "$1: ";
                $phy_section_name = $1;


                $length = $3;

                $addr = $2;

                ($addr = $addr) =~ s#\/\/.*$##g;
                ($addr = $addr) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                ($addr = $addr) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                ($addr = $addr) =~ s/(\d+)[kK]/$1\*1024/g;
#print "addr_of = $addr\n";
                $addr_of{$phy_section_name} = eval("$addr");
#print "addr_ofA= $addr_of{$phy_section_name}\n";


                ($length = $length) =~ s#\/\/.*$##g;
                ($length = $length) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
#print "length = $length\n";
                $section_sizes{$phy_section_name} = eval("$length");
#print "lengthA= $section_sizes{$phy_section_name}\n";
#print "section: $phy_section_name, $section_sizes{$phy_section_name}\n";
            }
            elsif (/^\s*(\w+_FADX\w*)\s*:/)
            {
                $phy_section_name = $1;

                _while_2b_0:
                {
                    while (<MAP_FILE>)
                    {
                        if (/^\s*ORIGIN\s*=\s*(.+)\s*[,]/)
                        {
                            $addr = $1;

                            ($addr = $addr) =~ s#\/\/.*$##g;
                            ($addr = $addr) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                            ($addr = $addr) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                            ($addr = $addr) =~ s/(\d+)[kK]/$1\*1024/g;
                            $addr_of{$phy_section_name} = eval("$addr");
                            last _while_2b_0;
                        }
                    }
                }

                _while_2b_1:
                {
                    while (<MAP_FILE>)
                    {
                        if (/^\s*LENGTH\s*=\s*(.*)$/)
                        {
                            $length = $1;
                            ($length = $length) =~ s#\/\/.*$##g;
                            ($length = $length) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                            ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                            ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
                            $section_sizes{$phy_section_name} = eval("$length");
                            last _while_2b_1;
                        }
                    }
                }
            }
    }
}

# third path
seek(MAP_FILE, 0, 0);
_while_2c:
{
    while (<MAP_FILE>)
    {
            if ((/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)\/\//) ||
                (/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)$/))
            {
#print "$1: ";
                $phy_section_name = $1;


                $length = $3;

                $addr = $2;

                ($addr = $addr) =~ s#\/\/.*$##g;
                ($addr = $addr) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                ($addr = $addr) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                ($addr = $addr) =~ s/(\d+)[kK]/$1\*1024/g;
#print "addr_of = $addr\n";
                $addr_of{$phy_section_name} = eval("$addr");
#print "addr_ofA= $addr_of{$phy_section_name}\n";


                ($length = $length) =~ s#\/\/.*$##g;
                ($length = $length) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
#print "length = $length\n";
                $section_sizes{$phy_section_name} = eval("$length");
#print "lengthA= $section_sizes{$phy_section_name}\n";
#print "section: $phy_section_name, $section_sizes{$phy_section_name}\n";
            }
            elsif (/^\s*(\w+_FADX\w*)\s*:/)
            {
                $phy_section_name = $1;

                _while_2c_0:
                {
                    while (<MAP_FILE>)
                    {
                        if (/^\s*ORIGIN\s*=\s*(.+)\s*[,]/)
                        {
                            $addr = $1;

                            ($addr = $addr) =~ s#\/\/.*$##g;
                            ($addr = $addr) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                            ($addr = $addr) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                            ($addr = $addr) =~ s/(\d+)[kK]/$1\*1024/g;
                            $addr_of{$phy_section_name} = eval("$addr");
                            last _while_2c_0;
                        }
                    }
                }

                _while_2c_1:
                {
                    while (<MAP_FILE>)
                    {
                        if (/^\s*LENGTH\s*=\s*(.*)$/)
                        {
                            $length = $1;
                            ($length = $length) =~ s#\/\/.*$##g;
                            ($length = $length) =~ s/ADDR\(\s*(\.*\w+)\s*\)/$addr_of{$1}/g;
                            ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_sizes{$1}/g;
                            ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
                            $section_sizes{$phy_section_name} = eval("$length");
                            last _while_2c_1;
                        }
                    }
                }
            }
    }
}

print "Physical sections:\n";
foreach $section (sort keys %section_sizes)
{
    if (!($section =~ /\./) && !($section =~ /FADX/))
    {
        $temp = sprintf("0x%08x\@$section", $addr_of{$section});
        $section_list{$temp} = $section_sizes{$section};
    }
}

foreach $section (sort keys %section_list)
{
    ($temp = $section) =~ s/.*@//;
    ($start = $section) =~ s/@.*//;

    printf("\t%50s:\torigin = 0x%08x,\tsize = 0x%08x (%d)\n", $temp, hex($start), $section_sizes{$temp}, $section_sizes{$temp});
}
print "\n\n\n";

print "\n\n\n\tVDSL PM summary\n\n";
print "\n\tPhysical Buffer\tPage_Names\tStart_Addr\tPage_Size\tAllocated_Size(bytes)\tPercents_Used\tBytes_Free\n\n";
foreach $buffer (keys(%buffer_types))
{
    if ($buffer_types{$buffer} eq "pmswap")
    {
        foreach $page (keys %{"buffer_usages_$buffer"})
        {
#            print "$buffer: $page\n";
            $percentage = 0;
            if ($section_sizes{$buffer} != 0)
            {
                $percentage = $section_sizes{$page}/$section_sizes{$buffer};
            }
            printf("\t$buffer\t$page\t0x%08x\t$section_sizes{$page}\t$section_sizes{$buffer}\t%02.2f\t%d\n", $addr_of{$buffer}, $percentage,
                                        $section_sizes{$buffer} - $section_sizes{$page});
            $PM_pages{substr($page, 0, 24)} = 1;
        }
    }
}

print "\n\n\n\tVDSL DM summary\n\n";
print "\n\tPhysical Buffer\tPage_Names\tStart_Addr\tPage_Size\tAllocated_Size(bytes)\tPercents_Used\tBytes_Free\n\n";
foreach $buffer (keys(%buffer_types))
{
    if ($buffer_types{$buffer} eq "dmswap")
    {
        foreach $page (keys %{"buffer_usages_$buffer"})
        {
#            print "$buffer: $page\n";
            $percentage = 0;
            if ($section_sizes{$buffer} != 0)
            {
                $percentage = $section_sizes{$page}/$section_sizes{$buffer};
            }
            printf("\t$buffer\t$page\t0x%08x\t$section_sizes{$page}\t$section_sizes{$buffer}\t%02.2f\t%d\n", $addr_of{$page}, $percentage,
                                        $section_sizes{$buffer} - $section_sizes{$page});
#            $DM_pages{$page} = 1;
            $DM_pages{substr($page, 0, 24)} = 1;
        }
    }
}

close(MAP_FILE);


open(SYM_FILE, "<$sym_file") || die "Failed to open $sym_file\n";

while(<SYM_FILE>)
{
    #2086  0x805d8        0 GLOB FUNC .PMSWAP_VCPE_CACHE_1     hw_reset_isr
    #2115  0x4054c        2 GLOB OBJ  .DMSWAP_VCPE_MAIN        gs_FGActive

    if ((/^\d+\s+0x\w+\s+(\d+)\s+GLOB\s+OBJ\s+(\.\w+_DMSWAP)\s+(\w+)/i) ||
        (/^\d+\s+0x\w+\s+(\d+)\s+GLOB\s+OBJ\s+(\.DMSWAP_\w+)\s+(\w+)/i) ||
        (/^\d+\s+0x\w+\s+(\d+)\s+GLOB\s+OBJ\s+(\.\w+_MEM)\s+(\w+)/i) ||
        (/^\d+\s+0x\w+\s+(\d+)\s+GLOB\s+OBJ\s+(\.\w+_BSS)\s+(\w+)/i))
    {
        $size = sprintf("%05d", eval($1));
        ${"$2"}{"$size\@$3"} = 1;
    }
    elsif ((/^\d+\s+0x\w+\s+(\d+)\s+GLOB\s+FUNC\s+(\.\w+_PMSWAP)\s+(\w+)/i) ||
           (/^\d+\s+0x\w+\s+(\d+)\s+GLOB\s+FUNC\s+(\.PMSWAP_\w+)\s+(\w+)/i))
    {
        $size = sprintf("%05d", eval($1));
        ${"$2"}{"$size\@$3"} = 1;
    }


}

print "\n>>> Top 20 of DM pages <<<\n\n";
foreach $dm_page (keys %DM_pages)
{
    if (%{$dm_page})
    {
        printf("\n$dm_page: Top 20\n\n");
        printf("\t%50s\t%s\n", "Variable Name",  "Size(bytes)");
        printf("\t%50s\t%s\n", "--------------------",  "------------------");

        $i = 0;
        _foreach_0_loop:
        {
            foreach $var (reverse sort keys %{$dm_page})
            {
                $i++;
                ($size = $var) =~ s/\@.*//;
                ($var_name = $var) =~ s/.*@//;
                printf("\t%50s\t%d \n", $var_name, $size);
                if ($i >= 20)
                {
                    last _foreach_0_loop;
                }
            }
        }
    }

}
                     
print "\n>>> Top 20 of PM pages <<<\n\n";
foreach $pm_page (keys %PM_pages)
{
    if (%{$pm_page})
    {
        printf("\n$pm_page: Top 20\n\n");
        printf("\t%50s\t%s\n", "Function Name",  "Size(bytes)");
        printf("\t%50s\t%s\n", "--------------------",  "------------------");

        $i = 0;
        _foreach_1_loop:
        {
            foreach $var (reverse sort keys %{$pm_page})
            {
                $i++;
                ($size = $var) =~ s/\@.*//;
                ($var_name = $var) =~ s/.*@//;
                printf("\t%50s\t%d \n", $var_name, $size);
                if ($i >= 20)
                {
                    last _foreach_1_loop;
                }
            }
        }
    }

}
close(SYM_FILE);

exit;

