# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
# this tool will read the harvard cmd file for codeswap build,
# generate the CodeSwap_Source.src and CodeSwap_Source.inc files,
# generate the super files which are used to hide the multiply
# defined objects.
#
# The CodeSwap_Source.src (similar to other *.src) will have
# info about the super files, the path to those files, and some
# info (used by gmake) about objects that are used to form
# these super files. Later on, in the make file, we use this info
# to trim down the object archive for codeswap build.

    $USAGE = "Usage:  perl codeswap_modem_build.pl\n" .
             "\t\tcmd_input_file            // with path\n".
             "\t\tcmd_output_file           // with no path\n".
             "\t\tmake_inputs_path          // with path\n".
             "\t\tcodeswap_source           // dir name\n".
             "\t\tcodeswap_source_path      // with path\n".
             "\t\tpath to Source/Platform/include \n".
             "\t\tpath to src_src/modem/include\n".
             "\t\tALL_SRC_FILES             // list of all *.src files\n".
             "\t\tBUILD_OPTION_LIST         // list of all builds options used in .cmd input file\n";
    
    $cmd_infile = @ARGV[0];
    $cmd_outfile = @ARGV[1];
    $make_inputs_dir = @ARGV[2];
    $codeswap_source_name = @ARGV[3];
    $super_file_dir = @ARGV[4];
    $swap_index_file = "@ARGV[5]swap_index.h";
    $arc_src_inc = @ARGV[6];
    

    $alias_gen_enabled = 0;
    $use_alias_build = 0;

    if ($#ARGV != 8)
    {
        die($USAGE);
    }
    
    #default for DANUBE build
    $num_of_swap_pages = 1;              # each page contains TWO swap blocks: one for PM and one for DM

    foreach $bld_opt (split / /,@ARGV[8])
    {
        $build_options{$bld_opt} = 1;
        if ($bld_opt eq "TARGET_ARC")
        {
            $build_options{"TARGET_HW"} = 1;
        }
        elsif ($bld_opt eq "ADSL_62")
        {
            $num_of_swap_pages = 0;              # each page contains TWO swap blocks: one for PM and one for DM
        }
        #print "$bld_opt ";
    }


    # read in alias file
    if ($alias_gen_enabled)
    {
        open(ALIAS_INFILE, "<alias_input.txt") ||  die ("can't open alias_input.txt\n");
        while(<ALIAS_INFILE>)
        {
            if (m%^(\w+.c):\s*(\w+)%)
            {
                ($temp1 = $1) =~ tr/A-Z/a-z/;
                if (!defined($aliased_function{$2}))
                {
                    $aliased_function{$2} = 1;
                    $alias_input{$temp1} .= "#pragma Alias($2, \"$2_zzzz\")\n";
                }
            }
        }
        close(ALIAS_INFILE);
    }

    # read in the *.src files
    foreach $file (split / /,@ARGV[7])
    {
        open(SRC_FILE, "<$file") || die ("Failed to open src file ($file)\n");
        $src_list_start = 0;
        while (<SRC_FILE>)
        {
            if (/\w+_SRC\s*[+]*=\s*\\/)
            {
                $src_list_start = 1;
            }
            elsif (/^\s*$/)
            {
                $src_list_start = 0;
            }

            if (($src_list_start) && (/(\S+[\\\/])(\w+\.[cs])\s*[\\]*/))
            {
                ($temp2 = $2) =~ tr/A-Z/a-z/;
                $src_file_with_path{$temp2} = $1 . $2;
            }
        }
        close(SRC_FILE);
    }

    # some global file naming definitions
    open(CMD_INFILE, "<$cmd_infile") || 
        die "cannot open $cmd_infile\n";
    open(CMD_OUTFILE, ">${make_inputs_dir}/$cmd_outfile") || 
        die "cannot open $cmd_outfile\n";
    #open(NEW_CMD_OUTFILE, ">${make_inputs_dir}/new_$cmd_outfile") || 
    #        die "cannot open new_$cmd_outfile\n";
    
    
    $state = 0;
#    $num_of_swap_pages = 1;              # each page contains TWO swap blocks: one for PM and one for DM
    $CodeSwapTable_content = "";

    $XdmaCodeSwapTable_content = "";
    $in_bg_cache = 0;
    
    $prev_FADX_block = "";
    $remove_DM_ZBT_from_image = 0;

    @ifxdef_stack = (1);               # by default, things are enabled.

    _end_of_file_block:
    while(<CMD_INFILE>)
    {


        while (/^\s*[^\/]+(GET_SIZE_OF\(\s*(\S+)\s*\))/)
        {
            if (open(FILE_IN, "<$2"))
            {
                seek(FILE_IN, 0, 2);
                $file_size = tell(FILE_IN);
                close(FILE_IN);
            }
            else
            {
                print "\t!!! Warning: $2 doesn't exist !!!\n\n";
                $file_size = 0;
            }
            ($temp_string = $1) =~ s#\\#.#g;
            ($temp_string = $temp_string) =~ s#\(#.#g;
            ($temp_string = $temp_string) =~ s#\)#.#g;
            $_ =~ s#${temp_string}#${file_size}#;
        }

        _switch_0:
        {

        # ifdef/ifndef SINGLE_CONDITION support
            if (/^\s*\#ifdef\s+(\w+)\s*$/) 
            {
#print "$_";
                if (!defined($build_options{$1}))
                {
                    push(@ifxdef_stack, 0);
                }
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

            if (/^\s*\#ifndef\s+(\w+)\s*$/) 
            {
#print "$_";
                if (defined($build_options{$1}))
                {
                    push(@ifxdef_stack, 0);
                }    
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

        # ifdef (CONDITION_1 || CONDITION_2) support
            if (/^\s*#ifdef\s+\(\s*(\w+) \|\| (\w+)\s*\)\s*$/) 
            {
#print "$_";
                if (!defined($build_options{$1}) && !defined($build_options{$2}))
                {
                    push(@ifxdef_stack, 0);
                }
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

        # ifdef (CONDITION_1 && CONDITION_2) support
            if (/^\s*#ifdef\s+\(\s*(\w+) \&\& (\w+)\s*\)\s*$/) 
            {
#print "$_";
                if (!defined($build_options{$1}) || !defined($build_options{$2}))
                {
                    push(@ifxdef_stack, 0);
                }    
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

            if (/^\s*#else/)
            {
#print "$_";
                if ($#ifxdef_stack <= 0)
                {
                    die("Error: unmatched #else detected\n");
                }
                push(@ifxdef_stack, ((1^pop(@ifxdef_stack)) && $ifxdef_stack[$#ifxdef_stack]) );
#print "@ifxdef_stack\n";

                last _switch_0;
            }
         
            # get out if hit endif
            if (/^\s*#endif/)
            {
#print "$_";
                if ($#ifxdef_stack <= 0)
                {
                    die("Error: unmatched #endif detected\n");
                }
                pop(@ifxdef_stack);
#print "@ifxdef_stack\n";
                last _switch_0;
            }

            if ($ifxdef_stack[$#ifxdef_stack] == 0)
            {
                last _switch_0;
            }

            if (/^\s+(\w+)\.o\s*\(\.text\)/)
            {
                if ($static_scope_on == 0)
                {
                    if ($in_bg_cache)
                    {
                        if (defined $bg_cache_list{"$1"})
                        {
#                            print "<<<<<<<<<< duplicate line # $.\n";
                        }
                        else
                        {
                            $bg_cache_list{"$1"} = 1;
                        }
                    }
                }

                if (!$in_bg_cache)
                {
                    if (defined $bg_cache_list{"$1"})
                    {
#print "static = $static_scope_on :: removing $1.o from $pmswap_block\n";
                        last _switch_0;
                    }
                }
            }
            elsif (/^\s+(\w+)\.o\s*\(\.rodata\)/)
            {
                if (!$in_bg_cache)
                {
                    if (defined $bg_cache_list{"$1"})
                    {
                        last _switch_0;
                    }
                }
            }

            if (/^\s*\/\/\s*Num of Swap Pages/)
            {
                print (CMD_OUTFILE $_);
                print (CMD_OUTFILE "            LONG($num_of_swap_pages);\n\n");
                last _switch_0;
            }
            if (/^\s*\/\/\s*The rest of ADSL_IMAGE_HEADER_BLOCK/)
            {
                print (CMD_OUTFILE $_);
                print (CMD_OUTFILE "$CodeSwapTable_content");
                last _switch_0;
            }
#           elsif (/^\s*\/\/\s*The rest of XDMA_IMAGE_HEADER_BLOCK/)
#           {
#               print (CMD_OUTFILE $_);
#               print (CMD_OUTFILE "$XdmaCodeSwapTable_content");
#               last _switch_0;
#           }

            if (/^\s*#include\s*"(\S+)"/)
            {
                IncludeFile($1);
                last _switch_0;
            }

            if ($state == 0)
            {
                # for each line, look to see if they are the definition of *_FADX
                # if so, keep track of them.
                if (/^\s*(\w+)_FADX_PM\s*:\s*/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "CSPAGE_BIS_$1"; 

                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_PM) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";
                    $XdmaCodeSwapTable_content .= "                LONG(ADDR($1_FADX_PM) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.$1_PMSWAP));\n";
                    $XdmaCodeSwapTable_content .= "                LONG(ADDR(.$1_PMSWAP));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(SIZEOF($1_FADX_PM)/4);\n";
                    $XdmaCodeSwapTable_content .= "                LONG(SIZEOF($1_FADX_PM)/4);\n";
                    $XdmaCodeSwapTable_content .= "                LONG(0);\n\n";

                    # followed by a dummy DM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n\n";

                }
                elsif (/^\s*(\w+)_FADX_DM\s*:\s*/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "CSPAGE_BIS_$1"; 

                    # starts with a dummy PM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";

                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_DM) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";
                    $XdmaCodeSwapTable_content .= "                LONG(ADDR($1_FADX_DM) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.$1_DMSWAP));\n";
                    $XdmaCodeSwapTable_content .= "                LONG(ADDR(.$1_DMSWAP));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG((SIZEOF($1_FADX_DM)/4));\n\n";
                    $XdmaCodeSwapTable_content .= "                LONG((SIZEOF($1_FADX_DM)/4));\n";
                    $XdmaCodeSwapTable_content .= "                LONG(0);\n\n";
    
                }
                elsif (/^\s*(\w+)_FADX_PM_BT\s*:\s*/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "CSPAGE_BIS_$1"; 

                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_PM_BT) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";
                    #$XdmaCodeSwapTable_content .= "                LONG(ADDR($1_FADX_PM_BT) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.$1_PMSWAP));\n";
                    #$XdmaCodeSwapTable_content .= "                LONG(ADDR(.$1_PMSWAP));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(0x80000000 + (SIZEOF($1_FADX_PM_BT)/4));\n";
                    #$XdmaCodeSwapTable_content .= "                LONG(SIZEOF($1_FADX_PM_BT)/4);\n";  # not a boot page to modem
                    #$XdmaCodeSwapTable_content .= "                LONG(0);\n\n";

                    # followed by a dummy DM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n\n";

                }
                elsif (/^\s*(\w+)_FADX_DM_BT\s*:\s*/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "CSPAGE_BIS_$1"; 

                    # starts with a dummy PM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";


                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_DM_$2BT) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";
                    #$XdmaCodeSwapTable_content .= "                LONG(ADDR($1_FADX_DM_$2BT) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.$1_DMSWAP));\n";
                    #$XdmaCodeSwapTable_content .= "                LONG(ADDR(.$1_DMSWAP));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(0x80000000 + (SIZEOF($1_FADX_DM_BT)/4));\n\n";
                    #$XdmaCodeSwapTable_content .= "                LONG(SIZEOF($1_FADX_DM_BT)/4);\n";        # not a boot page to modem
                    #$XdmaCodeSwapTable_content .= "                LONG(0);\n\n";

                }
                #elsif (/^\s*(\w+)_FADX_DM_IBT\s*:\s*/)
                #{
                #    #$swap_page_list{$num_of_swap_pages++} = "CSPAGE_BIS_$1_DM_IBOOTPAGE"; 
                #    $num_of_swap_pages++;

                #    # starts with a dummy PM header
                #    $CodeSwapTable_content .=         "            LONG(0);\n";
                #    # this is the actual destination address
                #    $CodeSwapTable_content .=         "            LONG(0);\n";
                #    $CodeSwapTable_content .=         "            LONG(0);\n";


                #    # source address (byte offset within Flash/Sram image)
                #    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_DM_IBT) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";
                #    $XdmaCodeSwapTable_content .= "                LONG(ADDR($1_FADX_DM_IBT) - ADDR(ADSL_IMAGE_HEADER_FADX));\n";

                #    # arc intermediate destination address 
                #    $CodeSwapTable_content .=         "            LONG(ADDR(AWRE_IBRAM));\n";
                #    $XdmaCodeSwapTable_content .= "                LONG(ADDR(AWRE_IBRAM));\n";

                #    # size of page
                #    $CodeSwapTable_content .=         "            LONG(SIZEOF($1_FADX_DM_IBT)/4);\n\n";       # not a boot page to ME
                #    $XdmaCodeSwapTable_content .= "                LONG(0x80000000 + (SIZEOF($1_FADX_DM_IBT)/4));\n"; # is a boot page to modem
                #    $XdmaCodeSwapTable_content .= "                LONG(ADDR(.$1_DMSWAP));\n\n";  # actual dest address.

                #}
                #print(NEW_CMD_OUTFILE $_);


                if ((/^\s*(\w+_FADX_[PD]M[_IZBT]*\w*)\s*:/) || (/^\s*(\w+_FADX)\s*:/))
                {
                    $temp = $1;

                    print (CMD_OUTFILE $_);
                    if ((!(/^\s*(\w+_FADX\w*)\s*:\s*ORIGIN/)) && ($prev_FADX_block ne ""))
                    {
                        print(CMD_OUTFILE "						    		ORIGIN = ADDR($prev_FADX_block) + SIZEOF($prev_FADX_block),\n");
                    }
                    $prev_FADX_block = $temp;
                }
                elsif (/^\s*LENGTH\s*=/)
                {

                    if ($prev_FADX_block eq "LAST_FADX")
                    {
#                        $CodeSwapTable_top = "            LONG($num_of_swap_pages);    // num of swap pages\n\n";
#                        $CodeSwapTable_content = $CodeSwapTable_top . $CodeSwapTable_content;
                        $swap_page_list{$num_of_swap_pages} = "NO_OF_SWAPPAGES";

                        # go processing MULT_DEF blocks
                        $state = 5;
                    }

                    if ($remove_DM_ZBT_from_image)
                    {
                        $remove_DM_ZBT_from_image = 0;
                        print(CMD_OUTFILE "                                    LENGTH = 0\n");
                    }
                    else
                    {
                        print (CMD_OUTFILE $_);
                    }
                }
                else
                {
                    print (CMD_OUTFILE $_);
                }

                last _switch_0;
            }
            elsif ($state == 5)
            {
                if (m/^\s*\.(\w*)_PMSWAP:/)
                {
                    if (($1 eq "BG_CACHE_1") || ($1 eq "BG_CACHE_2"))
                    {
                        $in_bg_cache = 1;
                    }
                    else
                    {
                        $in_bg_cache = 0;
                    }
                    $pmswap_block = $1;
                }

                if (m/^\s*\.(\w+)_MULT_DEF/)
                {
                    $state = 10;
                    $page_name = "SWAP_$1";
                    $page_name_root = $1;
                    $old_super_file_list = "";
                    $super_file_list = "";
                    $super_file_not_empty = 0;
                    $valid_cmd_infile = 1;

                    # if create alias files
                    if ($alias_gen_enabled)
                    {
                        $alias_file_content = "";
                    }

                }
                else
                {
                    if ((defined $build_options{"ARC6"}) && (m/^\s*(\w+)\.o\s*(\(.*\))/))
                    {
                        ($temp1 = "$1_A6.s") =~ tr/A-Z/a-z/;

                        if (defined($src_file_with_path{$temp1}))
                        {
                            ($temp2 = $_) =~ s/\.o/_A6.o/;
#print "$temp2\n";
                        }
                        else
                        {
                            $temp2 = $_;
                        }

                        print(CMD_OUTFILE $temp2);
                    }
                    else
                    {
                        print (CMD_OUTFILE $_);
                    }
                }

                if (m/^\s*(\w+)\.o\s*(\(.*\))/)
                {
                    ($temp1 = "$1.c") =~ tr/A-Z/a-z/;
                    ($temp2 = "$1.s") =~ tr/A-Z/a-z/;
                    if (defined($src_file_with_path{$temp1}))
                    {
                        #print(NEW_CMD_OUTFILE "$src_file_with_path{$temp1}$2\n");
                    }
                    elsif (defined($src_file_with_path{$temp2}))
                    {
                        #print(NEW_CMD_OUTFILE "$src_file_with_path{$temp2}$2\n");
                    }
                    else
                    {
                        #print(NEW_CMD_OUTFILE $_);
                    }
                }
                else
                {
                    #print(NEW_CMD_OUTFILE $_);
                }
                last _switch_0;
            }
            elsif ($state == 10)
            {
                if (m/^\s*\}/)
                {
                    $static_scope_on = 0;

                    if (($super_file_not_empty == 0) ||
                        ($skip_ARC_SIM_page eq $page_name_root)) 
                    {
                        print "\tremoving empty `${super_file_dir}\\${page_name}.c'\n\n";
                        system("rm -f ${super_file_dir}\\${page_name}.c");
                        print (CMD_OUTFILE "            //empty super file\n");
                    }
                    else
                    {
                        # generate super-file
                        $super_file_list = "#define ${page_name_root}_ONLY\n\n#include \"common.h\"\n" . $super_file_list;

                        # include *_include_macros.h if exists
                        stat("$arc_src_inc/${page_name_root}_include_macros.h");
                        if (-e _)
                        {
                            $super_file_list = "#include \"${page_name_root}_include_macros.h\"\n\n" . $super_file_list;
                        }

                        #generate alias file
                        if ($alias_gen_enabled)
                        {
                            if ($alias_file_content ne "")
                            {
                                open(ALIAS_OUTFILE, ">../../soc_src/modem/include/${page_name_root}_alias.h") || die("Failed to create $1_alias.h\n");
                                print (ALIAS_OUTFILE "/////////// LIST OF IMPORTED FUNCTIONS FROM DIFF SWAP PAGES ////////////////\n\n\n");
                                print (ALIAS_OUTFILE "/////////// LIST OF EXPORTED FUNCTIONS FROM THIS SWAP PAGES ////////////////\n\n\n");
                                ($alias_file_content = $alias_file_content) =~ s/zzzz/$page_name_root/g;
                                print (ALIAS_OUTFILE  "$alias_file_content");
                                close(ALIAS_OUTFILE);
                            }
                        }

                        # include *_alias.h if exists
                        if ($use_alias_build)
                        {
                            stat("$arc_src_inc/${page_name_root}_alias.h");
                            if (-e _)
                            {
                                $super_file_list .= "\n#include \"${page_name_root}_alias.h\"\n";
                            }
                        }

                        read_old_super_file("${super_file_dir}\\${page_name}.c");

                        if ($old_super_file_list eq $super_file_list)
                        {
                            print "\t`${super_file_dir}\\${page_name}.c' is up to date.\n\n";
                        }
                        else
                        {
                            print "\tgenerating `${super_file_dir}\\${page_name}.c'\n\n";
                            open(SUPER_FILE, ">${super_file_dir}/${page_name}.c") || 
                                die "cannot open ${super_file_dir}/${page_name}.c\n";
                            print (SUPER_FILE $super_file_list);
                            close(SUPER_FILE);
                        }
                        
                        $codeswap_src_list{$page_name} = 1;
    
                        print (CMD_OUTFILE "            //super file\n");
                        #print (CMD_OUTFILE "            ${page_name}.o(.text)\n");
                        if ($in_bg_cache)
                        {
                            print (CMD_OUTFILE "            ${page_name}.o(.text)\n");
                        }
                        else
                        {
                            print (CMD_OUTFILE "            ${page_name}.o(.text, .rodata)\n");
                        }
                    }
                    #print(NEW_CMD_OUTFILE $_);
                    $state = 5;
                }
                elsif (m/^\s*(\w+)\.o/)
                {
                    $super_file_not_empty = 1;
                    ($temp1 = "$1.c") =~ tr/A-Z/a-z/;
                    ($temp3 = "$1.s") =~ tr/A-Z/a-z/;
                    ($temp2 = "$1_A6.s") =~ tr/A-Z/a-z/;
                    if (defined($src_file_with_path{$temp1}))
                    {
                        $super_file_list .= "#include \"$src_file_with_path{$temp1}\"\n";
                    }
                    # check that no asm-source objects included in super file
                    elsif ((defined($src_file_with_path{$temp3})) || (defined($src_file_with_path{$temp2})))
                    {
                        die "Error: $temp1 can't be included inside $page_name\n";
                    }
                    else
                    {
                        $super_file_list .= "#include \"$1.c\"\n";
                    }
                    if ($static_scope_on == 0)
                    {
                        $objects_to_remove_frm_archive{"$1.o"} = 1;
                    }
                    #print(NEW_CMD_OUTFILE "zzzz$src_file_with_path{$temp1}(.text, .rodata)\n");

                    if ($alias_gen_enabled)
                    {
                        $local_alias_content = $alias_input{$temp1};
                        if ($local_alias_content ne "")
                        {
                            $alias_file_content .= ("\n// for $1.c\n" . $local_alias_content); 
                        }
                    }

                }
                elsif (m#^\s*//\s*C_SCOPE_NULL#)
                {
                    $static_scope_on = 0;
                    $super_file_list .= "#undef C_SCOPE\n#define C_SCOPE\n";
                }
                elsif (m#^\s*//\s*C_SCOPE_STATIC#)
                {
                    $static_scope_on = 1;
                    $super_file_list .= "#undef C_SCOPE\n#define C_SCOPE static\n";
                }
                else
                {
                    #print(NEW_CMD_OUTFILE $_);
                }
            }
        }
    }
    
    if ($valid_cmd_infile != 1)
    {
         close(CMD_OUTFILE);
         die ("\n\n\t\t!!! FAILURE: Invalid $cmd_infile !!!\n\n\n");
    }
    
    close(CMD_OUTFILE);
    #close(NEW_CMD_OUTFILE);


    # create virtual swap_index.h
    $swap_index_content = "    // swap pages index by swap index.\n";

    foreach $index (sort numeric keys(%swap_page_list))
    {
        $swap_index_content .= sprintf("    #define %40s        %d\n", "$swap_page_list{$index}", $index);
    }

    $swap_index_content = 
        "#ifndef _SWAP_INDEX_H\n" .
        "#define _SWAP_INDEX_H\n" .
        $swap_index_content .
        "#endif\n";

    $swap_index_content =~ s/VCO_/VDSL_/g;
    $swap_index_content =~ s/VCPE_/VDSL_/g;
    
    $old_swap_index_content = "";
    if (open(SWAP_INDEX, "<$swap_index_file"))
    {
        while(<SWAP_INDEX>)
        {
            $old_swap_index_content .= $_;
        }
        close(SWAP_INDEX);
    }

    if ($old_swap_index_content ne $swap_index_content)
    {
        system("attrib -r $swap_index_file");
        open(SWAP_INDEX, ">$swap_index_file") || 
            die "cannot open $swap_index_file\n";
        print(SWAP_INDEX $swap_index_content);
        close(SWAP_INDEX);
    }

    $src_line = "${codeswap_source_name}_SRC += \\\n";
#   $c_rls_line = "${codeswap_source_name}_C_RLS = \\\n";
#   $asm_rls_line = "${codeswap_source_name}_ASM_RLS = \\\n";
    foreach $superfile (keys(%codeswap_src_list))
    {
        $src_line .= "    ${super_file_dir}/${superfile}.c \\\n";
#       $c_rls_line .= "    ${superfile}.rls \\\n";
    }
    
    $new_src_content =  "$src_line\n$c_rls_line\n$asm_rls_line\n";
    
    $vpath_for_c_line = "VPATH_FOR_C += \\\n    ${super_file_dir}\n\n";
    
    $new_src_content .= $vpath_for_c_line;

    $new_src_content .= "MULT_DEF_OBJECTS += \\\n";

    foreach $obj (keys(%objects_to_remove_frm_archive))
    {
        $new_src_content .= "    $obj \\\n";
    }
    print(CODESWAP_SRC_OUTFILE "\n\n");
    
    
    $new_inc_content =  "-I$super_file_dir\n";
    


    $old_src_content = "";
    if (open(CODESWAP_SRC_OLDFILE, "<${make_inputs_dir}/${codeswap_source_name}.src"))
    {
        while(<CODESWAP_SRC_OLDFILE>)
        {
            $old_src_content .= $_;
        }
        close(CODESWAP_SRC_OLDFILE);
    }

    if ($old_src_content ne $new_src_content)
    {
        open(CODESWAP_SRC_OUTFILE, ">${make_inputs_dir}/${codeswap_source_name}.src") ||
            die "${make_inputs_dir}/${codeswap_source_name}.src\n";
        print (CODESWAP_SRC_OUTFILE $new_src_content);
        close(CODESWAP_SRC_OUTFILE);
    }

    $old_inc_content = "";
    if (open(CODESWAP_INC_OLDFILE, "<${make_inputs_dir}/${codeswap_source_name}.inc"))
    {
        while(<CODESWAP_INC_OLDFILE>)
        {
            $old_inc_content .= $_;
        }
        close(CODESWAP_INC_OLDFILE);
    }

    if ($old_inc_content ne $new_inc_content)
    {
        open(CODESWAP_INC_OUTFILE, ">${make_inputs_dir}/${codeswap_source_name}.inc") ||
            die "${make_inputs_dir}/${codeswap_source_name}.inc\n";
        print (CODESWAP_INC_OUTFILE $new_inc_content);
        close(CODESWAP_INC_OUTFILE);
    }

    exit;








sub read_old_super_file
{
    local ($file_name) = @_;
    
    $old_super_file_list = "";

    if (open(OLD_SUPER_FILE, "<$file_name"))
    {
        while (<OLD_SUPER_FILE>)
        {
            $old_super_file_list .= $_;
        }
        close (OLD_SUPER_FILE);
    }
}

sub numeric { $a <=> $b; }



sub IncludeFile
{
    local ($file_name) = @_;

    system("perl ./perl/ifdef_processing.pl ${make_inputs_dir}/$file_name temp_included_file.txt ${make_inputs_dir} \"$all_bld_options\"");

    if ($? != 0)
    {
        die ("Failed to preprocess ${make_inputs_dir}/$file_name\n");
    }

    open(INCLUDE_FILE, "<${make_inputs_dir}/temp_included_file.txt") || die "Failed to read in included file ${make_inputs_dir}/temp_included_file.txt";

    while(<INCLUDE_FILE>)
    {
        while (/^\s*[^\/]+(GET_SIZE_OF\(\s*(\S+)\s*\))/)
        {
            if (open(FILE_IN, "<$2"))
            {
                seek(FILE_IN, 0, 2);
                $file_size = tell(FILE_IN);
                close(FILE_IN);
            }
            else
            {
                print "\t!!! Warning: $2 doesn't exist !!!\n\n";
                $file_size = 0;
            }
            ($temp_string = $1) =~ s#\\#.#g;
            ($temp_string = $temp_string) =~ s#\(#.#g;
            ($temp_string = $temp_string) =~ s#\)#.#g;
            $_ =~ s#${temp_string}#${file_size}#;
        }
        print (CMD_OUTFILE $_);
    }

    close(INCLUDE_FILE);
    system("del ${make_inputs_dir}\\temp_included_file.txt");
}
