# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**

print "\n\n";

open(VDSL, "<$ARGV[0]") || die "!!! Error: Can't open $ARGV[0] !!!\n";
binmode(VDSL);
print "\tget VDSL version from $ARGV[0]...\n";

$found = 0;
while(<VDSL>)
{
   #if (/\@\(\#\)[V_]*([a-f0-9\.]+)/i)
   if (/\@\(\#\)[V_]*([a-f0-9\.a-f0-9\_]+)/i)
   {
      $vdsl_version = $1;
      $vdsl_version =~ s/\.//g;
      $found = 1;
   }
}
close(VDSL);

if ($found == 1)
{
    print "\t\tfound VDSL version: $vdsl_version\n\n";
}
else
{
    die "!!! Error: couldn't get the version string from bin file !!!\n";
}


open(ADSL, "<$ARGV[1]") || die "!!! Error: Can't open $ARGV[1] !!!\n";
binmode(ADSL);
print "\tget ADSL version from $ARGV[1]...\n";

$found = 0;
while(<ADSL>)
{
   #if (/\@\(\#\)[V_]*([a-f0-9\.]+)(_([a-z0-9\.]*))?/i)
   if (/\@\(\#\)[V_]*([a-f0-9\.a-f0-9\_]+)/i)
   {
      $adsl_version = $1;
      $underscore = $2;
      $extended = $3;
      $adsl_version =~ s/\.//g;
      if($underscore =~ m/_/)
      {
         uc $extended;
         foreach my $c (split(/\./,$extended))
         {
            $d = ord($c);
            $d = $d - 0x30 if(($d >= 0x30) && ($d <= 0x39));
            $d = $d - 0x37 if(($d >= 0x41) && ($d <= 0x5A));
            $hexchars .= sprintf("%02x", $d);
         }
         $adsl_version = $adsl_version . "_" . $hexchars;
      }
      $found = 1;
   }
}
close(ADSL);


if ($found == 1)
{
    print "\t\tfound ADSL version: $adsl_version\n\n";
}
else
{
    die "!!! Error: couldn't get the version string from bin file !!!\n";
}

print("\tcopying obj\\adsl_vdsl_cpe.bin to obj\\xcpe_${vdsl_version}_${adsl_version}.bin... \n\n");
system("copy obj\\adsl_vdsl_cpe.bin obj\\xcpe_${vdsl_version}_${adsl_version}.bin");
print("\tcopying obj\\ModemHWE.out to obj\\acpe_${adsl_version}.out... \n\n");
system("copy obj\\ModemHWE.out obj\\acpe_${adsl_version}.out");

print("\tcopying obj\\xcpe_${vdsl_version}_${adsl_version}.bin => obj\\xcpe_hw.bin... \n\n");
system("copy obj\\xcpe_${vdsl_version}_${adsl_version}.bin obj\\xcpe_hw.bin");
print("\tcopying obj\\acpe_${adsl_version}.out => obj\\xcpe_hw.out... \n\n");
system("copy obj\\acpe_${adsl_version}.out obj\\xcpe_hw.out");


# This batchfile is useful while creating a Directory for Release binaries in X drive (server)
open(outfile2, ">Get_versions_to_Bat_File.bat");
print outfile2 "set VDSLVERSTRING=${vdsl_version}\n";

$strlength = length ${adsl_version};
$strlength = $strlength - 1;
$adslver   = substr ${adsl_version},0, $strlength;
$adslver   = $adslver.'x';

print outfile2 "set ADSLVERSTRING=$adslver\n";

close(outfile2);
