######                                                ######                   
###### BEWARE THAT THIS FILE IS CASE SENSITIVE !!!    ######                   
######                                                ######                   



#  This makefile will read in supporting makefiles (namedly *.src, *.rls):
#      *.src contains definitions of subproject_SRC , VPATH_FOR_C, and VPATH_FOR_ASM.
#
#  These variables are used by makefile to set up search paths and object file
#  compilation rules.
#
#  The hcarc compiler will use its own search paths which are provided thru
#  *.inc files.
#
#  Note that this file is CASE SENSITIVE !!!


############################################################
###          USER MODIFIABLE ENVIRONMENTS                ###
############################################################

MAKE = ./gmake_3.80.exe
MAKE_FILE = project.mak
MAKE_INPUTS            = make_inputs
PERL_DIR               = perl
MAP_DIR                = map
SOC_SRC_INC_DIR        = ../../soc_src/modem/include
SOC_SRC_PLATFORM_DIR   = ../../soc_src/modem/Platform
SOURCE_PLATFORM_INC_DIR = $(SOC_SRC_INC_DIR)
UFLAGS_LIST             = uflags.dep
EXTRACT_SCRIPT         = ExtractModemImage.sc
POST_PROCESS_IMAGE     = 


OBJ_DIR                = obj
ASM_DIR                = asm
RLS_DIR                = make_rls
UFLAGS_DIR          = make_uflags
CODESWAP_SOURCE        = codeswap
CODESWAP_SRC_DIR       = ../../soc_src/modem/$(CODESWAP_SOURCE)
SOURCE_TIMESTAMPS      = source_timestamps.txt

LOADER_OBJ_DIR         = 
VCPE_OBJ_DIR           =


ifeq "$(TARGET_OPT)"  "TARGET_ASIM"
    TARGET                 = asim
    TARGET_FLAG            = -DTARGET_ASIM -DTARGET_HW
    OUT_FILE               = $(ITUX)_$(TARGET).out
    BIN_FILE               = $(ITUX)_$(TARGET).bin
    ARCHIVE_FILE           = $(ITUX)_$(TARGET).a
endif


ifeq "$(TARGET_OPT)"  "TARGET_HW"
    TARGET                 = hw
    TARGET_FLAG            = -DTARGET_HW
    OUT_FILE               = $(ITUX).out
    BIN_FILE               = $(ITUX).bin
    ARCHIVE_FILE           = $(ITUX).a
endif


ifeq "$(LIB_VER)" "3.0"
    HW_LIB_VERSION =
    HWENG_FLAG = -DHWENGINE_30
endif

ifeq "$(LIB_VER)" "4.5"
    HWENG_FLAG = -DHWENGINE_30
    HW_LIB_VERSION = _4.5
#    HWENG_FLAG = -DHWENGINE_45
endif

ifeq "$(LIB_VER)" "4.0"
    HWENG_FLAG = -DHWENGINE_30
    HW_LIB_VERSION = _4.0
#    HWENG_FLAG = -DHWENGINE_40
endif

ifeq "$(LIB_VER)" "5.0"
    HW_LIB_VERSION = _5.0
    HWENG_FLAG = -DHERCULES_ADSL_CPE
endif

ifeq "$(LIB_VER)" "6.2"
    HW_LIB_VERSION = _6.2
    HWENG_FLAG = -DHERCULES_ADSL_CPE
endif

ifneq "$(AFE_OPT)" ""
    AFE_FLAG = -D$(AFE_OPT)
endif

# there's a lot of common code between DANUBE_AFE and AMAZON_AFE
ifeq "$(AFE_OPT)" "DANUBE_AFE"
    AFE_FLAG += -DAMAZON_AFE
endif

# for DR_DSL build
ifeq "$(DR_DSL)" "1"
    DR_DSL_FLAG = -DNON_INTRUSIVE_IMPULSE_DETECT -DINTRUSIVE_IMPULSE_DETECT 
endif

# for ANNEX-B
ifeq "$(ANNEX_B)" "1"
    ANNEX_FLAG = -DISDN
endif

CODESWAP_CMD_FILE      = $(ITUX)_$(TARGET).cmd
ifndef CODESWAP_CMD_INFILE
    CODESWAP_CMD_INFILE    = harvardArch_biscs.cmd
endif


ifeq "$(ARC_OPT)" "ARC4"
    CORE_RSP = ModemHWE4.rsp 
    CC = $(ARCDIR)/bin/hcarc.exe
    LD = $(ARCDIR)/bin/hcarc.exe
    AR = $(ARCDIR)/bin/ararc.exe
    AS = $(ARCDIR)/bin/hcarc.exe
    SCARC = $(ARCDIR)/bin/scarc.exe
    SIM_FLAGS = @$(MAKE_INPUTS)/simflags.rsp
    PLATFORM_OPT = -DUSE_ARC_4

    ifeq "$(LIB_VER)" "5.0"
        HWEXEC_EXT = HWExec5
        PLATFORM_EXT = Platform5
        ifndef CODESWAP_MEM_INFILE
            CODESWAP_MEM_INFILE  = HERCULES.mem
        endif
        PLATFORM_OPT += -DHERCULES
    else
        HWEXEC_EXT = HWExec4
        PLATFORM_EXT = Platform4
        ifndef CODESWAP_MEM_INFILE
            CODESWAP_MEM_INFILE  = STRATIPHY.mem
        endif
        PLATFORM_OPT += -DSTRATIPHY
    endif
endif

CFLAGS        = -Hoff=Ldst_from_code

ifeq "$(ARC_OPT)" "ARC6"
    CORE_RSP = ModemHWE6.rsp

#ARCPATH = hcac
#ifeq "$(ARC6_VER)" "7_4_3" 
#ARCPATH = arc
#endif
    ARCPATH = arc

    CC = $(ARCDIR)/MetaWare/$(ARCPATH)/bin/hcac.exe
    LD = $(ARCDIR)/MetaWare/$(ARCPATH)/bin/hcac.exe
    AR = $(ARCDIR)/MetaWare/$(ARCPATH)/bin/arac.exe
    AS = $(ARCDIR)/MetaWare/$(ARCPATH)/bin/hcac.exe
    SCARC = $(ARCDIR)/MetaWare/$(ARCPATH)/bin/scac.exe

    SIM_FLAGS = @$(MAKE_INPUTS)/simflags6.rsp



    ifeq "$(LIB_VER)" "6.2"
        PLATFORM_EXT = Platform6.2
        PLATFORM_OPT = -DUSE_ARC_6 -DARC6 -DADSL_62
        HWEXEC_EXT = HWExec6.2
        CFLAGS        = -Hon=Ldst_from_code
        LDFLAGS       = -u gula_PackedSRCCoeffs_4KHz

        EXTRACT_SCRIPT         = ExtractModemImage_62.sc

        ifndef CODESWAP_MEM_INFILE
        CODESWAP_MEM_INFILE  = ADSL_62.mem
        endif

        LOADER_OBJ_DIR = obj/loader_62
        VCPE_OBJ_DIR   = obj/vcpe

        ifneq (,$(findstring VRX518, $(EXTRA_COMPILE_OPTIONS)))
           POST_PROCESS_IMAGE  =  build_AdslOnly_image.bat VRX518
           CODESWAP_MEM_INFILE += loader_VRx518.bin vcpe_cache.bin
        else
           POST_PROCESS_IMAGE  =  build_AdslOnly_image.bat
           CODESWAP_MEM_INFILE += loader_62.bin vcpe_cache.bin
        endif

    else
        PLATFORM_EXT = Platform6
        PLATFORM_OPT = -DUSE_ARC_6 -DDANUBE -DINFINEON
        HWEXEC_EXT = HWExec6

        ifndef CODESWAP_MEM_INFILE
        CODESWAP_MEM_INFILE  = DANUBE.mem
        endif
    endif
endif

CRTFLAGS      = -Hnocrt
LD_MAP_FLAGS  = -Hldopt=-Cout=$(MAP_DIR)/$(notdir $*).map -Hldopt=-Cpage=0
# note that EXTRA_COMPILE_OPTIONS is used to pass more build option from .bat files
CFLAGS        += $(EXTRA_COMPILE_OPTIONS) -DNEW_SOC_BUILD $(PLATFORM_OPT) $(TARGET_FLAG) $(AFE_FLAG) $(HWENG_FLAG) $(DR_DSL_FLAG) $(ANNEX_FLAG) -g1 @$(MAKE_INPUTS)/$(CORE_RSP) @$(MAKE_INPUTS)/ModemHWEcf.rsp @$(MAKE_INPUTS)/defines.rsp


# stop build on compiler warnings
CFLAGS += -Hretwc

ASFLAGS       = $(CFLAGS) -Hasmcpp
LDFLAGS       += @$(MAKE_INPUTS)/ModemHWElf.rsp @$(MAKE_INPUTS)/$(CORE_RSP) $(CRTFLAGS) $(LD_MAP_FLAGS) -Hldopt=-Ccrossref
ARFLAGS       = -c

CC_COMMAND = $(CC) $(CFLAGS) 
AS_COMMAND = $(AS) $(ASFLAGS)
#AS_COMMAND = $(AS) $(ASFLAGS)
AS_RLS_COMMAND = $(AS) $(ASFLAGS)

# the following sub-projects are retrieved from the Cocomo sub-projects.

AUTO_SUB_PROJECTS = \
                    MultTask \
                    HWEngineLib$(HW_LIB_VERSION) \


# note that Platform MUST be the first one in the list
# so that arc source directories are searched first.

MANUAL_SUB_PROJECTS = \
                      $(HWEXEC_EXT) \
                      $(PLATFORM_EXT) \
                      HWExec \
                      Platform \
   

CODESWAP_SUB_PROJECT = \
                       codeswap

NON_CODESWAP_SUB_PROJECTS = $(MANUAL_SUB_PROJECTS) $(AUTO_SUB_PROJECTS)

# note that MANUAL_SUB_PROJECTS has to be the first one in the list
# so that arc source directories are searched first.
ALL_SUB_PROJECTS = $(MANUAL_SUB_PROJECTS) $(CODESWAP_SUB_PROJECT) $(AUTO_SUB_PROJECTS) 

VPATH_FOR_DSP = \
                ../../build/MultMode/modem \
                ../../build/HWEngine_3.0 \
                ../../build/HWEngine_4.5 \
                ../../build/HWEngine_5.0 \
                ../../build/HWEngine_6.2 \

VPATH_FOR_PERL = $(PERL_DIR)

############################################################
###                AUTOMATED ENVIRONMENTS                ###
############################################################


ALL_AUTO_SUB_PROJ_SRC_FILES = $(AUTO_SUB_PROJECTS:%=$(MAKE_INPUTS)/%.src)
ALL_AUTO_SUB_PROJ_INC_FILES = $(AUTO_SUB_PROJECTS:%=$(MAKE_INPUTS)/%.inc)

ALL_NON_CODESWAP_SRC_FILES = $(NON_CODESWAP_SUB_PROJECTS:%=$(MAKE_INPUTS)/%.src)
ALL_SRC_FILES = $(ALL_SUB_PROJECTS:%=$(MAKE_INPUTS)/%.src)
-include $(ALL_SRC_FILES)

NON_CODESWAP_SOURCES       = $(foreach name,$(NON_CODESWAP_SUB_PROJECTS),$($(name)_SRC))
NON_CODESWAP_C_SOURCES     = $(filter %.c, $(notdir $(NON_CODESWAP_SOURCES)))
NON_CODESWAP_ASM_SOURCES   = $(filter %.s, $(notdir $(NON_CODESWAP_SOURCES)))

# these are variables for non-codeswap files
# MULT_DEF_OBJECTS is defined in codeswap.src and it's a list of multiply defined objects

TEMP_C_OBJECTS     = $(NON_CODESWAP_C_SOURCES:%.c=%.o)
TEMP_ASM_OBJECTS   = $(NON_CODESWAP_ASM_SOURCES:%.s=%.o)
NON_CODESWAP_C_OBJECTS     = $(filter-out $(MULT_DEF_OBJECTS), $(TEMP_C_OBJECTS))
NON_CODESWAP_ASM_OBJECTS   = $(filter-out $(MULT_DEF_OBJECTS), $(TEMP_ASM_OBJECTS))
#   NON_CODESWAP_C_OBJECTS     = $(TEMP_C_OBJECTS)
#   NON_CODESWAP_ASM_OBJECTS   = $(TEMP_ASM_OBJECTS)

#   NON_CODESWAP_C_RULES       = $(NON_CODESWAP_C_SOURCES:%.c=%.rls)
#   NON_CODESWAP_ASM_RULES     = $(NON_CODESWAP_ASM_SOURCES:%.s=%.rls)
NON_CODESWAP_C_RULES       = $(NON_CODESWAP_C_OBJECTS:%.o=%.rls)
NON_CODESWAP_ASM_RULES     = $(NON_CODESWAP_ASM_OBJECTS:%.o=%.rls)

NON_CODESWAP_INC_PATHS     = $(foreach name,$(NON_CODESWAP_SUB_PROJECTS), @$(MAKE_INPUTS)/$(name).inc)

CODESWAP_SOURCES       = $(foreach name,$(CODESWAP_SUB_PROJECT),$($(name)_SRC))
CODESWAP_C_SOURCES     = $(filter %.c, $(notdir $(CODESWAP_SOURCES)))
CODESWAP_ASM_SOURCES   = $(filter %.s, $(notdir $(CODESWAP_SOURCES)))

CODESWAP_C_RULES       = $(CODESWAP_C_SOURCES:%.c=%.rls)
CODESWAP_ASM_RULES     = $(CODESWAP_ASM_SOURCES:%.s=%.rls)

CODESWAP_C_OBJECTS     = $(CODESWAP_C_SOURCES:%.c=%.o)
CODESWAP_ASM_OBJECTS   = $(CODESWAP_ASM_SOURCES:%.s=%.o)

CODESWAP_INC_PATHS     = $(foreach name,$(CODESWAP_SUB_PROJECT), @$(MAKE_INPUTS)/$(name).inc)

ALL_SOURCES       = $(CODESWAP_SOURCES) $(NON_CODESWAP_SOURCES)
ALL_C_SOURCES     = $(CODESWAP_C_SOURCES) $(NON_CODESWAP_C_SOURCES)
ALL_ASM_SOURCES   = $(CODESWAP_ASM_SOURCES) $(NON_CODESWAP_ASM_SOURCES)

ALL_C_RULES       = $(CODESWAP_C_RULES) $(NON_CODESWAP_C_RULES)
ALL_ASM_RULES     = $(CODESWAP_ASM_RULES) $(NON_CODESWAP_ASM_RULES)

ALL_C_OBJECTS     = $(CODESWAP_C_OBJECTS) $(NON_CODESWAP_C_OBJECTS)
ALL_ASM_OBJECTS   = $(CODESWAP_ASM_OBJECTS) $(NON_CODESWAP_ASM_OBJECTS)

ALL_INC_PATHS     = $(CODESWAP_INC_PATHS) $(NON_CODESWAP_INC_PATHS)


# set up search paths for make
vpath %.c $(VPATH_FOR_C)

vpath %.s $(VPATH_FOR_ASM)

vpath %.dsp $(VPATH_FOR_DSP)

vpath %.bin $(OBJ_DIR) $(LOADER_OBJ_DIR) $(VCPE_OBJ_DIR)

vpath %.out $(OBJ_DIR)

vpath %.o   $(OBJ_DIR)

vpath %.src $(MAKE_INPUTS)

vpath %.inc $(MAKE_INPUTS)

vpath %.def $(MAKE_INPUTS)

vpath %.rls $(RLS_DIR)

vpath %.a   $(OBJ_DIR)

vpath %.cmd $(MAKE_INPUTS)

vpath %.mem $(MAKE_INPUTS)

vpath %.uf $(UFLAGS_DIR)

############################################################
#                                                          # 
#               RULE SECTIONS                              # 
#                                                          # 
############################################################

# to force make to exit cleanly when encountering errors or being killed.
.DELETE_ON_ERROR: $(BIN_FILE) $(OUT_FILE) $(ARCHIVE_FILE)
                  

############################################################
###           rules to build CODESWAP image              ###
############################################################

CODESWAP_MODEM: UPDATE_UFLAGS
	$(MAKE) -f $(MAKE_FILE) $(BIN_FILE) INCLUDE_OBJ_RLS=1


$(BIN_FILE): $(OUT_FILE)
	$(SCARC) -cl -memext=0,0x1fffff -memextinit=0 -nogoifmain -nooptions  -cmd="read $(EXTRACT_SCRIPT)" $(OBJ_DIR)/$(notdir $<) 
	$(POST_PROCESS_IMAGE)
	ImageCheckSum.exe cpe_image.bin
	mv cpe_image.bin $(OBJ_DIR)/$(BIN_FILE)

$(OUT_FILE): $(ARCHIVE_FILE)
	$(CC) $(LDFLAGS) $(MAKE_INPUTS)/$(CODESWAP_CMD_FILE) $(OBJ_DIR)/$(notdir $^) -o $(OBJ_DIR)/$(notdir $@)
	.\elfdump.exe -t $(OBJ_DIR)/$(notdir $@) > $(MAP_DIR)/$(basename $(notdir $@)).sym
	perl $(PERL_DIR)/MemSize_2.pl $(MAP_DIR)/$(basename $(notdir $@)) > $(MAP_DIR)/$(basename $(notdir $@))_mem.xls
	perl $(PERL_DIR)/SwapPage_CrossRef.pl $(MAP_DIR)/$(basename $(notdir $@)).map $(ITUX) > $(MAP_DIR)/$(basename $(notdir $@))_cross_ref.txt



# this rule is for creating archive of all objects for codeswap build

$(ARCHIVE_FILE): $(ALL_C_OBJECTS) $(ALL_ASM_OBJECTS) $(CODESWAP_CMD_FILE)
	$(AR) $(ARFLAGS) $(OBJ_DIR)/$(notdir $@) $(addprefix $(OBJ_DIR)/,$(filter-out $(CODESWAP_CMD_FILE), $(notdir $^)))

CLEAN_BUILD_FLAGS:
	@if exist .build_info.txt del .build_info.txt

CLEAN_IMAGES:
	@-rm -f $(OBJ_DIR)/$(OUT_FILE)
	@-rm -f $(OBJ_DIR)/$(BIN_FILE)
	@-rm -f $(OBJ_DIR)/*.bin
	@-rm -f $(OBJ_DIR)/*.out

# removing objects and archives
CLEAN_OBJ:
	@echo cleaning *.a, *.o and *.s
	@-rm -f $(OBJ_DIR)/*.a
	@-rm -f $(OBJ_DIR)/*.o
	@-rm -f $(ASM_DIR)/*.s


############################################################
###                  TESTS                               ###
############################################################

test:
	echo $(ALL_INC_PATHS)

############################################################
###                  CLEANS                              ###
############################################################

CLEAN_ALL: CLEAN_SRC_INC CLEAN_RLS CLEAN_OBJ CLEAN_IMAGES \
           CLEAN_CODESWAP CLEAN_UFLAGS CLEAN_BUILD_FLAGS CLEAN_SOURCE_TIMESTAMPS
	
CLEAN_ALL_EXCEPT_IMAGES: CLEAN_SRC_INC CLEAN_RLS CLEAN_OBJ \
                         CLEAN_CODESWAP CLEAN_UFLAGS CLEAN_BUILD_FLAGS CLEAN_SOURCE_TIMESTAMPS

############################################################
###          rules to set up CODESWAP build              ###
###                                                      ###
############################################################
SET_UP_CODESWAP: 
	$(MAKE) -f $(MAKE_FILE) $(CODESWAP_CMD_FILE)

$(CODESWAP_CMD_FILE): $(CODESWAP_CMD_INFILE) $(CODESWAP_MEM_INFILE) $(PERL_DIR)/setup_codeswap.pl
	@echo         generating $(CODESWAP_CMD_FILE) ...
	@echo
	@perl $(PERL_DIR)/setup_codeswap.pl $< $(CODESWAP_CMD_FILE) $(MAKE_INPUTS) \
	    $(CODESWAP_SOURCE) $(CODESWAP_SRC_DIR) $(SOURCE_PLATFORM_INC_DIR)/$(ITUX)_ \
        $(SOC_SRC_INC_DIR) "$(ALL_NON_CODESWAP_SRC_FILES)" \
        "$(TARGET_OPT) $(MEM_MAP) $(CACHE_OPT) $(ARC_OPT) $(subst -D,,$(EXTRA_COMPILE_OPTIONS) $(PLATFORM_OPT) $(TARGET_FLAG) $(AFE_FLAG) $(HWENG_FLAG))
	@echo 


CLEAN_CODESWAP: CLEAN_CODESWAP_SOURCE CLEAN_CODESWAP_SRC_INC

CLEAN_CODESWAP_SOURCE:
	@echo cleaning $(CODESWAP_SRC_DIR)
	@-rm -f $(CODESWAP_SRC_DIR)/*.c
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_CMD_FILE)

CLEAN_CODESWAP_SRC_INC:
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_SOURCE).src
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_SOURCE).inc

############################################################
###          rules to update .src/.inc from .dsp         ###
###                for AUTO_SUB_PROJECTS                 ###
############################################################

# the platform and HWExec files are manually updated thru make_inputs/platform.src, platform?.src
# HWExec.src, HWExec?.src and make_inputs/platform.inc, platform?.inc, HWExec.inc, HWExec?.inc

UPDATE_SRC_INC:  
	$(MAKE) -f $(MAKE_FILE) $(AUTO_SUB_PROJECTS:%=%.src)

# force codeswap to regenerate .cmd and super files
$(AUTO_SUB_PROJECTS:%=%.src):%.src:$(notdir %).dsp
	@echo 	generating $@ ...
	@perl $(PERL_DIR)/get_src_frm_dsp.pl $(basename $(notdir $^)) $(<D) $(MAKE_INPUTS) $(MSVC_CFG)
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_CMD_FILE)

CLEAN_SRC_INC: 
	@echo clear *.src
	@-rm -f  $(ALL_AUTO_SUB_PROJ_SRC_FILES) 
	@-rm -f  $(ALL_AUTO_SUB_PROJ_INC_FILES) 

############################################################
###          rules to generate timestamp                 ###
############################################################

BUILD_TIMESTAMP:
	@-rm -f timestmp*
	gendate
	cp  $(SOC_SRC_PLATFORM_DIR)/timestmpheader.c $(SOC_SRC_PLATFORM_DIR)/timestmp.c 
	cat timestmp1.c >>  $(SOC_SRC_PLATFORM_DIR)/timestmp.c 
	@-rm -f timestmp*

############################################################
###          rules to generate .o files                  ###
############################################################


ifdef INCLUDE_OBJ_RLS
    -include $(UFLAGS_DIR)/$(UFLAGS_LIST)
    -include $(ALL_C_RULES:%.rls=$(RLS_DIR)/%.rls)
    -include $(ALL_ASM_RULES:%.rls=$(RLS_DIR)/%.rls)
endif

    
############################################################
###      COMPILE default RULES UPDATE to build *.o       ###
############################################################

# this part provides rule to force update of the compile rule for
# each individual source file.

UPDATE_ALL_RLS:
	@echo              updating all .rls files
	@echo
	@$(MAKE) -f $(MAKE_FILE) $(ALL_C_RULES) $(ALL_ASM_RULES) INCLUDE_OBJ_RLS=1


#ifdef INCLUDE_OBJ_RLS
define C_RLS_template
ifndef $(1)_rls
$(1).rls: $(filter %/$(1).c, $(NON_CODESWAP_SOURCES) $(CODESWAP_SOURCES))
	@echo            generating $(1).rls
	@-rm -f tempzzz* $$(RLS_DIR)/$(1).rls
	@perl $$(PERL_DIR)/gen_C_rls.pl "$$(CC_COMMAND)" "$$(AS_COMMAND)" "CC_COMMAND" \
    "$$(ALL_INC_PATHS)" "$$(filter %/$(1).c, $$(NON_CODESWAP_SOURCES) $$(CODESWAP_SOURCES))" \
    "$(1).c" "$$(RLS_DIR)/$(1).rls" tempzzz $$(OBJ_DIR) $$(UFLAGS_DIR) $$(MAKE_INPUTS)
	@-rm -f tempzzz*
endif
endef
#endif

    
#ifdef INCLUDE_OBJ_RLS
define ASM_RLS_template
ifndef $(1)_rls
$(1).rls: $(filter %/$(1).s, $(NON_CODESWAP_SOURCES) $(CODESWAP_SOURCES))
	@echo            generating $(1).rls
	@-rm -f tempzzz* $$(RLS_DIR)/$(1).rls
	@perl $$(PERL_DIR)/gen_asm_rls.pl "$$(CC_COMMAND)" "$$(AS_RLS_COMMAND)" "AS_COMMAND" \
	"$$(ALL_INC_PATHS)" "$$(filter %/$(1).s, $$(NON_CODESWAP_SOURCES) $$(CODESWAP_SOURCES))" \
    "$(1).s" "$$(RLS_DIR)/$(1).rls" tempzzz $$(OBJ_DIR) $$(UFLAGS_DIR) $$(MAKE_INPUTS)
	@-rm -f tempzzz*
endif
endef
#endif

# creating rules to generate .rls files using the above templates
# these two lines are very picky about extra spaces after the commas.
$(foreach src_file,$(basename $(ALL_C_SOURCES)),$(eval $(call C_RLS_template,$(src_file))))
$(foreach src_file,$(basename $(ALL_ASM_SOURCES)),$(eval $(call ASM_RLS_template,$(src_file))))


CLEAN_RLS:
	@echo cleaning all rules *.rls ...
	@-rm -f $(RLS_DIR)/*.rls
	@-rm -f $(RLS_DIR)/*.bad

############################################################
###          rules to generate .uf files                 ###
############################################################

UPDATE_UFLAGS:
	@perl $(PERL_DIR)/update_uflags.pl $(UFLAGS_DIR) $(UFLAGS_LIST)

CLEAN_UFLAGS:
	@-rm -f $(UFLAGS_DIR)/*.dep

############################################################
###     rules to check time-stamp of source files        ###
###     to solve the MKS resynch problem                 ###
############################################################

CHECK_SOURCE_TIMESTAMPS: $(ALL_SRC_FILES)
	@perl $(PERL_DIR)/check_source_timestamps.pl "$(RLS_DIR)" "$(OBJ_DIR)" "$^" "$(SOURCE_TIMESTAMPS)" $(FORCE_REBUILD)

CLEAN_SOURCE_TIMESTAMPS:
	@-rm -f $(RLS_DIR)/$(SOURCE_TIMESTAMPS)

