/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   main_dma.c
 *
 *   Socrates DMA test.
 *
 *----------------------------------------------------------------------------
 */

#include "LL_IOf.h"
#include "hwtest_gdata.h"
#include "hwtest_const2.h"
#include "utility.h"
#include "hw_utility.h"
#include "init_hw.h"
#include "proc_results.h"
#include "dma_iof.h"

int32 gla_DMATestBuffer[2048];      // 8K bytes
int32 gl_mask;

void DMA_wait(void)
{
   int32 ul_status;

   // wait for error or for DMA transfer to finish
   do {
      DMA_RegisterRead((uint32) ADMA_STAT_AC_ADDR, &ul_status);
   } while(((ul_status & ADMA_STAT_AC_ERR_MASK) == 0) && ((ul_status & ADMA_STAT_AC_PROC_MASK) == ADMA_STAT_AC_PROC_MASK));
}

void Run_DMA(uint32 s_start, uint32 s_end, uint32 d_start)
{
   DMA_wait();

   // write addresses
   DMA_RegisterWrite((uint32) ADMA_SAD_S_AC_ADDR, s_start);
   DMA_RegisterWrite((uint32) ADMA_SAD_E_AC_ADDR, s_end);
   DMA_RegisterWrite((uint32) ADMA_DAD_S_AC_ADDR, d_start);
   // kick off transfer
   DMA_RegisterWrite((uint32) ADMA_CTRL_AC_ADDR, (uint32) ADMA_CTRL_AC_START_MASK);

   DMA_wait();
}

void DMA_setup_source_data(uint32 s_start, uint32 s_end)
{
   uint32 value;

   for(value = s_start;(value + 3) <= s_end; value += 4)
      *(uint32 *)(value) = value;
}

int16 DMA_test_data(uint32 s_start, uint32 s_end, uint32 d_start)
{
   uint32 value, *pointer;
   int16 errcount;

   errcount = 0;
   pointer = (uint32 *)d_start;

   for(value = s_start;(value + 3) <= s_end; value += 4, pointer++)
      if((*pointer&gl_mask) != (value&gl_mask))
         errcount++;

   return(errcount);
}

int16 DMA_test_core(uint32 s_start, uint32 s_end, uint32 d_start)
{
   DMA_setup_source_data(s_start, s_end);
   Run_DMA(s_start, s_end, d_start);
   return(DMA_test_data(s_start, s_end, d_start));
}

int16 DMA_test(void)
{
   gs_error_count = 0;
   gl_mask = 0xFFFFFFFF;

   /*******************************************************************************/
   /* Socrates Memory Map:                                                       */
   /*                                                                             */
   /* 0x00000 - 0x0FFFF 64K      Instruction Memory                             */
   /* 0x10000 - 0x15FFF 24K      Bulk Data Memory                               */
   /* 0x16000 - 0x17FFF 8K    Unused                                         */
   /* 0x18000 - 0x19FFF 8K    X Memory                                       */
   /* 0x1A000 - 0x1BFFF 8K    Y Memory                                       */
   /* 0x1C000 - 0x1C3FF 1K    MEI RAM                                        */
   /* 0x1C400 - 0x1FFFF 15K      Unused                                         */
   /* 0x20000 - 0x4FFFF 192K  ADSL Accelerator                               */
   /* 0x50000 - 0x8FFFF 256K  Expansion Bus                                  */
   /* 0x90000 - 0xFDFFF 456K  Unused                                         */
   /* 0xFE000 - 0xFFFFF 8K    Local Load/Store Memory                        */
   /*                                                                             */
   /*******************************************************************************/

   /* ============================================================================*/

   /* Test 0 */

   /* From X Memory to Bulk Data Memory */
   gs_error_count += DMA_test_core(0x18000, 0x19FFF, (uint32)gla_DMATestBuffer);

   /* ============================================================================*/

   /* Test 1 */

   /* From Y Memory to Bulk Data Memory */
   gs_error_count += DMA_test_core(0x1A000, 0x1BFFF, (uint32)gla_DMATestBuffer);

   /* ============================================================================*/

   /* Test 2 */

   /* From Bulk Data Memory to X Memory */
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, ((uint32)gla_DMATestBuffer) + 0x1FFF, 0x18000);

   /* ============================================================================*/

   /* Test 3 */

   /* From Bulk Data Memory to Y Memory */
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, ((uint32)gla_DMATestBuffer) + 0x1FFF, 0x1A000);

   /* ============================================================================*/

   /*******************************************************************************/
   /* 0x32800 - 0x32FFC Iridia Rx FFT In-Place Buffer A                        */
   /* 0x33000 - 0x337FC Iridia Rx FFT In-Place Buffer B                        */
   /* 0x33800 - 0x33FFC Iridia Rx FFT In-Place Buffer C                        */
   /* 0x32400 - 0x324FC Iridia Tx IFFT In-Place Buffer A                       */
   /* 0x32600 - 0x326FC Iridia Tx IFFT In-Place Buffer B                       */
   /* 0x34000 - 0x347FC Iridia Rx FDQ Mantissa Table                          */
   /* 0x35000 - 0x351FC Iridia Rx FDQ Exponent Table                          */
   /* 0x35200 - 0x353FC Iridia Rx Reverb-Segue Detect Table                      */
   /*                                                                             */
   /* 0x40000 - 0x44B3C Zephyr Rx Interleave Buffer                            */
   /* 0x2C000 - 0x2D27C Zephyr Tx Interleave Buffer                            */
   /*******************************************************************************/

   /* ============================================================================*/

   /* Test 4 */

   /* From ADSL Accelerator to Bulk Data Memory */

   gs_error_count += DMA_test_core(0x32800, 0x32FFC, (uint32)gla_DMATestBuffer);
   gs_error_count += DMA_test_core(0x33000, 0x337FC, (uint32)gla_DMATestBuffer);
   gs_error_count += DMA_test_core(0x33800, 0x33FFC, (uint32)gla_DMATestBuffer);
   gs_error_count += DMA_test_core(0x32400, 0x324FC, (uint32)gla_DMATestBuffer);
   gs_error_count += DMA_test_core(0x32600, 0x326FC, (uint32)gla_DMATestBuffer);

   gl_mask = 0x3FFF3FFF;
   gs_error_count += DMA_test_core(0x34000, 0x347FC, (uint32)gla_DMATestBuffer);
   gl_mask = 0x0F0F0F0F;
   gs_error_count += DMA_test_core(0x35000, 0x351FC, (uint32)gla_DMATestBuffer);
   gl_mask = 0x01010101;
   gs_error_count += DMA_test_core(0x35200, 0x353FC, (uint32)gla_DMATestBuffer);
   gl_mask = 0xFFFFFFFF;

   gs_error_count += DMA_test_core(0x40000, 0x41FFC, (uint32)gla_DMATestBuffer);
   gs_error_count += DMA_test_core(0x42000, 0x43FFC, (uint32)gla_DMATestBuffer);
   gs_error_count += DMA_test_core(0x44000, 0x44B3C, (uint32)gla_DMATestBuffer);

   gs_error_count += DMA_test_core(0x2C000, 0x2D27C, (uint32)gla_DMATestBuffer);

   /* ============================================================================*/

   /* Test 5 */

   /* From Bulk Data Memory to ADSL Accelerator */

   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x07FC, 0x32800);
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x07FC, 0x33000);
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x07FC, 0x33800);
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x00FF, 0x32400);
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x00FF, 0x32600);

   gl_mask = 0x3FFF3FFF;
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x07FC, 0x34000);
   gl_mask = 0x0F0F0F0F;
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x01FC, 0x35000);
   gl_mask = 0x01010101;
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x01FC, 0x35200);
   gl_mask = 0xFFFFFFFF;

   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x1FFF, 0x40000);
   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x1FFF, 0x42000);
   //gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x1FFF, 0x44000);

   gs_error_count += DMA_test_core((uint32)gla_DMATestBuffer, (uint32)gla_DMATestBuffer + 0x0FFF, 0x2C000);

   /* ============================================================================*/

   /* Test 6 */

   /* From ADSL Accelerator to XY Memory */

   gs_error_count += DMA_test_core(0x32800, 0x32FFC, 0x1A000);
   gs_error_count += DMA_test_core(0x33000, 0x337FC, 0x18000);
   gs_error_count += DMA_test_core(0x33800, 0x33FFC, 0x1A000);
   gs_error_count += DMA_test_core(0x32400, 0x324FC, 0x18000);
   gs_error_count += DMA_test_core(0x32600, 0x326FC, 0x1A000);

   gl_mask = 0x3FFF3FFF;
   gs_error_count += DMA_test_core(0x34000, 0x347FC, 0x1A000);
   gl_mask = 0x0F0F0F0F;
   gs_error_count += DMA_test_core(0x35000, 0x351FC, 0x18000);
   gl_mask = 0x01010101;
   gs_error_count += DMA_test_core(0x35200, 0x353FC, 0x1A000);
   gl_mask = 0xFFFFFFFF;

   gs_error_count += DMA_test_core(0x40000, 0x41FFC, 0x18000);
   gs_error_count += DMA_test_core(0x42000, 0x43FFC, 0x1A000);
   gs_error_count += DMA_test_core(0x44000, 0x44B3C, 0x1A000);

   gs_error_count += DMA_test_core(0x2C000, 0x2D27C, 0x18000);

   /* ============================================================================*/

   /* Test 7 */

   /* From XY Memory to ADSL Accelerator */

   gs_error_count += DMA_test_core(0x1A000, 0x1A7FC, 0x32800);
   gs_error_count += DMA_test_core(0x18000, 0x187FC, 0x33000);
   gs_error_count += DMA_test_core(0x1A000, 0x1A7FC, 0x33800);
   gs_error_count += DMA_test_core(0x18000, 0x180FF, 0x32400);
   gs_error_count += DMA_test_core(0x1A000, 0x1A0FF, 0x32600);

   gl_mask = 0x3FFF3FFF;
   gs_error_count += DMA_test_core(0x1A000, 0x1A7FC, 0x34000);
   gl_mask = 0x0F0F0F0F;
   gs_error_count += DMA_test_core(0x18000, 0x181FC, 0x35000);
   gl_mask = 0x01010101;
   gs_error_count += DMA_test_core(0x1A000, 0x1A1FC, 0x35200);
   gl_mask = 0xFFFFFFFF;

   gs_error_count += DMA_test_core(0x18000, 0x19FFF, 0x40000);
   gs_error_count += DMA_test_core(0x1A000, 0x1BFFF, 0x42000);
   //gs_error_count += DMA_test_core(0x18000, 0x183FF, 0x44000);

   gs_error_count += DMA_test_core(0x18000, 0x18FFF, 0x2C000);

   /* ============================================================================*/

   /* Test 8 */

   /* From ADSL Accelerator to Program Memory */

   gs_error_count += DMA_test_core(0x40000, 0x43FFF, 0x08000);
   gs_error_count += DMA_test_core(0x40000, 0x43FFF, 0x0C000);

   gs_error_count += DMA_test_core(0x40000, 0x43FFF, 0x03000);    // Avoid overwriting this program itself.
   gs_error_count += DMA_test_core(0x40000, 0x40FFF, 0x07000);    // Avoid overwriting this program itself.

   /* ============================================================================*/

   if(gs_error_count == 0)
      return(SUCCEED);
   else
      return(FAIL);
}

void main(int argc, char *argv[])
{
   gs_TestResult = (int16) 0xDEAD;

/* ==================================================================== */
/* Initializations                                          */
/* ==================================================================== */

   InitializePlatform();

/* ==================================================================== */
/* Run Test */
/* ==================================================================== */

   gs_hwTestType = DMA_TEST_ID;

   _RUN_AGAIN:
   gs_TestResult = DMA_test();


   gl_NumTimes_TestRan++;

   /* ==================================================================== */
   /* Display Test Results */
   /* ==================================================================== */
   gft_RunProcessResultsOnce = 1;

   while (1) {

      ProcessResults();

      if (gft_InfiniteLoop == 1)
         break;

   }
   goto _RUN_AGAIN;

}
