/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   main_multipage.c
 *
 *   Tests the ability of firmware to make a codeswap request.
 *
 *----------------------------------------------------------------------------
 */

//#include "memrymap.h"
#include "LL_IOf.h"
#include "hwtest_gdata.h"
#include "hwtest_const2.h"
#include "utility.h"
#include "hw_utility.h"
#include "init_hw.h"
#include "proc_results.h"
#include "soc_codeswap.h"
#include "mei_iof.h"

/***************************************************************
 *   main
 ***************************************************************/
void MEI_RegisterRead(uint32 ul_addr, uint32 *pul_word);
void MEI_RegisterWrite(uint32 ul_addr, uint32 ul_word);
void HandleCodeSwap(void);
void SendCodeSwapRequest(void);

int16 gs_CodeSwapSection, gs_CodeSwapStatus;

void main(int argc, char *argv[])
{
/* ==================================================================== */
/* Initializations                                          */
/* ==================================================================== */

   InitializePlatform();

/* ==================================================================== */
/* Run Test */
/* ==================================================================== */

   gs_hwTestType = 99; //MULTIPAGE_TEST_ID;


   // At boot, all pages are loaded except the code page that contains the ProcessResults() function.
   // Load that page here.

   gs_CodeSwapSection = 4; // Code section containing ProcessResults() function.
   SendCodeSwapRequest();
   gs_CodeSwapStatus = CODESWAP_IN_PROGRESS;
   while (gs_CodeSwapStatus != CODESWAP_COMPLETE){
      HandleCodeSwap();
   }

   gs_TestResult = 1;      // Page was loaded, proceed to ProcessResults and mp handler loop.

/* ==================================================================== */
/* Display Test Results */
/* ==================================================================== */

   ProcessResults();
}

/****************************************************************************
;  Prototype: void SendCodeSwapRequest(void)
;
;  Description:
;       Sends a codeswap request to host.
;
;  Arguments:
;
;  Return Value:
;     none
;
;
;****************************************************************************/
void SendCodeSwapRequest(void) {
   uint32 ul_data;

   // clear the CS_DONE bit
   MEI_RegisterWrite(MEI_INT_MC_ADDR, MEI_INT_MC_CS_DONE_MASK);

   // set the MSG_TYPE bit in the OMB_CODESWAP_MESSAGE register to 1
   // to indicate that the ARC->MEI message is a codeswap message
   ul_data = OMB_CODESWAP_MESSAGE_MSG_TYPE_MASK;

   // indicate which codeswap section we want
   ul_data |= ((uint32) gs_CodeSwapSection & OMB_CODESWAP_MESSAGE_CS_SECTION_MASK);
   MEI_RegisterWrite(OMB_CODESWAP_MESSAGE_ADDR, ul_data);

   // notify MEI of codeswap request by assertin the ARC->MEI mailbox message interrupt
   ul_data = (uint32) MEI_INT_AC_ARC_MSGAV_MASK;
   MEI_RegisterWrite(MEI_INT_AC_ADDR, ul_data);

}

/****************************************************************************
;  Prototype: int16 HandleCodeSwap(void);
;
;  Description:
;       Handles a codeswap request from start to finish.  Send the codeswap
;     request to the MEI, checks the MEI's response to the request, and
;     informs the task layer code of the status of the codeswap request.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;
;****************************************************************************/
void HandleCodeSwap(void)
{
   uint32 ul_data;
   // send the codeswap request
   if(gs_CodeSwapStatus == CODESWAP_START) {
      SendCodeSwapRequest();
      gs_CodeSwapStatus = CODESWAP_IN_PROGRESS;
   }

   // check the status of the codeswap request
   if(gs_CodeSwapStatus == CODESWAP_IN_PROGRESS) {
      // check if the MEI has finished handling a codeswap page
      MEI_RegisterRead(MEI_INT_MC_ADDR, &ul_data);
      if(ul_data & MEI_INT_MC_CS_DONE_MASK) {
         // check if the MEI has finished due to an error
         MEI_RegisterRead(IMB_CODESWAP_STATUS_ADDR, &ul_data);
         if((ul_data & IMB_CODESWAP_STATUS_MASK) == IMB_CODESWAP_STATUS_FAIL_MASK) {
            //HandleException(CODESWAP_ERROR);
            return; // ERROR
//          gs_RxNextState = FAIL_RX;
//          gs_TxNextState = FAIL_TX;
         }
         gs_CodeSwapStatus = CODESWAP_COMPLETE;
      }
   }
}

