/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   main_mte_reg_3.0.c
 *
 *   Iridia register tests.
 *    This file was created for the sole purpose of testing registers of IRIDIA
 *   version 3.0. #ifdef NEW_IRIDIA (revision 2.0?) was replaced with whatever
 *   code was needed for revision 3.0
 *
 *----------------------------------------------------------------------------
 */


#include "const.h"
#include "typedef.h"
#include "memrymap.h"
#include "iridia.h"
#include "LL_IOf.h"
#include "utility.h"
#include "hw_utility.h"
#include "hwtest_gdata.h"
#include "init_hw.h"
#include "proc_results.h"
#include "cmv_data.h"
#include "nmp_plfm.h"

extern uint8   guc_MPMsgReq;
extern uint8   guc_CodeSwapMsgReq;
extern uint8   guc_FastReadMsgReq;
extern uint8*  gpuc_FastReadMsgReq;

FlagT gft_AC_CLK_NotEnabled;

void main(int argc, char *argv[])
{
   /* turn off LED's at reset */
   LED2_off();
   LED3_off();

   // Light up LED to indicate test start.
   LED2_on();

/* ======================================================================= */
/*  Attempt WINHOST connectivity */
/* ======================================================================= */
   NewMPInitialize();

/* ==================================================================== */
/* Initializations                                          */
/* ==================================================================== */

   InitializePlatform();
   gs_hwTestType = NW_PROC_TEST_ID;

/* ==================================================================== */
/* Perform Codeswap                                         */
/* ==================================================================== */
   // At boot, all pages are loaded except the code page that contains the ProcessResults() function.
   // Load that page here.


   gs_CodeSwapSection=4;
   guc_CodeSwapMsgReq=1;
   gs_CodeSwapStatus = CODESWAP_IN_PROGRESS;
   while (gs_CodeSwapStatus != CODESWAP_COMPLETE)
   {
      ProcessTxMailbox();
      HandleCodeSwap();
   }


/* ==================================================================== */
/* Display Test Results */
/* ==================================================================== */

   NewMPSetupReadyMessage();
   ProcessTxMailbox();

   ProcessResults();

   // Turn off LED to indicate test end.
   LED2_off();
}
